# Copyright (c) 2000-2004 LOGILAB S.A. (Paris, FRANCE).
# http://www.logilab.fr/ -- mailto:contact@logilab.fr
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
"""unit tests for narval.core.tags
"""

__revision__ = '$Id: readers.py,v 1.35 2004/04/02 10:06:46 syt Exp $'

import unittest
from narval.tags import *

class MockElement:
    def __init__(self, eid):
        self.eid = eid

class MockTagger(MockElement):
        
    def tagger_id(self):
        return self.eid
    
class TagsTC(unittest.TestCase):    

    def test(self):
        el1 = MockElement(1)
        el2 = MockElement(2)
        tg1 = MockTagger(1)
        tg2 = MockTagger(2)
        self.assert_(not is_tagged(el1, tg1))
        self.assert_(not is_tagged(el1, tg2))
        self.assert_(not is_tagged(el2, tg1))
        self.assert_(not is_tagged(el2, tg2))
        
        tag_element(el1, tg1)
        self.assert_(is_tagged(el1, tg1))
        self.assert_(not is_tagged(el1, tg2))
        self.assert_(not is_tagged(el2, tg1))
        self.assert_(not is_tagged(el2, tg2))

        clear_tags(el1)
        self.assert_(not is_tagged(el1, tg1))
        self.assert_(not is_tagged(el1, tg2))
        self.assert_(not is_tagged(el2, tg1))
        self.assert_(not is_tagged(el2, tg2))

if __name__ == '__main__':
    unittest.main()
