import unittest
from time import localtime, mktime
from narval.utils import ShallowCalendar

class ShallowCalendarTC(unittest.TestCase):
    def test_minutes(self):
        sc = ShallowCalendar(('*', '1', '*', '*', '*', '*'))
        date = sc.next_date( (2004, 11, 29, 11, 36, 40) )
        self.assertEquals(date, (2004, 11, 29, 12, 1, 40, -1, -1, -1))

    def test_monthdays(self):
        sc = ShallowCalendar(('*', '*', '*', '2', '*', '*'))
        date = sc.next_date( (2004, 11, 29, 11, 36, 40) )
        self.assertEquals(date, (2004, 12, 2, 11, 36, 40, -1, -1, -1))

    def test_weekdays(self):
        sc = ShallowCalendar(('*', '*', '*', '*', '*', '2'))
        date = sc.next_date( (2004, 11, 29, 11, 36, 40) )
        self.assertEquals(date, (2004, 11, 30, 11, 36, 40, -1, -1, -1))

    def test_get_next_date_following_calls_1(self):
        sc = ShallowCalendar(('*', '1', '*', '*', '*', '*'))
        date1 = localtime(sc.get_next_date())
        date2 = localtime(sc.get_next_date())
        self.assertNotEquals(date1[:4], date2[:4])
        sc = ShallowCalendar(('*', '*', '18', '*', '*', '*'))
        date1 = localtime(sc.get_next_date())
        date2 = localtime(sc.get_next_date())
        self.assertNotEquals(date1[:3], date2[:3])

    def test_get_next_date_following_calls_2(self):
        sc = ShallowCalendar(('*', '1', '*', '*', '*', '*'))
        start_date = (2004, 11, 29, 21, 36, 40, -1, -1, -1)
        date1 = localtime(sc.get_next_date(start_date))[:6]
        self.assertEquals(date1, (2004, 11, 29, 22, 1, 40) )
        date2 = localtime(sc.get_next_date())[:6]
        self.assertEquals(date2, (2004, 11, 29, 23, 1, 40) )
        date3 = localtime(sc.get_next_date())[:6]
        self.assertEquals(date3, (2004, 11, 30, 0, 1, 40) )

        
if __name__ == '__main__':
    unittest.main()
