# Copyright (c) 2000-2004 LOGILAB S.A. (Paris, FRANCE).
# http://www.logilab.fr/ -- mailto:contact@logilab.fr
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
"""unit tests for narval.reader and Recipe / Action handlers
"""

__revision__ = '$Id: readers.py,v 1.35 2004/04/02 10:06:46 syt Exp $'

import unittest

from logilab.common import testlib

from narval.public import *
from narval.element import NSAttributesElement, NSAttribute

class MyElement(NSAttributesElement):
    toto = NSAttribute(NO_NS, 1, int, str)
    tutu = NSAttribute(AL_NS, None, str, str)
    
class NSAttributesElementTC(testlib.TestCase):

    def test_base(self):
        elmt = MyElement()
        self.assertRaises(KeyError, elmt.getattr, (NO_NS, 'toto'))
        self.assertEquals(elmt.toto, 1)
        self.assertRaises(KeyError, elmt.getattr, (AL_NS, 'tutu'))
        self.assertEquals(elmt.tutu, None)

    def test_dyn_attr(self):
        elmt = MyElement()
        elmt.balot = 4
        self.assertRaises(KeyError, elmt.getattr, (NO_NS, 'balot'))
        self.assertEquals(elmt.balot, 4)
    
    def test_init_attrs(self):
        elmt = MyElement()
        elmt.init_attrs({(NO_NS, 'toto'): '5',
                         (AL_NS, 'tutu'): u'paglop',
                         (AL_NS, 'eid'): '5',
                         (NO_NS, 'xxx'): '???'})
        self.assertEquals(elmt.getattr((NO_NS, 'toto')), 5)
        self.assertEquals(elmt.getattr((AL_NS, 'tutu')), 'paglop')
        self.assertEquals(type(elmt.getattr((AL_NS, 'tutu'))), str)
        self.assertRaises(KeyError, elmt.getattr, (AL_NS, 'eid'))
        self.assertRaises(AttributeError, getattr, elmt, 'xxx')
        self.assertRaises(KeyError, elmt.getattr, (NO_NS, 'xxx'))

    def test_serialize(self):
        elmt = MyElement()
        elmt.init_attrs({(NO_NS, 'toto'): '5',
                         (AL_NS, 'tutu'): u'paglop',
                         (AL_NS, 'eid'): '5',
                         (NO_NS, 'xxx'): '???'})
        xml_string = elmt.as_xml()
        self.assert_(xml_string)
        self.assertEquals(xml_string,
                          '<None xmlns:type="uri:memory:type" '\
                          'xmlns:al="http://www.logilab.org/namespaces/Narval/1.2" '\
                          'toto="5" al:tutu="paglop"/>')
        

if __name__ == '__main__':
    unittest.main()
