import unittest

from narval import AL_NS
from narval.reader import REGISTRY as reg
from narval.elements import core

reg.register_class(core.ErrorElement)
reg.register_class(core.StartPlanElement)
reg.register_class(core.ListenOnElement)
reg.register_class(core.QuitElement)

class BaseElementTC(unittest.TestCase):
    xml_string = None
    def setUp(self):
        self.elmt = reg.from_string(self.xml_string)[0]
        
    def _test_roundtrip(self):
        clone = reg.from_string(self.elmt.as_xml())[0] 
        self.assertEquals(self.elmt._ns_attrs, clone._ns_attrs)
        return clone

# error #######################################################################

class ErrorElementTC(BaseElementTC):

    xml_string = '<al:error type="gargl" xmlns:al="%s">message</al:error>' % AL_NS

    def test_base(self):
        self.assertEquals(self.elmt.type, "gargl")
        self.assertEquals(self.elmt.msg, 'message')

    def test_roundtrip(self):
        self._test_roundtrip()


# start plan ##################################################################

class StartPlanElementTC(BaseElementTC):

    xml_string = '<al:start-plan recipe="truc.bidule" xmlns:al="%s"/>'% AL_NS

    def test_base(self):
        self.assertEquals(self.elmt.recipe, "truc.bidule")
        self.assertEquals(self.elmt.time, None)
        self.assertEquals(self.elmt.delay, None)

    def test_roundtrip(self):
        clone = self._test_roundtrip()
        self.assertEquals(self.elmt.time, clone.time)
        self.assertEquals(self.elmt.delay, clone.delay)


class StartPlanElementTC1(StartPlanElementTC):

    xml_string = '''<al:start-plan recipe="truc.bidule" xmlns:al="%s">
    <al:time hours="4" weekdays="5"/>
</al:start-plan>
''' % AL_NS

    def test_base(self):
        self.assertEquals(self.elmt.recipe, "truc.bidule")
        self.assertEquals(self.elmt.time, ('*', '*', u'4', '*', '*', u'5') )
        self.assertEquals(self.elmt.delay, None)

class StartPlanElementTC2(StartPlanElementTC):

    xml_string = '''<al:start-plan recipe="truc.bidule" xmlns:al="%s">
    <al:delay seconds="4" hours="5"/>
</al:start-plan>
''' % AL_NS

    def test_base(self):
        self.assertEquals(self.elmt.recipe, "truc.bidule")
        self.assertEquals(self.elmt.time, None)
        self.assertEquals(self.elmt.delay, 4+5*60*60 )

# listen on ###################################################################

class ListenOnElementTC(BaseElementTC):

    xml_string = '<al:listen-on port="80" type="web" xmlns:al="%s"/>' % AL_NS

    def test_base(self):
        self.assertEquals(self.elmt.port, 80)
        self.assertEquals(self.elmt.type, 'web')
        self.assertEquals(self.elmt.host, 'localhost')

    def test_roundtrip(self):
        self._test_roundtrip()

class ListenOnElementTC2(ListenOnElementTC):

    xml_string = '<al:listen-on port="80" host="crater" type="web" xmlns:al="%s"/>' % AL_NS

    def test_base(self):
        self.assertEquals(self.elmt.port, 80)
        self.assertEquals(self.elmt.type, 'web')
        self.assertEquals(self.elmt.host, 'crater')

# quit ########################################################################

class QuitElementTC(BaseElementTC):

    xml_string = '<al:quit xmlns:al="%s"/>' % AL_NS

    def test_roundtrip(self):
        self._test_roundtrip()



if __name__ == '__main__':
    unittest.main()
