

import unittest

from narval.reader import REGISTRY as reg
from narval.elements import chat

reg.register_class(chat.BotConfigurationElement)

class BotConfigurationElementTC(unittest.TestCase):

    xml_string = """
<bot-configuration verbose="yes" min_treshold="0.30" max_treshold="0.70" mode="default">
  <access-right command="log_categorize">all</access-right>
  <access-right command="log_control">myuser</access-right>
  <access-right command="kb_add_rule">myuser</access-right>
  <access-right command="kb_add_stmt">myuser</access-right>
  <access-right command="kb_foaf_export">myuser</access-right>
  <access-right command="response">all</access-right>
  <access-right command="shutdown" usable-in-group-chat="no">toto</access-right>
</bot-configuration>
"""

    def setUp(self):
        self.elmt = reg.from_string(self.xml_string)[0]

    def test_base(self):
        self.assertEquals(self.elmt.verbose, True)
        #self.assertEquals(self.elmt.mode, 'default')
        self.assertEquals(self.elmt.min_treshold, 0.30)
        self.assertEquals(self.elmt.max_treshold, 0.70)

    def test_has_access_right(self):
        # with master_id
        self.assertEquals(self.elmt.has_access_right('syt', 'syt', 'shutdown'), False)
        self.assertEquals(self.elmt.has_access_right('syt', 'toto', 'shutdown'), True)
        self.assertEquals(self.elmt.has_access_right('syt', 'syt', 'undefined'), True)
        self.assertEquals(self.elmt.has_access_right('syt', 'toto', 'undefined'), False)
        self.assertEquals(self.elmt.has_access_right('syt', 'syt', 'response'), True)
        self.assertEquals(self.elmt.has_access_right('syt', 'toto', 'response'), True)
        self.assertEquals(self.elmt.has_access_right('syt', 'syt', 'log_control'), True)
        self.assertEquals(self.elmt.has_access_right('syt', 'toto', 'log_control'), False)
        # without master_id
        self.assertEquals(self.elmt.has_access_right(None, 'syt', 'undefined'), True)
        self.assertEquals(self.elmt.has_access_right(None, 'toto', 'undefined'), True)
        self.assertEquals(self.elmt.has_access_right(None, 'syt', 'log_control'), False)
        self.assertEquals(self.elmt.has_access_right(None, 'toto', 'log_control'), False)
        # special behaviour in group chat
        self.assertEquals(self.elmt.has_access_right('syt', 'syt', 'shutdown', True), False)
        self.assertEquals(self.elmt.has_access_right('syt', 'toto', 'shutdown', True), False)
        
    def test_roundtrip(self):
        clone = reg.from_string(self.elmt.as_xml())[0] 
        self.assertEquals(self.elmt._ns_attrs, clone._ns_attrs)
        self.assertEquals(self.elmt.acls, clone.acls)


class BotConfigurationElementTCWildcards(unittest.TestCase):

    xml_string = """
<bot-configuration verbose="yes" min_treshold="0.30" max_treshold="0.70" mode="default">
  <access-right command="log_co*">myuser</access-right>
  <access-right command="log_*">all</access-right>
  <access-right command="kb_*">myuser</access-right>
</bot-configuration>
"""

    def setUp(self):
        self.elmt = reg.from_string(self.xml_string)[0]

    def test_has_access_right(self):
        self.assertEquals(self.elmt.has_access_right('syt', 'syt', 'log_control'), True)
        self.assertEquals(self.elmt.has_access_right('syt', 'toto', 'log_control'), True)
        self.assertEquals(self.elmt.has_access_right('syt', 'syt', 'log_categorize'), True)
        self.assertEquals(self.elmt.has_access_right('syt', 'toto', 'log_categorize'), True)
        self.assertEquals(self.elmt.has_access_right('syt', 'syt', 'kb_add_stmt'), True)
        self.assertEquals(self.elmt.has_access_right('syt', 'toto', 'kb_add_stmt'), False)
        

if __name__ == '__main__':
    unittest.main()
