import unittest

from narval.reader import REGISTRY as reg
from narval.elements import activity

reg.register_class(activity.ActivityElement)

class ActivityElementTC(unittest.TestCase):

    xml_string = """
<activity date="2004-11-23" ratio="0.5">activity reports implementation</activity>
"""

    def setUp(self):
        self.elmt = reg.from_string(self.xml_string)[0]

    def test_base(self):
        self.assertEquals(self.elmt.date.year, 2004)
        self.assertEquals(self.elmt.date.month, 11)
        self.assertEquals(self.elmt.date.day, 23)
        self.assertEquals(self.elmt.ratio, 0.5)
        self.assertEquals(self.elmt.subject, 'activity reports implementation')

    def test_roundtrip(self):
        clone = reg.from_string(self.elmt.as_xml())[0] 
        self.assertEquals(self.elmt._ns_attrs, clone._ns_attrs)
        self.assertEquals(self.elmt.subject.strip(), clone.subject.strip())


if __name__ == '__main__':
    unittest.main()
