# Copyright (c) 2000-2004 LOGILAB S.A. (Paris, FRANCE).
# http://www.logilab.fr/ -- mailto:contact@logilab.fr
#
# Copyright (c) 2004 DoCoMo Euro-Labs GmbH (Munich, Germany).
# http://www.docomolab-euro.com/ -- mailto:tarlano@docomolab-euro.com
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
"""unit tests for narval modules.Metalog

:version: $Revision:$  
:author: Logilab

:copyright:
  2000-2004 LOGILAB S.A. (Paris, FRANCE)
  
  2004 DoCoMo Euro-Labs GmbH (Munich, Germany)
  
:contact:
  http://www.logilab.fr/ -- mailto:contact@logilab.fr
  
  http://www.docomolab-euro.com/ -- mailto:tarlano@docomolab-euro.com
"""

import unittest
from os.path import abspath, dirname
import os
from tempfile import mkstemp        
from logilab.common import testlib
from narval.elements.base import URLElement, FileElement

from narval.actions.Metalog import *

from cStringIO import StringIO

SUCCESS_MSG = 'this is metalog syntax'


FATAL_QU = """
What's up?
"""


DATA_QU = """
do you know if JOHN OWNS SOMETHING ?
"""
METALOG_STMTS = """
JOHN represents "John Smith" from "http://www.joesmith.example.org".
MARY represents "Mary" from "http://www.maryellen.example.org".
OWN represents "own" from "http://www.relationships.example.com".
OWNS represents the same as OWN.
RICH represents "rich" from "http://www.adjectives.example.com".

JOHN OWNS a "guitar".
MARY OWNS a "car".
JOHN and MARY OWN a "red house".
"""
class MockMessage:

    def __init__(self, message):
        self.message = message

    def build_reply(self, new_message):
        self.message = new_message
        return self

    def get_body(self):
        return self.message

class MetalogTest(testlib.TestCase):

    def setUp(self):
        _, self.kb_filename = mkstemp()
        f = open(self.kb_filename, 'w')
        f.write(METALOG_STMTS)
        f.close()
        
    def test_query_metalog(self):
        stmt_url = URLElement()
        stmt_url.address = self.kb_filename
        msg = MockMessage(DATA_QU)
        outputs = query_metalog({'msg' : msg,
                                 'metalog_kb' : stmt_url})
        msg = outputs['msg']
        print msg.get_body()
        self.assertNotEquals(msg.get_body(), 'Failed metalog resolve')
        self.assertEquals(msg.get_body(), 'JOHN OWN "guitar".')

    def test_query_metalog_fails(self):
        stmt_url = URLElement()
        stmt_url.address = self.kb_filename
        msg = MockMessage(FATAL_QU)
        outputs = query_metalog({'msg' : msg,
                                 'metalog_kb' : stmt_url})
        msg = outputs['msg']
        print msg.get_body()
        self.assertEquals(msg.get_body(), 'failed to query metalog')

        
if __name__ == '__main__':
    unittest.main()
