# Copyright (c) 2000-2004 LOGILAB S.A. (Paris, FRANCE).
# http://www.logilab.fr/ -- mailto:contact@logilab.fr
#
# Copyright (c) 2004 DoCoMo Euro-Labs GmbH (Munich, Germany).
# http://www.docomolab-euro.com/ -- mailto:tarlano@docomolab-euro.com
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
"""unit tests for JabberProtocolHandler

:version: $Revision:$  
:author: Logilab

:copyright:
  2000-2004 LOGILAB S.A. (Paris, FRANCE)
  
  2004 DoCoMo Euro-Labs GmbH (Munich, Germany)
  
:contact:
  http://www.logilab.fr/ -- mailto:contact@logilab.fr
  
  http://www.docomolab-euro.com/ -- mailto:tarlano@docomolab-euro.com
"""

import unittest
from logilab.common import testlib
from narval.protocol_handlers.jabber import *
from narval.protocol_handlers import TwistedProtocolHandler
from xml.sax import make_parser


# normal
MESSAGE_CHAT = """
<message to='arthur@jabber.logilab.org/Logilab' type='chat'>
  <body>salut</body>
</message>
<message type='chat' to='arthur_narval@jabber.logilab.org/Logilab' from='arthur@jabber.logilab.org/Logilab'>
  <x xmlns='jabber:x:event'>
    <composing/>
  </x>
  <body>yo</body>
  <html xmlns='http://jabber.org/protocol/xhtml-im'>
    <body xmlns='http://www.w3.org/1999/xhtml'>yo</body>
  </html>
</message>"""

#GROUPCHAT
MESSAGE_CHAT = """
<message to='arthur_narval@jabber.logilab.org/Logilab' type='groupchat' from='test@conference.jabber.logilab.org/arthur_narval'>
  <body>hi</body>
</message>
<message to='arthur_narval@jabber.logilab.org/Logilab' type='groupchat' from='test@conference.jabber.logilab.org/archer'>
  <body>hi</body>
</message> """

GROUPCHAT_PRESENCE = """<presence to='arthur_narval@jabber.logilab.org/Logilab' from='test@conference.jabber.logilab.org/maj.chip.hazard'>
  <x xmlns='jabber:x:delay' from='test@conference.jabber.logilab.org/maj.chip.hazard' stamp='20041007T08:41:14'/>
  <x xmlns='http://jabber.org/protocol/muc#user'>
    <item affiliation='none' role='participant'/>
  </x>
</presence>
"""

NORMAL_PRESENCE = """<presence from='arthur@jabber.logilab.org/Logilab' to='arthur_narval@jabber.logilab.org'/>"""

class JabTest(testlib.TestCase):

    def test_get_server(self):
        self.assertEquals(get_server('arthur@jabber.logilab.org'),
                          'jabber.logilab.org')
        self.assertEquals(get_server('arthur@jabber.logilab.org/Logilab'),
                          'jabber.logilab.org')
        self.assertEquals(get_server('arthur@jabber.logilab.org/Logilab'),
                          'jabber.logilab.org')
        self.assertNotEquals(get_server('test@conference.jabber.logilab.org/archer'),
                          'jabber.logilab.org')

    def test_is_from_groupchat(self):
        pass
        #TODO
        #handler = TwistedProtocolHandler()
        #parser = make_parser()
        #parser.setContentHandler(handler)
        #parser.parse(GROUPCHAT_PRESENCE)
        #grp_presence = handler.elmt
        #self.assertEquals(grp_presence.is_from_groupchat(), True)
        #chat_presence = handler(GROUPCHAT_PRESENCE)
        #self.assertEquals(chat_presence.is_from_groupchat(), False)
        


if __name__ == '__main__':
    unittest.main()
    
