# Copyright (c) 2000-2004 LOGILAB S.A. (Paris, FRANCE).
# http://www.logilab.fr/ -- mailto:contact@logilab.fr
#
# Copyright (c) 2004 DoCoMo Euro-Labs GmbH (Munich, Germany).
# http://www.docomolab-euro.com/ -- mailto:tarlano@docomolab-euro.com
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
"""unit tests for narval modules.Entertainement 

:version: $Revision:$  
:author: Logilab

:copyright:
  2000-2004 LOGILAB S.A. (Paris, FRANCE)
  
  2004 DoCoMo Euro-Labs GmbH (Munich, Germany)
  
:contact:
  http://www.logilab.fr/ -- mailto:contact@logilab.fr
  
  http://www.docomolab-euro.com/ -- mailto:tarlano@docomolab-euro.com
"""

import os
import unittest
from logilab.common.testlib import TestCase

from narval.actions.Entertainment import *

POSSIBLE_SEARCHES = ['imdb', 'allocine', 'xmltv']


class GlobalFilmElement(TestCase):

    def setUp(self):
        search_central = SearchCentral()
        search_central.add_file_ref('xmltv', os.path.join('data','xmltv-test.xml'))
        self.results = []
        for engine in  POSSIBLE_SEARCHES:
            list = search_central.search(engine, 'Monty Python')
            #self.assert_(list, 'Check %s is up and running correctly, or format has changed' % engine)
            if len(list):
                self.results.append((engine, list[0].eid))


    def test_available(self):
        search_central = SearchCentral()
        self.assertListEquals(search_central.get_available_engines(),
                              POSSIBLE_SEARCHES)

    def test_one_line(self):
        search_central = SearchCentral()
        for type, eid in self.results:
            film = search_central.get_complete(type, eid)
            if film:
                film_str = film.one_line_representation()
                self.assert_(film_str, '%s dont print %s' % (film, film.type))

    def test_representation(self):
        search_central = SearchCentral()
        for type, eid in self.results:
            film = search_central.get_complete(type, eid)
            if film:
                film_str = film.representation()
                self.assert_(film_str)
            
    


class AllocineTest(TestCase):

    def test_search(self):
        list = search_movie_allocine('Monty Python')
        self.assert_(list, 'Check allocine is up and running correctly, or format has changed')

    def test_get_one_item(self):
        list = search_movie_allocine('Monty Python')
        full_info = get_full_info_allocine(list[0].eid)
        self.assert_(full_info)

    def test_get_one_other_item(self):
        list = search_movie_allocine('Assasination Nixon')
        full_info = get_full_info_allocine(list[0].eid)
        self.assert_(full_info.info['cprojection'])

    def test_get_listings(self):
        list = search_movie_allocine('Assasination Nixon')
        full_info = get_full_info_allocine(list[0].eid)
        self.assert_(full_info.info['cprojection'])
        listings = search_listings_movie(full_info, '92120')
        for item in listings:
            for key in ['url','eid','version','eid','title']:
                self.assert_(item.has_key(key))
        
        
class IMDbTest(TestCase):

    def test_search(self):
        list = search_movie_imdb('Monty Python')
        self.assert_(list)

    def test_get_one_item(self):
        list = search_movie_imdb('Monty Python')
        full_info = get_full_info_imdb(list[0].eid)
        self.assert_(full_info)


class FunctionsTest(TestCase):

    def test_refining_search(self):
        search_str = 'allocine Monty Python'
        engines, search_str = extract_refining_search(search_str,
                                ['allocine', 'imdb', 'xmlt'])
        self.assertEquals(engines, ['allocine'])
        self.assertEquals(search_str, 'Monty Python')

    def test_refining_search2(self):
        search_str = 'Monty Python'
        engines = ['allocine', 'imdb', 'xmlt']
        engines_out, search_str = extract_refining_search(search_str,
                                                      engines)
        self.assertEquals(engines, engines_out)
        self.assertEquals(search_str, 'Monty Python')


class XmltvTest(TestCase):
    
    def setUp(self):
        self.search_central = SearchCentral()
        self.search_central.add_file_ref('xmltv', os.path.join('data','xmltv-test.xml'))

    def test_search(self):
        results = self.search_central.search('xmltv', 'Monty Python')
        self.assert_(results)
        for x in results:
            rep = x.one_line_representation()
            rep = x.representation()


if __name__ == '__main__':
    unittest.main()
