# Copyright (c) 2004 DoCoMo Euro-Labs GmbH (Munich, Germany).
# Copyright (c) 2002 Spex66.
# Copyright (c) 2001-2004 LOGILAB S.A. (Paris, FRANCE).
#
# http://www.docomolab-euro.com/ -- mailto:tarlano@docomolab-euro.com
# http://www.logilab.fr/ -- mailto:contact@logilab.fr
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
"""the shell service, provide access to an interactive python interpreter
with the narval interpreter available in the locals as "_"

:version: $Revision:$  
:author: Logilab

:copyright:
  2001-2004 LOGILAB S.A. (Paris, FRANCE)

  2002: spex66
  
  2004 DoCoMo Euro-Labs GmbH (Munich, Germany)
  
:contact:
  http://www.logilab.fr/ -- mailto:contact@logilab.fr
  
  http://www.docomolab-euro.com/ -- mailto:tarlano@docomolab-euro.com


:var CPRT: phrase to display when starting the interactive console
"""

__revision__ = "$Id: EventScheduler.py,v 1.9 2001/12/07 16:01:33 syt Exp $"
__docformat__ = "restructuredtext en"

import sys
from code import InteractiveConsole
try:
    import readline
except ImportError:
    log(LOG_WARN, 'readline is not available')
    
from narval.services.BaseService import BaseService

try:
    sys.ps1
except AttributeError:
    sys.ps1 = ">>> "
try:
    sys.ps2
except AttributeError:
    sys.ps2 = "... "

CPRT = 'Type "help", "copyright", "credits" or "license" for more information.'

class ShellService(BaseService, InteractiveConsole):
    """a narval service allowing narval's introspection through a python shell
    """
    
    def __init__(self, engine, name='ShellService'):
        BaseService.__init__(self, name)
        InteractiveConsole.__init__(self, locals={'_': engine})

    def _run(self):
        """service's main loop, wait for input from stdin"""
        self.write("Python %s on %s\n%s\n(%s)\n" % (
            sys.version, sys.platform, CPRT, self.__class__.__name__))
        more = 0
        while self.loop:
            if more:
                prompt = sys.ps2
            else:
                prompt = sys.ps1
            line = raw_input(prompt)
            if line.lower() in ('bye', 'quit', 'exit'):
                # get exit commands
                self.loop = 0
                self.locals['_'].post_event( ('quit', ))
            else:
                more = self.push(line)
                

