# pylint: disable-msg=W0611
#
# Copyright (c) 2004-2005 DoCoMo Euro-Labs GmbH (Munich, Germany).
# http://www.docomolab-euro.com/ -- mailto:tarlano@docomolab-euro.com
#
# Copyright (c) 2001-2005 LOGILAB S.A. (Paris, FRANCE).
# http://www.logilab.fr/ -- mailto:contact@logilab.fr
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
"""'virtual' module importing classes/functions that should be publicly
used by narval application's python libraries (i.e. interfaces, elements
and actions)


:version: $Revision:$  
:author: Logilab

:copyright:
  2001-2005 LOGILAB S.A. (Paris, FRANCE)
  
  2004-2005 DoCoMo Euro-Labs GmbH (Munich, Germany)

:contact:
  http://www.logilab.fr/ -- mailto:contact@logilab.fr
  
  http://www.docomolab-euro.com/ -- mailto:tarlano@docomolab-euro.com
"""

__revision__ = "$Id: public.py $"
__docformat__ = "restructuredtext en"

from urlparse import urlparse

from twisted.python.components import Interface, Adapter, implements

from narval import config
from narval.interfaces.base import IURL
from narval import NO_NS, AL_NS, TYPE_NS
from narval.reader import match_expression, multi_match_expression

def expand_vars(path):
    """expand some known environment variables for in the path string
    (NARVAL_HOME and HOME)

    :type path: str
    :param path: the file system path to expand

    :rtype: str
    :return: the expanded path
    """
    path = path.replace('$NARVAL_HOME', config.get_home())
    user_home = config.get_user_home()
    if not user_home:
        log(LOG_ERR, 'unable to expand $HOME')
        return path
    return path.replace('$HOME', user_home)

def url_to_file(obj=None, default=None):
    """return the path to a file and it's encoding from a IURL element

    :param obj: object adaptable to IURL

    :rtype: tuple(str, str)
    """
    if obj is None:
        path = normalize_url(default)[1][2]
        encoding = 'UTF-8'
    else:
        # FIXME: check protocol == file: ?
        iurl = IURL(obj)
        path = iurl.path()
        encoding = iurl.encoding or 'UTF-8'
    return path, encoding
    
def normalize_url(url):
    """normalize an url by trying to replace some environment variables
    (NARVAL_HOME and HOME)
    return the expanded url and the tuple returned by url parse
    
    :type url: str
    :param url: the url to expand

    :rtype: tuple
    :return:
      the expanded url and the result of urlparse.urlparse on the expanded url
    """
    url = expand_vars(url)
    url_tuple = urlparse(url)
    # remove the leading / from the filename with windows file names
    if url_tuple[0] == 'file' and url_tuple[2][0]=='/' and url_tuple[2][2] == ':':
        url_tuple = list(url_tuple)
        url_tuple[2] = url_tuple[2][1:]
        url_tuple = list(url_tuple)
    return url, url_tuple

