# Copyright (c) 2004 DoCoMo Euro-Labs GmbH (Munich, Germany).
# Copyright (c) 2001-2004 LOGILAB S.A. (Paris, FRANCE).
#
# http://www.docomolab-euro.com/ -- mailto:tarlano@docomolab-euro.com
# http://www.logilab.fr/ -- mailto:contact@logilab.fr
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
"""Specific RDF-related interfaces for narval elementss:

- statement
- rule
- rdql-query


:version: $Revision:$  
:author: Logilab

:copyright:
  2001-2004 LOGILAB S.A. (Paris, FRANCE)
  
  2004 DoCoMo Euro-Labs GmbH (Munich, Germany)
  
:contact:
  http://www.logilab.fr/ -- mailto:contact@logilab.fr
  
  http://www.docomolab-euro.com/ -- mailto:tarlano@docomolab-euro.com
"""

__revision__ = "$Id: lib.py,v 1.78 2002/10/14 14:24:11 syt Exp $"
__docformat__ = "restructuredtext en"

from narval.public import Interface, Adapter
from narval.interfaces.base import ICommand, IData, IDictionary

# interfaces ##################################################################
class IRDFStatement(Interface):
    """interface for a RDF like statement
        
    :ivar subject: the subject of the statement
    :ivar predicate: the predicate of the statement
    :ivar object: the object of the statement
    """

class IRDFRule(Interface):
    """interface for a RDF rule
        
    :ivar statement: the rule'statement 
    :type statement: `IRDFStatement`
    :ivar implies: list of statements implied by the rule
    :type implies: list(`IRDFStatement`)
    """

class IRDQLQuery(Interface):
    """interface for a RDQL query

    :ivar query: the rdql query
    :type query: str
    """

class IRDQLResultLine(IDictionary):
    """interface for a RDQL query's resuts line"""

class IRDFNamespace(Interface):
    """interface for RDF namespaces

    :ivar address: the uri
    :type address: str

    :ivar alias: the alias
    :type alias: str
    """
    

# adapters ####################################################################

class ICommandToIRDFStatement(Adapter):
    """adapt ICommand to IRDFStatement, under some condition"""
    __sources__ = ICommand,
    __implements__ = IRDFStatement,
    
    def __init__(self, original):
        Adapter.__init__(self, original)
        if not original.name in ('kb_add_stmt', 'kb_search_stmts'):
            # FIXME: raise appropriate exception
            raise Exception()
        if not len(original.args) == 3:
            # FIXME: raise appropriate exception
            raise Exception()
        self.subject, self.predicate, self.object = original.args

class IRDFStatementToIData(Adapter):
    """adapt IRDFStatement to IData"""
    __sources__ = IRDFStatement,
    __implements__ = IData,
    
    def __init__(self, original):
        Adapter.__init__(self, original)
        self.data = '%s %s %s.' % (original.subject, original.predicate,
                                   original.object)    

class ICommandToIRDQLQuery(Adapter):
    """adapt ICommand to IRDQLQuery, under some condition"""
    __sources__ = ICommand,
    __implements__ = IRDQLQuery,
    
    def __init__(self, original):
        Adapter.__init__(self, original)
        if not original.name == 'kb_rdql':
            # FIXME: raise appropriate exception
            raise Exception()
        if not len(original.args) == 1:
            # FIXME: raise appropriate exception
            raise Exception()
        self.query = original.args[0]


class IRDQLResultLineToIData(Adapter):
    """adapt IRDQLResultLine to IData"""
    __sources__ = IRDQLResultLine,
    __implements__ = IData,

    def __init__(self, original):
        Adapter.__init__(self, original)
        self.data = '(%s) : (%s)' % (
            ', '.join(original._dict.keys()),
            ', '.join(map(str, original._dict.values()))
            )
