# Copyright (c) 2001-2004 LOGILAB S.A. (Paris, FRANCE).
# http://www.logilab.fr/ -- mailto:contact@logilab.fr
#
# Copyright (c) 2004 DoCoMo Euro-Labs GmbH (Munich, Germany).
# http://www.docomolab-euro.com/ -- mailto:tarlano@docomolab-euro.com
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
"""Specfic RDF-related elements for narval memory's:

- statement
- rule
- rdql-query

:version: $Revision:$  
:author: Logilab

:copyright:
  2001-2004 LOGILAB S.A. (Paris, FRANCE)
  
  2004 DoCoMo Euro-Labs GmbH (Munich, Germany)
  
:contact:
  http://www.logilab.fr/ -- mailto:contact@logilab.fr
  
  http://www.docomolab-euro.com/ -- mailto:tarlano@docomolab-euro.com
"""

__revision__ = "$Id: lib.py,v 1.78 2002/10/14 14:24:11 syt Exp $"
__docformat__ = "restructuredtext en"

from narval.public import NO_NS, AL_NS, normalize_url
from narval.element import ALElement, NSAttribute
from narval.xml_handlers import ListHandler
from narval.elements.base import DictElement
from narval.interfaces.rdf import IRDFStatement, IRDFRule, IRDQLQuery, \
     IRDQLResultLine, IRDFNamespace

## class RDFHandler(BaseXMLHandler):

##     def start_element(self, head, attrs):
##         ns, prefix  = head
##         if ns is None:
##             rdf, name = prefix.split(':')
##             if name == "Description":
##                 self.elmt.subject = attrs[(None, 'rdf:about')]
##         else:
##             self.elmt.predicate = prefix

##     def characters(self, content):
##         self.elmt.object = content.strip()
        
##     def end_element(self, name):
##         return self.elmt
    

class RDFStatementElement(ALElement):
    """IRDFStatement implementation"""
    __implements__ = (IRDFStatement,)
    __xml_element__ = (NO_NS, 'rdf-statement')
    
    subject = NSAttribute(NO_NS, None, str, str)
    predicate = NSAttribute(NO_NS, None, str, str)
    object = NSAttribute(NO_NS, None, str, str)

    def __init__(self, subject=None, predicate=None, object=None, **kwargs):
        # this initializer is there to handle positional arguments
        super(RDFStatementElement, self).__init__(subject=subject,
                                                  predicate=predicate,
                                                  object=object,
                                                  **kwargs)
    def __repr__(self):
        return '<RDFStatementElement (%s,%s,%s) at %s>' % \
               (self.subject, self.predicate, self.object, id(self))

    def as_rdf_xml(self):
        return '  <rdf:Description rdf:about="%s">\n' \
               '    <ns0:%s xmlns:ns0="%s#">\n'\
               '       %s\n' \
               '    </ns0:%s>\n' \
               '  </rdf:Description>\n' % (self.subject,
                                           self.predicate,
                                           AL_NS,
                                           self.object,
                                           self.predicate)


class RDFRuleElement(ALElement):
    """IRDFStatement implementation"""
    __implements__ = (IRDFRule,)
    __xml_element__ = (NO_NS, 'rdf-rule')
    __child_handler__  = ListHandler
    list_attr = 'implies'
    
    subject = NSAttribute(NO_NS, None, str, str)
    predicate = NSAttribute(NO_NS, None, str, str)
    object = NSAttribute(NO_NS, None, str, str)
    implies = None


class RDQLQueryElement(ALElement):
    """IRDQL implementation"""
    __implements__ = (IRDQLQuery, )
    __xml_element__ = (NO_NS, 'rdql-query')
    
    query = NSAttribute(NO_NS, None, str, str)

    def __str__(self):
        return '<RDQLQueryElement (%s) at %s>' % (self.query, hex(id(self)))

    def __repr__(self):
        return str(self)

class RDQLResultLineElement(DictElement):
    """IRDQLResultLine implementation"""
    __implements__ = (IRDQLResultLine, )
    __xml_element__ = (NO_NS, 'rdql-result')

    def __str__(self):
        return '<RDQLResultLineElement at %s>' % (hex(id(self)))

    def __repr__(self):
        return str(self)

class RDFNamespaceElement(ALElement):
    """IRDFNamespace implementation"""
    __implements__ = (IRDFNamespace, )
    __xml_element__ = (NO_NS, 'rdf-ns')

    address = NSAttribute(NO_NS, None, str, str)
    alias = NSAttribute(NO_NS, None, str, str)

    def __str__(self):
        return '<RDFNamespaceElement (%s:%s) at %s>' % (
            self.address, self.alias, hex(id(self)))

    def __repr__(self):
        return str(self)
