# Copyright (c) 2004 DoCoMo Euro-Labs GmbH (Munich, Germany).
# Copyright (c) 2004 LOGILAB S.A. (Paris, FRANCE).
#
# http://www.docomolab-euro.com/ -- mailto:tarlano@docomolab-euro.com
# http://www.logilab.fr/ -- mailto:contact@logilab.fr
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
"""some elements used to control automatic documentation generation

:version: $Revision:$  
:author: Logilab

:copyright:
  2004 LOGILAB S.A. (Paris, FRANCE)
  
  2004 DoCoMo Euro-Labs GmbH (Munich, Germany)
  
:contact:
  http://www.logilab.fr/ -- mailto:contact@logilab.fr
  
  http://www.docomolab-euro.com/ -- mailto:tarlano@docomolab-euro.com
"""

__revision__ = "$Id:$"
__docformat__ = "restructuredtext en"

from narval.public import NO_NS
from narval.element import NSAttribute
from narval.action import ActionElement
from narval.recipe import RecipeElement
from narval.elements.base import URLElement

class AutodocConfigurationElement(URLElement):
    """an element to configure doc generation process\'s. It extends
    `URLElement` to locate the file where the documentation will be
    written, plus the following attributes:
    
    :type etype: str or None
    :attr etype: optional type of entity to document ('action' or 'recipe')

    :type group: str
    :attr group:
      the group attributes value for filtering (default to 'all', i.e.
      no filtering).

    :type directory: str or None
    :attr directory: optional base directory where generated files will be located

    :type lang: str
    :attr lang: the language abbreviation (default to 'en')
    """
    
    __xml_element__ = (NO_NS, 'autodoc-configuration')
    
    encoding = NSAttribute(NO_NS, 'UTF-8', str, str) # overiding URL's default
    etype = NSAttribute(NO_NS, None, str, str)
    group = NSAttribute(NO_NS, None, str, str)
    lang = NSAttribute(NO_NS, 'en', str, str)
    directory = NSAttribute(NO_NS, 'file:///$NARVAL_HOME/data', str, str)

    def raw_address(self, etype=None):
        """overiden from URLElement to compute address dynamically if
        necessary
        """
        if self.address:
            return self.address
        etype = self.etype and ('%s-' % self.etype) or ''
        return '%s/%s%s_%s.xml' % (self.directory, etype, self.group, self.lang)

    etypes = {'recipe': RecipeElement, 'action': ActionElement, None: object}
    
    def match_element(self, elmt):
        """return true if the given element should be documented"""
        if self.group and elmt.group != self.group:
            return False
        if elmt.__class__ not in (RecipeElement, ActionElement):
            return False
        if not isinstance(elmt, self.etypes[self.etype]):
            return False
        return True 
