# Copyright (c) 2004-2005 DoCoMo Euro-Labs GmbH (Munich, Germany).
# Copyright (c) 2004-2005 LOGILAB S.A. (Paris, FRANCE).
#
# http://www.docomolab-euro.com/ -- mailto:tarlano@docomolab-euro.com
# http://www.logilab.fr/ -- mailto:contact@logilab.fr
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
"""some elements used in activity traceability

:version: $Revision:$  
:author: Logilab

:copyright:
  2004-2005 LOGILAB S.A. (Paris, FRANCE)
  
  2004-2005 DoCoMo Euro-Labs GmbH (Munich, Germany)
  
:contact:
  http://www.logilab.fr/ -- mailto:contact@logilab.fr
  
  http://www.docomolab-euro.com/ -- mailto:tarlano@docomolab-euro.com
"""

__revision__ = "$Id:$"
__docformat__ = "restructuredtext en"

from xml.sax.saxutils import escape

from narval.public import NO_NS
from narval.element import ALElement, NSAttribute
from narval.xml_handlers import data_handler
from narval.serialutils import date_value, date_rev_value, float_rev_value
from narval.interfaces.activity import IActivity

class ActivityElement(ALElement):
    """an element representing some activity of the agent's user

    :type date: mxDateTime
    :attr date: the date of this activity

    :type ratio: float
    :attr ratio: the ratio of a full day spent on this activity (0 < ratio < 1)

    :type subject: str
    :attr subject: the subject of this activity
    """
    __implements__ = IActivity    
    __xml_element__ = (NO_NS, 'activity')
    __child_handler__  = data_handler('subject')
    
    date = NSAttribute(NO_NS, None, date_value, date_rev_value)
    ratio = NSAttribute(NO_NS, None, float, float_rev_value)
    subject = ''
    
    def children_as_xml(self, encoding='UTF-8'):
        """return the XML representation of children in this element.

        :type encoding: str
        :param encoding: the encoding to use in the returned string

        :rtype: str
        :return: XML string representing the element
        """
        return escape(getattr(self, 'subject', ''))


class ActivityConfigurationElement(ALElement):
    """an element to configure activity reports

    :type sendto: str
    :attr sendto: address of the activity reports'collector

    :type sendby: str
    :attr sendby: the way activity reports are sent (email or im)
    """
    
    __xml_element__ = (NO_NS, 'activity-configuration')
    
    sendto = NSAttribute(NO_NS, None, str, str)
    sendvia = NSAttribute(NO_NS, 'email', str, str)
