"""dynamically loaded elements used in narval"""

__revision__ = '$Id:$'


# factory functions ###########################################################

from narval.elements.core import ErrorElement
from narval.elements.base import CommandElement

def create_error(msg, type='', from_msg=None):
    """create and return a IError element

    :type msg: str
    :param msg: the error message
    
    :type type: str
    :param type: the error's type

    :type from_msg: IIMessage or None
    :param from_msg: optional Internet message which has triggered the error
    """
    assert msg
    error = ErrorElement()
    error.msg = msg
    error.type = type
    error.from_msg = from_msg
    return error

def create_command(cmdname, args):
    """create and return a ICommand element
    
    :type cmdname: str
    :param cmdname: the name of the command to create
    
    :type args: tuple
    :param args: the command arguments
    """
    command = CommandElement()
    command.name = cmdname
    command.args = args
    return command
