# Copyright (c) 2004-2005 DoCoMo Euro-Labs GmbH (Munich, Germany).
# Copyright (c) 2001-2005 LOGILAB S.A. (Paris, FRANCE).
#
# http://www.docomolab-euro.com/ -- mailto:tarlano@docomolab-euro.com
# http://www.logilab.fr/ -- mailto:contact@logilab.fr
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
"""create server/proxy object according to a desired protocol


:version: $Revision:$ 
:author: Logilab  

:copyright:
  2001-2005 LOGILAB S.A. (Paris, FRANCE)
  
  2004-2005 DoCoMo Euro-Labs GmbH (Munich, Germany)
  
:contact:
  http://www.logilab.fr/ -- mailto:contact@logilab.fr
  
  http://www.docomolab-euro.com/ -- mailto:tarlano@docomolab-euro.com
"""

__revision__ = '$Id: RPCFactory.py,v 1.4 2001/12/21 13:52:51 syt Exp $'

DEFAULT = 'pyro'

def create_server(port, handler, type=DEFAULT, debug=0):
    """return remotly accessible server"""
    if type == 'xmlrpc':
        from narval.communication import xmlrpc
        return xmlrpc.XMLRPCServer(port, handler)
    elif type == 'pyro':
        from narval.communication import pyro
        return pyro.PYROServer(port, handler, debug)
        
def create_proxy(uri):
    """return a proxy on the remote server"""
    type, host, port, name = decode_uri(uri)
    if type == 'xmlrpc':
        from narval.communication import xmlrpc
        return xmlrpc.XMLRPCProxy('http://%s:%s' % (host, port))
    elif type == 'pyro':
        from narval.communication import pyro
        return pyro.PYROProxy(uri).obj

def decode_uri(uri):
    addr, name = uri.split('/')
    proto, host, port = addr.split(':')
    return (proto, host, port, name)

def encode_uri(proto, host, port, name=''):
    host = host.split('.')[0]
    return '%s:%s:%s/%s' % (proto, host, port, name)

class ServerInterface:
    def call(self, method, params):
        # server must have a methods handler with references to
        # objects whose methods are shared, and the EXPORTED_METHODS
        # dictionnary which lists the shared methods and gives the
        # objects which provides these methods.
        raise Exception('not implemented')

class ProxyInterface:
    def request(self, method, param):
        raise Exception('not implemented')

