# Copyright (c) 2004-2005 DoCoMo Euro-Labs GmbH (Munich, Germany).
# Copyright (c) 2001-2005 LOGILAB S.A. (Paris, FRANCE).
#
# http://www.docomolab-euro.com/ -- mailto:tarlano@docomolab-euro.com
# http://www.logilab.fr/ -- mailto:contact@logilab.fr
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
"""narval introspection related actions


:version: $Revision:$  
:author: Logilab

:copyright:
  2000-2005 LOGILAB S.A. (Paris, FRANCE)
  
  2004-2005 DoCoMo Euro-Labs GmbH (Munich, Germany)
  
:contact:
  http://www.logilab.fr/ -- mailto:contact@logilab.fr
  
  http://www.docomolab-euro.com/ -- mailto:tarlano@docomolab-euro.com
"""

__revision__ = "$Id: Basic.py,v 1.70 2002/09/20 14:12:35 syt Exp $"
__docformat__ = 'restructuredtext en'

from narval.public import AL_NS, url_to_file
from narval.elements.base import FileElement

DEFAULT_PLANS_LOG_FILE_URL = 'file:$NARVAL_HOME/data/plans.log'

def plan_logs_file(obj=None):
    """return the path to the plans log's file and it's encoding

    :param obj: object adaptable to IURL or None

    :rtype: `FileElement`
    """
    address, encoding = url_to_file(obj, DEFAULT_PLANS_LOG_FILE_URL)
    return FileElement(address=address, encoding=encoding)


MOD_XML = '''<?xml version="1.0" encoding="ISO-8859-1"?>
<module xmlns:al="%s">''' % AL_NS

def act_log_plans(inputs):
    """log plans information into a log file for latter analysis"""
    log_str = []
    base_str = 'plan eid=%s name=%s.%s timestamp=%s status=%s'
    for plan in inputs['plans']:
        plan_str = base_str % (plan.eid, plan.group, plan.name,
                               plan.timestamp, plan.state)
        log_str.append(plan_str)
    log_file = plan_logs_file(inputs['logfile'])
    log_file.mode = 'a'
    log_file.data = '\n'.join(log_str) + '\n'
    return {'data':log_file}

MOD_XML = MOD_XML + """
<al:action name='log-plans' func='act_log_plans'>
  <al:description lang='en'>%s</al:description>

  <al:input id='plans' list='yes'>
    <al:match>isinstance(elmt, PlanElement)</al:match>
  </al:input>
  <al:input id='logfile' optional='yes'>
    <al:match>elmt.getattr((TYPE_NS, 'name')) == 'uri:memory:planslog'</al:match>
    <al:match>IURL(elmt)</al:match>
  </al:input>
  
  <al:output id='data'>
    <al:match>IFile(elmt)</al:match>
  </al:output>
</al:action>""" % act_log_plans.__doc__


MOD_XML +=  "</module>"
