# pylint: disable-msg=W0622
# Copyright (c) 2004-2005 DoCoMo Euro-Labs GmbH (Munich, Germany).
# Copyright (c) 2001-2004 LOGILAB S.A. (Paris, FRANCE).
#
# http://www.docomolab-euro.com/ -- mailto:tarlano@docomolab-euro.com
# http://www.logilab.fr/ -- mailto:contact@logilab.fr
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
"""narval's packaging information"""

__revision__ = '$Id: __pkginfo__.py,v 1.7 2004/02/20 15:55:44 alf Exp $'


modname = 'narval'

numversion = (2, 0, 2)
version = '.'.join([str(num) for num in numversion])
pyversions = ('2.3', )
#'2.4' not supported since there is no pythonX.Y-pyro packages


license = 'LGPL'
copyright = '''Copyright (c) 2000-2005 LOGILAB S.A. (Paris, FRANCE).
Copyright (c) 2004-2005 DoCoMo Euro-Labs GmbH (Munich, Germany).

http://www.logilab.fr/ -- mailto:contact@logilab.fr
http://www.docomolab-euro.com/ -- mailto:tarlano@docomolab-euro.com
'''

short_desc = "network assistant reasoning with a validating agent language"

long_desc = """Narval (Network Assistant Reasoning with a Validating
Agent Language) is a personal network assistant based on artificial
intelligence and agent technologies.

It executes recipes (sequences of actions) to perform tasks. It is
easy to specify a new action using XML and to implement it using
Python. Recipes can be constructed graphically by linking blocks
representing the actions without programming."""

scripts = ['bin/narval', 'bin/npm', 'bin/narval-runtest']

author = "Logilab"
author_email = "contact@logilab.fr"

web = "http://www.logilab.org/projects/narval"
ftp = "ftp://ftp.logilab.org/pub/narval/"
mailinglist = "http://lists.logilab.org/mailman/listinfo/ai-projects"

from glob import glob
import os

def __glob(expression):
    return [f for f in glob(expression) if f.find('.svn') == -1]

def __make_data_files():
    data_files = [('etc/narval',
                   __glob('conf/*')),
                  ]
    for base, local in (('share/narval', 'share/data'),
                        ('share/narval', 'share/recipes'),
                        ('share/narval', 'share/tests'),
                        ('share/narval', 'share/dtd'),
                        ('share/narval', 'share/doc'),
                        ('share/doc/narval', 'doc')):
        for dirpath, dirnames, files in os.walk(local):
            if '.svn' in dirnames:
                dirnames.remove('.svn')
            try:
                relative = os.path.join(*dirpath.split(os.sep)[1:])
            except TypeError:
                relative = ''
            data_files.append((os.path.join(base, relative),
                               [os.path.join(dirpath, f) for f in files]))        
    return data_files

data_files = __make_data_files()
