"""
Color data and pre-defined cmap objects.

This is a helper for cm.py, originally part of that file.
Separating the data (this file) from cm.py makes both easier
to deal with.

Objects visible in cm.py are the individual cmap objects ('autumn',
etc.) and a dictionary, 'datad', including all of these objects.
"""

from matplotlib import rcParams, colors
LUTSIZE = rcParams['image.lut']



_bone_data = {'red':   ((0., 0., 0.),(1.0, 1.0, 1.0)),
              'green': ((0., 0., 0.),(1.0, 1.0, 1.0)),
              'blue':  ((0., 0., 0.),(1.0, 1.0, 1.0))}


_autumn_data = {'red':   ((0., 1.0, 1.0),(1.0, 1.0, 1.0)),
                'green': ((0., 0., 0.),(1.0, 1.0, 1.0)),
                'blue':  ((0., 0., 0.),(1.0, 0., 0.))}

_bone_data = {'red':   ((0., 0., 0.),(0.746032, 0.652778, 0.652778),(1.0, 1.0, 1.0)),
              'green': ((0., 0., 0.),(0.365079, 0.319444, 0.319444),
                        (0.746032, 0.777778, 0.777778),(1.0, 1.0, 1.0)),
              'blue':  ((0., 0., 0.),(0.365079, 0.444444, 0.444444),(1.0, 1.0, 1.0))}

_cool_data = {'red':   ((0., 0., 0.), (1.0, 1.0, 1.0)),
              'green': ((0., 1., 1.), (1.0, 0.,  0.)),
              'blue':  ((0., 1., 1.), (1.0, 1.,  1.))}

_copper_data = {'red':   ((0., 0., 0.),(0.809524, 1.000000, 1.000000),(1.0, 1.0, 1.0)),
                'green': ((0., 0., 0.),(1.0, 0.7812, 0.7812)),
                'blue':  ((0., 0., 0.),(1.0, 0.4975, 0.4975))}

_flag_data = {'red':   ((0., 1., 1.),(0.015873, 1.000000, 1.000000),
                        (0.031746, 0.000000, 0.000000),(0.047619, 0.000000, 0.000000),
                        (0.063492, 1.000000, 1.000000),(0.079365, 1.000000, 1.000000),
                        (0.095238, 0.000000, 0.000000),(0.111111, 0.000000, 0.000000),
                        (0.126984, 1.000000, 1.000000),(0.142857, 1.000000, 1.000000),
                        (0.158730, 0.000000, 0.000000),(0.174603, 0.000000, 0.000000),
                        (0.190476, 1.000000, 1.000000),(0.206349, 1.000000, 1.000000),
                        (0.222222, 0.000000, 0.000000),(0.238095, 0.000000, 0.000000),
                        (0.253968, 1.000000, 1.000000),(0.269841, 1.000000, 1.000000),
                        (0.285714, 0.000000, 0.000000),(0.301587, 0.000000, 0.000000),
                        (0.317460, 1.000000, 1.000000),(0.333333, 1.000000, 1.000000),
                        (0.349206, 0.000000, 0.000000),(0.365079, 0.000000, 0.000000),
                        (0.380952, 1.000000, 1.000000),(0.396825, 1.000000, 1.000000),
                        (0.412698, 0.000000, 0.000000),(0.428571, 0.000000, 0.000000),
                        (0.444444, 1.000000, 1.000000),(0.460317, 1.000000, 1.000000),
                        (0.476190, 0.000000, 0.000000),(0.492063, 0.000000, 0.000000),
                        (0.507937, 1.000000, 1.000000),(0.523810, 1.000000, 1.000000),
                        (0.539683, 0.000000, 0.000000),(0.555556, 0.000000, 0.000000),
                        (0.571429, 1.000000, 1.000000),(0.587302, 1.000000, 1.000000),
                        (0.603175, 0.000000, 0.000000),(0.619048, 0.000000, 0.000000),
                        (0.634921, 1.000000, 1.000000),(0.650794, 1.000000, 1.000000),
                        (0.666667, 0.000000, 0.000000),(0.682540, 0.000000, 0.000000),
                        (0.698413, 1.000000, 1.000000),(0.714286, 1.000000, 1.000000),
                        (0.730159, 0.000000, 0.000000),(0.746032, 0.000000, 0.000000),
                        (0.761905, 1.000000, 1.000000),(0.777778, 1.000000, 1.000000),
                        (0.793651, 0.000000, 0.000000),(0.809524, 0.000000, 0.000000),
                        (0.825397, 1.000000, 1.000000),(0.841270, 1.000000, 1.000000),
                        (0.857143, 0.000000, 0.000000),(0.873016, 0.000000, 0.000000),
                        (0.888889, 1.000000, 1.000000),(0.904762, 1.000000, 1.000000),
                        (0.920635, 0.000000, 0.000000),(0.936508, 0.000000, 0.000000),
                        (0.952381, 1.000000, 1.000000),(0.968254, 1.000000, 1.000000),
                        (0.984127, 0.000000, 0.000000),(1.0, 0., 0.)),
              'green': ((0., 0., 0.),(0.015873, 1.000000, 1.000000),
                        (0.031746, 0.000000, 0.000000),(0.063492, 0.000000, 0.000000),
                        (0.079365, 1.000000, 1.000000),(0.095238, 0.000000, 0.000000),
                        (0.126984, 0.000000, 0.000000),(0.142857, 1.000000, 1.000000),
                        (0.158730, 0.000000, 0.000000),(0.190476, 0.000000, 0.000000),
                        (0.206349, 1.000000, 1.000000),(0.222222, 0.000000, 0.000000),
                        (0.253968, 0.000000, 0.000000),(0.269841, 1.000000, 1.000000),
                        (0.285714, 0.000000, 0.000000),(0.317460, 0.000000, 0.000000),
                        (0.333333, 1.000000, 1.000000),(0.349206, 0.000000, 0.000000),
                        (0.380952, 0.000000, 0.000000),(0.396825, 1.000000, 1.000000),
                        (0.412698, 0.000000, 0.000000),(0.444444, 0.000000, 0.000000),
                        (0.460317, 1.000000, 1.000000),(0.476190, 0.000000, 0.000000),
                        (0.507937, 0.000000, 0.000000),(0.523810, 1.000000, 1.000000),
                        (0.539683, 0.000000, 0.000000),(0.571429, 0.000000, 0.000000),
                        (0.587302, 1.000000, 1.000000),(0.603175, 0.000000, 0.000000),
                        (0.634921, 0.000000, 0.000000),(0.650794, 1.000000, 1.000000),
                        (0.666667, 0.000000, 0.000000),(0.698413, 0.000000, 0.000000),
                        (0.714286, 1.000000, 1.000000),(0.730159, 0.000000, 0.000000),
                        (0.761905, 0.000000, 0.000000),(0.777778, 1.000000, 1.000000),
                        (0.793651, 0.000000, 0.000000),(0.825397, 0.000000, 0.000000),
                        (0.841270, 1.000000, 1.000000),(0.857143, 0.000000, 0.000000),
                        (0.888889, 0.000000, 0.000000),(0.904762, 1.000000, 1.000000),
                        (0.920635, 0.000000, 0.000000),(0.952381, 0.000000, 0.000000),
                        (0.968254, 1.000000, 1.000000),(0.984127, 0.000000, 0.000000),
                        (1.0, 0., 0.)),
              'blue':  ((0., 0., 0.),(0.015873, 1.000000, 1.000000),
                        (0.031746, 1.000000, 1.000000),(0.047619, 0.000000, 0.000000),
                        (0.063492, 0.000000, 0.000000),(0.079365, 1.000000, 1.000000),
                        (0.095238, 1.000000, 1.000000),(0.111111, 0.000000, 0.000000),
                        (0.126984, 0.000000, 0.000000),(0.142857, 1.000000, 1.000000),
                        (0.158730, 1.000000, 1.000000),(0.174603, 0.000000, 0.000000),
                        (0.190476, 0.000000, 0.000000),(0.206349, 1.000000, 1.000000),
                        (0.222222, 1.000000, 1.000000),(0.238095, 0.000000, 0.000000),
                        (0.253968, 0.000000, 0.000000),(0.269841, 1.000000, 1.000000),
                        (0.285714, 1.000000, 1.000000),(0.301587, 0.000000, 0.000000),
                        (0.317460, 0.000000, 0.000000),(0.333333, 1.000000, 1.000000),
                        (0.349206, 1.000000, 1.000000),(0.365079, 0.000000, 0.000000),
                        (0.380952, 0.000000, 0.000000),(0.396825, 1.000000, 1.000000),
                        (0.412698, 1.000000, 1.000000),(0.428571, 0.000000, 0.000000),
                        (0.444444, 0.000000, 0.000000),(0.460317, 1.000000, 1.000000),
                        (0.476190, 1.000000, 1.000000),(0.492063, 0.000000, 0.000000),
                        (0.507937, 0.000000, 0.000000),(0.523810, 1.000000, 1.000000),
                        (0.539683, 1.000000, 1.000000),(0.555556, 0.000000, 0.000000),
                        (0.571429, 0.000000, 0.000000),(0.587302, 1.000000, 1.000000),
                        (0.603175, 1.000000, 1.000000),(0.619048, 0.000000, 0.000000),
                        (0.634921, 0.000000, 0.000000),(0.650794, 1.000000, 1.000000),
                        (0.666667, 1.000000, 1.000000),(0.682540, 0.000000, 0.000000),
                        (0.698413, 0.000000, 0.000000),(0.714286, 1.000000, 1.000000),
                        (0.730159, 1.000000, 1.000000),(0.746032, 0.000000, 0.000000),
                        (0.761905, 0.000000, 0.000000),(0.777778, 1.000000, 1.000000),
                        (0.793651, 1.000000, 1.000000),(0.809524, 0.000000, 0.000000),
                        (0.825397, 0.000000, 0.000000),(0.841270, 1.000000, 1.000000),
                        (0.857143, 1.000000, 1.000000),(0.873016, 0.000000, 0.000000),
                        (0.888889, 0.000000, 0.000000),(0.904762, 1.000000, 1.000000),
                        (0.920635, 1.000000, 1.000000),(0.936508, 0.000000, 0.000000),
                        (0.952381, 0.000000, 0.000000),(0.968254, 1.000000, 1.000000),
                        (0.984127, 1.000000, 1.000000),(1.0, 0., 0.))}

_gray_data =  {'red':   ((0., 0, 0), (1., 1, 1)),
               'green': ((0., 0, 0), (1., 1, 1)),
               'blue':  ((0., 0, 0), (1., 1, 1))}

_hot_data = {'red':   ((0., 0.0416, 0.0416),(0.365079, 1.000000, 1.000000),(1.0, 1.0, 1.0)),
             'green': ((0., 0., 0.),(0.365079, 0.000000, 0.000000),
                       (0.746032, 1.000000, 1.000000),(1.0, 1.0, 1.0)),
             'blue':  ((0., 0., 0.),(0.746032, 0.000000, 0.000000),(1.0, 1.0, 1.0))}

_hsv_data = {'red':   ((0., 1., 1.),(0.158730, 1.000000, 1.000000),
                       (0.174603, 0.968750, 0.968750),(0.333333, 0.031250, 0.031250),
                       (0.349206, 0.000000, 0.000000),(0.666667, 0.000000, 0.000000),
                       (0.682540, 0.031250, 0.031250),(0.841270, 0.968750, 0.968750),
                       (0.857143, 1.000000, 1.000000),(1.0, 1.0, 1.0)),
             'green': ((0., 0., 0.),(0.158730, 0.937500, 0.937500),
                       (0.174603, 1.000000, 1.000000),(0.507937, 1.000000, 1.000000),
                       (0.666667, 0.062500, 0.062500),(0.682540, 0.000000, 0.000000),
                       (1.0, 0., 0.)),
             'blue':  ((0., 0., 0.),(0.333333, 0.000000, 0.000000),
                       (0.349206, 0.062500, 0.062500),(0.507937, 1.000000, 1.000000),
                       (0.841270, 1.000000, 1.000000),(0.857143, 0.937500, 0.937500),
                       (1.0, 0.09375, 0.09375))}

_jet_data =   {'red':   ((0., 0, 0), (0.35, 0, 0), (0.66, 1, 1), (0.89,1, 1),
                         (1, 0.5, 0.5)),
               'green': ((0., 0, 0), (0.125,0, 0), (0.375,1, 1), (0.64,1, 1),
                         (0.91,0,0), (1, 0, 0)),
               'blue':  ((0., 0.5, 0.5), (0.11, 1, 1), (0.34, 1, 1), (0.65,0, 0),
                         (1, 0, 0))}

_pink_data = {'red':   ((0., 0.1178, 0.1178),(0.015873, 0.195857, 0.195857),
                        (0.031746, 0.250661, 0.250661),(0.047619, 0.295468, 0.295468),
                        (0.063492, 0.334324, 0.334324),(0.079365, 0.369112, 0.369112),
                        (0.095238, 0.400892, 0.400892),(0.111111, 0.430331, 0.430331),
                        (0.126984, 0.457882, 0.457882),(0.142857, 0.483867, 0.483867),
                        (0.158730, 0.508525, 0.508525),(0.174603, 0.532042, 0.532042),
                        (0.190476, 0.554563, 0.554563),(0.206349, 0.576204, 0.576204),
                        (0.222222, 0.597061, 0.597061),(0.238095, 0.617213, 0.617213),
                        (0.253968, 0.636729, 0.636729),(0.269841, 0.655663, 0.655663),
                        (0.285714, 0.674066, 0.674066),(0.301587, 0.691980, 0.691980),
                        (0.317460, 0.709441, 0.709441),(0.333333, 0.726483, 0.726483),
                        (0.349206, 0.743134, 0.743134),(0.365079, 0.759421, 0.759421),
                        (0.380952, 0.766356, 0.766356),(0.396825, 0.773229, 0.773229),
                        (0.412698, 0.780042, 0.780042),(0.428571, 0.786796, 0.786796),
                        (0.444444, 0.793492, 0.793492),(0.460317, 0.800132, 0.800132),
                        (0.476190, 0.806718, 0.806718),(0.492063, 0.813250, 0.813250),
                        (0.507937, 0.819730, 0.819730),(0.523810, 0.826160, 0.826160),
                        (0.539683, 0.832539, 0.832539),(0.555556, 0.838870, 0.838870),
                        (0.571429, 0.845154, 0.845154),(0.587302, 0.851392, 0.851392),
                        (0.603175, 0.857584, 0.857584),(0.619048, 0.863731, 0.863731),
                        (0.634921, 0.869835, 0.869835),(0.650794, 0.875897, 0.875897),
                        (0.666667, 0.881917, 0.881917),(0.682540, 0.887896, 0.887896),
                        (0.698413, 0.893835, 0.893835),(0.714286, 0.899735, 0.899735),
                        (0.730159, 0.905597, 0.905597),(0.746032, 0.911421, 0.911421),
                        (0.761905, 0.917208, 0.917208),(0.777778, 0.922958, 0.922958),
                        (0.793651, 0.928673, 0.928673),(0.809524, 0.934353, 0.934353),
                        (0.825397, 0.939999, 0.939999),(0.841270, 0.945611, 0.945611),
                        (0.857143, 0.951190, 0.951190),(0.873016, 0.956736, 0.956736),
                        (0.888889, 0.962250, 0.962250),(0.904762, 0.967733, 0.967733),
                        (0.920635, 0.973185, 0.973185),(0.936508, 0.978607, 0.978607),
                        (0.952381, 0.983999, 0.983999),(0.968254, 0.989361, 0.989361),
                        (0.984127, 0.994695, 0.994695),(1.0, 1.0, 1.0)),
              'green': ((0., 0., 0.),(0.015873, 0.102869, 0.102869),
                        (0.031746, 0.145479, 0.145479),(0.047619, 0.178174, 0.178174),
                        (0.063492, 0.205738, 0.205738),(0.079365, 0.230022, 0.230022),
                        (0.095238, 0.251976, 0.251976),(0.111111, 0.272166, 0.272166),
                        (0.126984, 0.290957, 0.290957),(0.142857, 0.308607, 0.308607),
                        (0.158730, 0.325300, 0.325300),(0.174603, 0.341178, 0.341178),
                        (0.190476, 0.356348, 0.356348),(0.206349, 0.370899, 0.370899),
                        (0.222222, 0.384900, 0.384900),(0.238095, 0.398410, 0.398410),
                        (0.253968, 0.411476, 0.411476),(0.269841, 0.424139, 0.424139),
                        (0.285714, 0.436436, 0.436436),(0.301587, 0.448395, 0.448395),
                        (0.317460, 0.460044, 0.460044),(0.333333, 0.471405, 0.471405),
                        (0.349206, 0.482498, 0.482498),(0.365079, 0.493342, 0.493342),
                        (0.380952, 0.517549, 0.517549),(0.396825, 0.540674, 0.540674),
                        (0.412698, 0.562849, 0.562849),(0.428571, 0.584183, 0.584183),
                        (0.444444, 0.604765, 0.604765),(0.460317, 0.624669, 0.624669),
                        (0.476190, 0.643958, 0.643958),(0.492063, 0.662687, 0.662687),
                        (0.507937, 0.680900, 0.680900),(0.523810, 0.698638, 0.698638),
                        (0.539683, 0.715937, 0.715937),(0.555556, 0.732828, 0.732828),
                        (0.571429, 0.749338, 0.749338),(0.587302, 0.765493, 0.765493),
                        (0.603175, 0.781313, 0.781313),(0.619048, 0.796819, 0.796819),
                        (0.634921, 0.812029, 0.812029),(0.650794, 0.826960, 0.826960),
                        (0.666667, 0.841625, 0.841625),(0.682540, 0.856040, 0.856040),
                        (0.698413, 0.870216, 0.870216),(0.714286, 0.884164, 0.884164),
                        (0.730159, 0.897896, 0.897896),(0.746032, 0.911421, 0.911421),
                        (0.761905, 0.917208, 0.917208),(0.777778, 0.922958, 0.922958),
                        (0.793651, 0.928673, 0.928673),(0.809524, 0.934353, 0.934353),
                        (0.825397, 0.939999, 0.939999),(0.841270, 0.945611, 0.945611),
                        (0.857143, 0.951190, 0.951190),(0.873016, 0.956736, 0.956736),
                        (0.888889, 0.962250, 0.962250),(0.904762, 0.967733, 0.967733),
                        (0.920635, 0.973185, 0.973185),(0.936508, 0.978607, 0.978607),
                        (0.952381, 0.983999, 0.983999),(0.968254, 0.989361, 0.989361),
                        (0.984127, 0.994695, 0.994695),(1.0, 1.0, 1.0)),
              'blue':  ((0., 0., 0.),(0.015873, 0.102869, 0.102869),
                        (0.031746, 0.145479, 0.145479),(0.047619, 0.178174, 0.178174),
                        (0.063492, 0.205738, 0.205738),(0.079365, 0.230022, 0.230022),
                        (0.095238, 0.251976, 0.251976),(0.111111, 0.272166, 0.272166),
                        (0.126984, 0.290957, 0.290957),(0.142857, 0.308607, 0.308607),
                        (0.158730, 0.325300, 0.325300),(0.174603, 0.341178, 0.341178),
                        (0.190476, 0.356348, 0.356348),(0.206349, 0.370899, 0.370899),
                        (0.222222, 0.384900, 0.384900),(0.238095, 0.398410, 0.398410),
                        (0.253968, 0.411476, 0.411476),(0.269841, 0.424139, 0.424139),
                        (0.285714, 0.436436, 0.436436),(0.301587, 0.448395, 0.448395),
                        (0.317460, 0.460044, 0.460044),(0.333333, 0.471405, 0.471405),
                        (0.349206, 0.482498, 0.482498),(0.365079, 0.493342, 0.493342),
                        (0.380952, 0.503953, 0.503953),(0.396825, 0.514344, 0.514344),
                        (0.412698, 0.524531, 0.524531),(0.428571, 0.534522, 0.534522),
                        (0.444444, 0.544331, 0.544331),(0.460317, 0.553966, 0.553966),
                        (0.476190, 0.563436, 0.563436),(0.492063, 0.572750, 0.572750),
                        (0.507937, 0.581914, 0.581914),(0.523810, 0.590937, 0.590937),
                        (0.539683, 0.599824, 0.599824),(0.555556, 0.608581, 0.608581),
                        (0.571429, 0.617213, 0.617213),(0.587302, 0.625727, 0.625727),
                        (0.603175, 0.634126, 0.634126),(0.619048, 0.642416, 0.642416),
                        (0.634921, 0.650600, 0.650600),(0.650794, 0.658682, 0.658682),
                        (0.666667, 0.666667, 0.666667),(0.682540, 0.674556, 0.674556),
                        (0.698413, 0.682355, 0.682355),(0.714286, 0.690066, 0.690066),
                        (0.730159, 0.697691, 0.697691),(0.746032, 0.705234, 0.705234),
                        (0.761905, 0.727166, 0.727166),(0.777778, 0.748455, 0.748455),
                        (0.793651, 0.769156, 0.769156),(0.809524, 0.789314, 0.789314),
                        (0.825397, 0.808969, 0.808969),(0.841270, 0.828159, 0.828159),
                        (0.857143, 0.846913, 0.846913),(0.873016, 0.865261, 0.865261),
                        (0.888889, 0.883229, 0.883229),(0.904762, 0.900837, 0.900837),
                        (0.920635, 0.918109, 0.918109),(0.936508, 0.935061, 0.935061),
                        (0.952381, 0.951711, 0.951711),(0.968254, 0.968075, 0.968075),
                        (0.984127, 0.984167, 0.984167),(1.0, 1.0, 1.0))}

_prism_data = {'red':   ((0., 1., 1.),(0.031746, 1.000000, 1.000000),
                         (0.047619, 0.000000, 0.000000),(0.063492, 0.000000, 0.000000),
                         (0.079365, 0.666667, 0.666667),(0.095238, 1.000000, 1.000000),
                         (0.126984, 1.000000, 1.000000),(0.142857, 0.000000, 0.000000),
                         (0.158730, 0.000000, 0.000000),(0.174603, 0.666667, 0.666667),
                         (0.190476, 1.000000, 1.000000),(0.222222, 1.000000, 1.000000),
                         (0.238095, 0.000000, 0.000000),(0.253968, 0.000000, 0.000000),
                         (0.269841, 0.666667, 0.666667),(0.285714, 1.000000, 1.000000),
                         (0.317460, 1.000000, 1.000000),(0.333333, 0.000000, 0.000000),
                         (0.349206, 0.000000, 0.000000),(0.365079, 0.666667, 0.666667),
                         (0.380952, 1.000000, 1.000000),(0.412698, 1.000000, 1.000000),
                         (0.428571, 0.000000, 0.000000),(0.444444, 0.000000, 0.000000),
                         (0.460317, 0.666667, 0.666667),(0.476190, 1.000000, 1.000000),
                         (0.507937, 1.000000, 1.000000),(0.523810, 0.000000, 0.000000),
                         (0.539683, 0.000000, 0.000000),(0.555556, 0.666667, 0.666667),
                         (0.571429, 1.000000, 1.000000),(0.603175, 1.000000, 1.000000),
                         (0.619048, 0.000000, 0.000000),(0.634921, 0.000000, 0.000000),
                         (0.650794, 0.666667, 0.666667),(0.666667, 1.000000, 1.000000),
                         (0.698413, 1.000000, 1.000000),(0.714286, 0.000000, 0.000000),
                         (0.730159, 0.000000, 0.000000),(0.746032, 0.666667, 0.666667),
                         (0.761905, 1.000000, 1.000000),(0.793651, 1.000000, 1.000000),
                         (0.809524, 0.000000, 0.000000),(0.825397, 0.000000, 0.000000),
                         (0.841270, 0.666667, 0.666667),(0.857143, 1.000000, 1.000000),
                         (0.888889, 1.000000, 1.000000),(0.904762, 0.000000, 0.000000),
                         (0.920635, 0.000000, 0.000000),(0.936508, 0.666667, 0.666667),
                         (0.952381, 1.000000, 1.000000),(0.984127, 1.000000, 1.000000),
                         (1.0, 0.0, 0.0)),
               'green': ((0., 0., 0.),(0.031746, 1.000000, 1.000000),
                         (0.047619, 1.000000, 1.000000),(0.063492, 0.000000, 0.000000),
                         (0.095238, 0.000000, 0.000000),(0.126984, 1.000000, 1.000000),
                         (0.142857, 1.000000, 1.000000),(0.158730, 0.000000, 0.000000),
                         (0.190476, 0.000000, 0.000000),(0.222222, 1.000000, 1.000000),
                         (0.238095, 1.000000, 1.000000),(0.253968, 0.000000, 0.000000),
                         (0.285714, 0.000000, 0.000000),(0.317460, 1.000000, 1.000000),
                         (0.333333, 1.000000, 1.000000),(0.349206, 0.000000, 0.000000),
                         (0.380952, 0.000000, 0.000000),(0.412698, 1.000000, 1.000000),
                         (0.428571, 1.000000, 1.000000),(0.444444, 0.000000, 0.000000),
                         (0.476190, 0.000000, 0.000000),(0.507937, 1.000000, 1.000000),
                         (0.523810, 1.000000, 1.000000),(0.539683, 0.000000, 0.000000),
                         (0.571429, 0.000000, 0.000000),(0.603175, 1.000000, 1.000000),
                         (0.619048, 1.000000, 1.000000),(0.634921, 0.000000, 0.000000),
                         (0.666667, 0.000000, 0.000000),(0.698413, 1.000000, 1.000000),
                         (0.714286, 1.000000, 1.000000),(0.730159, 0.000000, 0.000000),
                         (0.761905, 0.000000, 0.000000),(0.793651, 1.000000, 1.000000),
                         (0.809524, 1.000000, 1.000000),(0.825397, 0.000000, 0.000000),
                         (0.857143, 0.000000, 0.000000),(0.888889, 1.000000, 1.000000),
                         (0.904762, 1.000000, 1.000000),(0.920635, 0.000000, 0.000000),
                         (0.952381, 0.000000, 0.000000),(0.984127, 1.000000, 1.000000),
                         (1.0, 1.0, 1.0)),
               'blue':  ((0., 0., 0.),(0.047619, 0.000000, 0.000000),
                         (0.063492, 1.000000, 1.000000),(0.079365, 1.000000, 1.000000),
                         (0.095238, 0.000000, 0.000000),(0.142857, 0.000000, 0.000000),
                         (0.158730, 1.000000, 1.000000),(0.174603, 1.000000, 1.000000),
                         (0.190476, 0.000000, 0.000000),(0.238095, 0.000000, 0.000000),
                         (0.253968, 1.000000, 1.000000),(0.269841, 1.000000, 1.000000),
                         (0.285714, 0.000000, 0.000000),(0.333333, 0.000000, 0.000000),
                         (0.349206, 1.000000, 1.000000),(0.365079, 1.000000, 1.000000),
                         (0.380952, 0.000000, 0.000000),(0.428571, 0.000000, 0.000000),
                         (0.444444, 1.000000, 1.000000),(0.460317, 1.000000, 1.000000),
                         (0.476190, 0.000000, 0.000000),(0.523810, 0.000000, 0.000000),
                         (0.539683, 1.000000, 1.000000),(0.555556, 1.000000, 1.000000),
                         (0.571429, 0.000000, 0.000000),(0.619048, 0.000000, 0.000000),
                         (0.634921, 1.000000, 1.000000),(0.650794, 1.000000, 1.000000),
                         (0.666667, 0.000000, 0.000000),(0.714286, 0.000000, 0.000000),
                         (0.730159, 1.000000, 1.000000),(0.746032, 1.000000, 1.000000),
                         (0.761905, 0.000000, 0.000000),(0.809524, 0.000000, 0.000000),
                         (0.825397, 1.000000, 1.000000),(0.841270, 1.000000, 1.000000),
                         (0.857143, 0.000000, 0.000000),(0.904762, 0.000000, 0.000000),
                         (0.920635, 1.000000, 1.000000),(0.936508, 1.000000, 1.000000),
                         (0.952381, 0.000000, 0.000000),(1.0, 0.0, 0.0))}

_spring_data = {'red':   ((0., 1., 1.),(1.0, 1.0, 1.0)),
                'green': ((0., 0., 0.),(1.0, 1.0, 1.0)),
                'blue':  ((0., 1., 1.),(1.0, 0.0, 0.0))}


_summer_data = {'red':   ((0., 0., 0.),(1.0, 1.0, 1.0)),
                'green': ((0., 0.5, 0.5),(1.0, 1.0, 1.0)),
                'blue':  ((0., 0.4, 0.4),(1.0, 0.4, 0.4))}


_winter_data = {'red':   ((0., 0., 0.),(1.0, 0.0, 0.0)),
                'green': ((0., 0., 0.),(1.0, 1.0, 1.0)),
                'blue':  ((0., 1., 1.),(1.0, 0.5, 0.5))}

autumn = colors.LinearSegmentedColormap('autumn', _autumn_data, LUTSIZE)
bone   = colors.LinearSegmentedColormap('bone  ', _bone_data, LUTSIZE)
cool   = colors.LinearSegmentedColormap('cool',   _cool_data, LUTSIZE)
copper = colors.LinearSegmentedColormap('copper', _copper_data, LUTSIZE)
flag   = colors.LinearSegmentedColormap('flag',   _flag_data, LUTSIZE)
gray   = colors.LinearSegmentedColormap('gray',   _gray_data, LUTSIZE)
hot    = colors.LinearSegmentedColormap('hot',    _hot_data, LUTSIZE)
hsv    = colors.LinearSegmentedColormap('hsv',    _hsv_data, LUTSIZE)
jet    = colors.LinearSegmentedColormap('jet',    _jet_data, LUTSIZE)
pink   = colors.LinearSegmentedColormap('pink',   _pink_data, LUTSIZE)
prism  = colors.LinearSegmentedColormap('prism',  _prism_data, LUTSIZE)
spring = colors.LinearSegmentedColormap('spring', _spring_data, LUTSIZE)
summer = colors.LinearSegmentedColormap('summer', _summer_data, LUTSIZE)
winter = colors.LinearSegmentedColormap('winter', _winter_data, LUTSIZE)




datad = {
    'autumn': _autumn_data,
    'bone':   _bone_data,
    'cool':   _cool_data,
    'copper': _copper_data,
    'flag':   _flag_data,
    'gray' :  _gray_data,
    'hot':    _hot_data,
    'hsv':    _hsv_data,
    'jet' :   _jet_data,
    'pink':   _pink_data,
    'prism':  _prism_data,
    'spring': _spring_data,
    'summer': _summer_data,
    'winter': _winter_data
    }

# 34 colormaps based on color specifications and designs
# developed by Cynthia Brewer (http://colorbrewer.org).
# The ColorBrewer palettes have been included under the terms
# of an Apache-stype license (for details, see the file
# LICENSE_COLORBREWER in the license directory of the matplotlib
# source distribution).
_Accent_data =  {'blue': [(0.0, 0.49803921580314636, 0.49803921580314636), (0.14285714285714285, 0.83137255907058716, 0.83137255907058716), (0.2857142857142857, 0.52549022436141968, 0.52549022436141968), (0.42857142857142855, 0.60000002384185791, 0.60000002384185791), (0.5714285714285714, 0.69019609689712524, 0.69019609689712524), (0.7142857142857143, 0.49803921580314636, 0.49803921580314636), (0.8571428571428571, 0.090196080505847931, 0.090196080505847931), (1.0, 0.40000000596046448, 0.40000000596046448)],
    'green': [(0.0, 0.78823530673980713, 0.78823530673980713), (0.14285714285714285, 0.68235296010971069, 0.68235296010971069), (0.2857142857142857, 0.75294119119644165, 0.75294119119644165), (0.42857142857142855, 1.0, 1.0), (0.5714285714285714, 0.42352941632270813, 0.42352941632270813), (0.7142857142857143, 0.0078431377187371254, 0.0078431377187371254), (0.8571428571428571, 0.35686275362968445, 0.35686275362968445), (1.0, 0.40000000596046448, 0.40000000596046448)],
    'red': [(0.0, 0.49803921580314636, 0.49803921580314636), (0.14285714285714285, 0.7450980544090271, 0.7450980544090271), (0.2857142857142857, 0.99215686321258545, 0.99215686321258545), (0.42857142857142855, 1.0, 1.0), (0.5714285714285714, 0.21960784494876862, 0.21960784494876862), (0.7142857142857143, 0.94117647409439087, 0.94117647409439087), (0.8571428571428571, 0.74901962280273438, 0.74901962280273438), (1.0, 0.40000000596046448, 0.40000000596046448)]}
_Blues_data =  {'blue': [(0.0, 1.0, 1.0), (0.125, 0.9686274528503418, 0.9686274528503418), (0.25, 0.93725490570068359, 0.93725490570068359), (0.375, 0.88235294818878174, 0.88235294818878174), (0.5, 0.83921569585800171, 0.83921569585800171), (0.625, 0.7764706015586853, 0.7764706015586853), (0.75, 0.70980393886566162, 0.70980393886566162), (0.875, 0.61176472902297974, 0.61176472902297974), (1.0, 0.41960784792900085, 0.41960784792900085)],
    'green': [(0.0, 0.9843137264251709, 0.9843137264251709), (0.125, 0.92156863212585449, 0.92156863212585449), (0.25, 0.85882353782653809, 0.85882353782653809), (0.375, 0.7921568751335144, 0.7921568751335144), (0.5, 0.68235296010971069, 0.68235296010971069), (0.625, 0.57254904508590698, 0.57254904508590698), (0.75, 0.44313725829124451, 0.44313725829124451), (0.875, 0.31764706969261169, 0.31764706969261169), (1.0, 0.18823529779911041, 0.18823529779911041)],
    'red': [(0.0, 0.9686274528503418, 0.9686274528503418), (0.125, 0.87058824300765991, 0.87058824300765991), (0.25, 0.7764706015586853, 0.7764706015586853), (0.375, 0.61960786581039429, 0.61960786581039429), (0.5, 0.41960784792900085, 0.41960784792900085), (0.625, 0.25882354378700256, 0.25882354378700256), (0.75, 0.12941177189350128, 0.12941177189350128), (0.875, 0.031372550874948502, 0.031372550874948502), (1.0, 0.031372550874948502, 0.031372550874948502)]}
_BrBG_data =  {'blue': [(0.0, 0.019607843831181526, 0.019607843831181526), (0.10000000000000001, 0.039215687662363052, 0.039215687662363052), (0.20000000000000001, 0.17647059261798859, 0.17647059261798859), (0.29999999999999999, 0.49019607901573181, 0.49019607901573181), (0.40000000000000002, 0.76470589637756348, 0.76470589637756348), (0.5, 0.96078431606292725, 0.96078431606292725), (0.59999999999999998, 0.89803922176361084, 0.89803922176361084), (0.69999999999999996, 0.75686275959014893, 0.75686275959014893), (0.80000000000000004, 0.56078433990478516, 0.56078433990478516), (0.90000000000000002, 0.36862745881080627, 0.36862745881080627), (1.0, 0.18823529779911041, 0.18823529779911041)],
    'green': [(0.0, 0.18823529779911041, 0.18823529779911041), (0.10000000000000001, 0.31764706969261169, 0.31764706969261169), (0.20000000000000001, 0.5058823823928833, 0.5058823823928833), (0.29999999999999999, 0.7607843279838562, 0.7607843279838562), (0.40000000000000002, 0.90980392694473267, 0.90980392694473267), (0.5, 0.96078431606292725, 0.96078431606292725), (0.59999999999999998, 0.91764706373214722, 0.91764706373214722), (0.69999999999999996, 0.80392158031463623, 0.80392158031463623), (0.80000000000000004, 0.59215688705444336, 0.59215688705444336), (0.90000000000000002, 0.40000000596046448, 0.40000000596046448), (1.0, 0.23529411852359772, 0.23529411852359772)],
    'red': [(0.0, 0.32941177487373352, 0.32941177487373352), (0.10000000000000001, 0.54901963472366333, 0.54901963472366333), (0.20000000000000001, 0.74901962280273438, 0.74901962280273438), (0.29999999999999999, 0.87450981140136719, 0.87450981140136719), (0.40000000000000002, 0.96470588445663452, 0.96470588445663452), (0.5, 0.96078431606292725, 0.96078431606292725), (0.59999999999999998, 0.78039216995239258, 0.78039216995239258), (0.69999999999999996, 0.50196081399917603, 0.50196081399917603), (0.80000000000000004, 0.20784313976764679, 0.20784313976764679), (0.90000000000000002, 0.0039215688593685627, 0.0039215688593685627), (1.0, 0.0, 0.0)]}
_BuGn_data =  {'blue': [(0.0, 0.99215686321258545, 0.99215686321258545), (0.125, 0.97647058963775635, 0.97647058963775635), (0.25, 0.90196079015731812, 0.90196079015731812), (0.375, 0.78823530673980713, 0.78823530673980713), (0.5, 0.64313727617263794, 0.64313727617263794), (0.625, 0.46274510025978088, 0.46274510025978088), (0.75, 0.27058824896812439, 0.27058824896812439), (0.875, 0.17254902422428131, 0.17254902422428131), (1.0, 0.10588235408067703, 0.10588235408067703)],
    'green': [(0.0, 0.98823529481887817, 0.98823529481887817), (0.125, 0.96078431606292725, 0.96078431606292725), (0.25, 0.92549020051956177, 0.92549020051956177), (0.375, 0.84705883264541626, 0.84705883264541626), (0.5, 0.7607843279838562, 0.7607843279838562), (0.625, 0.68235296010971069, 0.68235296010971069), (0.75, 0.54509806632995605, 0.54509806632995605), (0.875, 0.42745098471641541, 0.42745098471641541), (1.0, 0.26666668057441711, 0.26666668057441711)], 'red': [(0.0, 0.9686274528503418, 0.9686274528503418), (0.125, 0.89803922176361084, 0.89803922176361084), (0.25, 0.80000001192092896, 0.80000001192092896), (0.375, 0.60000002384185791, 0.60000002384185791), (0.5, 0.40000000596046448, 0.40000000596046448), (0.625, 0.25490197539329529, 0.25490197539329529), (0.75, 0.13725490868091583, 0.13725490868091583), (0.875, 0.0, 0.0), (1.0, 0.0, 0.0)]}
_BuPu_data =  {'blue': [(0.0, 0.99215686321258545, 0.99215686321258545), (0.125, 0.95686274766921997, 0.95686274766921997), (0.25, 0.90196079015731812, 0.90196079015731812), (0.375, 0.85490196943283081, 0.85490196943283081), (0.5, 0.7764706015586853, 0.7764706015586853), (0.625, 0.69411766529083252, 0.69411766529083252), (0.75, 0.61568629741668701, 0.61568629741668701), (0.875, 0.48627451062202454, 0.48627451062202454), (1.0, 0.29411765933036804, 0.29411765933036804)],
    'green': [(0.0, 0.98823529481887817, 0.98823529481887817), (0.125, 0.92549020051956177, 0.92549020051956177), (0.25, 0.82745099067687988, 0.82745099067687988), (0.375, 0.73725491762161255, 0.73725491762161255), (0.5, 0.58823531866073608, 0.58823531866073608), (0.625, 0.41960784792900085, 0.41960784792900085), (0.75, 0.25490197539329529, 0.25490197539329529), (0.875, 0.058823529630899429, 0.058823529630899429), (1.0, 0.0, 0.0)],
    'red': [(0.0, 0.9686274528503418, 0.9686274528503418), (0.125, 0.87843137979507446, 0.87843137979507446), (0.25, 0.74901962280273438, 0.74901962280273438), (0.375, 0.61960786581039429, 0.61960786581039429), (0.5, 0.54901963472366333, 0.54901963472366333), (0.625, 0.54901963472366333, 0.54901963472366333), (0.75, 0.53333336114883423, 0.53333336114883423), (0.875, 0.5058823823928833, 0.5058823823928833), (1.0, 0.30196079611778259, 0.30196079611778259)]}
_Dark2_data =  {'blue': [(0.0, 0.46666666865348816, 0.46666666865348816), (0.14285714285714285, 0.0078431377187371254, 0.0078431377187371254), (0.2857142857142857, 0.70196080207824707, 0.70196080207824707), (0.42857142857142855, 0.54117649793624878, 0.54117649793624878), (0.5714285714285714, 0.11764705926179886, 0.11764705926179886), (0.7142857142857143, 0.0078431377187371254, 0.0078431377187371254), (0.8571428571428571, 0.11372549086809158, 0.11372549086809158), (1.0, 0.40000000596046448, 0.40000000596046448)],
    'green': [(0.0, 0.61960786581039429, 0.61960786581039429), (0.14285714285714285, 0.37254902720451355, 0.37254902720451355), (0.2857142857142857, 0.43921568989753723, 0.43921568989753723), (0.42857142857142855, 0.16078431904315948, 0.16078431904315948), (0.5714285714285714, 0.65098041296005249, 0.65098041296005249), (0.7142857142857143, 0.67058825492858887, 0.67058825492858887), (0.8571428571428571, 0.46274510025978088, 0.46274510025978088), (1.0, 0.40000000596046448, 0.40000000596046448)],
    'red': [(0.0, 0.10588235408067703, 0.10588235408067703), (0.14285714285714285, 0.85098040103912354, 0.85098040103912354), (0.2857142857142857, 0.45882353186607361, 0.45882353186607361), (0.42857142857142855, 0.90588235855102539, 0.90588235855102539), (0.5714285714285714, 0.40000000596046448, 0.40000000596046448), (0.7142857142857143, 0.90196079015731812, 0.90196079015731812), (0.8571428571428571, 0.65098041296005249, 0.65098041296005249), (1.0, 0.40000000596046448, 0.40000000596046448)]}
_GnBu_data =  {'blue': [(0.0, 0.94117647409439087, 0.94117647409439087), (0.125, 0.85882353782653809, 0.85882353782653809), (0.25, 0.77254903316497803, 0.77254903316497803), (0.375, 0.70980393886566162, 0.70980393886566162), (0.5, 0.76862746477127075, 0.76862746477127075), (0.625, 0.82745099067687988, 0.82745099067687988), (0.75, 0.7450980544090271, 0.7450980544090271), (0.875, 0.67450982332229614, 0.67450982332229614), (1.0, 0.5058823823928833, 0.5058823823928833)],
    'green': [(0.0, 0.98823529481887817, 0.98823529481887817), (0.125, 0.9529411792755127, 0.9529411792755127), (0.25, 0.92156863212585449, 0.92156863212585449), (0.375, 0.86666667461395264, 0.86666667461395264), (0.5, 0.80000001192092896, 0.80000001192092896), (0.625, 0.70196080207824707, 0.70196080207824707), (0.75, 0.54901963472366333, 0.54901963472366333), (0.875, 0.40784314274787903, 0.40784314274787903), (1.0, 0.25098040699958801, 0.25098040699958801)],
    'red': [(0.0, 0.9686274528503418, 0.9686274528503418), (0.125, 0.87843137979507446, 0.87843137979507446), (0.25, 0.80000001192092896, 0.80000001192092896), (0.375, 0.65882354974746704, 0.65882354974746704), (0.5, 0.48235294222831726, 0.48235294222831726), (0.625, 0.30588236451148987, 0.30588236451148987), (0.75, 0.16862745583057404, 0.16862745583057404), (0.875, 0.031372550874948502, 0.031372550874948502), (1.0, 0.031372550874948502, 0.031372550874948502)]}
_Greens_data =  {'blue': [(0.0, 0.96078431606292725, 0.96078431606292725), (0.125, 0.87843137979507446, 0.87843137979507446), (0.25, 0.75294119119644165, 0.75294119119644165), (0.375, 0.60784316062927246, 0.60784316062927246), (0.5, 0.46274510025978088, 0.46274510025978088), (0.625, 0.364705890417099, 0.364705890417099), (0.75, 0.27058824896812439, 0.27058824896812439), (0.875, 0.17254902422428131, 0.17254902422428131), (1.0, 0.10588235408067703, 0.10588235408067703)],
    'green': [(0.0, 0.98823529481887817, 0.98823529481887817), (0.125, 0.96078431606292725, 0.96078431606292725), (0.25, 0.91372549533843994, 0.91372549533843994), (0.375, 0.85098040103912354, 0.85098040103912354), (0.5, 0.76862746477127075, 0.76862746477127075), (0.625, 0.67058825492858887, 0.67058825492858887), (0.75, 0.54509806632995605, 0.54509806632995605), (0.875, 0.42745098471641541, 0.42745098471641541), (1.0, 0.26666668057441711, 0.26666668057441711)],
    'red': [(0.0, 0.9686274528503418, 0.9686274528503418), (0.125, 0.89803922176361084, 0.89803922176361084), (0.25, 0.78039216995239258, 0.78039216995239258), (0.375, 0.63137257099151611, 0.63137257099151611), (0.5, 0.45490196347236633, 0.45490196347236633), (0.625, 0.25490197539329529, 0.25490197539329529), (0.75, 0.13725490868091583, 0.13725490868091583), (0.875, 0.0, 0.0), (1.0, 0.0, 0.0)]}
_Greys_data =  {'blue': [(0.0, 1.0, 1.0), (0.125, 0.94117647409439087, 0.94117647409439087), (0.25, 0.85098040103912354, 0.85098040103912354), (0.375, 0.74117648601531982, 0.74117648601531982), (0.5, 0.58823531866073608, 0.58823531866073608), (0.625, 0.45098039507865906, 0.45098039507865906), (0.75, 0.32156863808631897, 0.32156863808631897), (0.875, 0.14509804546833038, 0.14509804546833038), (1.0, 0.0, 0.0)],
    'green': [(0.0, 1.0, 1.0), (0.125, 0.94117647409439087, 0.94117647409439087), (0.25, 0.85098040103912354, 0.85098040103912354), (0.375, 0.74117648601531982, 0.74117648601531982), (0.5, 0.58823531866073608, 0.58823531866073608), (0.625, 0.45098039507865906, 0.45098039507865906), (0.75, 0.32156863808631897, 0.32156863808631897), (0.875, 0.14509804546833038, 0.14509804546833038), (1.0, 0.0, 0.0)],
    'red': [(0.0, 1.0, 1.0), (0.125, 0.94117647409439087, 0.94117647409439087), (0.25, 0.85098040103912354, 0.85098040103912354), (0.375, 0.74117648601531982, 0.74117648601531982), (0.5, 0.58823531866073608, 0.58823531866073608), (0.625, 0.45098039507865906, 0.45098039507865906), (0.75, 0.32156863808631897, 0.32156863808631897), (0.875, 0.14509804546833038, 0.14509804546833038), (1.0, 0.0, 0.0)]}
_Oranges_data =  {'blue': [(0.0, 0.92156863212585449, 0.92156863212585449), (0.125, 0.80784314870834351, 0.80784314870834351), (0.25, 0.63529413938522339, 0.63529413938522339), (0.375, 0.41960784792900085, 0.41960784792900085), (0.5, 0.23529411852359772, 0.23529411852359772), (0.625, 0.074509806931018829, 0.074509806931018829), (0.75, 0.0039215688593685627, 0.0039215688593685627), (0.875, 0.011764706112444401, 0.011764706112444401), (1.0, 0.015686275437474251, 0.015686275437474251)],
    'green': [(0.0, 0.96078431606292725, 0.96078431606292725), (0.125, 0.90196079015731812, 0.90196079015731812), (0.25, 0.81568628549575806, 0.81568628549575806), (0.375, 0.68235296010971069, 0.68235296010971069), (0.5, 0.55294120311737061, 0.55294120311737061), (0.625, 0.4117647111415863, 0.4117647111415863), (0.75, 0.28235295414924622, 0.28235295414924622), (0.875, 0.21176470816135406, 0.21176470816135406), (1.0, 0.15294118225574493, 0.15294118225574493)],
    'red': [(0.0, 1.0, 1.0), (0.125, 0.99607843160629272, 0.99607843160629272), (0.25, 0.99215686321258545, 0.99215686321258545), (0.375, 0.99215686321258545, 0.99215686321258545), (0.5, 0.99215686321258545, 0.99215686321258545), (0.625, 0.94509804248809814, 0.94509804248809814), (0.75, 0.85098040103912354, 0.85098040103912354), (0.875, 0.65098041296005249, 0.65098041296005249), (1.0, 0.49803921580314636, 0.49803921580314636)]}
_OrRd_data =  {'blue': [(0.0, 0.92549020051956177, 0.92549020051956177), (0.125, 0.78431373834609985, 0.78431373834609985), (0.25, 0.61960786581039429, 0.61960786581039429), (0.375, 0.51764708757400513, 0.51764708757400513), (0.5, 0.3490196168422699, 0.3490196168422699), (0.625, 0.28235295414924622, 0.28235295414924622), (0.75, 0.12156862765550613, 0.12156862765550613), (0.875, 0.0, 0.0), (1.0, 0.0, 0.0)],
    'green': [(0.0, 0.9686274528503418, 0.9686274528503418), (0.125, 0.90980392694473267, 0.90980392694473267), (0.25, 0.83137255907058716, 0.83137255907058716), (0.375, 0.73333334922790527, 0.73333334922790527), (0.5, 0.55294120311737061, 0.55294120311737061), (0.625, 0.3960784375667572, 0.3960784375667572), (0.75, 0.18823529779911041, 0.18823529779911041), (0.875, 0.0, 0.0), (1.0, 0.0, 0.0)],
    'red': [(0.0, 1.0, 1.0), (0.125, 0.99607843160629272, 0.99607843160629272), (0.25, 0.99215686321258545, 0.99215686321258545), (0.375, 0.99215686321258545, 0.99215686321258545), (0.5, 0.98823529481887817, 0.98823529481887817), (0.625, 0.93725490570068359, 0.93725490570068359), (0.75, 0.84313726425170898, 0.84313726425170898), (0.875, 0.70196080207824707, 0.70196080207824707), (1.0, 0.49803921580314636, 0.49803921580314636)]}
_Paired_data =  {'blue': [(0.0, 0.89019608497619629, 0.89019608497619629), (0.090909090909090912, 0.70588237047195435, 0.70588237047195435), (0.18181818181818182, 0.54117649793624878, 0.54117649793624878), (0.27272727272727271, 0.17254902422428131, 0.17254902422428131), (0.36363636363636365, 0.60000002384185791, 0.60000002384185791), (0.45454545454545453, 0.10980392247438431, 0.10980392247438431), (0.54545454545454541, 0.43529412150382996, 0.43529412150382996), (0.63636363636363635, 0.0, 0.0), (0.72727272727272729, 0.83921569585800171, 0.83921569585800171), (0.81818181818181823, 0.60392159223556519, 0.60392159223556519), (0.90909090909090906, 0.60000002384185791, 0.60000002384185791), (1.0, 0.15686275064945221, 0.15686275064945221)],
    'green': [(0.0, 0.80784314870834351, 0.80784314870834351), (0.090909090909090912, 0.47058823704719543, 0.47058823704719543), (0.18181818181818182, 0.87450981140136719, 0.87450981140136719), (0.27272727272727271, 0.62745100259780884, 0.62745100259780884), (0.36363636363636365, 0.60392159223556519, 0.60392159223556519), (0.45454545454545453, 0.10196078568696976, 0.10196078568696976), (0.54545454545454541, 0.74901962280273438, 0.74901962280273438), (0.63636363636363635, 0.49803921580314636, 0.49803921580314636), (0.72727272727272729, 0.69803923368453979, 0.69803923368453979), (0.81818181818181823, 0.23921568691730499, 0.23921568691730499), (0.90909090909090906, 1.0, 1.0), (1.0, 0.3490196168422699, 0.3490196168422699)],
    'red': [(0.0, 0.65098041296005249, 0.65098041296005249), (0.090909090909090912, 0.12156862765550613, 0.12156862765550613), (0.18181818181818182, 0.69803923368453979, 0.69803923368453979), (0.27272727272727271, 0.20000000298023224, 0.20000000298023224), (0.36363636363636365, 0.9843137264251709, 0.9843137264251709), (0.45454545454545453, 0.89019608497619629, 0.89019608497619629), (0.54545454545454541, 0.99215686321258545, 0.99215686321258545), (0.63636363636363635, 1.0, 1.0), (0.72727272727272729, 0.7921568751335144, 0.7921568751335144), (0.81818181818181823, 0.41568627953529358, 0.41568627953529358), (0.90909090909090906, 1.0, 1.0), (1.0, 0.69411766529083252, 0.69411766529083252)]}
_Pastel1_data =  {'blue': [(0.0, 0.68235296010971069, 0.68235296010971069), (0.125, 0.89019608497619629, 0.89019608497619629), (0.25, 0.77254903316497803, 0.77254903316497803), (0.375, 0.89411765336990356, 0.89411765336990356), (0.5, 0.65098041296005249, 0.65098041296005249), (0.625, 0.80000001192092896, 0.80000001192092896), (0.75, 0.74117648601531982, 0.74117648601531982), (0.875, 0.92549020051956177, 0.92549020051956177), (1.0, 0.94901961088180542, 0.94901961088180542)],
    'green': [(0.0, 0.70588237047195435, 0.70588237047195435), (0.125, 0.80392158031463623, 0.80392158031463623), (0.25, 0.92156863212585449, 0.92156863212585449), (0.375, 0.79607844352722168, 0.79607844352722168), (0.5, 0.85098040103912354, 0.85098040103912354), (0.625, 1.0, 1.0), (0.75, 0.84705883264541626, 0.84705883264541626), (0.875, 0.85490196943283081, 0.85490196943283081), (1.0, 0.94901961088180542, 0.94901961088180542)],
    'red': [(0.0, 0.9843137264251709, 0.9843137264251709), (0.125, 0.70196080207824707, 0.70196080207824707), (0.25, 0.80000001192092896, 0.80000001192092896), (0.375, 0.87058824300765991, 0.87058824300765991), (0.5, 0.99607843160629272, 0.99607843160629272), (0.625, 1.0, 1.0), (0.75, 0.89803922176361084, 0.89803922176361084), (0.875, 0.99215686321258545, 0.99215686321258545), (1.0, 0.94901961088180542, 0.94901961088180542)]}
_Pastel2_data =  {'blue': [(0.0, 0.80392158031463623, 0.80392158031463623), (0.14285714285714285, 0.67450982332229614, 0.67450982332229614), (0.2857142857142857, 0.90980392694473267, 0.90980392694473267), (0.42857142857142855, 0.89411765336990356, 0.89411765336990356), (0.5714285714285714, 0.78823530673980713, 0.78823530673980713), (0.7142857142857143, 0.68235296010971069, 0.68235296010971069), (0.8571428571428571, 0.80000001192092896, 0.80000001192092896), (1.0, 0.80000001192092896, 0.80000001192092896)],
    'green': [(0.0, 0.88627451658248901, 0.88627451658248901), (0.14285714285714285, 0.80392158031463623, 0.80392158031463623), (0.2857142857142857, 0.83529412746429443, 0.83529412746429443), (0.42857142857142855, 0.7921568751335144, 0.7921568751335144), (0.5714285714285714, 0.96078431606292725, 0.96078431606292725), (0.7142857142857143, 0.94901961088180542, 0.94901961088180542), (0.8571428571428571, 0.88627451658248901, 0.88627451658248901), (1.0, 0.80000001192092896, 0.80000001192092896)],
    'red': [(0.0, 0.70196080207824707, 0.70196080207824707), (0.14285714285714285, 0.99215686321258545, 0.99215686321258545), (0.2857142857142857, 0.79607844352722168, 0.79607844352722168), (0.42857142857142855, 0.95686274766921997, 0.95686274766921997), (0.5714285714285714, 0.90196079015731812, 0.90196079015731812), (0.7142857142857143, 1.0, 1.0), (0.8571428571428571, 0.94509804248809814, 0.94509804248809814), (1.0, 0.80000001192092896, 0.80000001192092896)]}
_PiYG_data =  {'blue': [(0.0, 0.32156863808631897, 0.32156863808631897), (0.10000000000000001, 0.49019607901573181, 0.49019607901573181), (0.20000000000000001, 0.68235296010971069, 0.68235296010971069), (0.29999999999999999, 0.85490196943283081, 0.85490196943283081), (0.40000000000000002, 0.93725490570068359, 0.93725490570068359), (0.5, 0.9686274528503418, 0.9686274528503418), (0.59999999999999998, 0.81568628549575806, 0.81568628549575806), (0.69999999999999996, 0.52549022436141968, 0.52549022436141968), (0.80000000000000004, 0.25490197539329529, 0.25490197539329529), (0.90000000000000002, 0.12941177189350128, 0.12941177189350128), (1.0, 0.098039217293262482, 0.098039217293262482)],
    'green': [(0.0, 0.0039215688593685627, 0.0039215688593685627), (0.10000000000000001, 0.10588235408067703, 0.10588235408067703), (0.20000000000000001, 0.46666666865348816, 0.46666666865348816), (0.29999999999999999, 0.7137255072593689, 0.7137255072593689), (0.40000000000000002, 0.87843137979507446, 0.87843137979507446), (0.5, 0.9686274528503418, 0.9686274528503418), (0.59999999999999998, 0.96078431606292725, 0.96078431606292725), (0.69999999999999996, 0.88235294818878174, 0.88235294818878174), (0.80000000000000004, 0.73725491762161255, 0.73725491762161255), (0.90000000000000002, 0.57254904508590698, 0.57254904508590698), (1.0, 0.39215686917304993, 0.39215686917304993)],
    'red': [(0.0, 0.55686277151107788, 0.55686277151107788), (0.10000000000000001, 0.77254903316497803, 0.77254903316497803), (0.20000000000000001, 0.87058824300765991, 0.87058824300765991), (0.29999999999999999, 0.94509804248809814, 0.94509804248809814), (0.40000000000000002, 0.99215686321258545, 0.99215686321258545), (0.5, 0.9686274528503418, 0.9686274528503418), (0.59999999999999998, 0.90196079015731812, 0.90196079015731812), (0.69999999999999996, 0.72156864404678345, 0.72156864404678345), (0.80000000000000004, 0.49803921580314636, 0.49803921580314636), (0.90000000000000002, 0.30196079611778259, 0.30196079611778259), (1.0, 0.15294118225574493, 0.15294118225574493)]}
_PRGn_data =  {'blue': [(0.0, 0.29411765933036804, 0.29411765933036804), (0.10000000000000001, 0.51372551918029785, 0.51372551918029785), (0.20000000000000001, 0.67058825492858887, 0.67058825492858887), (0.29999999999999999, 0.81176471710205078, 0.81176471710205078), (0.40000000000000002, 0.90980392694473267, 0.90980392694473267), (0.5, 0.9686274528503418, 0.9686274528503418), (0.59999999999999998, 0.82745099067687988, 0.82745099067687988), (0.69999999999999996, 0.62745100259780884, 0.62745100259780884), (0.80000000000000004, 0.3803921639919281, 0.3803921639919281), (0.90000000000000002, 0.21568627655506134, 0.21568627655506134), (1.0, 0.10588235408067703, 0.10588235408067703)],
    'green': [(0.0, 0.0, 0.0), (0.10000000000000001, 0.16470588743686676, 0.16470588743686676), (0.20000000000000001, 0.43921568989753723, 0.43921568989753723), (0.29999999999999999, 0.64705884456634521, 0.64705884456634521), (0.40000000000000002, 0.83137255907058716, 0.83137255907058716), (0.5, 0.9686274528503418, 0.9686274528503418), (0.59999999999999998, 0.94117647409439087, 0.94117647409439087), (0.69999999999999996, 0.85882353782653809, 0.85882353782653809), (0.80000000000000004, 0.68235296010971069, 0.68235296010971069), (0.90000000000000002, 0.47058823704719543, 0.47058823704719543), (1.0, 0.26666668057441711, 0.26666668057441711)],
    'red': [(0.0, 0.25098040699958801, 0.25098040699958801), (0.10000000000000001, 0.46274510025978088, 0.46274510025978088), (0.20000000000000001, 0.60000002384185791, 0.60000002384185791), (0.29999999999999999, 0.7607843279838562, 0.7607843279838562), (0.40000000000000002, 0.90588235855102539, 0.90588235855102539), (0.5, 0.9686274528503418, 0.9686274528503418), (0.59999999999999998, 0.85098040103912354, 0.85098040103912354), (0.69999999999999996, 0.65098041296005249, 0.65098041296005249), (0.80000000000000004, 0.35294118523597717, 0.35294118523597717), (0.90000000000000002, 0.10588235408067703, 0.10588235408067703), (1.0, 0.0, 0.0)]}
_PuBu_data =  {'blue': [(0.0, 0.9843137264251709, 0.9843137264251709), (0.125, 0.94901961088180542, 0.94901961088180542), (0.25, 0.90196079015731812, 0.90196079015731812), (0.375, 0.85882353782653809, 0.85882353782653809), (0.5, 0.81176471710205078, 0.81176471710205078), (0.625, 0.75294119119644165, 0.75294119119644165), (0.75, 0.69019609689712524, 0.69019609689712524), (0.875, 0.55294120311737061, 0.55294120311737061), (1.0, 0.34509804844856262, 0.34509804844856262)],
    'green': [(0.0, 0.9686274528503418, 0.9686274528503418), (0.125, 0.90588235855102539, 0.90588235855102539), (0.25, 0.81960785388946533, 0.81960785388946533), (0.375, 0.74117648601531982, 0.74117648601531982), (0.5, 0.66274511814117432, 0.66274511814117432), (0.625, 0.56470590829849243, 0.56470590829849243), (0.75, 0.43921568989753723, 0.43921568989753723), (0.875, 0.35294118523597717, 0.35294118523597717), (1.0, 0.21960784494876862, 0.21960784494876862)],
    'red': [(0.0, 1.0, 1.0), (0.125, 0.92549020051956177, 0.92549020051956177), (0.25, 0.81568628549575806, 0.81568628549575806), (0.375, 0.65098041296005249, 0.65098041296005249), (0.5, 0.45490196347236633, 0.45490196347236633), (0.625, 0.21176470816135406, 0.21176470816135406), (0.75, 0.019607843831181526, 0.019607843831181526), (0.875, 0.015686275437474251, 0.015686275437474251), (1.0, 0.0078431377187371254, 0.0078431377187371254)]}
_PuBuGn_data =  {'blue': [(0.0, 0.9843137264251709, 0.9843137264251709), (0.125, 0.94117647409439087, 0.94117647409439087), (0.25, 0.90196079015731812, 0.90196079015731812), (0.375, 0.85882353782653809, 0.85882353782653809), (0.5, 0.81176471710205078, 0.81176471710205078), (0.625, 0.75294119119644165, 0.75294119119644165), (0.75, 0.54117649793624878, 0.54117649793624878), (0.875, 0.3490196168422699, 0.3490196168422699), (1.0, 0.21176470816135406, 0.21176470816135406)],
    'green': [(0.0, 0.9686274528503418, 0.9686274528503418), (0.125, 0.88627451658248901, 0.88627451658248901), (0.25, 0.81960785388946533, 0.81960785388946533), (0.375, 0.74117648601531982, 0.74117648601531982), (0.5, 0.66274511814117432, 0.66274511814117432), (0.625, 0.56470590829849243, 0.56470590829849243), (0.75, 0.5058823823928833, 0.5058823823928833), (0.875, 0.42352941632270813, 0.42352941632270813), (1.0, 0.27450981736183167, 0.27450981736183167)],
    'red': [(0.0, 1.0, 1.0), (0.125, 0.92549020051956177, 0.92549020051956177), (0.25, 0.81568628549575806, 0.81568628549575806), (0.375, 0.65098041296005249, 0.65098041296005249), (0.5, 0.40392157435417175, 0.40392157435417175), (0.625, 0.21176470816135406, 0.21176470816135406), (0.75, 0.0078431377187371254, 0.0078431377187371254), (0.875, 0.0039215688593685627, 0.0039215688593685627), (1.0, 0.0039215688593685627, 0.0039215688593685627)]}
_PuOr_data =  {'blue': [(0.0, 0.031372550874948502, 0.031372550874948502), (0.10000000000000001, 0.023529412224888802, 0.023529412224888802), (0.20000000000000001, 0.078431375324726105, 0.078431375324726105), (0.29999999999999999, 0.38823530077934265, 0.38823530077934265), (0.40000000000000002, 0.7137255072593689, 0.7137255072593689), (0.5, 0.9686274528503418, 0.9686274528503418), (0.59999999999999998, 0.92156863212585449, 0.92156863212585449), (0.69999999999999996, 0.82352942228317261, 0.82352942228317261), (0.80000000000000004, 0.67450982332229614, 0.67450982332229614), (0.90000000000000002, 0.53333336114883423, 0.53333336114883423), (1.0, 0.29411765933036804, 0.29411765933036804)],
    'green': [(0.0, 0.23137255012989044, 0.23137255012989044), (0.10000000000000001, 0.34509804844856262, 0.34509804844856262), (0.20000000000000001, 0.50980395078659058, 0.50980395078659058), (0.29999999999999999, 0.72156864404678345, 0.72156864404678345), (0.40000000000000002, 0.87843137979507446, 0.87843137979507446), (0.5, 0.9686274528503418, 0.9686274528503418), (0.59999999999999998, 0.85490196943283081, 0.85490196943283081), (0.69999999999999996, 0.67058825492858887, 0.67058825492858887), (0.80000000000000004, 0.45098039507865906, 0.45098039507865906), (0.90000000000000002, 0.15294118225574493, 0.15294118225574493), (1.0, 0.0, 0.0)],
    'red': [(0.0, 0.49803921580314636, 0.49803921580314636), (0.10000000000000001, 0.70196080207824707, 0.70196080207824707), (0.20000000000000001, 0.87843137979507446, 0.87843137979507446), (0.29999999999999999, 0.99215686321258545, 0.99215686321258545), (0.40000000000000002, 0.99607843160629272, 0.99607843160629272), (0.5, 0.9686274528503418, 0.9686274528503418), (0.59999999999999998, 0.84705883264541626, 0.84705883264541626), (0.69999999999999996, 0.69803923368453979, 0.69803923368453979), (0.80000000000000004, 0.50196081399917603, 0.50196081399917603), (0.90000000000000002, 0.32941177487373352, 0.32941177487373352), (1.0, 0.17647059261798859, 0.17647059261798859)]}
_PuRd_data =  {'blue': [(0.0, 0.97647058963775635, 0.97647058963775635), (0.125, 0.93725490570068359, 0.93725490570068359), (0.25, 0.85490196943283081, 0.85490196943283081), (0.375, 0.78039216995239258, 0.78039216995239258), (0.5, 0.69019609689712524, 0.69019609689712524), (0.625, 0.54117649793624878, 0.54117649793624878), (0.75, 0.33725491166114807, 0.33725491166114807), (0.875, 0.26274511218070984, 0.26274511218070984), (1.0, 0.12156862765550613, 0.12156862765550613)],
    'green': [(0.0, 0.95686274766921997, 0.95686274766921997), (0.125, 0.88235294818878174, 0.88235294818878174), (0.25, 0.72549021244049072, 0.72549021244049072), (0.375, 0.58039218187332153, 0.58039218187332153), (0.5, 0.3960784375667572, 0.3960784375667572), (0.625, 0.16078431904315948, 0.16078431904315948), (0.75, 0.070588238537311554, 0.070588238537311554), (0.875, 0.0, 0.0), (1.0, 0.0, 0.0)],
    'red': [(0.0, 0.9686274528503418, 0.9686274528503418), (0.125, 0.90588235855102539, 0.90588235855102539), (0.25, 0.83137255907058716, 0.83137255907058716), (0.375, 0.78823530673980713, 0.78823530673980713), (0.5, 0.87450981140136719, 0.87450981140136719), (0.625, 0.90588235855102539, 0.90588235855102539), (0.75, 0.80784314870834351, 0.80784314870834351), (0.875, 0.59607845544815063, 0.59607845544815063), (1.0, 0.40392157435417175, 0.40392157435417175)]}
_Purples_data =  {'blue': [(0.0, 0.99215686321258545, 0.99215686321258545), (0.125, 0.96078431606292725, 0.96078431606292725), (0.25, 0.92156863212585449, 0.92156863212585449), (0.375, 0.86274510622024536, 0.86274510622024536), (0.5, 0.78431373834609985, 0.78431373834609985), (0.625, 0.729411780834198, 0.729411780834198), (0.75, 0.63921570777893066, 0.63921570777893066), (0.875, 0.56078433990478516, 0.56078433990478516), (1.0, 0.49019607901573181, 0.49019607901573181)],
    'green': [(0.0, 0.9843137264251709, 0.9843137264251709), (0.125, 0.92941176891326904, 0.92941176891326904), (0.25, 0.85490196943283081, 0.85490196943283081), (0.375, 0.74117648601531982, 0.74117648601531982), (0.5, 0.60392159223556519, 0.60392159223556519), (0.625, 0.49019607901573181, 0.49019607901573181), (0.75, 0.31764706969261169, 0.31764706969261169), (0.875, 0.15294118225574493, 0.15294118225574493), (1.0, 0.0, 0.0)],
    'red': [(0.0, 0.98823529481887817, 0.98823529481887817), (0.125, 0.93725490570068359, 0.93725490570068359), (0.25, 0.85490196943283081, 0.85490196943283081), (0.375, 0.73725491762161255, 0.73725491762161255), (0.5, 0.61960786581039429, 0.61960786581039429), (0.625, 0.50196081399917603, 0.50196081399917603), (0.75, 0.41568627953529358, 0.41568627953529358), (0.875, 0.32941177487373352, 0.32941177487373352), (1.0, 0.24705882370471954, 0.24705882370471954)]}
_RdBu_data =  {'blue': [(0.0, 0.12156862765550613, 0.12156862765550613), (0.10000000000000001, 0.16862745583057404, 0.16862745583057404), (0.20000000000000001, 0.30196079611778259, 0.30196079611778259), (0.29999999999999999, 0.50980395078659058, 0.50980395078659058), (0.40000000000000002, 0.78039216995239258, 0.78039216995239258), (0.5, 0.9686274528503418, 0.9686274528503418), (0.59999999999999998, 0.94117647409439087, 0.94117647409439087), (0.69999999999999996, 0.87058824300765991, 0.87058824300765991), (0.80000000000000004, 0.76470589637756348, 0.76470589637756348), (0.90000000000000002, 0.67450982332229614, 0.67450982332229614), (1.0, 0.3803921639919281, 0.3803921639919281)],
    'green': [(0.0, 0.0, 0.0), (0.10000000000000001, 0.094117648899555206, 0.094117648899555206), (0.20000000000000001, 0.37647059559822083, 0.37647059559822083), (0.29999999999999999, 0.64705884456634521, 0.64705884456634521), (0.40000000000000002, 0.85882353782653809, 0.85882353782653809), (0.5, 0.9686274528503418, 0.9686274528503418), (0.59999999999999998, 0.89803922176361084, 0.89803922176361084), (0.69999999999999996, 0.77254903316497803, 0.77254903316497803), (0.80000000000000004, 0.57647061347961426, 0.57647061347961426), (0.90000000000000002, 0.40000000596046448, 0.40000000596046448), (1.0, 0.18823529779911041, 0.18823529779911041)],
    'red': [(0.0, 0.40392157435417175, 0.40392157435417175), (0.10000000000000001, 0.69803923368453979, 0.69803923368453979), (0.20000000000000001, 0.83921569585800171, 0.83921569585800171), (0.29999999999999999, 0.95686274766921997, 0.95686274766921997), (0.40000000000000002, 0.99215686321258545, 0.99215686321258545), (0.5, 0.9686274528503418, 0.9686274528503418), (0.59999999999999998, 0.81960785388946533, 0.81960785388946533), (0.69999999999999996, 0.57254904508590698, 0.57254904508590698), (0.80000000000000004, 0.26274511218070984, 0.26274511218070984), (0.90000000000000002, 0.12941177189350128, 0.12941177189350128), (1.0, 0.019607843831181526, 0.019607843831181526)]}
_RdGy_data =  {'blue': [(0.0, 0.12156862765550613, 0.12156862765550613), (0.10000000000000001, 0.16862745583057404, 0.16862745583057404), (0.20000000000000001, 0.30196079611778259, 0.30196079611778259), (0.29999999999999999, 0.50980395078659058, 0.50980395078659058), (0.40000000000000002, 0.78039216995239258, 0.78039216995239258), (0.5, 1.0, 1.0), (0.59999999999999998, 0.87843137979507446, 0.87843137979507446), (0.69999999999999996, 0.729411780834198, 0.729411780834198), (0.80000000000000004, 0.52941179275512695, 0.52941179275512695), (0.90000000000000002, 0.30196079611778259, 0.30196079611778259), (1.0, 0.10196078568696976, 0.10196078568696976)],
    'green': [(0.0, 0.0, 0.0), (0.10000000000000001, 0.094117648899555206, 0.094117648899555206), (0.20000000000000001, 0.37647059559822083, 0.37647059559822083), (0.29999999999999999, 0.64705884456634521, 0.64705884456634521), (0.40000000000000002, 0.85882353782653809, 0.85882353782653809), (0.5, 1.0, 1.0), (0.59999999999999998, 0.87843137979507446, 0.87843137979507446), (0.69999999999999996, 0.729411780834198, 0.729411780834198), (0.80000000000000004, 0.52941179275512695, 0.52941179275512695), (0.90000000000000002, 0.30196079611778259, 0.30196079611778259), (1.0, 0.10196078568696976, 0.10196078568696976)],
    'red': [(0.0, 0.40392157435417175, 0.40392157435417175), (0.10000000000000001, 0.69803923368453979, 0.69803923368453979), (0.20000000000000001, 0.83921569585800171, 0.83921569585800171), (0.29999999999999999, 0.95686274766921997, 0.95686274766921997), (0.40000000000000002, 0.99215686321258545, 0.99215686321258545), (0.5, 1.0, 1.0), (0.59999999999999998, 0.87843137979507446, 0.87843137979507446), (0.69999999999999996, 0.729411780834198, 0.729411780834198), (0.80000000000000004, 0.52941179275512695, 0.52941179275512695), (0.90000000000000002, 0.30196079611778259, 0.30196079611778259), (1.0, 0.10196078568696976, 0.10196078568696976)]}
_RdPu_data =  {'blue': [(0.0, 0.9529411792755127, 0.9529411792755127), (0.125, 0.86666667461395264, 0.86666667461395264), (0.25, 0.75294119119644165, 0.75294119119644165), (0.375, 0.70980393886566162, 0.70980393886566162), (0.5, 0.63137257099151611, 0.63137257099151611), (0.625, 0.59215688705444336, 0.59215688705444336), (0.75, 0.49411764740943909, 0.49411764740943909), (0.875, 0.46666666865348816, 0.46666666865348816), (1.0, 0.41568627953529358, 0.41568627953529358)],
    'green': [(0.0, 0.9686274528503418, 0.9686274528503418), (0.125, 0.87843137979507446, 0.87843137979507446), (0.25, 0.77254903316497803, 0.77254903316497803), (0.375, 0.62352943420410156, 0.62352943420410156), (0.5, 0.40784314274787903, 0.40784314274787903), (0.625, 0.20392157137393951, 0.20392157137393951), (0.75, 0.0039215688593685627, 0.0039215688593685627), (0.875, 0.0039215688593685627, 0.0039215688593685627), (1.0, 0.0, 0.0)],
    'red': [(0.0, 1.0, 1.0), (0.125, 0.99215686321258545, 0.99215686321258545), (0.25, 0.98823529481887817, 0.98823529481887817), (0.375, 0.98039215803146362, 0.98039215803146362), (0.5, 0.9686274528503418, 0.9686274528503418), (0.625, 0.86666667461395264, 0.86666667461395264), (0.75, 0.68235296010971069, 0.68235296010971069), (0.875, 0.47843137383460999, 0.47843137383460999), (1.0, 0.28627452254295349, 0.28627452254295349)]}
_RdYlGn_data =  {'blue': [(0.0, 0.14901961386203766, 0.14901961386203766), (0.10000000000000001, 0.15294118225574493, 0.15294118225574493), (0.20000000000000001, 0.26274511218070984, 0.26274511218070984), (0.29999999999999999, 0.3803921639919281, 0.3803921639919281), (0.40000000000000002, 0.54509806632995605, 0.54509806632995605), (0.5, 0.74901962280273438, 0.74901962280273438), (0.59999999999999998, 0.54509806632995605, 0.54509806632995605), (0.69999999999999996, 0.41568627953529358, 0.41568627953529358), (0.80000000000000004, 0.38823530077934265, 0.38823530077934265), (0.90000000000000002, 0.31372550129890442, 0.31372550129890442), (1.0, 0.21568627655506134, 0.21568627655506134)],
    'green': [(0.0, 0.0, 0.0), (0.10000000000000001, 0.18823529779911041, 0.18823529779911041), (0.20000000000000001, 0.42745098471641541, 0.42745098471641541), (0.29999999999999999, 0.68235296010971069, 0.68235296010971069), (0.40000000000000002, 0.87843137979507446, 0.87843137979507446), (0.5, 1.0, 1.0), (0.59999999999999998, 0.93725490570068359, 0.93725490570068359), (0.69999999999999996, 0.85098040103912354, 0.85098040103912354), (0.80000000000000004, 0.74117648601531982, 0.74117648601531982), (0.90000000000000002, 0.59607845544815063, 0.59607845544815063), (1.0, 0.40784314274787903, 0.40784314274787903)],
    'red': [(0.0, 0.64705884456634521, 0.64705884456634521), (0.10000000000000001, 0.84313726425170898, 0.84313726425170898), (0.20000000000000001, 0.95686274766921997, 0.95686274766921997), (0.29999999999999999, 0.99215686321258545, 0.99215686321258545), (0.40000000000000002, 0.99607843160629272, 0.99607843160629272), (0.5, 1.0, 1.0), (0.59999999999999998, 0.85098040103912354, 0.85098040103912354), (0.69999999999999996, 0.65098041296005249, 0.65098041296005249), (0.80000000000000004, 0.40000000596046448, 0.40000000596046448), (0.90000000000000002, 0.10196078568696976, 0.10196078568696976), (1.0, 0.0, 0.0)]}
_Reds_data =  {'blue': [(0.0, 0.94117647409439087, 0.94117647409439087), (0.125, 0.82352942228317261, 0.82352942228317261), (0.25, 0.63137257099151611, 0.63137257099151611), (0.375, 0.44705882668495178, 0.44705882668495178), (0.5, 0.29019609093666077, 0.29019609093666077), (0.625, 0.17254902422428131, 0.17254902422428131), (0.75, 0.11372549086809158, 0.11372549086809158), (0.875, 0.08235294371843338, 0.08235294371843338), (1.0, 0.050980392843484879, 0.050980392843484879)],
    'green': [(0.0, 0.96078431606292725, 0.96078431606292725), (0.125, 0.87843137979507446, 0.87843137979507446), (0.25, 0.73333334922790527, 0.73333334922790527), (0.375, 0.57254904508590698, 0.57254904508590698), (0.5, 0.41568627953529358, 0.41568627953529358), (0.625, 0.23137255012989044, 0.23137255012989044), (0.75, 0.094117648899555206, 0.094117648899555206), (0.875, 0.058823529630899429, 0.058823529630899429), (1.0, 0.0, 0.0)],
    'red': [(0.0, 1.0, 1.0), (0.125, 0.99607843160629272, 0.99607843160629272), (0.25, 0.98823529481887817, 0.98823529481887817), (0.375, 0.98823529481887817, 0.98823529481887817), (0.5, 0.9843137264251709, 0.9843137264251709), (0.625, 0.93725490570068359, 0.93725490570068359), (0.75, 0.79607844352722168, 0.79607844352722168), (0.875, 0.64705884456634521, 0.64705884456634521), (1.0, 0.40392157435417175, 0.40392157435417175)]}
_Set1_data =  {'blue': [(0.0, 0.10980392247438431, 0.10980392247438431), (0.125, 0.72156864404678345, 0.72156864404678345), (0.25, 0.29019609093666077, 0.29019609093666077), (0.375, 0.63921570777893066, 0.63921570777893066), (0.5, 0.0, 0.0), (0.625, 0.20000000298023224, 0.20000000298023224), (0.75, 0.15686275064945221, 0.15686275064945221), (0.875, 0.74901962280273438, 0.74901962280273438), (1.0, 0.60000002384185791, 0.60000002384185791)],
    'green': [(0.0, 0.10196078568696976, 0.10196078568696976), (0.125, 0.49411764740943909, 0.49411764740943909), (0.25, 0.68627452850341797, 0.68627452850341797), (0.375, 0.30588236451148987, 0.30588236451148987), (0.5, 0.49803921580314636, 0.49803921580314636), (0.625, 1.0, 1.0), (0.75, 0.33725491166114807, 0.33725491166114807), (0.875, 0.5058823823928833, 0.5058823823928833), (1.0, 0.60000002384185791, 0.60000002384185791)],
    'red': [(0.0, 0.89411765336990356, 0.89411765336990356), (0.125, 0.21568627655506134, 0.21568627655506134), (0.25, 0.30196079611778259, 0.30196079611778259), (0.375, 0.59607845544815063, 0.59607845544815063), (0.5, 1.0, 1.0), (0.625, 1.0, 1.0), (0.75, 0.65098041296005249, 0.65098041296005249), (0.875, 0.9686274528503418, 0.9686274528503418), (1.0, 0.60000002384185791, 0.60000002384185791)]}
_Set2_data =  {'blue': [(0.0, 0.64705884456634521, 0.64705884456634521), (0.14285714285714285, 0.38431373238563538, 0.38431373238563538), (0.2857142857142857, 0.79607844352722168, 0.79607844352722168), (0.42857142857142855, 0.76470589637756348, 0.76470589637756348), (0.5714285714285714, 0.32941177487373352, 0.32941177487373352), (0.7142857142857143, 0.18431372940540314, 0.18431372940540314), (0.8571428571428571, 0.58039218187332153, 0.58039218187332153), (1.0, 0.70196080207824707, 0.70196080207824707)],
    'green': [(0.0, 0.7607843279838562, 0.7607843279838562), (0.14285714285714285, 0.55294120311737061, 0.55294120311737061), (0.2857142857142857, 0.62745100259780884, 0.62745100259780884), (0.42857142857142855, 0.54117649793624878, 0.54117649793624878), (0.5714285714285714, 0.84705883264541626, 0.84705883264541626), (0.7142857142857143, 0.85098040103912354, 0.85098040103912354), (0.8571428571428571, 0.76862746477127075, 0.76862746477127075), (1.0, 0.70196080207824707, 0.70196080207824707)],
    'red': [(0.0, 0.40000000596046448, 0.40000000596046448), (0.14285714285714285, 0.98823529481887817, 0.98823529481887817), (0.2857142857142857, 0.55294120311737061, 0.55294120311737061), (0.42857142857142855, 0.90588235855102539, 0.90588235855102539), (0.5714285714285714, 0.65098041296005249, 0.65098041296005249), (0.7142857142857143, 1.0, 1.0), (0.8571428571428571, 0.89803922176361084, 0.89803922176361084), (1.0, 0.70196080207824707, 0.70196080207824707)]}
_Set3_data =  {'blue': [(0.0, 0.78039216995239258, 0.78039216995239258), (0.090909090909090912, 0.70196080207824707, 0.70196080207824707), (0.18181818181818182, 0.85490196943283081, 0.85490196943283081), (0.27272727272727271, 0.44705882668495178, 0.44705882668495178), (0.36363636363636365, 0.82745099067687988, 0.82745099067687988), (0.45454545454545453, 0.38431373238563538, 0.38431373238563538), (0.54545454545454541, 0.4117647111415863, 0.4117647111415863), (0.63636363636363635, 0.89803922176361084, 0.89803922176361084), (0.72727272727272729, 0.85098040103912354, 0.85098040103912354), (0.81818181818181823, 0.74117648601531982, 0.74117648601531982), (0.90909090909090906, 0.77254903316497803, 0.77254903316497803), (1.0, 0.43529412150382996, 0.43529412150382996)],
    'green': [(0.0, 0.82745099067687988, 0.82745099067687988), (0.090909090909090912, 1.0, 1.0), (0.18181818181818182, 0.729411780834198, 0.729411780834198), (0.27272727272727271, 0.50196081399917603, 0.50196081399917603), (0.36363636363636365, 0.69411766529083252, 0.69411766529083252), (0.45454545454545453, 0.70588237047195435, 0.70588237047195435), (0.54545454545454541, 0.87058824300765991, 0.87058824300765991), (0.63636363636363635, 0.80392158031463623, 0.80392158031463623), (0.72727272727272729, 0.85098040103912354, 0.85098040103912354), (0.81818181818181823, 0.50196081399917603, 0.50196081399917603), (0.90909090909090906, 0.92156863212585449, 0.92156863212585449), (1.0, 0.92941176891326904, 0.92941176891326904)],
    'red': [(0.0, 0.55294120311737061, 0.55294120311737061), (0.090909090909090912, 1.0, 1.0), (0.18181818181818182, 0.7450980544090271, 0.7450980544090271), (0.27272727272727271, 0.9843137264251709, 0.9843137264251709), (0.36363636363636365, 0.50196081399917603, 0.50196081399917603), (0.45454545454545453, 0.99215686321258545, 0.99215686321258545), (0.54545454545454541, 0.70196080207824707, 0.70196080207824707), (0.63636363636363635, 0.98823529481887817, 0.98823529481887817), (0.72727272727272729, 0.85098040103912354, 0.85098040103912354), (0.81818181818181823, 0.73725491762161255, 0.73725491762161255), (0.90909090909090906, 0.80000001192092896, 0.80000001192092896), (1.0, 1.0, 1.0)]}
_Spectral_data =  {'blue': [(0.0, 0.25882354378700256, 0.25882354378700256), (0.10000000000000001, 0.30980393290519714, 0.30980393290519714), (0.20000000000000001, 0.26274511218070984, 0.26274511218070984), (0.29999999999999999, 0.3803921639919281, 0.3803921639919281), (0.40000000000000002, 0.54509806632995605, 0.54509806632995605), (0.5, 0.74901962280273438, 0.74901962280273438), (0.59999999999999998, 0.59607845544815063, 0.59607845544815063), (0.69999999999999996, 0.64313727617263794, 0.64313727617263794), (0.80000000000000004, 0.64705884456634521, 0.64705884456634521), (0.90000000000000002, 0.74117648601531982, 0.74117648601531982), (1.0, 0.63529413938522339, 0.63529413938522339)],
    'green': [(0.0, 0.0039215688593685627, 0.0039215688593685627), (0.10000000000000001, 0.24313725531101227, 0.24313725531101227), (0.20000000000000001, 0.42745098471641541, 0.42745098471641541), (0.29999999999999999, 0.68235296010971069, 0.68235296010971069), (0.40000000000000002, 0.87843137979507446, 0.87843137979507446), (0.5, 1.0, 1.0), (0.59999999999999998, 0.96078431606292725, 0.96078431606292725), (0.69999999999999996, 0.86666667461395264, 0.86666667461395264), (0.80000000000000004, 0.7607843279838562, 0.7607843279838562), (0.90000000000000002, 0.53333336114883423, 0.53333336114883423), (1.0, 0.30980393290519714, 0.30980393290519714)],
    'red': [(0.0, 0.61960786581039429, 0.61960786581039429), (0.10000000000000001, 0.83529412746429443, 0.83529412746429443), (0.20000000000000001, 0.95686274766921997, 0.95686274766921997), (0.29999999999999999, 0.99215686321258545, 0.99215686321258545), (0.40000000000000002, 0.99607843160629272, 0.99607843160629272), (0.5, 1.0, 1.0), (0.59999999999999998, 0.90196079015731812, 0.90196079015731812), (0.69999999999999996, 0.67058825492858887, 0.67058825492858887), (0.80000000000000004, 0.40000000596046448, 0.40000000596046448), (0.90000000000000002, 0.19607843458652496, 0.19607843458652496), (1.0, 0.36862745881080627, 0.36862745881080627)]}
_YlGn_data =  {'blue': [(0.0, 0.89803922176361084, 0.89803922176361084), (0.125, 0.72549021244049072, 0.72549021244049072), (0.25, 0.63921570777893066, 0.63921570777893066), (0.375, 0.55686277151107788, 0.55686277151107788), (0.5, 0.47450980544090271, 0.47450980544090271), (0.625, 0.364705890417099, 0.364705890417099), (0.75, 0.26274511218070984, 0.26274511218070984), (0.875, 0.21568627655506134, 0.21568627655506134), (1.0, 0.16078431904315948, 0.16078431904315948)],
    'green': [(0.0, 1.0, 1.0), (0.125, 0.98823529481887817, 0.98823529481887817), (0.25, 0.94117647409439087, 0.94117647409439087), (0.375, 0.86666667461395264, 0.86666667461395264), (0.5, 0.7764706015586853, 0.7764706015586853), (0.625, 0.67058825492858887, 0.67058825492858887), (0.75, 0.51764708757400513, 0.51764708757400513), (0.875, 0.40784314274787903, 0.40784314274787903), (1.0, 0.27058824896812439, 0.27058824896812439)],
     'red': [(0.0, 1.0, 1.0), (0.125, 0.9686274528503418, 0.9686274528503418), (0.25, 0.85098040103912354, 0.85098040103912354), (0.375, 0.67843139171600342, 0.67843139171600342), (0.5, 0.47058823704719543, 0.47058823704719543), (0.625, 0.25490197539329529, 0.25490197539329529), (0.75, 0.13725490868091583, 0.13725490868091583), (0.875, 0.0, 0.0), (1.0, 0.0, 0.0)]}
_YlGnBu_data =  {'blue': [(0.0, 0.85098040103912354, 0.85098040103912354), (0.125, 0.69411766529083252, 0.69411766529083252), (0.25, 0.70588237047195435, 0.70588237047195435), (0.375, 0.73333334922790527, 0.73333334922790527), (0.5, 0.76862746477127075, 0.76862746477127075), (0.625, 0.75294119119644165, 0.75294119119644165), (0.75, 0.65882354974746704, 0.65882354974746704), (0.875, 0.58039218187332153, 0.58039218187332153), (1.0, 0.34509804844856262, 0.34509804844856262)],
    'green': [(0.0, 1.0, 1.0), (0.125, 0.97254902124404907, 0.97254902124404907), (0.25, 0.91372549533843994, 0.91372549533843994), (0.375, 0.80392158031463623, 0.80392158031463623), (0.5, 0.7137255072593689, 0.7137255072593689), (0.625, 0.56862747669219971, 0.56862747669219971), (0.75, 0.36862745881080627, 0.36862745881080627), (0.875, 0.20392157137393951, 0.20392157137393951), (1.0, 0.11372549086809158, 0.11372549086809158)],
    'red': [(0.0, 1.0, 1.0), (0.125, 0.92941176891326904, 0.92941176891326904), (0.25, 0.78039216995239258, 0.78039216995239258), (0.375, 0.49803921580314636, 0.49803921580314636), (0.5, 0.25490197539329529, 0.25490197539329529), (0.625, 0.11372549086809158, 0.11372549086809158), (0.75, 0.13333334028720856, 0.13333334028720856), (0.875, 0.14509804546833038, 0.14509804546833038), (1.0, 0.031372550874948502, 0.031372550874948502)]}
_YlOrBr_data =  {'blue': [(0.0, 0.89803922176361084, 0.89803922176361084), (0.125, 0.73725491762161255, 0.73725491762161255), (0.25, 0.56862747669219971, 0.56862747669219971), (0.375, 0.30980393290519714, 0.30980393290519714), (0.5, 0.16078431904315948, 0.16078431904315948), (0.625, 0.078431375324726105, 0.078431375324726105), (0.75, 0.0078431377187371254, 0.0078431377187371254), (0.875, 0.015686275437474251, 0.015686275437474251), (1.0, 0.023529412224888802, 0.023529412224888802)],
    'green': [(0.0, 1.0, 1.0), (0.125, 0.9686274528503418, 0.9686274528503418), (0.25, 0.89019608497619629, 0.89019608497619629), (0.375, 0.76862746477127075, 0.76862746477127075), (0.5, 0.60000002384185791, 0.60000002384185791), (0.625, 0.43921568989753723, 0.43921568989753723), (0.75, 0.29803922772407532, 0.29803922772407532), (0.875, 0.20392157137393951, 0.20392157137393951), (1.0, 0.14509804546833038, 0.14509804546833038)],
    'red': [(0.0, 1.0, 1.0), (0.125, 1.0, 1.0), (0.25, 0.99607843160629272, 0.99607843160629272), (0.375, 0.99607843160629272, 0.99607843160629272), (0.5, 0.99607843160629272, 0.99607843160629272), (0.625, 0.92549020051956177, 0.92549020051956177), (0.75, 0.80000001192092896, 0.80000001192092896), (0.875, 0.60000002384185791, 0.60000002384185791), (1.0, 0.40000000596046448, 0.40000000596046448)]}
_YlOrRd_data =  {'blue': [(0.0, 0.80000001192092896, 0.80000001192092896), (0.125, 0.62745100259780884, 0.62745100259780884), (0.25, 0.46274510025978088, 0.46274510025978088), (0.375, 0.29803922772407532, 0.29803922772407532), (0.5, 0.23529411852359772, 0.23529411852359772), (0.625, 0.16470588743686676, 0.16470588743686676), (0.75, 0.10980392247438431, 0.10980392247438431), (0.875, 0.14901961386203766, 0.14901961386203766), (1.0, 0.14901961386203766, 0.14901961386203766)],
    'green': [(0.0, 1.0, 1.0), (0.125, 0.92941176891326904, 0.92941176891326904), (0.25, 0.85098040103912354, 0.85098040103912354), (0.375, 0.69803923368453979, 0.69803923368453979), (0.5, 0.55294120311737061, 0.55294120311737061), (0.625, 0.30588236451148987, 0.30588236451148987), (0.75, 0.10196078568696976, 0.10196078568696976), (0.875, 0.0, 0.0), (1.0, 0.0, 0.0)],
    'red': [(0.0, 1.0, 1.0), (0.125, 1.0, 1.0), (0.25, 0.99607843160629272, 0.99607843160629272), (0.375, 0.99607843160629272, 0.99607843160629272), (0.5, 0.99215686321258545, 0.99215686321258545), (0.625, 0.98823529481887817, 0.98823529481887817), (0.75, 0.89019608497619629, 0.89019608497619629), (0.875, 0.74117648601531982, 0.74117648601531982), (1.0, 0.50196081399917603, 0.50196081399917603)]}
Accent = colors.LinearSegmentedColormap('Accent', _Accent_data, LUTSIZE)
Blues = colors.LinearSegmentedColormap('Blues', _Blues_data, LUTSIZE)
BrBG = colors.LinearSegmentedColormap('BrBG', _BrBG_data, LUTSIZE)
BuGn = colors.LinearSegmentedColormap('BuGn', _BuGn_data, LUTSIZE)
BuPu = colors.LinearSegmentedColormap('BuPu', _BuPu_data, LUTSIZE)
Dark2 = colors.LinearSegmentedColormap('Dark2', _Dark2_data, LUTSIZE)
GnBu = colors.LinearSegmentedColormap('GnBu', _GnBu_data, LUTSIZE)
Greens = colors.LinearSegmentedColormap('Greens', _Greens_data, LUTSIZE)
Greys = colors.LinearSegmentedColormap('Greys', _Greys_data, LUTSIZE)
Oranges = colors.LinearSegmentedColormap('Oranges', _Oranges_data, LUTSIZE)
OrRd = colors.LinearSegmentedColormap('OrRd', _OrRd_data, LUTSIZE)
Paired = colors.LinearSegmentedColormap('Paired', _Paired_data, LUTSIZE)
Pastel1 = colors.LinearSegmentedColormap('Pastel1', _Pastel1_data, LUTSIZE)
Pastel2 = colors.LinearSegmentedColormap('Pastel2', _Pastel2_data, LUTSIZE)
PiYG = colors.LinearSegmentedColormap('PiYG', _PiYG_data, LUTSIZE)
PRGn = colors.LinearSegmentedColormap('PRGn', _PRGn_data, LUTSIZE)
PuBu = colors.LinearSegmentedColormap('PuBu', _PuBu_data, LUTSIZE)
PuBuGn = colors.LinearSegmentedColormap('PuBuGn', _PuBuGn_data, LUTSIZE)
PuOr = colors.LinearSegmentedColormap('PuOr', _PuOr_data, LUTSIZE)
PuRd = colors.LinearSegmentedColormap('PuRd', _PuRd_data, LUTSIZE)
Purples = colors.LinearSegmentedColormap('Purples', _Purples_data, LUTSIZE)
RdBu = colors.LinearSegmentedColormap('RdBu', _RdBu_data, LUTSIZE)
RdGy = colors.LinearSegmentedColormap('RdGy', _RdGy_data, LUTSIZE)
RdPu = colors.LinearSegmentedColormap('RdPu', _RdPu_data, LUTSIZE)
RdYlGn = colors.LinearSegmentedColormap('RdYlGn', _RdYlGn_data, LUTSIZE)
Reds = colors.LinearSegmentedColormap('Reds', _Reds_data, LUTSIZE)
Set1 = colors.LinearSegmentedColormap('Set1', _Set1_data, LUTSIZE)
Set2 = colors.LinearSegmentedColormap('Set2', _Set2_data, LUTSIZE)
Set3 = colors.LinearSegmentedColormap('Set3', _Set3_data, LUTSIZE)
Spectral = colors.LinearSegmentedColormap('Spectral', _Spectral_data, LUTSIZE)
YlGn = colors.LinearSegmentedColormap('YlGn', _YlGn_data, LUTSIZE)
YlGnBu = colors.LinearSegmentedColormap('YlGnBu', _YlGnBu_data, LUTSIZE)
YlOrBr = colors.LinearSegmentedColormap('YlOrBr', _YlOrBr_data, LUTSIZE)
YlOrRd = colors.LinearSegmentedColormap('YlOrRd', _YlOrRd_data, LUTSIZE)
datad['Accent']=_Accent_data
datad['Blues']=_Blues_data
datad['BrBG']=_BrBG_data
datad['BuGn']=_BuGn_data
datad['BuPu']=_BuPu_data
datad['Dark2']=_Dark2_data
datad['GnBu']=_GnBu_data
datad['Greens']=_Greens_data
datad['Greys']=_Greys_data
datad['Oranges']=_Oranges_data
datad['OrRd']=_OrRd_data
datad['Paired']=_Paired_data
datad['Pastel1']=_Pastel1_data
datad['Pastel2']=_Pastel2_data
datad['PiYG']=_PiYG_data
datad['PRGn']=_PRGn_data
datad['PuBu']=_PuBu_data
datad['PuBuGn']=_PuBuGn_data
datad['PuOr']=_PuOr_data
datad['PuRd']=_PuRd_data
datad['Purples']=_Purples_data
datad['RdBu']=_RdBu_data
datad['RdGy']=_RdGy_data
datad['RdPu']=_RdPu_data
datad['RdYlGn']=_RdYlGn_data
datad['Reds']=_Reds_data
datad['Set1']=_Set1_data
datad['Set2']=_Set2_data
datad['Set3']=_Set3_data
datad['Spectral']=_Spectral_data
datad['YlGn']=_YlGn_data
datad['YlGnBu']=_YlGnBu_data
datad['YlOrBr']=_YlOrBr_data
datad['YlOrRd']=_YlOrRd_data

# reverse all the colormaps.
# reversed colormaps have '_r' appended to the name.

def revcmap(data):
    data_r = {}
    for key,val in data.iteritems():
        val = list(val)
        valrev = val[::-1]
        valnew = []
        for a,b,c in valrev:
            valnew.append((1.-a,b,c))
        data_r[key]=valnew
    return data_r

cmapnames = datad.keys()
for cmapname in cmapnames:
    cmapname_r = cmapname+'_r'
    cmapdat_r = revcmap(datad[cmapname])
    datad[cmapname_r] = cmapdat_r
    locals()[cmapname_r] = colors.LinearSegmentedColormap(cmapname_r, cmapdat_r, LUTSIZE)
