# -*- coding: utf-8 -*-
#
# This module contains the configuration of the individual eric installation
#

_pkg_config = {
    'ericDir'             : '/scisoft/ESRF_sw/linux_i386_03/lib/python2.4/site-packages/eric3',
    'ericPixDir'          : '/scisoft/ESRF_sw/linux_i386_03/lib/python2.4/site-packages/eric3/pixmaps',
    'ericIconDir'         : '/scisoft/ESRF_sw/linux_i386_03/lib/python2.4/site-packages/eric3/icons',
    'ericDTDDir'          : '/scisoft/ESRF_sw/linux_i386_03/lib/python2.4/site-packages/eric3/DTDs',
    'ericDocDir'          : '/scisoft/ESRF_sw/linux_i386_03/lib/python2.4/site-packages/eric3/Documentation',
    'ericExamplesDir'     : '/scisoft/ESRF_sw/linux_i386_03/lib/python2.4/site-packages/eric3/Examples',
    'ericTranslationsDir' : '/scisoft/ESRF_sw/linux_i386_03/lib/python2.4/site-packages/eric3',
    'ericWizardsDir'      : '/scisoft/ESRF_sw/linux_i386_03/lib/python2.4/site-packages/eric3/Wizards',
    'ericTemplatesDir'    : '/scisoft/ESRF_sw/linux_i386_03/lib/python2.4/site-packages/eric3/DesignerTemplates',
    'ericOthersDir'       : '/scisoft/ESRF_sw/linux_i386_03/lib/python2.4/site-packages/eric3',
    'bindir'              : '/scisoft/ESRF_sw/linux_i386_03/bin/',
    'mdir'                : '/scisoft/ESRF_sw/linux_i386_03/lib/python2.4/site-packages',
}

def getConfig(name):
    '''
    Module function to get a configuration value.

    @param name the name of the configuration value (string).
    '''
    try:
        return _pkg_config[name]
    except KeyError:
        pass

    raise AttributeError, '"%s" is not a valid configuration value' % name
