# -*- coding: utf-8 -*-

# Copyright (c) 2002 - 2005 Detlev Offenbach <detlev@die-offenbachs.de>
#

"""
Module defining configuration variables for the VCS package
"""

from qt import qApp, QStringList

# Available version control systems
ConfigVcsSystems = ['None', 'Subversion', 'CVS']

# Display strings for the available version control systems
# This list must be kept in sync with the one above.
ConfigVcsSystemsDisplay = QStringList()
ConfigVcsSystemsDisplay.append(qApp.translate('VCS Systems', 'None'))
ConfigVcsSystemsDisplay.append(qApp.translate('VCS Systems', 'Subversion'))
ConfigVcsSystemsDisplay.append(qApp.translate('VCS Systems', 'CVS'))

# List of indicators (directory or file) for a specific
# version control system.
ConfigVcsSystemIndicators = [('Subversion', '.svn'), 
                              ('CVS','CVS')
]

# List of VCS that support login/logout functionality    
ConfigVcsAuthSystems = ['CVS']
