# -*- coding: utf-8 -*-

# Copyright (c) 2002 - 2005 Detlev Offenbach <detlev@die-offenbachs.de>
# Copyright (c) 2000 Phil Thompson <phil@river-bank.demon.co.uk>
#

"""
Module defining the debug protocol tokens.
"""

# The address used for debugger/client communications.
DebugAddress = '127.0.0.1'

# The protocol "words".
RequestOK =             '>OK?<'
RequestEnv =            '>Environment<'
RequestLoad =           '>Load<'
RequestRun =            '>Run<'
RequestCoverage =       '>Coverage<'
RequestProfile =        '>Profile<'
RequestCyclops =        '>Cyclops<'
RequestContinue =       '>Continue<'
RequestStep =           '>Step<'
RequestStepOver =       '>StepOver<'
RequestStepOut =        '>StepOut<'
RequestStepQuit =       '>StepQuit<'
RequestBreak =          '>Break<'
RequestBreakEnable =    '>EnableBreak<'
RequestBreakIgnore =    '>IgnoreBreak<'
RequestVariables =      '>Variables<'
RequestVariable =       '>Variable<'
RequestSetFilter =      '>SetFilter<'
RequestEval =           '>Eval<'
RequestExec =           '>Exec<'
RequestShutdown =       '>Shutdown<'
RequestBanner =         '>Banner<'
RequestCompletion =     '>Completion<'
RequestUTPrepare =      '>UTPrepare<'
RequestUTRun =          '>UTRun<'
RequestUTStop =         '>UTStop<'

ResponseOK =            '>OK<'
ResponseContinue =      '>Continue<'
ResponseException =     '>Exception<'
ResponseSyntax =        '>SyntaxError<'
ResponseExit =          '>Exit<'
ResponseLine =          '>Line<'
ResponseRaw =           '>Raw<'
ResponseClearBreak =    '>ClearBreak<'
ResponseVariables =     RequestVariables
ResponseVariable =      RequestVariable
ResponseBanner =        RequestBanner
ResponseCompletion =    RequestCompletion
ResponseUTPrepared =    '>UTPrepared<'
ResponseUTStartTest =   '>UTStartTest<'
ResponseUTStopTest =    '>UTStopTest<'
ResponseUTTestFailed =  '>UTTestFailed<'
ResponseUTTestErrored = '>UTTestErrored<'
ResponseUTFinished =    '>UTFinished<'
ResponseCyclopsError =  '>CyclopsError<'

PassiveStartup =        '>PassiveStartup<'

EOT = '>EOT<\n'
