# Copyright (c) 2002 Detlev Offenbach <detlev@die-offenbachs.de>


from qt import *

from Info import *
from Config import ConfigVarTypeDispStrings, ConfigVarDefaultFilter
from FilterForm import FilterForm


class FilterDialog(FilterForm):
    """FilterDialog(parent=None,name=None,modal=0,fl=0)
    A Dialog window for the configuration of the  variables type
    filter to be applied during a debugging session.
    """
    def __init__(self,parent = None,name = None,modal = 0,fl = 0):
        FilterForm.__init__(self,parent,name,modal,fl)

        self.setCaption(self.trUtf8('%1 - Variables Filter')
            .arg(Program))

        #populate the listboxes and set the default selection
        for lb in self.localsListbox, self.globalsListbox:
            for ts in ConfigVarTypeDispStrings:
                lb.insertItem(self.trUtf8(ts))
            for filterIndex in ConfigVarDefaultFilter:
                lb.setSelected(filterIndex, 1)

    def getSelection(self):
        """
        Public slot to retrieve the current selections as a tuple of 
        lists of integer values. The first list is the locals variables
        filter, the second the globals variables filter.
        """
        lList = []
        gList = []
        for i in range(self.localsListbox.count()):
            if self.localsListbox.isSelected(i):
                lList.append(i)
        for i in range(self.globalsListbox.count()):
            if self.globalsListbox.isSelected(i):
                gList.append(i)
        return (lList, gList)
        
    def setSelection(self, lList, gList):
        """
        Public slot to set the current selection. lList and gList are 
        lists of integer values.
        """
        for filterIndex in lList:
            self.localsListbox.setSelected(filterIndex, 1)        
        for filterIndex in gList:
            self.globalsListbox.setSelected(filterIndex, 1)        
