"""
    Drawable3D.py
    3D plotting of 2D arrays 
        
"""

from PyDVT import __version__,__date__,__author__


import qt
import pyqt_pl
import myqplplot
import Numeric
from Binding import Pen,Brush


class  Drawable_3D(qt.QGrid):
    def __init__( self, parent=None):
       self.parent=parent
       qt.QGrid.__init__(self,2,parent)
       back_color = qt.QColor()
       back_color.setRgb( 0xFF, 0xFF, 0xFF )
       self.qpl=  myqplplot.MyQplplot(self,back_color=back_color)
       self.VScroll=qt.QScrollBar(qt.Qt.Vertical,self)
       self.HScroll=qt.QScrollBar(qt.Qt.Horizontal,self)
       self.GraphicObjects=[]        
              
       self.init=1
       self.style="3dSurface"
       self.MeshMode=1
       self.log=0
       self.functions={}
       
       self.SetEnv(0,1000,0,1000,0,1000)
    
       self.VScroll.setTracking(0)
       self.HScroll.setTracking(0)
       self.HScroll.setMinValue(0)
       self.HScroll.setMaxValue(270)
       self.HScroll.setEnabled(1)
       self.VScroll.setMinValue(0)
       self.VScroll.setMaxValue(90)
       self.VScroll.setEnabled(1)
       self.ViewAltitude=60.0
       self.ViewAzimuth=30.0       
       self.VScroll.setValue(self.ViewAltitude)
       self.HScroll.setValue(self.ViewAzimuth)
       self.TrackScrollBars=0
       self.connect(self.HScroll,qt.SIGNAL("valueChanged(int)"),self.hchange)
       self.connect(self.VScroll,qt.SIGNAL("valueChanged(int)"),self.vchange)
       self.connect(self.HScroll,qt.SIGNAL("sliderMoved(int)"),self.hmove)
       self.connect(self.VScroll,qt.SIGNAL("sliderMoved(int)"),self.vmove)
       self.TitleLabel=self.XLabel=self.YLabel=self.ZLabel=""

    def Show(self):
       self.show()

    def RemoveFunction(self,name=None):
        if name==None:
            self.functions={}
        else:
            if name in self.functions.keys():  del self.functions[name]

    def SetTrackScrollbars(self,value):
       if self.TrackScrollBars != value:
           if self.TrackScrollBars:
               self.disconnect(self.HScroll,qt.SIGNAL("sliderMoved(int)"),self.hchange)
               self.disconnect(self.VScroll,qt.SIGNAL("sliderMoved(int)"),self.vchange)
               self.connect(self.HScroll,qt.SIGNAL("valueChanged(int)"),self.hchange)
               self.connect(self.VScroll,qt.SIGNAL("valueChanged(int)"),self.vchange)
               self.connect(self.HScroll,qt.SIGNAL("sliderMoved(int)"),self.hmove)
               self.connect(self.VScroll,qt.SIGNAL("sliderMoved(int)"),self.vmove)               
           else: 
               self.disconnect(self.HScroll,qt.SIGNAL("valueChanged(int)"),self.hchange)
               self.disconnect(self.VScroll,qt.SIGNAL("valueChanged(int)"),self.vchange)
               self.disconnect(self.HScroll,qt.SIGNAL("sliderMoved(int)"),self.hmove)
               self.disconnect(self.VScroll,qt.SIGNAL("sliderMoved(int)"),self.vmove)    
               self.connect(self.HScroll,qt.SIGNAL("sliderMoved(int)"),self.hchange)
               self.connect(self.VScroll,qt.SIGNAL("sliderMoved(int)"),self.vchange)
       self.TrackScrollBars = value
                    
    def SetFunction(self,name,function_pars):        
        self.functions[name]=function_pars
              
    def SetFunctionItem(self,name,item,val):
        if name in self.functions.keys():
            self.functions[name][item]=val

    def SetLabels(self,title_label="",x_label="",y_label="",z_label=""):
        self.TitleLabel,self.XLabel,self.YLabel,self.ZLabel=title_label,x_label,y_label,z_label

    def SetEnv(self,xmin,xmax,ymin,ymax,zmin,zmax):   
       (self.xmin,self.xmax,self.ymin,self.ymax,self.zmin,self.zmax)=(xmin,xmax,ymin,ymax,zmin,zmax)
  
    def hmove( self, value ):
        self.ViewAzimuth=float(value)
        self._Refresh(0)

    def vmove( self, value ):
        self.ViewAltitude=float(value)
        self._Refresh(0)

    def hchange( self, value ):
        self.ViewAzimuth=float(value)
        self._Refresh(1)

    def vchange( self, value ):
        self.ViewAltitude=float(value)
        self._Refresh(1)


    def SetStyle(self,style):
      if style != self.style:
         self.style=style
         self._Refresh(1)
         
    def SetMeshPlottingMode(self,mode):
      if mode=="XLines":mode=2
      elif mode=="Both":mode=3
      else: mode=1
      
      if self.MeshMode!=mode:
         self.MeshMode=mode
         self._Refresh(1)

    def Linear( self ):
      if self.log:
         self.log=0
         self._Refresh(1)

    def Log( self,minvalue=0.000001):
      self.minvaluelog=minvalue 
      if self.log==0:
         self.log=1
         self._Refresh(1)      

    def Redraw(self):
        #self.GraphicObjects=[]        
        self._Refresh()

    def _DrawFunctions(self,modpl,draw_function=1):
         modpl.pladv(0)         
         modpl.plrgb1(0,0,0)
         #plwind(-1.0, 1.0, -0.9, 1.1)
         if self.TitleLabel != "":
            modpl.plvpor(0.0, 1.0, 0.0, 0.9)
         else:
            modpl.plvpor(0.0, 1.0, 0.0, 1.0)
         modpl.plwind(-1.0, 1.0, -0.75, 1.25)

         if self.log:
               minval,maxval=self.zmin,self.zmax
               if minval<=0: minval=self.minvaluelog
               if maxval<=minval: maxval=minval+0.000001
               modpl.plw3d(1.0, 1.0, 1.0, self.xmin,self.xmax,self.ymin,self.ymax,Numeric.log10(minval),Numeric.log10(maxval), self.ViewAltitude,self.ViewAzimuth)
               modpl.plbox3("bnstu",self.XLabel, 0.0, 0,
                "bnstu", self.YLabel, 0.0, 0,
                 "bcdlmnstuv", self.ZLabel, 0.0, 0)                              
         else:
             modpl.plw3d(1.0, 1.0, 1.0, self.xmin,self.xmax,self.ymin,self.ymax,self.zmin,self.zmax, self.ViewAltitude,self.ViewAzimuth)
             modpl.plbox3("bnstu", self.XLabel, 0.0, 0,
              "bnstu", self.YLabel, 0.0, 0,
              "bcdmnstuv", self.ZLabel, 0.0, 0)
         
         if self.TitleLabel != "": modpl.plmtex("t", 1.5, 0.5, 0.5, self.TitleLabel)

         if draw_function:         
             for function in  self.functions.values():
                func=(function["data"])             
                if func.shape[0] != 0 and func.shape[1] != 0:
                    if self.log:
                       func=Numeric.maximum(func,minval)               
                       func=Numeric.log10(func)
                    pen=function["pen"]
                    modpl.plrgb1(pen.color[0],pen.color[1],pen.color[2])
                    
                    #3d Surface
                    if self.style=="3dSurface":
                      modpl.plot3d(function["xdata"], function["ydata"], Numeric.transpose(func), self.MeshMode, 0)
                    #Mesh Surface
                    elif self.style=="SurfaceMesh":
                      modpl.plmesh(function["xdata"], function["ydata"], Numeric.transpose(func), self.MeshMode)
                    #Shaded 3d Surface
                    else:
                      #TODO: Correct light source
                      #modpl.pllightsource((self.xmin+self.xmax)/2, (self.ymin+self.ymax)/2,self.zmax*2 )                      
                      self.qpl.set_cmap1_rgb(modpl,pen.color)
                      modpl.plotsh3d(function["xdata"], function["ydata"], Numeric.transpose(func), 0)
     

    def _Refresh(self,draw_function=1):
         self.qpl.InitDrawing()
         self._DrawFunctions(pyqt_pl,draw_function)
         self.qpl.EndDrawing()



    def Destroy(self):
        self.parent=None
        self.qpl=  None
        self.functions={}
        self.GraphicObjects=[]        
        self.VScroll=None
        self.HScroll=None

    def Save(self,filename,format="BMP"):
        import pl
        pl.plsdev("psc")
        pl.plsfnam(filename)
        pl.plscolbg(self.qpl.back_color.red(),self.qpl.back_color.green(),self.qpl.back_color.blue())        
        pl.plinit()
        self._DrawFunctions(pl,1)
        pl.plend()
        if format=="PS": return
        if format=="JPG": format="JPEG"
        else:
            try:
                import Image
                pilim=Image.open(filename).transpose(Image.ROTATE_270)
                pilim.save(filename,format)
            except:
                import os
                try: os.remove(tmpfile)
                except: pass
                return 0


    def _RightButtonPress(self,e):
        if self.parent is not None: self.parent._RightButtonPress(e.globalPos ())
        
    def _DoubleClick(self,e):
        pass
			        
    def _LeftButtonPress(self,e):
      pass
   
    def _LeftButtonRelease(self,e):
      pass
   
    def _Motion(self,e):
      pass
   
    def _PressMotion(self,e):
      pass

    def _KeyPress(self,e):
        ret=str(e.text())
        if ret=="": ret= e.key()
        if self.parent is not None: self.parent._KeyPress(ret)

    def GetViewport(self):
        return self.qpl
