"""
    DrawableContour.py
    Contour and shading plot of 2D arrays 
"""

from PyDVT import __version__,__date__,__author__


class  Drawable_Contour:
    """
    Contour/shading plotting widget interface definition
            
    This class generates the following callbacks to parent (a View object):
        _RightButtonPress
        _ButtonPress
        _DoubleClick
        _ButtonRelease
        _Motion
        _ButtonPressMotion
        _KeyPress
    """

    def __init__( self, parent=None):
        """
        Parameters:
            parent: parent widget (a View object)
        """
        pass

    
    def Show(self):
        """
        Displays widget
        """
        pass


    def RemoveFunction(self,name=None):
        """
        Parameters:
            name: name of the function to be removed from the drawable.
                  if none, all are removed
        """        
        pass

            
    def SetFunction(self,name,function_pars):
        """
        Parameters:
            name: name of the function to be included
            function_pars: dictionary with the function properties (see ContourView)
                           in addiction: "pen": Pen object to contour plot
        """        
        pass


    def SetFunctionItem(self,name,item,val):
        """
        Sets "item" of the function named "name" to the value "val"
        """        
        pass

              
    def SetLabels(self,title_label="",x_label="",y_label=""):
        """
        Parameters:
            title_label: Label on the top of drawing
            x_label: Label for x axis
            y_label: Label for y axis
        """
        pass



    def SetEnv(self,xmin,xmax,ymin,ymax,zmin=None,zmax=None):   
        """
        Sets drawing limits
        Parameters:
            xmin,xmax: lower,upper values of x axis
            ymin,ymax: lower,upper values of y axis
            zmin,zmax: lower,upper values of z
        """
        pass

  
    def SetStyle(self,style):
        """
        Parameters:
            style: "Contour", "Shade" or "Both"
        """
        pass


    def SetContourLevels(self,levels):
        """
        Parameters:
            levels: integer, number of levels of contour plotting
        """
        pass


    def SetContourLabels(self,labels):
        """
        Parameters:
            lebels: if non-zero adds labels to contour plotting
        """
        pass

        
    def SetShadeLevels(self,levels):
        """
        Parameters:
            levels: integer, number of levels of shade plotting
        """
        pass


    def SetShadeColormap(self,colormap):
        """
        Sets colormap used for shading plot
        Parameters:
            colormap: Sets colormap used for shading plot:
                      "GrayScale","Color","Temperature","Red","Green","Blue" or "RevGrey"
        """
        pass
    

    def ToggleGridlines(self):
        """
        Toggles gridlines state (initial state: off)
        """
        pass

         
    def Linear( self ):
        """
        Sets linear scale
        """
        pass


    def Log( self ):
        """
        Sets logarithmic scale
        Parameters:
            minvalue: if on is non-zero sets the displaying value
                      for all values lass than or equals to zero
        """
        pass


    def Redraw(self):
        """
        Draws itself        
        """
        pass


    def Destroy(self):
        """
        Cleanup
        """
        pass


    def Save(self,filename,format):        
        """
        Parameters:
            filename: name of the output file.
            format: format to be saved ("PS","PNG","BMP" or "JPG")
        """

