"""
    Binding.py
    GUI Binding importing

    The package choses for the Binding to import according
    to the imported modules so the GUI library (qt, Tkinter)
    have to be loaded previously.

    Modules other than  GUIBinding.Binding are loaded
    dinamically (in order not to load unecessary modules).
"""

from PyDVT import __version__,__date__,__author__

import PyDVT
import sys

PACKAGE="PyDVT"
if PyDVT.GUI_Binding is not None:
    exec ("from "+ PyDVT.GUI_Binding +".Binding import *")
    GUI_Binding=PyDVT.GUI_Binding
elif ("qt" in sys.modules.keys()) or ("QtBinding" in sys.modules.keys()) or (PACKAGE+".QtBinding" in sys.modules.keys()):
    from QtBinding.Binding import *
    GUI_Binding="QtBinding"
elif ("Tkinter" in sys.modules.keys()) or ("TkBinding" in sys.modules.keys()) or (PACKAGE+".TkBinding" in sys.modules.keys()):
    from TkBinding.Binding import *
    GUI_Binding="TkBinding"
#GUI framework: used to generate documentation
elif ("GUIBinding" in sys.modules.keys()) or (PACKAGE+".GUIBinding" in sys.modules.keys()):
    from GUIBinding.Binding import *
    GUI_Binding="GUIBinding"
else:
    GUI_Binding=None


def Drawable_1D (*args,**keys):
    exec "from " + GUI_Binding + ".Drawable1D import Drawable_1D"
    return Drawable_1D(*args,**keys)    

def Drawable_2D (*args,**keys):
    exec "from " + GUI_Binding + ".Drawable2D import Drawable_2D"
    return Drawable_2D(*args,**keys)

def Drawable_3D (*args,**keys):
    exec "from " + GUI_Binding + ".Drawable3D import Drawable_3D"
    return Drawable_3D(*args,**keys)

def Drawable_Contour (*args,**keys):
    exec "from " + GUI_Binding + ".DrawableContour import Drawable_Contour"
    return Drawable_Contour(*args,**keys)

def Drawable_Table (*args,**keys):
    exec "from " + GUI_Binding + ".DrawableTable import Drawable_Table"
    return Drawable_Table(*args,**keys)

def ColormapEditorWidget (*args,**keys):
    exec "from " + GUI_Binding + ".ColormapEditorWidget import ColormapEditorWidget"
    return ColormapEditorWidget(*args,**keys)

def GraphStyleDialog (*args,**keys):
    exec "from " + GUI_Binding + ".ExtendedGraphDialogs import GraphStyleDialog"
    return GraphStyleDialog(*args,**keys)

def RoiStyleDialog (*args,**keys):
    exec "from " + GUI_Binding + ".ExtendedGraphDialogs import RoiStyleDialog"
    return RoiStyleDialog(*args,**keys)

def PeakStyleDialog (*args,**keys):
    exec "from " + GUI_Binding + ".ExtendedGraphDialogs import PeakStyleDialog"
    return PeakStyleDialog(*args,**keys)

def FitParametersDialog (*args,**keys):
    exec "from " + GUI_Binding + ".FitParametersDialog import FitParametersDialog"
    return FitParametersDialog(*args,**keys)
