#!/bin/sh
# $Id: plplot-test.sh.in,v 1.13 2002/01/28 19:24:19 airwin Exp $
# test suite for executing all configured demos (either in plplot/tmp 
# or else in the install area) capable of file output.  Our ultimate aim
# is to compare the generated files with results generated on a system
# that is known to give good results.  However, single-precision
# contamination (even when double is configured) and the consequent large
# roundoff error is currently hampering our cross-platform comparisons.
# So for now, this is only a test suite in the sense that it checks the
# files corresponding to our demo plots can all be generated.  It is
# up to the user to display those files with the appropriate software
# (e.g., gv for postscript files and kview or a browser for png 
# or jpeg files on Linux systems) to make sure they display properly.

version=5.1.0

usage()
{
   cat <<EOF
Usage: plplot-test.sh [OPTIONS]
Options:
   [--flat] (Use this option when running this script from plplot/tmp)
   [--device=DEVICE] (DEVICE = one of psc [default], ps, png, jpeg, cgm, xfig, or plmeta.
   [--version]
   [--help]
EOF
   exit $1
}

# These variables set by default assuming you are going to run this
# script from the installed demos directory $prefix/lib/plplot$version/examples.
cdir=c
export cdir
cxxdir=c++
export cxxdir
f77dir=f77
export f77dir
pythondir=python
export pythondir
tcldir=tcl
export tcldir
octavedir=/usr/local/plplot/share/plplot_octave//:/usr/local/plplot/lib/plplot5.1.0/examples/octave
export octavedir
installbindir=/usr/local/plplot/bin
export installbindir

while test $# -gt 0; do
   case "$1" in
   -*=*) optarg=`echo "$1" | sed 's/[-_a-zA-Z0-9]*=//'` ;;
   *) optarg= ;;
   esac

   case $1 in
      --flat)
#        We are running this script from the flat plplot/tmp directory.
         cdir=.
         export cdir
	 cxxdir=.
	 export cxxdir
	 f77dir=.
	 export f77dir
	 pythondir=.
	 export pythondir
	 tcldir=.
	 export tcldir
	 octavedir=../bindings/octave
	 export octavedir
	 installbindir=.
	 export installbindir
	 ;;
      --device=*)
         device=$optarg
         export device
         ;;
      --version)
         echo $version
	 exit 0
         ;;
      --help)
         usage 0 1>&2
         ;;
      *)
         usage 1 1>&2
         ;;
   esac
   shift
done

if test -z "$device"; then
   device=psc
   export device
fi

case $device in
   ps|psc)
      dsuffix=ps
      export dsuffix
      options=
      export options
      ;;
   png)
      dsuffix=png
      export dsuffix
      options="-fam -fflen 2"
      export options
      ;;
   jpeg)
      dsuffix=jpeg
      export dsuffix
      options="-fam -fflen 2"
      export options
      ;;
   cgm)
      dsuffix=cgm
      export dsuffix
      options=
      export options
      ;;
   xfig)
      dsuffix=fig
      export dsuffix
      options="-fam -fflen 2"
      export options
      ;;
   plmeta)
      dsuffix=plmeta
      export dsuffix
      options=
      export options
      ;;
   *)
      usage 1 1>&2
      ;;
esac

# Find out what options have been configured, and test accordingly.
test_f77=no
test_cxx=yes
test_python=yes
test_tcl=no
test_octave=no

# The C examples should always be available if PLplot works at all.
./test_c.sh

if test "$test_f77" = "yes" ; then
   ./test_f77.sh
fi

if test "$test_cxx" = "yes" ; then
   ./test_cxx.sh
fi

if test "$test_python" = "yes" ; then
   ./test_python.sh
fi

if test "$test_tcl" = "yes" ; then
   ./test_tcl.sh
fi
if test "$test_octave" = "yes" ; then
   ./test_octave.sh
fi
