!********1*********2*********3*********4*********5*********6*********7**
                                                                        
!  *****************
!  *               *
!  *   hst_ffa8.f  *
!  *               *
!  *****************
                    
!+ HST_FFA8 - (MAthematical procedures) Fast Fourier Analysis:
!    radix 8
     Subroutine HST_FFA8 (maxdat, numdat, maxexpnt, EXPONTS, sort, DATA, &
       status)
!  Description:
!    Perform forward fast Fourier transform on real data of a
!    power of two in length
!  Keywords:
!    Fourier~Transform.Fast.Real~Forward, FFT.Real~Forward
!  Method:
!    FAST FOURIER ANALYSIS:  RADIX 8 METHOD
!    SEE BERGLAND IN IEEE TRANS. AUDIO & ELECTROACOUSTICS
!    VOL. AU-17, NO. 2, PP138-144
!    Adapted to use precalculated twiddle factors
!  Usage:
!    General
!  Deficiencies:
!  Bugs:
!    None known
!  Authors:
!    Bergland : See BERGLAND IN IEEE TRANS. AUDIO & ELECTROACOUSTICS
!    VOL. AU-17, NO. 2, PP138-144
!    A P Hammersley (hammersley@esrf.fr)
!  History:
!    16-Jun-1992: V0.1 Original, based on MA_FFA8, based on FFA8
!    (HAMMERSLEY)(BERGLAND)
!    04-Feb-1999: V0.2 Changes to argument list of 'HST_ORD2'
!    (HAMMERSLEY)
!  Type Definitions:
     Implicit None
!  Global Constants:
     ! Include 'st_symbols.inc'
!  Import:
     Integer, Intent(IN) :: maxdat ! Dimension of array 'DATA'
     Integer, Intent(IN) :: numdat ! Number of real data points to transform
     Integer, Intent(IN) :: maxexpnt ! Dimension size of twiddle factor
!      array, must
!    be at least twice 'numdat'
     Real, Intent(IN) :: EXPONTS(maxexpnt) ! Array containing complex
!      exponential
!    multiplying factors ("twiddle factors"). This must contain
!    'numdat' complex factors, i.e. numdat*2 elements
     Logical, Intent(IN) :: sort ! .True. if the transform is to be sorted
!      into
!    normal frequency order. Otherwise it is left in bit reversed
!    order
!  Import/Export:
     Real, Intent(INOUT) :: DATA(maxdat) ! On import : the real array to be
!      Fourier
!    transformed. On export: Half of the Hermitian complex Fourier
!    components of the Fourier transform stored in the following
!    fashion. DATA(1) is the DC level, DATA(2) is the high
!    frequency term, DATA(odd index>1) imaginary term,
!    DATA(even index>2) real term.
!  Status:
     Integer, Intent(INOUT) :: status ! Status return variable
!  Local Constants:
     Character(Len=5), Parameter :: Version = 'V0.2' ! Version number for
!      subroutine
!  Local Variables:
     Integer :: eightpwr ! The maximum power of eight that is less or
!    equal to the data length
     Integer :: elm1 ! Array element index variable
     Integer :: elm2 ! Array element index variable
     Integer :: elm3 ! Array element index variable
     Integer :: elm4 ! Array element index variable
     Integer :: elm5 ! Array element index variable
     Integer :: elm6 ! Array element index variable
     Integer :: elm7 ! Array element index variable
     Integer :: interval ! Interval in array elements
     Integer :: length ! 2**'two_pwr'
     Integer :: nn ! number of array elements
     Integer :: stage ! The stage of the radix eight transforms
     Integer :: two_pwr ! The data length expressed as a power of two
!--------1---------2---------3---------4---------5---------6---------7--
                                                                        
!  Check status
!     If (status .Ne. St_goodvalue) Then
!        Call ST_SAVE ('Subroutine HST_FFA8 ' // Version)
!        Return
!     End If
           
!  Check that the region to be added to is reasonably defined
     If (maxdat.Le.0 .Or. maxexpnt.Le.1) Then
        status =-1 ! St_bad_dim1
     Else If (numdat .Gt. maxdat) Then
        status =-2 ! St_bad_adr1
     Else If (numdat*2 .Gt. maxexpnt)Then
        status = -3 !St_bad_rel1
     Else
         
        two_pwr = Nint(Log(Real(numdat)) / Log(2.))
        length = 2**two_pwr
                           
!     Check that the data length is a power of two
        If (length .Ne. numdat) Then
           status = -4 !St_bad_2power1
        End If
              
     End If
           
!  Recheck status
!     If (status .Ne. St_goodvalue) Then
!        status = status + St_mod_ma
!        Call ST_SAVE ('Subroutine HST_FFA8 ' // Version)
!        Return
!     End If
           
! - - - -1- - - - -2- - - - -3- - - - -4- - - - -5- - - - -6- - - - -7--
!  Arguments would appear to be reasonable, go ahead.
     eightpwr = two_pwr / 3
     nn = 1
           
     If (two_pwr-eightpwr * 3 .Eq. 2) Then
                                          
!     Perform radix 4 stage of transform
        nn = 4
        interval = length / 4
        elm1 = interval + 1
        elm2 = elm1 + interval
        elm3 = elm2 + interval
        Call HST_R4TR (interval, DATA(1), DATA(elm1), DATA(elm2), &
          DATA(elm3))
                     
     Else If (two_pwr - eightpwr * 3 .Eq. 1) Then
                                                 
!     Perform radix 2 stage of transform
        nn = 2
        interval = length / 2
        Call HST_R2TR (interval, DATA(1), DATA(interval+1))
                                                           
     End If
           
     If (eightpwr .Gt. 0) Then
                              
!     Perform radix 8 iterations
                                
        Do stage = 1, eightpwr
           nn = nn*8
           interval = length / nn
           elm1 = interval + 1
           elm2 = elm1 + interval
           elm3 = elm2 + interval
           elm4 = elm3 + interval
           elm5 = elm4 + interval
           elm6 = elm5 + interval
           elm7 = elm6 + interval
                                 
           Call HST_FRR8 (interval, nn, DATA(1), DATA(elm1), DATA(elm2), &
             DATA(elm3), DATA(elm4), DATA(elm5), DATA(elm6), DATA(elm7), &
             DATA(1), DATA(elm1), DATA(elm2), DATA(elm3), &
             DATA(elm4),DATA(elm5), DATA(elm6), DATA(elm7), EXPONTS, numdat)
        End Do
              
     End If
           
     Call HST_ORD1 (length, DATA)
                                 
!  If required sort the transform into normal frequency order
     If (sort) Then
        Call HST_ORD2 (numdat, length, two_pwr, DATA)
     End If
           
!  End of Subroutine HST_FFA8
     End
!********1*********2*********3*********4*********5*********6*********7**
!********1*********2*********3*********4*********5*********6*********7**
                                                                        
!  ****************
!  *              *
!  *  hst_frr8.f  *
!  *              *
!  ****************
                   
!+ HST_FRR8 - MAthematical procedures: Forward Real Radix-8
!    Fourier transform
     Subroutine HST_FRR8 (int, nn, BR0, BR1, BR2, BR3, BR4, BR5, BR6, BR7, &
       BI0, BI1, BI2, BI3, BI4, BI5, BI6, BI7, EXPONTS, npts)
!  Description:
!    This subroutine is adapted from R8TR a subroutine written by
!    Bergland to calculate one iteration of a radix-8 transform of real
!    input data. Berglands original subroutine may be found in IEEE
!    Transactions on Audio and Electroacoustic, Vol. Au-17, pp.138-144.
!  Keywords:
!    Fourier~Transform.Fast.Radix-8~Forward~Real,
!    FFT.Radix-8~Forward~Real
!  Method:
!    See FAST FOURIER ANALYSIS:  RADIX 8 METHOD
!    SEE BERGLAND IN IEEE TRANS. AUDIO & ELECTROACOUSTICS
!    VOL. AU-17, NO. 2, PP138-144
!    R8TR has been adapted to use twiddle factors obtained from a work
!    array and the complex arithmetic has been altered to be more
!    efficient.
!  Usage:
!    Private
!  Deficiencies:
!    This subroutine should only be used from MA_FFA8 and is not
!    otherwise for general use
!  Bugs:
!  Authors:
!    Bergland : See BERGLAND IN IEEE TRANS. AUDIO & ELECTROACOUSTICS
!    VOL. AU-17, NO. 2, PP138-144
!    A P Hammersley (hammersley@esrf.fr)
!  History:
!    16-Jun-1992: V0.1 Original, based on MA_FRR8 (HAMMERSLEY),
!    based on R8TR (BERGLAND)
!    03-Feb-1999: V0.2 Simplify code, by removing line numbers and
!    replacing 'Continue' statements with 'End Do' statements where
!    possible (HAMMERSLEY)
!    08-Apr-2002: V0.3 Replace old style DO statements with statement numbers by
!    the 'DO - END DO' construct (problems with Absoft F95 compiler) (WILCKE)
!  Type Definitions:
     Implicit None
!  Global Constants:
     ! Include 'st_symbols.inc'
!  Import:
     Integer, Intent(IN) :: int
     Integer, Intent(IN) :: nn
     Integer, Intent(IN) :: npts
     Real, Intent(IN) :: EXPONTS(0: npts*2-1)
!  Import/Export:
     Real, Intent(INOUT) :: BR0(npts)
     Real, Intent(INOUT) :: BR1(npts)
     Real, Intent(INOUT) :: BR2(npts)
     Real, Intent(INOUT) :: BR3(npts)
     Real, Intent(INOUT) :: BR4(npts)
     Real, Intent(INOUT) :: BR5(npts)
     Real, Intent(INOUT) :: BR6(npts)
     Real, Intent(INOUT) :: BR7(npts)
     Real, Intent(INOUT) :: BI0(npts)
     Real, Intent(INOUT) :: BI1(npts)
     Real, Intent(INOUT) :: BI2(npts)
     Real, Intent(INOUT) :: BI3(npts)
     Real, Intent(INOUT) :: BI4(npts)
     Real, Intent(INOUT) :: BI5(npts)
     Real, Intent(INOUT) :: BI6(npts)
     Real, Intent(INOUT) :: BI7(npts)
!  Status:
!  Local Constants:
     Character(Len=5), Parameter :: Version = 'V0.3' ! Version number for
!      subroutine
!  Local Variables:
     Integer :: int8
     Integer :: j
     Integer :: j0, j1, j2, j3, j4, j5, j6, j7, j8, j9, j10, j11, j12
     Integer :: j13, j14
     Integer :: ji, jl, jlast, jr, jthet
     Integer :: k
     Integer :: k0, kl
!    Integer ks
     Integer :: l1, l2, l3, l4, l5, l6, l7, l8
     Integer :: l9, l10, l11, l12, l13, l14, l15
     Integer :: nptdnn
     Integer :: th2
     Integer :: welm
     Real :: c1, c2, c3, c4, c5, c6, c7
     Real :: c22
     Real :: div22
     Real :: itmp0
     Real :: p7
     Real :: pi
     Real :: pr
     Real :: rtmp0
     Real :: s22
     Real :: sum22
     Real :: s1, s2, s3, s4, s5, s6, s7
     Real :: t0, t1, t2, t3, t4, t5, t6, t7
     Real :: ti0, ti1, ti2, ti3, ti4, ti5, ti6, ti7
     Real :: tr0, tr1, tr2, tr3, tr4, tr5, tr6, tr7
     Real :: wdiv1, wdiv2, wdiv3, wdiv4, wdiv5, wdiv6, wdiv7
     Real :: wsum1, wsum2, wsum3, wsum4, wsum5, wsum6, wsum7
!  Local Arrays:
     Integer :: L(15) ! For indexing into butterfly elements
!    Equivalences:
     Equivalence (L15,L(1)),(L14,L(2)),(L13,L(3)),(L12,L(4)), &
       (L11,L(5)),(L10,L(6)),(L9,L(7)),(L8,L(8)),(L7,L(9)), &
       (L6,L(10)),(L5,L(11)),(L4,L(12)),(L3,L(13)),(L2,L(14)), (L1,L(15))
!--------1---------2---------3---------4---------5---------6---------7--
!**DEBUG***DEBUG***DEBUG***DEBUG***DEBUG***DEBUG***DEBUG***DEBUG***DEBUG
!  Write (*,'(/1x,''[D] npts = '',i8)') npts
!**DEBUG***DEBUG***DEBUG***DEBUG***DEBUG***DEBUG***DEBUG***DEBUG***DEBUG
                                                                        
!  Set up indexing values
     L(1) = nn / 8
     Do k = 2, 15
                 
        If (L(k - 1) .Lt. 2) Then
           L(k - 1) = 2
           L(k) = 2
        Else If (L(k - 1) .Eq. 2) Then
           L(k) = 2
        Else
           L(k) = L(k - 1) / 2
        End If
              
     End Do
           
           
     nptdnn = npts / nn
     p7 = 0.7071067812
     c22 = .9238795325
     s22 = .3826834324
     sum22 = c22 + s22
     div22 = s22 - c22
     ji = 3
     jl = 2
     jr = 2
           
     Do j1 = 2, l1, 2
     Do j2 = j1, l2, l1
     Do j3 = j2, l3, l2
     Do j4 = j3, l4, l3
     Do j5 = j4, l5, l4
     Do j6 = j5, l6, l5
     Do j7 = j6, l7, l6
     Do j8 = j7, l8, l7
     Do j9 = j8, l9, l8
     Do j10 = j9, l10, l9
     Do j11 = j10, l11, l10
     Do j12 = j11, l12, l11
     Do j13 = j12, l13, l12
     Do j14 = j13, l14, l13
     Do jthet = j14, l15, l14
        th2 = jthet - 2
        If (th2) 71, 71, 76
        71        Continue
        Do k = 1, int
           T0 = BR0(k) + BR4(k)
           t1 = BR1(k) + BR5(k)
           t2 = BR2(k) + BR6(k)
           t3 = BR3(k) + BR7(k)
           t4 = BR0(k) - BR4(k)
           t5 = BR1(k) - BR5(k)
           t6 = BR2(k) - BR6(k)
           t7 = BR3(k) - BR7(k)
           BR2(k) = t0 - t2
           BR3(k) = t1 - t3
           t0 = t0 + t2
           t1 = t1 + t3
           BR0(k) = t0 + t1
           BR1(k) = t0 - t1
           pr = p7*(t5 - t7)
           pi = p7*(t5 + t7)
           BR4(k) = t4 + pr
           BR7(k) = t6 + pi
           BR6(k) = t4 - pr
           BR5(k) = pi - t6
        End Do
        If (nn - 8) 70, 70, 73
        73        k0 = int * 8 + 1
        kl = k0 + int - 1
        Do k = k0, kl
           pr = p7 * (BI2(k) - BI6(k))
           pi = p7 * (BI2(k) + BI6(k))
           tr0 = BI0(k) + pr
           ti0 = BI4(k) + pi
           tr2 = BI0(k) - pr
           ti2 = BI4(k) - pi
           pr = p7 * (BI3(k) - BI7(k))
           pi = p7 * (BI3(k) + BI7(k))
           tr1 = BI1(k) + pr
           ti1 = BI5(k) + pi
           tr3 = BI1(k) - pr
           ti3 = BI5(k) - pi
           pi = c22 * (tr1 + ti1)
           pr = pi - ti1 * sum22
           pi = pi + tr1 * div22
           BI0(k) = tr0 + pr
           BI6(k) = tr0 - pr
           BI7(k) = pi + ti0
           BI1(k) = pi - ti0
           pr = c22 * (tr3 + ti3)
           pi = pr - ti3 * sum22
           pr =  - (pr + tr3 * div22)
           BI2(k) = tr2 + pr
           BI4(k) = tr2 - pr
           BI5(k) = ti2 + pi
           BI3(k) = pi - ti2
        End Do
        Goto 70
        76        th2 = th2 * nptdnn
        c1 = EXPONTS(th2)
        s1 = EXPONTS(th2 + 1)
        wsum1 = c1 + s1
        wdiv1 = s1 - c1
        welm = th2 + th2
        c2 = EXPONTS(welm)
        s2 = EXPONTS(welm + 1)
        wsum2 = c2 + s2
        wdiv2 = s2 - c2
        welm = welm + th2
        c3 = EXPONTS(welm)
        s3 = EXPONTS(welm + 1)
        wsum3 = c3 + s3
        wdiv3 = s3 - c3
        welm = welm + th2
        c4 = EXPONTS(welm)
        s4 = EXPONTS(welm + 1)
        wsum4 = c4 + s4
        wdiv4 = s4 - c4
        welm = welm + th2
        c5 = EXPONTS(welm)
        s5 = EXPONTS(welm + 1)
        wsum5 = c5 + s5
        wdiv5 = s5 - c5
        welm = welm + th2
        c6 = EXPONTS(welm)
        s6 = EXPONTS(welm + 1)
        wsum6 = c6 + s6
        wdiv6 = s6 - c6
        welm = welm + th2
        c7 = EXPONTS(welm)
        s7 = EXPONTS(welm + 1)
        wsum7 = c7 + s7
        wdiv7 = s7 - c7
                       
        int8 = int * 8
        j0 = jr * int8 + 1
        k0 = ji * int8 + 1
        jlast = j0 + int - 1
        Do j = j0, jlast
           k = k0 + j - j0
           rtmp0 = BR1(j)
           itmp0 = BI1(k)
           ti1 = c1 * (rtmp0  +  itmp0)
           tr1 = ti1 - itmp0 * wsum1
           ti1 = ti1 + rtmp0 * wdiv1
           rtmp0 = BR2(j)
           itmp0 = BI2(k)
           ti2 = c2 * (rtmp0  +  itmp0)
           tr2 = ti2 - itmp0 * wsum2
           ti2 = ti2 + rtmp0 * wdiv2
           rtmp0 = BR3(j)
           itmp0 = BI3(k)
           ti3 = c3 * (rtmp0 + itmp0)
           tr3 = ti3 - itmp0 * wsum3
           ti3 = ti3 + rtmp0 * wdiv3
           rtmp0 = BR4(j)
           itmp0 = BI4(k)
           ti4 = c4 * (rtmp0 + itmp0)
           tr4 = ti4 - itmp0 * wsum4
           ti4 = ti4 + rtmp0 * wdiv4
           rtmp0 = BR5(j)
           itmp0 = BI5(k)
           ti5 = c5 * (rtmp0 + itmp0)
           tr5 = ti5 - itmp0 * wsum5
           ti5 = ti5 + rtmp0 * wdiv5
           rtmp0 = BR6(j)
           itmp0 = BI6(k)
           ti6 = c6 * (rtmp0 + itmp0)
           tr6 = ti6 - itmp0 * wsum6
           ti6 = ti6 + rtmp0 * wdiv6
           rtmp0 = BR7(j)
           itmp0 = BI7(k)
           ti7 = c7 * (rtmp0 + itmp0)
           tr7 = ti7 - itmp0 * wsum7
           ti7 = ti7 + rtmp0 * wdiv7
           t0 = BR0(j) + tr4
           t1 = BI0(k) + ti4
           tr4 = BR0(j) - tr4
           ti4 = BI0(k) - ti4
           t2 = tr1 + tr5
           t3 = ti1 + ti5
           tr5 = tr1 - tr5
           ti5 = ti1 - ti5
           t4 = tr2 + tr6
           t5 = ti2 + ti6
           tr6 = tr2 - tr6
           ti6 = ti2 - ti6
           t6 = tr3 + tr7
           t7 = ti3 + ti7
           tr7 = tr3 - tr7
           ti7 = ti3 - ti7
           tr0 = t0 + t4
           ti0 = t1 + t5
           tr2 = t0 - t4
           ti2 = t1 - t5
           tr1 = t2 + t6
           ti1 = t3 + t7
           tr3 = t2 - t6
           ti3 = t3 - t7
           t0 = tr4 - ti6
           t1 = ti4 + tr6
           t4 = tr4 + ti6
           t5 = ti4 - tr6
           t2 = tr5 - ti7
           t3 = ti5 + tr7
           t6 = tr5 + ti7
           t7 = ti5 - tr7
           BR0(j) = tr0 + tr1
           BI7(k) = ti0 + ti1
           BI6(k) = tr0 - tr1
           BR1(j) = ti1 - ti0
           BR2(j) = tr2 - ti3
           BI5(k) = ti2 + tr3
           BI4(k) = tr2 + ti3
           BR3(j) = tr3 - ti2
           pr = p7 * (t2 - t3)
           pi = p7 * (t2 + t3)
           BR4(j) = t0 + pr
           BI3(k) = t1 + pi
           BI2(k) = t0 - pr
           BR5(j) = pi - t1
           pr =  -p7 * (t6 + t7)
           pi = p7 * (t6 - t7)
           BR6(j) = t4 + pr
           BI1(k) = t5 + pi
           BI0(k) = t4 - pr
           BR7(j) = pi - t5
        End Do
              
        jr = jr + 2
        ji = ji - 2
                   
        If (ji .Le. jl) Then
           ji = jr + jr - 1
           jl = jr
        End If
              
        70     Continue
     End Do
     End Do
     End Do
     End Do
     End Do
     End Do
     End Do
     End Do
     End Do
     End Do
     End Do
     End Do
     End Do
     End Do
     End Do
                       
!     End of Subroutine HST_FRR8
        End
!********1*********2*********3*********4*********5*********6*********7**
!********1*********2*********3*********4*********5*********6*********7**
                                                                        
!  *****************
!  *               *
!  *   hst_ffs8.f  *
!  *               *
!  *****************
                    
!+ HST_FFS8 - (MAthematical procedures) Fast Fourier Synthesis:
!    radix 8
     Subroutine HST_FFS8 (maxdat, numdat, maxexpnt, EXPONTS, sort, DATA, &
       status)
!  Description:
!    Perform reverse fast Fourier transform on Hermitian data of a
!    power of two in length
!
!    (Note: This doesn't seem to perform any normalisation.)
!  Keywords:
!    Fourier~Transform.Fast.Hermitian~Reverse, FFT.Hermitian~Reverse
!  Method:
!    FAST FOURIER ANALYSIS:  RADIX 8 METHOD
!    SEE BERGLAND IN IEEE TRANS. AUDIO & ELECTROACOUSTICS
!    VOL. AU-17, NO. 2, PP138-144
!    Adapted to use precalculated twiddle factors
!  Usage:
!    General
!  Deficiencies:
!  Bugs:
!  Authors:
!    Bergland : See BERGLAND IN IEEE TRANS. AUDIO & ELECTROACOUSTICS
!    VOL. AU-17, NO. 2, PP138-144
!    A P Hammersley (hammersley@esrf.fr)
!  History:
!    16-Jun-1992: V0.1 Original, based on MA_FFS8 (HAMMERSLEY),
!    based on FFS8 (BERGLAND)
!    04-Feb-1999: V0.2 Changes to argument list of 'HST_ORD2'
!    (HAMMERSLEY)
!  Type Definitions:
     Implicit None
!  Global Constants:
     ! Include 'st_symbols.inc'
!  Import:
     Integer, Intent(IN) :: maxdat ! Dimension of array 'DATA'
     Integer, Intent(IN) :: numdat ! Number of real data points to transform
     Integer, Intent(IN) :: maxexpnt ! Dimension size of twiddle factor
!      array, must
!    be at least twice 'numdat'
     Real, Intent(IN) :: EXPONTS(maxexpnt) ! Array containing complex
!      exponential
!    multiplying factors ("twiddle factors"). This must contain
!    'numdat' complex factors, i.e. numdat*2 elements
     Logical, Intent(IN) :: sort ! .True. if the transform is entered in
!      normal
!    frequency order. Otherwise it must be entered in bit reversed
!    order
!  Import/Export:
     Real, Intent(INOUT) :: DATA(maxdat) ! Import: Half of the Hermitian
!      complex
!    Fourier components of the Fourier transform stored in the
!    following fashion. DATA(1) is the DC level, DATA(2) is the
!    high frequency term, DATA(odd index>1) imaginary term,
!    DATA(even index>2) real term.
!    On export contains a real series in all elements.
!  Status:
     Integer, Intent(INOUT) :: status ! Status return variable
!  Local Constants:
     Character(Len=5), Parameter :: Version = 'V0.2' ! Version number for
!      subroutine
!  Local Variables:
     Integer :: eightpwr ! The maximum power of eight that is less or
!    equal to the data length
     Integer :: elm1 ! Array element index variable
     Integer :: elm2 ! Array element index variable
     Integer :: elm3 ! Array element index variable
     Integer :: elm4 ! Array element index variable
     Integer :: elm5 ! Array element index variable
     Integer :: elm6 ! Array element index variable
     Integer :: elm7 ! Array element index variable
     Integer :: interval ! Interval in array elements
     Integer :: length ! 2**twopwr
     Integer :: nn ! number of array elements
     Integer :: stage ! The stage of the radix eight transforms
     Integer :: twopwr ! The data length expressed as a power of two
!--------1---------2---------3---------4---------5---------6---------7--
!  Check status
!     If (status .Ne. St_goodvalue) Then
!        Call ST_SAVE ('Subroutine HST_FFS8 ' // Version)
!        Return
!     End If
           
!  Check that the region to be added to is reasonably defined
     If (maxdat .Le. 0 .Or. maxexpnt .Le. 1) Then
        status = -1 ! St_bad_dim1
     Else If (numdat .Gt. maxdat) Then
        status = -2 !St_bad_adr1
     Else If (numdat * 2 .Gt. maxexpnt)Then
        status = -3 !St_bad_rel1
     Else
         
        twopwr = Nint(Log(Real(numdat)) / Log(2.0))
        length = 2**twopwr
                          
!     Check that the data length is a power of two
        If (length .Ne. numdat) Then
           status = -7 !St_bad_2power1
        End If
              
     End If
           
!  Re-check status
!     If (status .Ne. St_goodvalue) Then
!        status = St_mod_ma + status
!        Call ST_SAVE ('Subroutine HST_FFS8 ' // Version)
!        Return
!     End If
           
! - - - -1- - - - -2- - - - -3- - - - -4- - - - -5- - - - -6- - - - -7--
!  Arguments would appear to be reasonable, go ahead.
     eightpwr = twopwr / 3
                          
     If (sort) Then
        Call HST_ORD2 (numdat, length, twopwr, DATA)
     End If
           
     Call HST_ORD1 (length, DATA)
                                 
!  Perform radix 8 iterations
     If (eightpwr .Gt. 0) Then
        nn = 8 * length
                       
        Do stage = 1, eightpwr
           nn = nn / 8
           interval = length / nn
           elm1 = interval + 1
           elm2 = elm1 + interval
           elm3 = elm2 + interval
           elm4 = elm3 + interval
           elm5 = elm4 + interval
           elm6 = elm5 + interval
           elm7 = elm6 + interval
                                 
           CALL HST_IHR8 (interval,nn,DATA(1),DATA(elm1),DATA(elm2), &
             DATA(elm3),DATA(elm4),DATA(elm5),DATA(elm6),DATA(elm7), &
             DATA(1),DATA(elm1),DATA(elm2),DATA(elm3),DATA(elm4), &
             DATA(elm5),DATA(elm6),DATA(elm7),EXPONTS,numdat)
        End Do
              
     End If
           
!  Do a radix 2 or radix 4 iteration if one is required.
     If (twopwr - eightpwr * 3 .Eq. 2) Then
        interval = length / 4
        elm1 = interval + 1
        elm2 = elm1 + interval
        elm3 = elm2 + interval
        Call HST_R4SYN (interval, DATA(1), DATA(elm1), DATA(elm2), &
          DATA(elm3))
     Else If (twopwr - eightpwr * 3 .Eq. 1) Then
        interval = length / 2
        Call HST_R2TR (interval, DATA(1), DATA(interval + 1))
     End If
           
!  End of Subroutine HST_FFS8
     End
!********1*********2*********3*********4*********5*********6*********7**
!********1*********2*********3*********4*********5*********6*********7**
                                                                        
!  ****************
!  *              *
!  *  hst_ihr8.f  *
!  *              *
!  ****************
                   
!+ HST_IHR8 - Inverse Hermitian Radix-8 Fourier transform
     Subroutine HST_IHR8 (int, nn, BR0, BR1, BR2, BR3, BR4, BR5, BR6, BR7, &
       BI0, BI1, BI2, BI3, BI4, BI5, BI6, BI7, EXPONTS, npts)
!  Description:
!    Performs one iteration of a radix-8 inverse transform of Hermitian
!    input data.
!  Keywords:
!    Fourier~Transform.Fast.Radix-8~Inverse~Hermitian,
!    FFT.Radix-8~Inverse~Hermitian
!  Method:
!    See FAST FOURIER ANALYSIS:  RADIX 8 METHOD
!    SEE BERGLAND IN IEEE TRANS. AUDIO & ELECTROACOUSTICS
!    VOL. AU-17, NO. 2, PP138-144
!    Has been adapted to use twiddle factors obtained from a work
!    array and the complex arithmetic has been altered to be more
!    efficient.
!  Usage:
!    Private
!  Deficiencies:
!    This subroutine should only be used from HST_FFS8 and is not
!    otherwise for general use
!  Bugs:
!  Authors:
!    Bergland : See BERGLAND IN IEEE TRANS. AUDIO & ELECTROACOUSTICS
!    VOL. AU-17, NO. 2, PP138-144
!    A P Hammersley (hammersley@esrf.fr)
!  History:
!    18-Jul-1986: V0.1 (Based on DR8SYN.FOR - based on R8SYN.FOR)
!    (HAMMERSLEY),
!    03-Feb-1999: V0.2 Simplify code, by removing line numbers and
!    replacing 'Continue' statements with 'End Do' statements where
!    possible (HAMMERSLEY)
!    08-Apr-2002: V0.3 Replace old style DO statements with statement numbers by
!    the 'DO - END DO' construct (problems with Absoft F95 compiler) (WILCKE)
!  Type Definitions:
     Implicit None
!  Global Constants:
     ! Include 'st_symbols.inc'
!  Import:
     Integer, Intent(IN) :: int
     Integer, Intent(IN) :: nn
     Integer, Intent(IN) :: npts
     Real, Intent(IN) :: EXPONTS(0: npts*2-1)
!  Import/Export:
     Real, Intent(INOUT) :: BR0(npts)
     Real, Intent(INOUT) :: BR1(npts)
     Real, Intent(INOUT) :: BR2(npts)
     Real, Intent(INOUT) :: BR3(npts)
     Real, Intent(INOUT) :: BR4(npts)
     Real, Intent(INOUT) :: BR5(npts)
     Real, Intent(INOUT) :: BR6(npts)
     Real, Intent(INOUT) :: BR7(npts)
     Real, Intent(INOUT) :: BI0(npts)
     Real, Intent(INOUT) :: BI1(npts)
     Real, Intent(INOUT) :: BI2(npts)
     Real, Intent(INOUT) :: BI3(npts)
     Real, Intent(INOUT) :: BI4(npts)
     Real, Intent(INOUT) :: BI5(npts)
     Real, Intent(INOUT) :: BI6(npts)
     Real, Intent(INOUT) :: BI7(npts)
!  Status:
!  Local Constants:
     Character(Len=5), Parameter :: Version = 'V0.3' ! Version number for
!      subroutine
!  Local Variables:
     Integer :: int8
     Integer :: j
     Integer :: j0, j1, j2, j3, j4, j5, j6, j7, j8, j9, j10, j11, j12
     Integer :: j13, j14
     Integer :: ji, jl, jlast, jr, jthet
     Integer :: k
     Integer :: k0, kl
!    Integer ks
     Integer :: l1, l2, l3, l4, l5, l6, l7, l8
     Integer :: l9, l10, l11, l12, l13, l14, l15
     Integer :: nptdnn
     Integer :: th2
     Integer :: welm
     Real :: c1, c2, c3, c4, c5, c6, c7
     Real :: c22
     Real :: div22
     Real :: itmp0
     Real :: p7, p7two
     Real :: pi
     Real :: pr
     Real :: ri
     Real :: rr
     Real :: rtmp0
     Real :: s22
     Real :: sum22
     Real :: s1, s2, s3, s4, s5, s6, s7
     Real :: t0, t1, t2, t3, t4, t5, t6, t7, t8
     Real :: temp
     Real :: ti0, ti1, ti2, ti3, ti4, ti5, ti6, ti7
     Real :: tr0, tr1, tr2, tr3, tr4, tr5, tr6, tr7
     Real :: tt0, tt1
     Real :: ttr6, ttr7
     Real :: wdiv1, wdiv2, wdiv3, wdiv4, wdiv5, wdiv6, wdiv7
     Real :: wsum1, wsum2, wsum3, wsum4, wsum5, wsum6, wsum7
!  Local Arrays:
     Integer :: L(15) ! For indexing into butterfly elements
!    Equivalences:
     Equivalence (L15,L(1)),(L14,L(2)),(L13,L(3)),(L12,L(4)), &
       (L11,L(5)),(L10,L(6)),(L9,L(7)),(L8,L(8)),(L7,L(9)), &
       (L6,L(10)),(L5,L(11)),(L4,L(12)),(L3,L(13)),(L2,L(14)), (L1,L(15))
!--------1---------2---------3---------4---------5---------6---------7--
                                                                        
!  Set up indexing values
     L(1) = nn / 8
     Do k = 2, 15
                 
        If (L(k - 1) .Lt. 2) Then
           L(k - 1) = 2
           L(k) = 2
        Else If (L(k - 1) .Eq. 2) Then
           L(k) = 2
        Else
           L(k) = L(k - 1) / 2
        End If
              
     End Do
           
     nptdnn = npts / nn
     p7 = 0.7071067812
     p7two = 1.4142135624
     c22 = .9238795325
     s22 = .3826834324
     sum22 = c22 + s22
     div22 = s22 - c22
     ji = 3
     jl = 2
     jr = 2
           
     Do J1=2,L1,2
     Do J2=J1,L2,L1
     Do J3=J2,L3,L2
     Do J4=J3,L4,L3
     Do J5=J4,L5,L4
     Do J6=J5,L6,L5
     Do J7=J6,L7,L6
     Do J8=J7,L8,L7
     Do J9=J8,L9,L8
     Do J10=J9,L10,L9
     Do J11=J10,L11,L10
     Do J12=J11,L12,L11
     Do J13=J12,L13,L12
     Do J14=J13,L14,L13
     Do JTHET=J14,L15,L14
        TH2=JTHET-2
        IF(TH2) 71,71,76
        71           Continue
        Do K=1,INT
           T0=BR0(K)+BR1(K)
           T1=BR0(K)-BR1(K)
           T2=BR2(K)+BR2(K)
           T3=BR3(K)+BR3(K)
           T4=BR4(K)+BR6(K)
           T6=BR7(K)-BR5(K)
           T5=BR4(K)-BR6(K)
           T7=BR7(K)+BR5(K)
           PR=P7*(T7+T5)
           PI=P7*(T7-T5)
           TT0=T0+T2
           TT1=T1+T3
           T2=T0-T2
           T3=T1-T3
           T4=T4+T4
           T5=PR+PR
           T6=T6+T6
           T7=PI+PI
           BR0(K)=TT0+T4
           BR1(K)=TT1+T5
           BR2(K)=T2+T6
           BR3(K)=T3+T7
           BR4(K)=TT0-T4
           BR5(K)=TT1-T5
           BR6(K)=T2-T6
           BR7(K)=T3-T7
        End Do
        IF(NN-8) 70,70,73
        73           K0=INT*8+1
        KL=K0+INT-1
        Do K=K0,KL
           T1=BI0(K)+BI6(K)
           T2=BI7(K)-BI1(K)
           T3=BI0(K)-BI6(K)
           T4=BI7(K)+BI1(K)
           PR=C22*(T3+T4)
           PI=PR-T3*sum22
           PR=PR+T4*div22
           T5=BI2(K)+BI4(K)
           T6=BI5(K)-BI3(K)
           T7=BI2(K)-BI4(K)
           T8=BI5(K)+BI3(K)
           RI=C22*(T7+T8)
           RR=RI-T7*sum22
           RI=-(RI+T8*div22)
           BI0(K)=(T1+T5)+(T1+T5)
           BI4(K)=(T2+T6)+(T2+T6)
           BI1(K)=(PR+RR)+(PR+RR)
           BI5(K)=(PI+RI)+(PI+RI)
           T5=T1-T5
           T6=T2-T6
           BI2(K)=P7TWO*(T6+T5)
           BI6(K)=P7TWO*(T6-T5)
           RR=PR-RR
           RI=PI-RI
           BI3(K)=P7TWO*(RI+RR)
           BI7(K)=P7TWO*(RI-RR)
        End Do
        GOTO 70
        76           th2=th2*nptdnn
        c1=EXPONTS(th2)
        s1=-EXPONTS(th2+1)
        wsum1=c1+s1
        wdiv1=s1-c1
        welm=th2+th2
        c2=EXPONTS(welm)
        s2=-EXPONTS(welm+1)
        wsum2=c2+s2
        wdiv2=s2-c2
        welm=welm+th2
        c3=EXPONTS(welm)
        s3=-EXPONTS(welm+1)
        wsum3=c3+s3
        wdiv3=s3-c3
        welm=welm+th2
        c4=EXPONTS(welm)
        s4=-EXPONTS(welm+1)
        wsum4=c4+s4
        wdiv4=s4-c4
        welm=welm+th2
        c5=EXPONTS(welm)
        s5=-EXPONTS(welm+1)
        wsum5=c5+s5
        wdiv5=s5-c5
        welm=welm+th2
        c6=EXPONTS(welm)
        s6=-EXPONTS(welm+1)
        wsum6=c6+s6
        wdiv6=s6-c6
        welm=welm+th2
        c7=EXPONTS(welm)
        s7=-EXPONTS(welm+1)
        wsum7=c7+s7
        wdiv7=s7-c7
        INT8=INT*8
        J0=JR*INT8+1
        K0=JI*INT8+1
        JLAST=J0+INT-1
        Do J=J0,JLAST
!        KS=K0+J-J0
!        Do K=KS,KS
           k = k0+j-j0
           TR0=BR0(J)+BI6(K)
           TI0=BI7(K)-BR1(J)
           TR1=BR0(J)-BI6(K)
           TI1=BI7(K)+BR1(J)
           TR2=BR2(J)+BI4(K)
           TI2=BI5(K)-BR3(J)
           TR3=BI5(K)+BR3(J)
           TI3=BI4(K)-BR2(J)
           TR4=BR4(J)+BI2(K)
           TI4=BI3(K)-BR5(J)
           T0=BR4(J)-BI2(K)
           T1=BI3(K)+BR5(J)
           TR5=P7*(T0+T1)
           TI5=P7*(T1-T0)
           TR6=BR6(J)+BI0(K)
           TI6=BI1(K)-BR7(J)
           T0=BR6(J)-BI0(K)
           T1=BI1(K)+BR7(J)
           TR7=-P7*(T0-T1)
           TI7=-P7*(T1+T0)
           T0=TR0+TR2
           T1=TI0+TI2
           T2=TR1+TR3
           T3=TI1+TI3
           TR2=TR0-TR2
           TI2=TI0-TI2
           TR3=TR1-TR3
           TI3=TI1-TI3
           T4=TR4+TR6
           T5=TI4+TI6
           T6=TR5+TR7
           T7=TI5+TI7
           TTR6=TI4-TI6
           TI6=TR6-TR4
           TTR7=TI5-TI7
           TI7=TR7-TR5
           BR0(J)=T0+T4
           BI0(K)=T1+T5
           rtmp0=T2+T6
           itmp0=T3+T7
           temp=c1*(rtmp0+itmp0)
           BR1(J)=temp-itmp0*wsum1
           BI1(K)=temp+rtmp0*wdiv1
           rtmp0=TR2+TTR6
           itmp0=TI2+TI6
           temp=c2*(rtmp0+itmp0)
           BR2(J)=temp-itmp0*wsum2
           BI2(K)=temp+rtmp0*wdiv2
           rtmp0=TR3+TTR7
           itmp0=TI3+TI7
           temp=c3*(rtmp0+itmp0)
           BR3(J)=temp-itmp0*wsum3
           BI3(K)=temp+rtmp0*wdiv3
           rtmp0=T0-T4
           itmp0=T1-T5
           temp=c4*(rtmp0+itmp0)
           BR4(J)=temp-itmp0*wsum4
           BI4(K)=temp+rtmp0*wdiv4
           rtmp0=T2-T6
           itmp0=T3-T7
           temp=c5*(rtmp0+itmp0)
           BR5(J)=temp-itmp0*wsum5
           BI5(K)=temp+rtmp0*wdiv5
           rtmp0=TR2-TTR6
           itmp0=TI2-TI6
           temp=c6*(rtmp0+itmp0)
           BR6(J)=temp-itmp0*wsum6
           BI6(K)=temp+rtmp0*wdiv6
           rtmp0=TR3-TTR7
           itmp0=TI3-TI7
           temp=c7*(rtmp0+itmp0)
           BR7(J)=temp-itmp0*wsum7
           BI7(K)=temp+rtmp0*wdiv7
!        End Do
        End Do
        JR=JR+2
        JI=JI-2
        IF(JI-JL) 78,78,70
        78           JI=JR+JR-1
        JL=JR
        70        CONTINUE
     End Do
     End Do
     End Do
     End Do
     End Do
     End Do
     End Do
     End Do
     End Do
     End Do
     End Do
     End Do
     End Do
     End Do
     End Do
                          
!     End of Subroutine HST_IHR8
        End
!********1*********2*********3*********4*********5*********6*********7**
!********1*********2*********3*********4*********5*********6*********7**
                                                                        
!  *********************
!  *                   *
!  *  hst_expnt.f  *
!  *                   *
!  *********************
                        
!+ HST_EXPNT MAthematic procedures: EXPoNTials calculation
     Subroutine HST_EXPNT (maxdat, numdat, jump, TWIDDLE, status)
!  Description:
!    Calculates the complex exponentials (twiddle factors)
!    necessary for Fourier transform programs. 'numdat'/2 complex
!    twiddle factors are calculated.
!  Keywords:
!    Twiddle~Factors, Fourier~Coefficients,
!    Complex~Exponentials.Calculation
!  Method:
!    Calculates the initial complex exponential which is also the
!    multiplier to form the next complex expontial. Complex
!    multiplication is used to form successive expontials. To avoid
!    cumulation of round-off errors the complex exponentials are
!    recalculated by FORTRAN functions every 'jump' elements.
!    N.B. The complex multiplication is carried out by an
!    algorithm which involves three multiplications instead of four
!    per complex multiplication
!  Usage:
!    General
!  Deficiencies:
!  Bugs:
!  Authors:
!    A P Hammersley (hammersley@esrf.fr)
!  History:
!    16-Jun-1992: V0.1 Original, based on MA_EXPNT (HAMMERSLEY)
!  Type Definitions:
     Implicit None
!  Global Constants:
     ! Include 'st_symbols.inc'
!  Import:
     Integer, Intent(IN) :: maxdat ! Dimension of array 'TWIDDLE'
     Integer, Intent(IN) :: numdat ! Number of elements over which the
!      twiddle
!    factors are to be calculated. This is 'numdat'/2 complex
!    elements
     Integer, Intent(IN) :: jump ! Gap between accurate calculation of the
!    exponentials.
!  Export:
     Real, Intent(OUT) :: TWIDDLE(0: maxdat-1) ! The complex twiddle factors
!  Status:
     Integer, Intent(INOUT) :: status ! Status return variable
!  Local Constants:
     Character(Len=5), Parameter :: Version = 'V0.1' ! Version number for
!      subroutine
!  Local Variables:
     Integer :: elm ! Loop variable for elements
     Integer :: group ! Loop variable for groups
     Integer :: len2 ! The length in array elements between
!    recalculating the twiddle factors using FORTRAN functions
     Integer :: num1 ! Number of complex data elements
     Integer :: num1d2 ! Number of complex elements divided by two
     Integer :: num1d4 ! Number of complex elements divided by four
     Real :: itemp1 ! Temporary variable involved in complex
!    multiplication
     Real :: itmp1 ! Temporary variable used to store imaginary part of
!    a complex variable
     Real :: rtmp1 ! Temporary variable used to store real part of
!    a complex variable
     Real :: sum ! Temporay variable used to store the sum of two
!    variables
     Real :: wdif1 ! The difference between the real and imaginary
!    components of the multiplying constant between successive
!    twiddle factors
     Real :: wint ! The interval in radians for calculating the twiddle
!    factors
     Real :: wr1 ! The real value of the multiplying constant between
!    successive twiddle factors
     Real :: wsum1 ! The sum of the real and imaginary components of the
!    multiplying constant between successive twiddle factors
!--------1---------2---------3---------4---------5---------6---------7--
!  Check status
!     If (status .Ne. St_goodvalue) Then
!        Call ST_SAVE ('Subroutine HST_EXPNT ' // Version)
!        Return
!     End If
           
!  Check that the region to be added to is reasonably defined
     If (maxdat .Le. 0) Then
        status = -11 !St_bad_dim1
     Else If (numdat .Gt. maxdat) Then
        status = -12 !St_bad_adr1
     Else If (jump .Lt. 1) Then
        status = -13 !St_bad_int1
     End If
           
!  Recheck status
!     If (status .Ne. St_goodvalue) Then
!        status = status + St_mod_ma
!        Call ST_SAVE ('Subroutine HST_EXPNT ' // Version)
!     Else
         
! - - - -1- - - - -2- - - - -3- - - - -4- - - - -5- - - - -6- - - - -7--
!     Arguments would appear to be reasonable, go ahead.
                                                        
!**DEBUG***DEBUG***DEBUG***DEBUG***DEBUG***DEBUG***DEBUG***DEBUG***DEBUG
!     Write (*,'(1x,''Entered HST_EXPNT'')')
!     Write (*,'(1x,''maxdat = ''i8)') maxdat
!     Write (*,'(1x,''numdat = ''i8)') numdat
!     Write (*,'(1x,''jump = ''i8)') jump
!     Write (*,'(1x,''status = ''i12)') status
!**DEBUG***DEBUG***DEBUG***DEBUG***DEBUG***DEBUG***DEBUG***DEBUG***DEBUG
                                                                        
!     Create array of complex exponentials.
        num1 = numdat / 2
        num1d2 = num1 / 2
        num1d4 = num1d2 / 2
        wint = 6.283185307179586 / Real(num1)
        TWIDDLE(0) = 1.0
        TWIDDLE(1) = 0.0
        wr1 = Cos(wint)
        wdif1 = Sin(wint)
        wsum1 = wr1 + wdif1
        wdif1 = wdif1 - wr1
                           
        Do group = 1, num1d4, jump
                                  
           If (group .Le. num1d4) Then
              len2 = group+group
              TWIDDLE(len2) = Cos(wint*group)
              TWIDDLE(len2+1) = Sin(wint*group)
                                               
              Do elm = 1, jump - 1
                 len2 = group + elm
                 len2 = len2 + len2
                                   
                 If (len2 .Le. num1d2) Then
                    rtmp1 = TWIDDLE(len2-2)
                    itmp1 = TWIDDLE(len2-1)
                    sum = rtmp1 + itmp1
                    itemp1 = wr1 * sum
                    TWIDDLE(len2) = itemp1 - itmp1 * wsum1
                    TWIDDLE(len2+1) = itemp1 + rtmp1 * wdif1
                 End If
                       
              End Do
                    
           End If
                 
        End Do
              
        Do elm = num1d2+2, num1-2,2
           TWIDDLE(elm) = -TWIDDLE(num1-elm)
           TWIDDLE(elm+1) = TWIDDLE(num1-elm+1)
        End Do
              
        Do elm = 0, num1-1
           TWIDDLE(elm+num1) = -TWIDDLE(elm)
        End Do
              
!     End If
           
!  End of Subroutine HST_EXPNT
     End
!********1*********2*********3*********4*********5*********6*********7**
!********1*********2*********3*********4*********5*********6*********7**
                                                                        
!  ********************
!  *                  *
!  *  hst_r4tr.f  *
!  *                  *
!  ********************
                       
!+ HST_R4TR - (MAthematical procedures) Radix 4 TRansform
     Subroutine HST_R4TR (int, B0, B1, B2, B3)
!  Description:
!    This subroutine is adapted from R4TR a subroutine written by
!    Bergland to perform radix-2 FFT.
!    Berglands original subroutine may be found in IEEE
!    Transactions on Audio and Electroacoustic, Vol. Au-17, pp.138-144.
!  Keywords:
!    Fourier~Transform.Radix~4
!  Method:
!    See FAST FOURIER ANALYSIS:  RADIX 8 METHOD
!    SEE BERGLAND IN IEEE TRANS. AUDIO & ELECTROACOUSTICS
!    VOL. AU-17, NO. 2, PP138-144
!  Usage:
!    Private
!  Deficiencies:
!  Bugs:
!  Authors:
!    Bergland : See BERGLAND IN IEEE TRANS. AUDIO & ELECTROACOUSTICS
!    VOL. AU-17, NO. 2, PP138-144
!    A P Hammersley (hammersley@esrf.fr)
!  History:
!    16-Jun-1992: V0.1 Original, based on MA_R2TR (HAMMERSLEY),
!    based on R2TR (BERGLAND)
!    04-Feb-1999: V0.2 Simplify code, by removing line numbers and
!    replacing 'Continue' statements with 'End Do' statements where
!    possible (HAMMERSLEY)
!  Type Definitions:
     Implicit None
!  Global Constants:
     ! Include 'st_symbols.inc'
!  Import:
     Integer, Intent(IN) :: int
!  Import/Export:
     Real, Intent(INOUT) :: B0(int)
     Real, Intent(INOUT) :: B1(int)
     Real, Intent(INOUT) :: B2(int)
     Real, Intent(INOUT) :: B3(int)
!  Status:
!  Local Constants:
     Character(Len=5), Parameter :: Version = 'V0.2' ! Version number for
!      subroutine
!  Local Variables:
     Integer :: k ! Loop variable
     Real :: r0
     Real :: r1
     Real :: temp ! Temporary variable for swapping elements
!  Local Arrays:
!--------1---------2---------3---------4---------5---------6---------7--
                                                                        
     Do k = 1, int
        r0 = B0(k) + B2(k)
        r1 = B1(k) + B3(k)
        B2(k) = B0(k) - B2(k)
        B3(k) = B1(k) - B3(k)
        B0(k) = r0 + r1
        B1(k) = r0 - r1
     End Do
           
     End
!  End of Subroutine HST_R4TR
!********1*********2*********3*********4*********5*********6*********7**
!********1*********2*********3*********4*********5*********6*********7**
                                                                        
!  ********************
!  *                  *
!  *  hst_r4syn.f *
!  *                  *
!  ********************
                       
!+ HST_R4SYN - (MAthematical procedures) Radix 4 SYNthesis
     SUBROUTINE HST_R4SYN(INT, B0, B1, B2, B3)
!  Description:
!    This subroutine is adapted from R4TR a subroutine written by
!    Bergland to perform radix-2 FFT.
!    Berglands original subroutine may be found in IEEE
!    Transactions on Audio and Electroacoustic, Vol. Au-17, pp.138-144.
!  Keywords:
!    Fourier~Transform.Radix~4
!  Method:
!    See FAST FOURIER ANALYSIS:  RADIX 8 METHOD
!    SEE BERGLAND IN IEEE TRANS. AUDIO & ELECTROACOUSTICS
!    VOL. AU-17, NO. 2, PP138-144
!  Usage:
!    Private
!  Deficiencies:
!  Bugs:
!  Authors:
!    Bergland : See BERGLAND IN IEEE TRANS. AUDIO & ELECTROACOUSTICS
!    VOL. AU-17, NO. 2, PP138-144
!    A P Hammersley (hammersley@esrf.fr)
!  History:
!    16-Jun-1992: V0.1 Original, based on MA_R2TR (HAMMERSLEY),
!    based on R2TR (BERGLAND)
!    04-Feb-1999: V0.2 Simplify code, by removing line numbers and
!    replacing 'Continue' statements with 'End Do' statements where
!    possible (HAMMERSLEY)
!  Type Definitions:
     Implicit None
!  Global Constants:
     ! Include 'st_symbols.inc'
!  Import:
     Integer, Intent(IN) :: int
!  Import/Export:
     Real, Intent(INOUT) :: B0(int)
     Real, Intent(INOUT) :: B1(int)
     Real, Intent(INOUT) :: B2(int)
     Real, Intent(INOUT) :: B3(int)
!  Status:
!  Local Constants:
     Character(Len=5), Parameter :: Version = 'V0.2' ! Version number for
!      subroutine
!  Local Variables:
     Integer :: k ! Loop variable
     Real :: t0
     Real :: t1
     Real :: t2
     Real :: t3
!  Local Arrays:
!--------1---------2---------3---------4---------5---------6---------7--
                                                                        
     Do k = 1, int
        t0 = B0(k) + B1(k)
        t1 = B0(k) - B1(k)
        t2 = B2(k) + B2(k)
        t3 = B3(k) + B3(k)
        B0(k) = t0 + t2
        B2(k) = t0 - t2
        B1(k) = t1 + t3
        B3(k) = t1 - t3
     End Do
           
     End
!  End of Subroutine HST_R4SYN
!********1*********2*********3*********4*********5*********6*********7**
!********1*********2*********3*********4*********5*********6*********7**
                                                                        
!  ********************
!  *                  *
!  *  hst_r2tr.f  *
!  *                  *
!  ********************
                       
!+ HST_R2TR - (MAthematical procedures) Radix 2 Fourier TRansform
     SUBROUTINE HST_R2TR (int, B0, B1)
!  Description:
!    This subroutine is adapted from R2TR a subroutine written by
!    Bergland to perform radix-2 FFT.
!    Berglands original subroutine may be found in IEEE
!    Transactions on Audio and Electroacoustic, Vol. Au-17, pp.138-144.
!  Keywords:
!    Fourier~Transform.Radix~2
!  Method:
!    See FAST FOURIER ANALYSIS:  RADIX 8 METHOD
!    SEE BERGLAND IN IEEE TRANS. AUDIO & ELECTROACOUSTICS
!    VOL. AU-17, NO. 2, PP138-144
!  Usage:
!    Private
!  Deficiencies:
!  Bugs:
!  Authors:
!    Bergland : See BERGLAND IN IEEE TRANS. AUDIO & ELECTROACOUSTICS
!    VOL. AU-17, NO. 2, PP138-144
!    A P Hammersley (hammersley@esrf.fr)
!  History:
!    16-Jun-1992: V0.1 Original, based on MA_R2TR (HAMMERSLEY),
!    based on R2TR (BERGLAND)
!    04-Feb-1999: V0.2 Simplify code, by removing line numbers and
!    replacing 'Continue' statements with 'End Do' statements where
!    possible (HAMMERSLEY)
!  Type Definitions:
     Implicit None
!  Global Constants:
     ! Include 'st_symbols.inc'
!  Import:
     Integer, Intent(IN) :: int
!  Import/Export:
     Real, Intent(INOUT) :: B0(int)
     Real, Intent(INOUT) :: B1(int)
!  Status:
!  Local Constants:
     Character(Len=5), Parameter :: Version = 'V0.2' ! Version number for
!      subroutine
!  Local Variables:
     Integer :: k ! Loop variable
     Real :: temp ! Temporary variable for swapping elements
!  Local Arrays:
!--------1---------2---------3---------4---------5---------6---------7--
                                                                        
     Do k = 1, int
        temp = B0(k) + B1(k)
        B1(k) = B0(k) - B1(k)
        B0(k) = temp
     End Do
           
     End
!  End of Subroutine HST_R2TR
!********1*********2*********3*********4*********5*********6*********7**
!********1*********2*********3*********4*********5*********6*********7**
                                                                        
!  ********************
!  *                  *
!  *  hst_ord2.f  *
!  *                  *
!  ********************
                       
!+ HST_ORD2 - (MAthematical procedures) ORDerind (2) of radix-8 FFT
     Subroutine HST_ORD2 (numdat, n, m, B)
!  Description:
!    This subroutine is adapted from ORD2 a subroutine written by
!    Bergland to re-order data after an FFT.
!    Berglands original subroutine may be found in IEEE
!    Transactions on Audio and Electroacoustic, Vol. Au-17, pp.138-144.
!  Keywords:
!    Fourier~Transform.Fast.Re-order
!  Method:
!    See FAST FOURIER ANALYSIS:  RADIX 8 METHOD
!    SEE BERGLAND IN IEEE TRANS. AUDIO & ELECTROACOUSTICS
!    VOL. AU-17, NO. 2, PP138-144
!  Usage:
!    Private
!  Deficiencies:
!  Bugs:
!  Authors:
!    Bergland : See BERGLAND IN IEEE TRANS. AUDIO & ELECTROACOUSTICS
!    VOL. AU-17, NO. 2, PP138-144
!    A P Hammersley (hammersley@esrf.fr)
!  History:
!    16-Jun-1992: V0.1 Original, based on MA_ORD2 (HAMMERSLEY),
!    based on ORD2 (BERGLAND)
!    03-Feb-1999: V0.2 Simplify code, by removing line numbers and
!    replacing 'Continue' statements with 'End Do' statements where
!    possible (HAMMERSLEY)
!    04-Feb-1999: V0.3 Add number of data points as argument
!    (HAMMERSLEY)
!    08-Apr-2002: V0.4 Replace old style DO statements with statement numbers by
!    the 'DO - END DO' construct (problems with Absoft F95 compiler) (WILCKE)
!  Type Definitions:
     Implicit None
!  Global Constants:
     ! Include 'st_symbols.inc'
!  Import:
     Integer, Intent(IN) :: numdat ! Number of data points in FFT
     Integer, Intent(IN) :: n
     Integer, Intent(IN) :: m
!  Import/Export:
     Real, Intent(INOUT) :: B(numdat) ! FFT to be re-ordered
!  Status:
!  Local Constants:
     Character(Len=5), Parameter :: Version = 'V0.4' ! Version number for
!      subroutine
!  Local Variables:
     Integer :: ij
     Integer :: ji
     Integer :: j1, j2, j3, j4, j5, j6, j7, j8, j9, j10, j11, j12
     Integer :: j13, j14, j15, j16, j17, j18
     Integer :: k
     Integer :: L1, L2, L3, L4, L5, L6, L7, L8, L9, L10, L11, L12
     Integer :: L13, L14, L15, L16, L17, L18, L19
     Real :: t ! Temporary variable for swapping elements
!  Local Arrays:
     Integer :: L(20)
!    Equivalences:
     Equivalence (L19,L(1)),(L18,L(2)),(L17,L(3)),(L16,L( &
       4)),(L15,L(5)),(L14,L(6)),(L13,L(7)),(L12,L(8)),(L11,L( &
       9)),(L10,L(10)),(L9,L(11)),(L8,L(12)),(L7,L(13)),(L6,L( &
       14)),(L5,L(15)),(L4,L(16)),(L3,L(17)),(L2,L(18)),(L1,L(19))
!--------1---------2---------3---------4---------5---------6---------7--
                                                                        
     L(1) = n
     Do k = 2, m
        L(k) = L(k - 1) / 2
     End Do
     Do k = m, 19
        L(k + 1) = 2
     End Do
     ij = 2
     Do j1 = 2, L1, 2
        Do j2 = j1, L2, L1
           Do j3 = j2, L3, L2
              Do j4 = j3, L4, L3
                 Do j5 = j4, L5, L4
                    Do j6 = j5, L6, L5
                       Do j7 = j6, L7, L6
                          Do j8 = j7, L8, L7
                             Do j9 = j8, L9, L8
                                Do j10 = j9, L10, L9
                                   Do j11 = j10, L11, L10
                                      Do j12 = j11, L12, L11
                                         Do j13 = j12, L13, L12
                                            Do j14 = j13, L14, L13
                                               Do j15 = j14, L15, L14
                                                  Do j16 = j15, L16, L15
                                                     Do j17 = j16, L17, L16
                                                        Do j18 = j17, L18, L17
                                                           Do ji = j18, L19, L18
                                                              If (ij .Lt. ji) &
                                                                 Then
                                                                 t = B(ij - 1)
                                                                 B(ij - 1) = &
                                                                    B(ji - 1)
                                                                 B(ji - 1) = t
                                                                 t = B(ij)
                                                                 B(ij) = B(ji)
                                                                 B(ji) = t
                                                              End If
                                                              ij = ij + 2
                                                           End Do
                                                        End Do
                                                     End Do
                                                  End Do
                                               End Do
                                            End Do
                                         End Do
                                      End Do
                                   End Do
                                End Do
                             End Do
                          End Do
                       End Do
                    End Do
                 End Do
              End Do
           End Do
        End Do
     End Do
                                                                      
!                                                           End of HST_ORD2
                                                              End
!********1*********2*********3*********4*********5*********6*********7**
!********1*********2*********3*********4*********5*********6*********7**
                                                                        
!  ********************
!  *                  *
!  *  hst_ord1.f  *
!  *                  *
!  ********************
                       
!+ HST_ORD1 - (MAthematical procedures) ORDering (1) of radix-8 FFT
     Subroutine HST_ORD1 (n, B)
!  Description:
!    This subroutine is adapted from ORD1 a subroutine written by
!    Bergland to re-order data after an FFT.
!    Berglands original subroutine may be found in IEEE
!    Transactions on Audio and Electroacoustic, Vol. Au-17, pp.138-144.
!  Keywords:
!    Fourier~Transform.Fast.Re-order
!  Method:
!    See FAST FOURIER ANALYSIS:  RADIX 8 METHOD
!    SEE BERGLAND IN IEEE TRANS. AUDIO & ELECTROACOUSTICS
!    VOL. AU-17, NO. 2, PP138-144
!  Usage:
!    Private
!  Deficiencies:
!  Bugs:
!  Authors:
!    Bergland : See BERGLAND IN IEEE TRANS. AUDIO & ELECTROACOUSTICS
!    VOL. AU-17, NO. 2, PP138-144
!    A P Hammersley (hammersley@esrf.fr)
!  History:
!    16-Jun-1992: V0.1 Original, based on MA_ORD1 (HAMMERSLEY),
!    based on R8TR (BERGLAND)
!    03-Feb-1999: V0.2 Simplify code, by removing line numbers and
!    replacing 'Continue' statements with 'End Do' statements where
!    possible (HAMMERSLEY)
!  Type Definitions:
     Implicit None
!  Global Constants:
     ! Include 'st_symbols.inc'
!  Import:
     Integer, Intent(IN) :: n
!  Import/Export:
     Real, Intent(INOUT) :: B(n)
!  Status:
!  Local Constants:
     Character(Len=5), Parameter :: Version = 'V0.2' ! Version number for
!      subroutine
!  Local Variables:
     Integer :: j
     Integer :: k, kl
     Real :: t ! Temporary variable for swapping elements
!  Local Arrays:
!    Equivalences:
!--------1---------2---------3---------4---------5---------6---------7--
     k = 4
     kl = 2
     Do j = 4, n, 2
                   
        If (k .Gt. j) Then
           t = B(j)
           B(j) = B(k)
           B(k) = t
        End If
              
        k = k - 2
        If (k .Le. kl) Then
           k = j + j
           kl = j
        End If
              
     End Do
           
!  End of HST_ORD1
     End
!********1*********2*********3*********4*********5*********6*********7**
                                                                        
                                                                        
                                                                        
                                                                        
                                                                        
                                                                        
                                                                        
                                                                        
