/* Vhst_fourier.f -- translated by f2c (version 20000121).
   You must link the resulting object file with the libraries:
	-lf2c -lm   (in that order)
*/

#include "f2c.h"

/* Table of constant values */

static integer c__2 = 2;

/* ********1*********2*********3*********4*********5*********6*********7*********8 */
/* ********1*********2*********3*********4*********5*********6*********7** */
/*  ***************** */
/*  *               * */
/*  *   hst_ffa8.f  * */
/*  *               * */
/*  ***************** */
/* + HST_FFA8 - (MAthematical procedures) Fast Fourier Analysis: */
/*    radix 8 */
/* Subroutine */ int hst_ffa8__(maxdat, numdat, maxexpnt, exponts, sort, data,
	 status)
integer *maxdat, *numdat, *maxexpnt;
real *exponts;
logical *sort;
real *data;
integer *status;
{
    /* System generated locals */
    integer i__1;
    real r__1;

    /* Builtin functions */
    double log();
    integer i_nint(), pow_ii();

    /* Local variables */
    extern /* Subroutine */ int hst_ord1__(), hst_ord2__(), hst_frr8__(), 
	    hst_r2tr__(), hst_r4tr__();
    static integer interval, eightpwr, stage, nn, length, elm1, elm2, elm3, 
	    elm4, elm5, elm6, elm7, two_pwr__;

/*  Description: */
/*    Perform forward fast Fourier transform on real data of a */
/*    power of two in length */
/*  Keywords: */
/*    Fourier~Transform.Fast.Real~Forward, FFT.Real~Forward */
/*  Method: */
/*    FAST FOURIER ANALYSIS:  RADIX 8 METHOD */
/*    SEE BERGLAND IN IEEE TRANS. AUDIO & ELECTROACOUSTICS */
/*    VOL. AU-17, NO. 2, PP138-144 */
/*    Adapted to use precalculated twiddle factors */
/*  Usage: */
/*    General */
/*  Deficiencies: */
/*  Bugs: */
/*    None known */
/*  Authors: */
/*    Bergland : See BERGLAND IN IEEE TRANS. AUDIO & ELECTROACOUSTICS */
/*    VOL. AU-17, NO. 2, PP138-144 */
/*    A P Hammersley (hammersley@esrf.fr) */
/*  History: */
/*    16-Jun-1992: V0.1 Original, based on MA_FFA8, based on FFA8 */
/*    (HAMMERSLEY)(BERGLAND) */
/*    04-Feb-1999: V0.2 Changes to argument list of 'HST_ORD2' */
/*    (HAMMERSLEY) */
/*  Type Definitions: */
/* ...Translated by Pacific-Sierra Research vf90 Personal 3.4N5 11:36:22 7/11/02 */
/* ...Switches: */
/*  Global Constants: */
/*      Include 'st_symbols.inc' */
/*  Import: */
/* Dimension of array 'DATA' */
/* Number of real data points to transform */
/*      array, must */
/*    be at least twice 'numdat' */
/* Dimension size of twiddle factor */
/*      exponential */
/*    multiplying factors ("twiddle factors"). This must contain */
/*    'numdat' complex factors, i.e. numdat*2 elements */
/* Array containing complex */
/*      into */
/*    normal frequency order. Otherwise it is left in bit reversed */
/*    order */
/*  Import/Export: */
/* .True. if the transform is to be sorted */
/*      Fourier */
/*    transformed. On export: Half of the Hermitian complex Fourier */
/*    components of the Fourier transform stored in the following */
/*    fashion. DATA(1) is the DC level, DATA(2) is the high */
/*    frequency term, DATA(odd index>1) imaginary term, */
/*    DATA(even index>2) real term. */
/*  Status: */
/* On import : the real array to be */
/*  Local Constants: */
/* Status return variable */
/* Version number for */
/*      subroutine */
/*  Local Variables: */
/*    equal to the data length */
/* The maximum power of eight that is less or */
/* Array element index variable */
/* Array element index variable */
/* Array element index variable */
/* Array element index variable */
/* Array element index variable */
/* Array element index variable */
/* Array element index variable */
/* Interval in array elements */
/* 2**'two_pwr' */
/* number of array elements */
/* The stage of the radix eight transforms */
/* --------1---------2---------3---------4---------5---------6---------7-- */
/*  Check status */
/*     If (status .Ne. St_goodvalue) Then */
/*        Call ST_SAVE ('Subroutine HST_FFA8 ' // Version) */
/*        Return */
/*     End If */
/*  Check that the region to be added to is reasonably defined */
/* The data length expressed as a power of two */
    /* Parameter adjustments */
    --data;
    --exponts;

    /* Function Body */
    if (*maxdat <= 0 || *maxexpnt <= 1) {
	*status = -1;
/* St_bad_dim1 */
    } else if (*numdat > *maxdat) {
	*status = -2;
/* St_bad_adr1 */
    } else if (*numdat << 1 > *maxexpnt) {
	*status = -3;
/* St_bad_rel1 */
    } else {
	r__1 = log((real) (*numdat)) / log((float)2.);
	two_pwr__ = i_nint(&r__1);
	length = pow_ii(&c__2, &two_pwr__);
	if (length != *numdat) {
	    *status = -4;
	}
/* St_bad_2power1 */
    }
/*  Recheck status */
/*     If (status .Ne. St_goodvalue) Then */
/*        status = status + St_mod_ma */
/*        Call ST_SAVE ('Subroutine HST_FFA8 ' // Version) */
/*        Return */
/*     End If */
/* - - - -1- - - - -2- - - - -3- - - - -4- - - - -5- - - - -6- - - - -7-- */
/*  Arguments would appear to be reasonable, go ahead. */
    eightpwr = two_pwr__ / 3;
    nn = 1;
    if (two_pwr__ - eightpwr * 3 == 2) {
/*     Perform radix 4 stage of transform */
	nn = 4;
	interval = length / 4;
	elm1 = interval + 1;
	elm2 = elm1 + interval;
	elm3 = elm2 + interval;
	hst_r4tr__(&interval, &data[1], &data[elm1], &data[elm2], &data[elm3])
		;
    } else if (two_pwr__ - eightpwr * 3 == 1) {
/*     Perform radix 2 stage of transform */
	nn = 2;
	interval = length / 2;
	hst_r2tr__(&interval, &data[1], &data[interval + 1]);
    }
    if (eightpwr > 0) {
/*     Perform radix 8 iterations */
	i__1 = eightpwr;
	for (stage = 1; stage <= i__1; ++stage) {
	    nn <<= 3;
	    interval = length / nn;
	    elm1 = interval + 1;
	    elm2 = elm1 + interval;
	    elm3 = elm2 + interval;
	    elm4 = elm3 + interval;
	    elm5 = elm4 + interval;
	    elm6 = elm5 + interval;
	    elm7 = elm6 + interval;
	    hst_frr8__(&interval, &nn, &data[1], &data[elm1], &data[elm2], &
		    data[elm3], &data[elm4], &data[elm5], &data[elm6], &data[
		    elm7], &data[1], &data[elm1], &data[elm2], &data[elm3], &
		    data[elm4], &data[elm5], &data[elm6], &data[elm7], &
		    exponts[1], numdat);
	}
    }
    hst_ord1__(&length, &data[1]);
    if (*sort) {
	hst_ord2__(numdat, &length, &two_pwr__, &data[1]);
    }
/*  End of Subroutine HST_FFA8 */
} /* hst_ffa8__ */

/* ********1*********2*********3*********4*********5*********6*********7** */
/* ********1*********2*********3*********4*********5*********6*********7** */
/*  **************** */
/*  *              * */
/*  *  hst_frr8.f  * */
/*  *              * */
/*  **************** */
/* + HST_FRR8 - MAthematical procedures: Forward Real Radix-8 */
/*    Fourier transform */
/* Subroutine */ int hst_frr8__(int__, nn, br0, br1, br2, br3, br4, br5, br6, 
	br7, bi0, bi1, bi2, bi3, bi4, bi5, bi6, bi7, exponts, npts)
integer *int__, *nn;
real *br0, *br1, *br2, *br3, *br4, *br5, *br6, *br7, *bi0, *bi1, *bi2, *bi3, *
	bi4, *bi5, *bi6, *bi7, *exponts;
integer *npts;
{
    /* System generated locals */
    integer i__1, i__2, i__3, i__4, i__5, i__6, i__7, i__8, i__9, i__10, 
	    i__11, i__12, i__13, i__14, i__15, i__16, i__17, i__18, i__19, 
	    i__20, i__21, i__22, i__23, i__24, i__25, i__26, i__27, i__28, 
	    i__29, i__30;
    static integer equiv_14[15];

    /* Local variables */
    static real div22;
    static integer welm;
    static real sum22, itmp0, wdiv1, wdiv2, wdiv3, wdiv4, wdiv5, wdiv6, wdiv7,
	     rtmp0;
    static integer j, k;
    static real wsum1, wsum2, wsum3, wsum4, wsum5, wsum6, wsum7;
#define l (equiv_14)
    static integer jlast, jthet;
    static real c1, c2, c3, c4, c5, c6;
    static integer j0, j1, j2, j3, j4, j5, j6, j7, j8, j9, k0;
#define l1 (equiv_14 + 14)
#define l2 (equiv_14 + 13)
#define l3 (equiv_14 + 12)
#define l4 (equiv_14 + 11)
#define l5 (equiv_14 + 10)
#define l6 (equiv_14 + 9)
#define l7 (equiv_14 + 8)
#define l8 (equiv_14 + 7)
#define l9 (equiv_14 + 6)
    static real c7, p7, s1, s2, s3, s4, s5, s6, s7, t0, t1, t2, t3, t4, t5, 
	    t6, t7, c22;
    static integer j10, j11, j12, j13, j14;
#define l10 (equiv_14 + 5)
#define l11 (equiv_14 + 4)
#define l12 (equiv_14 + 3)
    static integer ji;
#define l13 (equiv_14 + 2)
#define l14 (equiv_14 + 1)
    static integer jl, kl;
#define l15 (equiv_14)
    static real pi, s22;
    static integer jr;
    static real pr;
    static integer nptdnn;
    static real ti0;
    static integer th2;
    static real ti1, ti2, ti3, ti4, ti5, ti6, ti7, tr0, tr1, tr2, tr3, tr4, 
	    tr5, tr6, tr7;
    static integer int8;

/*  Description: */
/*    This subroutine is adapted from R8TR a subroutine written by */
/*    Bergland to calculate one iteration of a radix-8 transform of real */
/*    input data. Berglands original subroutine may be found in IEEE */
/*    Transactions on Audio and Electroacoustic, Vol. Au-17, pp.138-144. */
/*  Keywords: */
/*    Fourier~Transform.Fast.Radix-8~Forward~Real, */
/*    FFT.Radix-8~Forward~Real */
/*  Method: */
/*    See FAST FOURIER ANALYSIS:  RADIX 8 METHOD */
/*    SEE BERGLAND IN IEEE TRANS. AUDIO & ELECTROACOUSTICS */
/*    VOL. AU-17, NO. 2, PP138-144 */
/*    R8TR has been adapted to use twiddle factors obtained from a work */
/*    array and the complex arithmetic has been altered to be more */
/*    efficient. */
/*  Usage: */
/*    Private */
/*  Deficiencies: */
/*    This subroutine should only be used from MA_FFA8 and is not */
/*    otherwise for general use */
/*  Bugs: */
/*  Authors: */
/*    Bergland : See BERGLAND IN IEEE TRANS. AUDIO & ELECTROACOUSTICS */
/*    VOL. AU-17, NO. 2, PP138-144 */
/*    A P Hammersley (hammersley@esrf.fr) */
/*  History: */
/*    16-Jun-1992: V0.1 Original, based on MA_FRR8 (HAMMERSLEY), */
/*    based on R8TR (BERGLAND) */
/*    03-Feb-1999: V0.2 Simplify code, by removing line numbers and */
/*    replacing 'Continue' statements with 'End Do' statements where */
/*    possible (HAMMERSLEY) */
/*    08-Apr-2002: V0.3 Replace old style DO statements with statement numbers by */
/*    the 'DO - END DO' construct (problems with Absoft F95 compiler) (WILCKE) */
/*  Type Definitions: */
/* ...Translated by Pacific-Sierra Research vf90 Personal 3.4N5 11:36:22 7/11/02 */
/* ...Switches: */
/*  Global Constants: */
/*      Include 'st_symbols.inc' */
/*  Import: */
/*  Import/Export: */
/*  Status: */
/*  Local Constants: */
/* Version number for */
/*      subroutine */
/*  Local Variables: */
/*    Integer ks */
/*  Local Arrays: */
/*    Equivalences: */
/* For indexing into butterfly elements */
    /* Parameter adjustments */
    --bi7;
    --bi6;
    --bi5;
    --bi4;
    --bi3;
    --bi2;
    --bi1;
    --bi0;
    --br7;
    --br6;
    --br5;
    --br4;
    --br3;
    --br2;
    --br1;
    --br0;

    /* Function Body */
    l[0] = *nn / 8;
    for (k = 2; k <= 15; ++k) {
	if (l[k - 2] < 2) {
	    l[k - 2] = 2;
	    l[k - 1] = 2;
	} else if (l[k - 2] == 2) {
	    l[k - 1] = 2;
	} else {
	    l[k - 1] = l[k - 2] / 2;
	}
    }
    nptdnn = *npts / *nn;
    p7 = (float).7071067812;
    c22 = (float).9238795325;
    s22 = (float).3826834324;
    sum22 = c22 + s22;
    div22 = s22 - c22;
    ji = 3;
    jl = 2;
    jr = 2;
    i__1 = *l1;
    for (j1 = 2; j1 <= i__1; j1 += 2) {
	i__2 = *l2;
	i__3 = *l1;
	for (j2 = j1; i__3 < 0 ? j2 >= i__2 : j2 <= i__2; j2 += i__3) {
	    i__4 = *l3;
	    i__5 = *l2;
	    for (j3 = j2; i__5 < 0 ? j3 >= i__4 : j3 <= i__4; j3 += i__5) {
		i__6 = *l4;
		i__7 = *l3;
		for (j4 = j3; i__7 < 0 ? j4 >= i__6 : j4 <= i__6; j4 += i__7) 
			{
		    i__8 = *l5;
		    i__9 = *l4;
		    for (j5 = j4; i__9 < 0 ? j5 >= i__8 : j5 <= i__8; j5 += 
			    i__9) {
			i__10 = *l6;
			i__11 = *l5;
			for (j6 = j5; i__11 < 0 ? j6 >= i__10 : j6 <= i__10; 
				j6 += i__11) {
			    i__12 = *l7;
			    i__13 = *l6;
			    for (j7 = j6; i__13 < 0 ? j7 >= i__12 : j7 <= 
				    i__12; j7 += i__13) {
				i__14 = *l8;
				i__15 = *l7;
				for (j8 = j7; i__15 < 0 ? j8 >= i__14 : j8 <= 
					i__14; j8 += i__15) {
				    i__16 = *l9;
				    i__17 = *l8;
				    for (j9 = j8; i__17 < 0 ? j9 >= i__16 : 
					    j9 <= i__16; j9 += i__17) {
					i__18 = *l10;
					i__19 = *l9;
					for (j10 = j9; i__19 < 0 ? j10 >= 
						i__18 : j10 <= i__18; j10 += 
						i__19) {
					    i__20 = *l11;
					    i__21 = *l10;
					    for (j11 = j10; i__21 < 0 ? j11 >=
						     i__20 : j11 <= i__20; 
						    j11 += i__21) {
			  i__22 = *l12;
			  i__23 = *l11;
			  for (j12 = j11; i__23 < 0 ? j12 >= i__22 : j12 <= 
				  i__22; j12 += i__23) {
			      i__24 = *l13;
			      i__25 = *l12;
			      for (j13 = j12; i__25 < 0 ? j13 >= i__24 : j13 
				      <= i__24; j13 += i__25) {
				  i__26 = *l14;
				  i__27 = *l13;
				  for (j14 = j13; i__27 < 0 ? j14 >= i__26 : 
					  j14 <= i__26; j14 += i__27) {
				      i__28 = *l15;
				      i__29 = *l14;
				      for (jthet = j14; i__29 < 0 ? jthet >= 
					      i__28 : jthet <= i__28; jthet +=
					       i__29) {
					  th2 = jthet - 2;
					  if (th2 <= 0) {
/* L71: */
			i__30 = *int__;
			for (k = 1; k <= i__30; ++k) {
			    t0 = br0[k] + br4[k];
			    t1 = br1[k] + br5[k];
			    t2 = br2[k] + br6[k];
			    t3 = br3[k] + br7[k];
			    t4 = br0[k] - br4[k];
			    t5 = br1[k] - br5[k];
			    t6 = br2[k] - br6[k];
			    t7 = br3[k] - br7[k];
			    br2[k] = t0 - t2;
			    br3[k] = t1 - t3;
			    t0 += t2;
			    t1 += t3;
			    br0[k] = t0 + t1;
			    br1[k] = t0 - t1;
			    pr = p7 * (t5 - t7);
			    pi = p7 * (t5 + t7);
			    br4[k] = t4 + pr;
			    br7[k] = t6 + pi;
			    br6[k] = t4 - pr;
			    br5[k] = pi - t6;
			}
			if (*nn - 8 <= 0) {
			    goto L70;
			}
/* L73: */
			k0 = (*int__ << 3) + 1;
			kl = k0 + *int__ - 1;
			i__30 = kl;
			for (k = k0; k <= i__30; ++k) {
			    pr = p7 * (bi2[k] - bi6[k]);
			    pi = p7 * (bi2[k] + bi6[k]);
			    tr0 = bi0[k] + pr;
			    ti0 = bi4[k] + pi;
			    tr2 = bi0[k] - pr;
			    ti2 = bi4[k] - pi;
			    pr = p7 * (bi3[k] - bi7[k]);
			    pi = p7 * (bi3[k] + bi7[k]);
			    tr1 = bi1[k] + pr;
			    ti1 = bi5[k] + pi;
			    tr3 = bi1[k] - pr;
			    ti3 = bi5[k] - pi;
			    pi = c22 * (tr1 + ti1);
			    pr = pi - ti1 * sum22;
			    pi += tr1 * div22;
			    bi0[k] = tr0 + pr;
			    bi6[k] = tr0 - pr;
			    bi7[k] = pi + ti0;
			    bi1[k] = pi - ti0;
			    pr = c22 * (tr3 + ti3);
			    pi = pr - ti3 * sum22;
			    pr = -(pr + tr3 * div22);
			    bi2[k] = tr2 + pr;
			    bi4[k] = tr2 - pr;
			    bi5[k] = ti2 + pi;
			    bi3[k] = pi - ti2;
			}
			goto L70;
					  }
					  th2 *= nptdnn;
					  c1 = exponts[th2];
					  s1 = exponts[th2 + 1];
					  wsum1 = c1 + s1;
					  wdiv1 = s1 - c1;
					  welm = th2 + th2;
					  c2 = exponts[welm];
					  s2 = exponts[welm + 1];
					  wsum2 = c2 + s2;
					  wdiv2 = s2 - c2;
					  welm += th2;
					  c3 = exponts[welm];
					  s3 = exponts[welm + 1];
					  wsum3 = c3 + s3;
					  wdiv3 = s3 - c3;
					  welm += th2;
					  c4 = exponts[welm];
					  s4 = exponts[welm + 1];
					  wsum4 = c4 + s4;
					  wdiv4 = s4 - c4;
					  welm += th2;
					  c5 = exponts[welm];
					  s5 = exponts[welm + 1];
					  wsum5 = c5 + s5;
					  wdiv5 = s5 - c5;
					  welm += th2;
					  c6 = exponts[welm];
					  s6 = exponts[welm + 1];
					  wsum6 = c6 + s6;
					  wdiv6 = s6 - c6;
					  welm += th2;
					  c7 = exponts[welm];
					  s7 = exponts[welm + 1];
					  wsum7 = c7 + s7;
					  wdiv7 = s7 - c7;
					  int8 = *int__ << 3;
					  j0 = jr * int8 + 1;
					  k0 = ji * int8 + 1;
					  jlast = j0 + *int__ - 1;
					  i__30 = jlast;
					  for (j = j0; j <= i__30; ++j) {
			k = k0 + j - j0;
			rtmp0 = br1[j];
			itmp0 = bi1[k];
			ti1 = c1 * (rtmp0 + itmp0);
			tr1 = ti1 - itmp0 * wsum1;
			ti1 += rtmp0 * wdiv1;
			rtmp0 = br2[j];
			itmp0 = bi2[k];
			ti2 = c2 * (rtmp0 + itmp0);
			tr2 = ti2 - itmp0 * wsum2;
			ti2 += rtmp0 * wdiv2;
			rtmp0 = br3[j];
			itmp0 = bi3[k];
			ti3 = c3 * (rtmp0 + itmp0);
			tr3 = ti3 - itmp0 * wsum3;
			ti3 += rtmp0 * wdiv3;
			rtmp0 = br4[j];
			itmp0 = bi4[k];
			ti4 = c4 * (rtmp0 + itmp0);
			tr4 = ti4 - itmp0 * wsum4;
			ti4 += rtmp0 * wdiv4;
			rtmp0 = br5[j];
			itmp0 = bi5[k];
			ti5 = c5 * (rtmp0 + itmp0);
			tr5 = ti5 - itmp0 * wsum5;
			ti5 += rtmp0 * wdiv5;
			rtmp0 = br6[j];
			itmp0 = bi6[k];
			ti6 = c6 * (rtmp0 + itmp0);
			tr6 = ti6 - itmp0 * wsum6;
			ti6 += rtmp0 * wdiv6;
			rtmp0 = br7[j];
			itmp0 = bi7[k];
			ti7 = c7 * (rtmp0 + itmp0);
			tr7 = ti7 - itmp0 * wsum7;
			ti7 += rtmp0 * wdiv7;
			t0 = br0[j] + tr4;
			t1 = bi0[k] + ti4;
			tr4 = br0[j] - tr4;
			ti4 = bi0[k] - ti4;
			t2 = tr1 + tr5;
			t3 = ti1 + ti5;
			tr5 = tr1 - tr5;
			ti5 = ti1 - ti5;
			t4 = tr2 + tr6;
			t5 = ti2 + ti6;
			tr6 = tr2 - tr6;
			ti6 = ti2 - ti6;
			t6 = tr3 + tr7;
			t7 = ti3 + ti7;
			tr7 = tr3 - tr7;
			ti7 = ti3 - ti7;
			tr0 = t0 + t4;
			ti0 = t1 + t5;
			tr2 = t0 - t4;
			ti2 = t1 - t5;
			tr1 = t2 + t6;
			ti1 = t3 + t7;
			tr3 = t2 - t6;
			ti3 = t3 - t7;
			t0 = tr4 - ti6;
			t1 = ti4 + tr6;
			t4 = tr4 + ti6;
			t5 = ti4 - tr6;
			t2 = tr5 - ti7;
			t3 = ti5 + tr7;
			t6 = tr5 + ti7;
			t7 = ti5 - tr7;
			br0[j] = tr0 + tr1;
			bi7[k] = ti0 + ti1;
			bi6[k] = tr0 - tr1;
			br1[j] = ti1 - ti0;
			br2[j] = tr2 - ti3;
			bi5[k] = ti2 + tr3;
			bi4[k] = tr2 + ti3;
			br3[j] = tr3 - ti2;
			pr = p7 * (t2 - t3);
			pi = p7 * (t2 + t3);
			br4[j] = t0 + pr;
			bi3[k] = t1 + pi;
			bi2[k] = t0 - pr;
			br5[j] = pi - t1;
			pr = -p7 * (t6 + t7);
			pi = p7 * (t6 - t7);
			br6[j] = t4 + pr;
			bi1[k] = t5 + pi;
			bi0[k] = t4 - pr;
			br7[j] = pi - t5;
					  }
					  jr += 2;
					  ji += -2;
					  if (ji <= jl) {
			ji = jr + jr - 1;
			jl = jr;
					  }
L70:
					  ;
				      }
				  }
			      }
			  }
					    }
					}
				    }
				}
			    }
			}
		    }
		}
	    }
	}
    }
/*     End of Subroutine HST_FRR8 */
} /* hst_frr8__ */

#undef l15
#undef l14
#undef l13
#undef l12
#undef l11
#undef l10
#undef l9
#undef l8
#undef l7
#undef l6
#undef l5
#undef l4
#undef l3
#undef l2
#undef l1
#undef l


/* ********1*********2*********3*********4*********5*********6*********7** */
/* ********1*********2*********3*********4*********5*********6*********7** */
/*  ***************** */
/*  *               * */
/*  *   hst_ffs8.f  * */
/*  *               * */
/*  ***************** */
/* + HST_FFS8 - (MAthematical procedures) Fast Fourier Synthesis: */
/*    radix 8 */
/* Subroutine */ int hst_ffs8__(maxdat, numdat, maxexpnt, exponts, sort, data,
	 status)
integer *maxdat, *numdat, *maxexpnt;
real *exponts;
logical *sort;
real *data;
integer *status;
{
    /* System generated locals */
    integer i__1;
    real r__1;

    /* Builtin functions */
    double log();
    integer i_nint(), pow_ii();

    /* Local variables */
    extern /* Subroutine */ int hst_ord1__(), hst_ord2__(), hst_ihr8__(), 
	    hst_r2tr__();
    static integer interval, eightpwr, stage;
    extern /* Subroutine */ int hst_r4syn__();
    static integer nn, length, twopwr, elm1, elm2, elm3, elm4, elm5, elm6, 
	    elm7;

/*  Description: */
/*    Perform reverse fast Fourier transform on Hermitian data of a */
/*    power of two in length */

/*    (Note: This doesn't seem to perform any normalisation.) */
/*  Keywords: */
/*    Fourier~Transform.Fast.Hermitian~Reverse, FFT.Hermitian~Reverse */
/*  Method: */
/*    FAST FOURIER ANALYSIS:  RADIX 8 METHOD */
/*    SEE BERGLAND IN IEEE TRANS. AUDIO & ELECTROACOUSTICS */
/*    VOL. AU-17, NO. 2, PP138-144 */
/*    Adapted to use precalculated twiddle factors */
/*  Usage: */
/*    General */
/*  Deficiencies: */
/*  Bugs: */
/*  Authors: */
/*    Bergland : See BERGLAND IN IEEE TRANS. AUDIO & ELECTROACOUSTICS */
/*    VOL. AU-17, NO. 2, PP138-144 */
/*    A P Hammersley (hammersley@esrf.fr) */
/*  History: */
/*    16-Jun-1992: V0.1 Original, based on MA_FFS8 (HAMMERSLEY), */
/*    based on FFS8 (BERGLAND) */
/*    04-Feb-1999: V0.2 Changes to argument list of 'HST_ORD2' */
/*    (HAMMERSLEY) */
/*  Type Definitions: */
/* ...Translated by Pacific-Sierra Research vf90 Personal 3.4N5 11:36:22 7/11/02 */
/* ...Switches: */
/*  Global Constants: */
/*      Include 'st_symbols.inc' */
/*  Import: */
/* Dimension of array 'DATA' */
/* Number of real data points to transform */
/*      array, must */
/*    be at least twice 'numdat' */
/* Dimension size of twiddle factor */
/*      exponential */
/*    multiplying factors ("twiddle factors"). This must contain */
/*    'numdat' complex factors, i.e. numdat*2 elements */
/* Array containing complex */
/*      normal */
/*    frequency order. Otherwise it must be entered in bit reversed */
/*    order */
/*  Import/Export: */
/* .True. if the transform is entered in */
/*      complex */
/*    Fourier components of the Fourier transform stored in the */
/*    following fashion. DATA(1) is the DC level, DATA(2) is the */
/*    high frequency term, DATA(odd index>1) imaginary term, */
/*    DATA(even index>2) real term. */
/*    On export contains a real series in all elements. */
/*  Status: */
/* Import: Half of the Hermitian */
/*  Local Constants: */
/* Status return variable */
/* Version number for */
/*      subroutine */
/*  Local Variables: */
/*    equal to the data length */
/* The maximum power of eight that is less or */
/* Array element index variable */
/* Array element index variable */
/* Array element index variable */
/* Array element index variable */
/* Array element index variable */
/* Array element index variable */
/* Array element index variable */
/* Interval in array elements */
/* 2**twopwr */
/* number of array elements */
/* The stage of the radix eight transforms */
/* --------1---------2---------3---------4---------5---------6---------7-- */
/*  Check status */
/*     If (status .Ne. St_goodvalue) Then */
/*        Call ST_SAVE ('Subroutine HST_FFS8 ' // Version) */
/*        Return */
/*     End If */
/*  Check that the region to be added to is reasonably defined */
/* The data length expressed as a power of two */
    /* Parameter adjustments */
    --data;
    --exponts;

    /* Function Body */
    if (*maxdat <= 0 || *maxexpnt <= 1) {
	*status = -1;
/* St_bad_dim1 */
    } else if (*numdat > *maxdat) {
	*status = -2;
/* St_bad_adr1 */
    } else if (*numdat << 1 > *maxexpnt) {
	*status = -3;
/* St_bad_rel1 */
    } else {
	r__1 = log((real) (*numdat)) / log((float)2.);
	twopwr = i_nint(&r__1);
	length = pow_ii(&c__2, &twopwr);
	if (length != *numdat) {
	    *status = -7;
	}
/* St_bad_2power1 */
    }
/*  Re-check status */
/*     If (status .Ne. St_goodvalue) Then */
/*        status = St_mod_ma + status */
/*        Call ST_SAVE ('Subroutine HST_FFS8 ' // Version) */
/*        Return */
/*     End If */
/* - - - -1- - - - -2- - - - -3- - - - -4- - - - -5- - - - -6- - - - -7-- */
/*  Arguments would appear to be reasonable, go ahead. */
    eightpwr = twopwr / 3;
    if (*sort) {
	hst_ord2__(numdat, &length, &twopwr, &data[1]);
    }
    hst_ord1__(&length, &data[1]);
/*  Perform radix 8 iterations */
    if (eightpwr > 0) {
	nn = length << 3;
	i__1 = eightpwr;
	for (stage = 1; stage <= i__1; ++stage) {
	    nn /= 8;
	    interval = length / nn;
	    elm1 = interval + 1;
	    elm2 = elm1 + interval;
	    elm3 = elm2 + interval;
	    elm4 = elm3 + interval;
	    elm5 = elm4 + interval;
	    elm6 = elm5 + interval;
	    elm7 = elm6 + interval;
	    hst_ihr8__(&interval, &nn, &data[1], &data[elm1], &data[elm2], &
		    data[elm3], &data[elm4], &data[elm5], &data[elm6], &data[
		    elm7], &data[1], &data[elm1], &data[elm2], &data[elm3], &
		    data[elm4], &data[elm5], &data[elm6], &data[elm7], &
		    exponts[1], numdat);
	}
    }
/*  Do a radix 2 or radix 4 iteration if one is required. */
    if (twopwr - eightpwr * 3 == 2) {
	interval = length / 4;
	elm1 = interval + 1;
	elm2 = elm1 + interval;
	elm3 = elm2 + interval;
	hst_r4syn__(&interval, &data[1], &data[elm1], &data[elm2], &data[elm3]
		);
    } else if (twopwr - eightpwr * 3 == 1) {
	interval = length / 2;
	hst_r2tr__(&interval, &data[1], &data[interval + 1]);
    }
/*  End of Subroutine HST_FFS8 */
} /* hst_ffs8__ */

/* ********1*********2*********3*********4*********5*********6*********7** */
/* ********1*********2*********3*********4*********5*********6*********7** */
/*  **************** */
/*  *              * */
/*  *  hst_ihr8.f  * */
/*  *              * */
/*  **************** */
/* + HST_IHR8 - Inverse Hermitian Radix-8 Fourier transform */
/* Subroutine */ int hst_ihr8__(int__, nn, br0, br1, br2, br3, br4, br5, br6, 
	br7, bi0, bi1, bi2, bi3, bi4, bi5, bi6, bi7, exponts, npts)
integer *int__, *nn;
real *br0, *br1, *br2, *br3, *br4, *br5, *br6, *br7, *bi0, *bi1, *bi2, *bi3, *
	bi4, *bi5, *bi6, *bi7, *exponts;
integer *npts;
{
    /* System generated locals */
    integer i__1, i__2, i__3, i__4, i__5, i__6, i__7, i__8, i__9, i__10, 
	    i__11, i__12, i__13, i__14, i__15, i__16, i__17, i__18, i__19, 
	    i__20, i__21, i__22, i__23, i__24, i__25, i__26, i__27, i__28, 
	    i__29, i__30;
    static integer equiv_14[15];

    /* Local variables */
    static real ttr7, div22;
    static integer welm;
    static real temp, sum22, itmp0, wdiv1, wdiv2, wdiv3, wdiv4, wdiv5, wdiv6, 
	    wdiv7, rtmp0;
    static integer j, k;
    static real wsum1, wsum2, wsum3, wsum4, p7two, wsum5, wsum6, wsum7;
#define l (equiv_14)
    static integer jlast, jthet;
    static real c1, c2, c3, c4, c5, c6;
    static integer j0, j1, j2, j3, j4, j5, j6, j7, j8, j9, k0;
#define l1 (equiv_14 + 14)
#define l2 (equiv_14 + 13)
#define l3 (equiv_14 + 12)
#define l4 (equiv_14 + 11)
#define l5 (equiv_14 + 10)
#define l6 (equiv_14 + 9)
#define l7 (equiv_14 + 8)
#define l8 (equiv_14 + 7)
#define l9 (equiv_14 + 6)
    static real c7, p7, s1, s2, s3, s4, s5, s6, s7, t0, t1, t2, t3, t4, t5, 
	    t6, t7, t8, c22;
    static integer j10, j11, j12, j13, j14;
#define l10 (equiv_14 + 5)
#define l11 (equiv_14 + 4)
#define l12 (equiv_14 + 3)
    static integer ji;
#define l13 (equiv_14 + 2)
#define l14 (equiv_14 + 1)
    static integer jl, kl;
#define l15 (equiv_14)
    static real pi, s22, ri;
    static integer jr;
    static real pr, rr;
    static integer nptdnn;
    static real ti0;
    static integer th2;
    static real ti1, ti2, ti3, ti4, ti5, ti6, ti7, tr0, tr1, tr2, tr3, tr4, 
	    tr5, tr6, tr7, tt0, tt1;
    static integer int8;
    static real ttr6;

/*  Description: */
/*    Performs one iteration of a radix-8 inverse transform of Hermitian */
/*    input data. */
/*  Keywords: */
/*    Fourier~Transform.Fast.Radix-8~Inverse~Hermitian, */
/*    FFT.Radix-8~Inverse~Hermitian */
/*  Method: */
/*    See FAST FOURIER ANALYSIS:  RADIX 8 METHOD */
/*    SEE BERGLAND IN IEEE TRANS. AUDIO & ELECTROACOUSTICS */
/*    VOL. AU-17, NO. 2, PP138-144 */
/*    Has been adapted to use twiddle factors obtained from a work */
/*    array and the complex arithmetic has been altered to be more */
/*    efficient. */
/*  Usage: */
/*    Private */
/*  Deficiencies: */
/*    This subroutine should only be used from HST_FFS8 and is not */
/*    otherwise for general use */
/*  Bugs: */
/*  Authors: */
/*    Bergland : See BERGLAND IN IEEE TRANS. AUDIO & ELECTROACOUSTICS */
/*    VOL. AU-17, NO. 2, PP138-144 */
/*    A P Hammersley (hammersley@esrf.fr) */
/*  History: */
/*    18-Jul-1986: V0.1 (Based on DR8SYN.FOR - based on R8SYN.FOR) */
/*    (HAMMERSLEY), */
/*    03-Feb-1999: V0.2 Simplify code, by removing line numbers and */
/*    replacing 'Continue' statements with 'End Do' statements where */
/*    possible (HAMMERSLEY) */
/*    08-Apr-2002: V0.3 Replace old style DO statements with statement numbers by */
/*    the 'DO - END DO' construct (problems with Absoft F95 compiler) (WILCKE) */
/*  Type Definitions: */
/* ...Translated by Pacific-Sierra Research vf90 Personal 3.4N5 11:36:22 7/11/02 */
/* ...Switches: */
/*  Global Constants: */
/*      Include 'st_symbols.inc' */
/*  Import: */
/*  Import/Export: */
/*  Status: */
/*  Local Constants: */
/* Version number for */
/*      subroutine */
/*  Local Variables: */
/*    Integer ks */
/*  Local Arrays: */
/*    Equivalences: */
/* For indexing into butterfly elements */
    /* Parameter adjustments */
    --bi7;
    --bi6;
    --bi5;
    --bi4;
    --bi3;
    --bi2;
    --bi1;
    --bi0;
    --br7;
    --br6;
    --br5;
    --br4;
    --br3;
    --br2;
    --br1;
    --br0;

    /* Function Body */
    l[0] = *nn / 8;
    for (k = 2; k <= 15; ++k) {
	if (l[k - 2] < 2) {
	    l[k - 2] = 2;
	    l[k - 1] = 2;
	} else if (l[k - 2] == 2) {
	    l[k - 1] = 2;
	} else {
	    l[k - 1] = l[k - 2] / 2;
	}
    }
    nptdnn = *npts / *nn;
    p7 = (float).7071067812;
    p7two = (float)1.4142135624;
    c22 = (float).9238795325;
    s22 = (float).3826834324;
    sum22 = c22 + s22;
    div22 = s22 - c22;
    ji = 3;
    jl = 2;
    jr = 2;
    i__1 = *l1;
    for (j1 = 2; j1 <= i__1; j1 += 2) {
	i__2 = *l2;
	i__3 = *l1;
	for (j2 = j1; i__3 < 0 ? j2 >= i__2 : j2 <= i__2; j2 += i__3) {
	    i__4 = *l3;
	    i__5 = *l2;
	    for (j3 = j2; i__5 < 0 ? j3 >= i__4 : j3 <= i__4; j3 += i__5) {
		i__6 = *l4;
		i__7 = *l3;
		for (j4 = j3; i__7 < 0 ? j4 >= i__6 : j4 <= i__6; j4 += i__7) 
			{
		    i__8 = *l5;
		    i__9 = *l4;
		    for (j5 = j4; i__9 < 0 ? j5 >= i__8 : j5 <= i__8; j5 += 
			    i__9) {
			i__10 = *l6;
			i__11 = *l5;
			for (j6 = j5; i__11 < 0 ? j6 >= i__10 : j6 <= i__10; 
				j6 += i__11) {
			    i__12 = *l7;
			    i__13 = *l6;
			    for (j7 = j6; i__13 < 0 ? j7 >= i__12 : j7 <= 
				    i__12; j7 += i__13) {
				i__14 = *l8;
				i__15 = *l7;
				for (j8 = j7; i__15 < 0 ? j8 >= i__14 : j8 <= 
					i__14; j8 += i__15) {
				    i__16 = *l9;
				    i__17 = *l8;
				    for (j9 = j8; i__17 < 0 ? j9 >= i__16 : 
					    j9 <= i__16; j9 += i__17) {
					i__18 = *l10;
					i__19 = *l9;
					for (j10 = j9; i__19 < 0 ? j10 >= 
						i__18 : j10 <= i__18; j10 += 
						i__19) {
					    i__20 = *l11;
					    i__21 = *l10;
					    for (j11 = j10; i__21 < 0 ? j11 >=
						     i__20 : j11 <= i__20; 
						    j11 += i__21) {
			  i__22 = *l12;
			  i__23 = *l11;
			  for (j12 = j11; i__23 < 0 ? j12 >= i__22 : j12 <= 
				  i__22; j12 += i__23) {
			      i__24 = *l13;
			      i__25 = *l12;
			      for (j13 = j12; i__25 < 0 ? j13 >= i__24 : j13 
				      <= i__24; j13 += i__25) {
				  i__26 = *l14;
				  i__27 = *l13;
				  for (j14 = j13; i__27 < 0 ? j14 >= i__26 : 
					  j14 <= i__26; j14 += i__27) {
				      i__28 = *l15;
				      i__29 = *l14;
				      for (jthet = j14; i__29 < 0 ? jthet >= 
					      i__28 : jthet <= i__28; jthet +=
					       i__29) {
					  th2 = jthet - 2;
					  if (th2 <= 0) {
/* L71: */
			i__30 = *int__;
			for (k = 1; k <= i__30; ++k) {
			    t0 = br0[k] + br1[k];
			    t1 = br0[k] - br1[k];
			    t2 = br2[k] + br2[k];
			    t3 = br3[k] + br3[k];
			    t4 = br4[k] + br6[k];
			    t6 = br7[k] - br5[k];
			    t5 = br4[k] - br6[k];
			    t7 = br7[k] + br5[k];
			    pr = p7 * (t7 + t5);
			    pi = p7 * (t7 - t5);
			    tt0 = t0 + t2;
			    tt1 = t1 + t3;
			    t2 = t0 - t2;
			    t3 = t1 - t3;
			    t4 += t4;
			    t5 = pr + pr;
			    t6 += t6;
			    t7 = pi + pi;
			    br0[k] = tt0 + t4;
			    br1[k] = tt1 + t5;
			    br2[k] = t2 + t6;
			    br3[k] = t3 + t7;
			    br4[k] = tt0 - t4;
			    br5[k] = tt1 - t5;
			    br6[k] = t2 - t6;
			    br7[k] = t3 - t7;
			}
			if (*nn - 8 <= 0) {
			    goto L70;
			}
/* L73: */
			k0 = (*int__ << 3) + 1;
			kl = k0 + *int__ - 1;
			i__30 = kl;
			for (k = k0; k <= i__30; ++k) {
			    t1 = bi0[k] + bi6[k];
			    t2 = bi7[k] - bi1[k];
			    t3 = bi0[k] - bi6[k];
			    t4 = bi7[k] + bi1[k];
			    pr = c22 * (t3 + t4);
			    pi = pr - t3 * sum22;
			    pr += t4 * div22;
			    t5 = bi2[k] + bi4[k];
			    t6 = bi5[k] - bi3[k];
			    t7 = bi2[k] - bi4[k];
			    t8 = bi5[k] + bi3[k];
			    ri = c22 * (t7 + t8);
			    rr = ri - t7 * sum22;
			    ri = -(ri + t8 * div22);
			    bi0[k] = t1 + t5 + (t1 + t5);
			    bi4[k] = t2 + t6 + (t2 + t6);
			    bi1[k] = pr + rr + (pr + rr);
			    bi5[k] = pi + ri + (pi + ri);
			    t5 = t1 - t5;
			    t6 = t2 - t6;
			    bi2[k] = p7two * (t6 + t5);
			    bi6[k] = p7two * (t6 - t5);
			    rr = pr - rr;
			    ri = pi - ri;
			    bi3[k] = p7two * (ri + rr);
			    bi7[k] = p7two * (ri - rr);
			}
			goto L70;
					  }
					  th2 *= nptdnn;
					  c1 = exponts[th2];
					  s1 = -exponts[th2 + 1];
					  wsum1 = c1 + s1;
					  wdiv1 = s1 - c1;
					  welm = th2 + th2;
					  c2 = exponts[welm];
					  s2 = -exponts[welm + 1];
					  wsum2 = c2 + s2;
					  wdiv2 = s2 - c2;
					  welm += th2;
					  c3 = exponts[welm];
					  s3 = -exponts[welm + 1];
					  wsum3 = c3 + s3;
					  wdiv3 = s3 - c3;
					  welm += th2;
					  c4 = exponts[welm];
					  s4 = -exponts[welm + 1];
					  wsum4 = c4 + s4;
					  wdiv4 = s4 - c4;
					  welm += th2;
					  c5 = exponts[welm];
					  s5 = -exponts[welm + 1];
					  wsum5 = c5 + s5;
					  wdiv5 = s5 - c5;
					  welm += th2;
					  c6 = exponts[welm];
					  s6 = -exponts[welm + 1];
					  wsum6 = c6 + s6;
					  wdiv6 = s6 - c6;
					  welm += th2;
					  c7 = exponts[welm];
					  s7 = -exponts[welm + 1];
					  wsum7 = c7 + s7;
					  wdiv7 = s7 - c7;
					  int8 = *int__ << 3;
					  j0 = jr * int8 + 1;
					  k0 = ji * int8 + 1;
					  jlast = j0 + *int__ - 1;
					  i__30 = jlast;
					  for (j = j0; j <= i__30; ++j) {
/*        KS=K0+J-J0 */
/*        Do K=KS,KS */
			k = k0 + j - j0;
			tr0 = br0[j] + bi6[k];
			ti0 = bi7[k] - br1[j];
			tr1 = br0[j] - bi6[k];
			ti1 = bi7[k] + br1[j];
			tr2 = br2[j] + bi4[k];
			ti2 = bi5[k] - br3[j];
			tr3 = bi5[k] + br3[j];
			ti3 = bi4[k] - br2[j];
			tr4 = br4[j] + bi2[k];
			ti4 = bi3[k] - br5[j];
			t0 = br4[j] - bi2[k];
			t1 = bi3[k] + br5[j];
			tr5 = p7 * (t0 + t1);
			ti5 = p7 * (t1 - t0);
			tr6 = br6[j] + bi0[k];
			ti6 = bi1[k] - br7[j];
			t0 = br6[j] - bi0[k];
			t1 = bi1[k] + br7[j];
			tr7 = -p7 * (t0 - t1);
			ti7 = -p7 * (t1 + t0);
			t0 = tr0 + tr2;
			t1 = ti0 + ti2;
			t2 = tr1 + tr3;
			t3 = ti1 + ti3;
			tr2 = tr0 - tr2;
			ti2 = ti0 - ti2;
			tr3 = tr1 - tr3;
			ti3 = ti1 - ti3;
			t4 = tr4 + tr6;
			t5 = ti4 + ti6;
			t6 = tr5 + tr7;
			t7 = ti5 + ti7;
			ttr6 = ti4 - ti6;
			ti6 = tr6 - tr4;
			ttr7 = ti5 - ti7;
			ti7 = tr7 - tr5;
			br0[j] = t0 + t4;
			bi0[k] = t1 + t5;
			rtmp0 = t2 + t6;
			itmp0 = t3 + t7;
			temp = c1 * (rtmp0 + itmp0);
			br1[j] = temp - itmp0 * wsum1;
			bi1[k] = temp + rtmp0 * wdiv1;
			rtmp0 = tr2 + ttr6;
			itmp0 = ti2 + ti6;
			temp = c2 * (rtmp0 + itmp0);
			br2[j] = temp - itmp0 * wsum2;
			bi2[k] = temp + rtmp0 * wdiv2;
			rtmp0 = tr3 + ttr7;
			itmp0 = ti3 + ti7;
			temp = c3 * (rtmp0 + itmp0);
			br3[j] = temp - itmp0 * wsum3;
			bi3[k] = temp + rtmp0 * wdiv3;
			rtmp0 = t0 - t4;
			itmp0 = t1 - t5;
			temp = c4 * (rtmp0 + itmp0);
			br4[j] = temp - itmp0 * wsum4;
			bi4[k] = temp + rtmp0 * wdiv4;
			rtmp0 = t2 - t6;
			itmp0 = t3 - t7;
			temp = c5 * (rtmp0 + itmp0);
			br5[j] = temp - itmp0 * wsum5;
			bi5[k] = temp + rtmp0 * wdiv5;
			rtmp0 = tr2 - ttr6;
			itmp0 = ti2 - ti6;
			temp = c6 * (rtmp0 + itmp0);
			br6[j] = temp - itmp0 * wsum6;
			bi6[k] = temp + rtmp0 * wdiv6;
			rtmp0 = tr3 - ttr7;
			itmp0 = ti3 - ti7;
			temp = c7 * (rtmp0 + itmp0);
			br7[j] = temp - itmp0 * wsum7;
			bi7[k] = temp + rtmp0 * wdiv7;
/*        End Do */
					  }
					  jr += 2;
					  ji += -2;
					  if (ji - jl <= 0) {
/* L78: */
			ji = jr + jr - 1;
			jl = jr;
					  }
L70:
					  ;
				      }
				  }
			      }
			  }
					    }
					}
				    }
				}
			    }
			}
		    }
		}
	    }
	}
    }
/*     End of Subroutine HST_IHR8 */
} /* hst_ihr8__ */

#undef l15
#undef l14
#undef l13
#undef l12
#undef l11
#undef l10
#undef l9
#undef l8
#undef l7
#undef l6
#undef l5
#undef l4
#undef l3
#undef l2
#undef l1
#undef l


/* ********1*********2*********3*********4*********5*********6*********7** */
/* ********1*********2*********3*********4*********5*********6*********7** */
/*  ********************* */
/*  *                   * */
/*  *  hst_expnt.f  * */
/*  *                   * */
/*  ********************* */
/* + HST_EXPNT MAthematic procedures: EXPoNTials calculation */
/* Subroutine */ int hst_expnt__(maxdat, numdat, jump, twiddle, status)
integer *maxdat, *numdat, *jump;
real *twiddle;
integer *status;
{
    /* System generated locals */
    integer i__1, i__2, i__3;

    /* Builtin functions */
    double cos(), sin();

    /* Local variables */
    static real wint, wdif1, itmp1, rtmp1, wsum1;
    static integer num1d2, num1d4, group;
    static real itemp1, wr1;
    static integer elm;
    static real sum;
    static integer len2, num1;

/*  Description: */
/*    Calculates the complex exponentials (twiddle factors) */
/*    necessary for Fourier transform programs. 'numdat'/2 complex */
/*    twiddle factors are calculated. */
/*  Keywords: */
/*    Twiddle~Factors, Fourier~Coefficients, */
/*    Complex~Exponentials.Calculation */
/*  Method: */
/*    Calculates the initial complex exponential which is also the */
/*    multiplier to form the next complex expontial. Complex */
/*    multiplication is used to form successive expontials. To avoid */
/*    cumulation of round-off errors the complex exponentials are */
/*    recalculated by FORTRAN functions every 'jump' elements. */
/*    N.B. The complex multiplication is carried out by an */
/*    algorithm which involves three multiplications instead of four */
/*    per complex multiplication */
/*  Usage: */
/*    General */
/*  Deficiencies: */
/*  Bugs: */
/*  Authors: */
/*    A P Hammersley (hammersley@esrf.fr) */
/*  History: */
/*    16-Jun-1992: V0.1 Original, based on MA_EXPNT (HAMMERSLEY) */
/*  Type Definitions: */
/* ...Translated by Pacific-Sierra Research vf90 Personal 3.4N5 11:36:22 7/11/02 */
/* ...Switches: */
/*  Global Constants: */
/*      Include 'st_symbols.inc' */
/*  Import: */
/* Dimension of array 'TWIDDLE' */
/*      twiddle */
/*    factors are to be calculated. This is 'numdat'/2 complex */
/*    elements */
/* Number of elements over which the */
/*    exponentials. */
/*  Export: */
/* Gap between accurate calculation of the */
/*  Status: */
/* The complex twiddle factors */
/*  Local Constants: */
/* Status return variable */
/* Version number for */
/*      subroutine */
/*  Local Variables: */
/* Loop variable for elements */
/* Loop variable for groups */
/*    recalculating the twiddle factors using FORTRAN functions */
/* The length in array elements between */
/* Number of complex data elements */
/* Number of complex elements divided by two */
/* Number of complex elements divided by four */
/*    multiplication */
/* Temporary variable involved in complex */
/*    a complex variable */
/* Temporary variable used to store imaginary part of */
/*    a complex variable */
/* Temporary variable used to store real part of */
/*    variables */
/* Temporay variable used to store the sum of two */
/*    components of the multiplying constant between successive */
/*    twiddle factors */
/* The difference between the real and imaginary */
/*    factors */
/* The interval in radians for calculating the twiddle */
/*    successive twiddle factors */
/* The real value of the multiplying constant between */
/*    multiplying constant between successive twiddle factors */
/* --------1---------2---------3---------4---------5---------6---------7-- */
/*  Check status */
/*     If (status .Ne. St_goodvalue) Then */
/*        Call ST_SAVE ('Subroutine HST_EXPNT ' // Version) */
/*        Return */
/*     End If */
/*  Check that the region to be added to is reasonably defined */
/* The sum of the real and imaginary components of the */
    if (*maxdat <= 0) {
	*status = -11;
/* St_bad_dim1 */
    } else if (*numdat > *maxdat) {
	*status = -12;
/* St_bad_adr1 */
    } else if (*jump < 1) {
	*status = -13;
/* St_bad_int1 */
    }
/*  Recheck status */
/*     If (status .Ne. St_goodvalue) Then */
/*        status = status + St_mod_ma */
/*        Call ST_SAVE ('Subroutine HST_EXPNT ' // Version) */
/*     Else */
/* - - - -1- - - - -2- - - - -3- - - - -4- - - - -5- - - - -6- - - - -7-- */
/*     Arguments would appear to be reasonable, go ahead. */
/* **DEBUG***DEBUG***DEBUG***DEBUG***DEBUG***DEBUG***DEBUG***DEBUG***DEBUG */
/*     Write (*,'(1x,''Entered HST_EXPNT'')') */
/*     Write (*,'(1x,''maxdat = ''i8)') maxdat */
/*     Write (*,'(1x,''numdat = ''i8)') numdat */
/*     Write (*,'(1x,''jump = ''i8)') jump */
/*     Write (*,'(1x,''status = ''i12)') status */
/* **DEBUG***DEBUG***DEBUG***DEBUG***DEBUG***DEBUG***DEBUG***DEBUG***DEBUG */
/*     Create array of complex exponentials. */
    num1 = *numdat / 2;
    num1d2 = num1 / 2;
    num1d4 = num1d2 / 2;
    wint = (float)6.283185307179586 / (real) num1;
    twiddle[0] = (float)1.;
    twiddle[1] = (float)0.;
    wr1 = cos(wint);
    wdif1 = sin(wint);
    wsum1 = wr1 + wdif1;
    wdif1 -= wr1;
    i__1 = num1d4;
    i__2 = *jump;
    for (group = 1; i__2 < 0 ? group >= i__1 : group <= i__1; group += i__2) {
	if (group <= num1d4) {
	    len2 = group + group;
	    twiddle[len2] = cos(wint * group);
	    twiddle[len2 + 1] = sin(wint * group);
	    i__3 = *jump - 1;
	    for (elm = 1; elm <= i__3; ++elm) {
		len2 = group + elm;
		len2 += len2;
		if (len2 <= num1d2) {
		    rtmp1 = twiddle[len2 - 2];
		    itmp1 = twiddle[len2 - 1];
		    sum = rtmp1 + itmp1;
		    itemp1 = wr1 * sum;
		    twiddle[len2] = itemp1 - itmp1 * wsum1;
		    twiddle[len2 + 1] = itemp1 + rtmp1 * wdif1;
		}
	    }
	}
    }
    i__2 = num1 - 2;
    for (elm = num1d2 + 2; elm <= i__2; elm += 2) {
	twiddle[elm] = -twiddle[num1 - elm];
	twiddle[elm + 1] = twiddle[num1 - elm + 1];
    }
    i__2 = num1 - 1;
    for (elm = 0; elm <= i__2; ++elm) {
	twiddle[elm + num1] = -twiddle[elm];
    }
/*     End If */
/*  End of Subroutine HST_EXPNT */
} /* hst_expnt__ */

/* ********1*********2*********3*********4*********5*********6*********7** */
/* ********1*********2*********3*********4*********5*********6*********7** */
/*  ******************** */
/*  *                  * */
/*  *  hst_r4tr.f  * */
/*  *                  * */
/*  ******************** */
/* + HST_R4TR - (MAthematical procedures) Radix 4 TRansform */
/* Subroutine */ int hst_r4tr__(int__, b0, b1, b2, b3)
integer *int__;
real *b0, *b1, *b2, *b3;
{
    /* System generated locals */
    integer i__1;

    /* Local variables */
    static integer k;
    static real r0, r1;

/*  Description: */
/*    This subroutine is adapted from R4TR a subroutine written by */
/*    Bergland to perform radix-2 FFT. */
/*    Berglands original subroutine may be found in IEEE */
/*    Transactions on Audio and Electroacoustic, Vol. Au-17, pp.138-144. */
/*  Keywords: */
/*    Fourier~Transform.Radix~4 */
/*  Method: */
/*    See FAST FOURIER ANALYSIS:  RADIX 8 METHOD */
/*    SEE BERGLAND IN IEEE TRANS. AUDIO & ELECTROACOUSTICS */
/*    VOL. AU-17, NO. 2, PP138-144 */
/*  Usage: */
/*    Private */
/*  Deficiencies: */
/*  Bugs: */
/*  Authors: */
/*    Bergland : See BERGLAND IN IEEE TRANS. AUDIO & ELECTROACOUSTICS */
/*    VOL. AU-17, NO. 2, PP138-144 */
/*    A P Hammersley (hammersley@esrf.fr) */
/*  History: */
/*    16-Jun-1992: V0.1 Original, based on MA_R2TR (HAMMERSLEY), */
/*    based on R2TR (BERGLAND) */
/*    04-Feb-1999: V0.2 Simplify code, by removing line numbers and */
/*    replacing 'Continue' statements with 'End Do' statements where */
/*    possible (HAMMERSLEY) */
/*  Type Definitions: */
/* ...Translated by Pacific-Sierra Research vf90 Personal 3.4N5 11:36:22 7/11/02 */
/* ...Switches: */
/*  Global Constants: */
/*      Include 'st_symbols.inc' */
/*  Import: */
/*  Import/Export: */
/*  Status: */
/*  Local Constants: */
/* Version number for */
/*      subroutine */
/*  Local Variables: */
/* Loop variable */
/*  Local Arrays: */
/* --------1---------2---------3---------4---------5---------6---------7-- */
/* Temporary variable for swapping elements */
    /* Parameter adjustments */
    --b3;
    --b2;
    --b1;
    --b0;

    /* Function Body */
    i__1 = *int__;
    for (k = 1; k <= i__1; ++k) {
	r0 = b0[k] + b2[k];
	r1 = b1[k] + b3[k];
	b2[k] = b0[k] - b2[k];
	b3[k] = b1[k] - b3[k];
	b0[k] = r0 + r1;
	b1[k] = r0 - r1;
    }
} /* hst_r4tr__ */

/*  End of Subroutine HST_R4TR */
/* ********1*********2*********3*********4*********5*********6*********7** */
/* ********1*********2*********3*********4*********5*********6*********7** */
/*  ******************** */
/*  *                  * */
/*  *  hst_r4syn.f * */
/*  *                  * */
/*  ******************** */
/* + HST_R4SYN - (MAthematical procedures) Radix 4 SYNthesis */
/* Subroutine */ int hst_r4syn__(int__, b0, b1, b2, b3)
integer *int__;
real *b0, *b1, *b2, *b3;
{
    /* System generated locals */
    integer i__1;

    /* Local variables */
    static integer k;
    static real t0, t1, t2, t3;

/*  Description: */
/*    This subroutine is adapted from R4TR a subroutine written by */
/*    Bergland to perform radix-2 FFT. */
/*    Berglands original subroutine may be found in IEEE */
/*    Transactions on Audio and Electroacoustic, Vol. Au-17, pp.138-144. */
/*  Keywords: */
/*    Fourier~Transform.Radix~4 */
/*  Method: */
/*    See FAST FOURIER ANALYSIS:  RADIX 8 METHOD */
/*    SEE BERGLAND IN IEEE TRANS. AUDIO & ELECTROACOUSTICS */
/*    VOL. AU-17, NO. 2, PP138-144 */
/*  Usage: */
/*    Private */
/*  Deficiencies: */
/*  Bugs: */
/*  Authors: */
/*    Bergland : See BERGLAND IN IEEE TRANS. AUDIO & ELECTROACOUSTICS */
/*    VOL. AU-17, NO. 2, PP138-144 */
/*    A P Hammersley (hammersley@esrf.fr) */
/*  History: */
/*    16-Jun-1992: V0.1 Original, based on MA_R2TR (HAMMERSLEY), */
/*    based on R2TR (BERGLAND) */
/*    04-Feb-1999: V0.2 Simplify code, by removing line numbers and */
/*    replacing 'Continue' statements with 'End Do' statements where */
/*    possible (HAMMERSLEY) */
/*  Type Definitions: */
/* ...Translated by Pacific-Sierra Research vf90 Personal 3.4N5 11:36:22 7/11/02 */
/* ...Switches: */
/*  Global Constants: */
/*      Include 'st_symbols.inc' */
/*  Import: */
/*  Import/Export: */
/*  Status: */
/*  Local Constants: */
/* Version number for */
/*      subroutine */
/*  Local Variables: */
/* Loop variable */
/*  Local Arrays: */
/* --------1---------2---------3---------4---------5---------6---------7-- */
    /* Parameter adjustments */
    --b3;
    --b2;
    --b1;
    --b0;

    /* Function Body */
    i__1 = *int__;
    for (k = 1; k <= i__1; ++k) {
	t0 = b0[k] + b1[k];
	t1 = b0[k] - b1[k];
	t2 = b2[k] + b2[k];
	t3 = b3[k] + b3[k];
	b0[k] = t0 + t2;
	b2[k] = t0 - t2;
	b1[k] = t1 + t3;
	b3[k] = t1 - t3;
    }
} /* hst_r4syn__ */

/*  End of Subroutine HST_R4SYN */
/* ********1*********2*********3*********4*********5*********6*********7** */
/* ********1*********2*********3*********4*********5*********6*********7** */
/*  ******************** */
/*  *                  * */
/*  *  hst_r2tr.f  * */
/*  *                  * */
/*  ******************** */
/* + HST_R2TR - (MAthematical procedures) Radix 2 Fourier TRansform */
/* Subroutine */ int hst_r2tr__(int__, b0, b1)
integer *int__;
real *b0, *b1;
{
    /* System generated locals */
    integer i__1;

    /* Local variables */
    static real temp;
    static integer k;

/*  Description: */
/*    This subroutine is adapted from R2TR a subroutine written by */
/*    Bergland to perform radix-2 FFT. */
/*    Berglands original subroutine may be found in IEEE */
/*    Transactions on Audio and Electroacoustic, Vol. Au-17, pp.138-144. */
/*  Keywords: */
/*    Fourier~Transform.Radix~2 */
/*  Method: */
/*    See FAST FOURIER ANALYSIS:  RADIX 8 METHOD */
/*    SEE BERGLAND IN IEEE TRANS. AUDIO & ELECTROACOUSTICS */
/*    VOL. AU-17, NO. 2, PP138-144 */
/*  Usage: */
/*    Private */
/*  Deficiencies: */
/*  Bugs: */
/*  Authors: */
/*    Bergland : See BERGLAND IN IEEE TRANS. AUDIO & ELECTROACOUSTICS */
/*    VOL. AU-17, NO. 2, PP138-144 */
/*    A P Hammersley (hammersley@esrf.fr) */
/*  History: */
/*    16-Jun-1992: V0.1 Original, based on MA_R2TR (HAMMERSLEY), */
/*    based on R2TR (BERGLAND) */
/*    04-Feb-1999: V0.2 Simplify code, by removing line numbers and */
/*    replacing 'Continue' statements with 'End Do' statements where */
/*    possible (HAMMERSLEY) */
/*  Type Definitions: */
/* ...Translated by Pacific-Sierra Research vf90 Personal 3.4N5 11:36:22 7/11/02 */
/* ...Switches: */
/*  Global Constants: */
/*      Include 'st_symbols.inc' */
/*  Import: */
/*  Import/Export: */
/*  Status: */
/*  Local Constants: */
/* Version number for */
/*      subroutine */
/*  Local Variables: */
/* Loop variable */
/*  Local Arrays: */
/* --------1---------2---------3---------4---------5---------6---------7-- */
/* Temporary variable for swapping elements */
    /* Parameter adjustments */
    --b1;
    --b0;

    /* Function Body */
    i__1 = *int__;
    for (k = 1; k <= i__1; ++k) {
	temp = b0[k] + b1[k];
	b1[k] = b0[k] - b1[k];
	b0[k] = temp;
    }
} /* hst_r2tr__ */

/*  End of Subroutine HST_R2TR */
/* ********1*********2*********3*********4*********5*********6*********7** */
/* ********1*********2*********3*********4*********5*********6*********7** */
/*  ******************** */
/*  *                  * */
/*  *  hst_ord2.f  * */
/*  *                  * */
/*  ******************** */
/* + HST_ORD2 - (MAthematical procedures) ORDerind (2) of radix-8 FFT */
/* Subroutine */ int hst_ord2__(numdat, n, m, b)
integer *numdat, *n, *m;
real *b;
{
    /* System generated locals */
    integer i__1, i__2, i__3, i__4, i__5, i__6, i__7, i__8, i__9, i__10, 
	    i__11, i__12, i__13, i__14, i__15, i__16, i__17, i__18, i__19, 
	    i__20, i__21, i__22, i__23, i__24, i__25, i__26, i__27, i__28, 
	    i__29, i__30, i__31, i__32, i__33, i__34, i__35, i__36, i__37;
    static integer equiv_18[20];

    /* Local variables */
    static integer k;
#define l (equiv_18)
    static real t;
    static integer j1, j2, j3, j4, j5, j6, j7, j8, j9;
#define l1 (equiv_18 + 18)
#define l2 (equiv_18 + 17)
#define l3 (equiv_18 + 16)
#define l4 (equiv_18 + 15)
#define l5 (equiv_18 + 14)
#define l6 (equiv_18 + 13)
#define l7 (equiv_18 + 12)
#define l8 (equiv_18 + 11)
#define l9 (equiv_18 + 10)
    static integer j10, j11, j12, j13, j14, j15, j16, j17, ij, ji, j18;
#define l10 (equiv_18 + 9)
#define l11 (equiv_18 + 8)
#define l12 (equiv_18 + 7)
#define l13 (equiv_18 + 6)
#define l14 (equiv_18 + 5)
#define l15 (equiv_18 + 4)
#define l16 (equiv_18 + 3)
#define l17 (equiv_18 + 2)
#define l18 (equiv_18 + 1)
#define l19 (equiv_18)

/*  Description: */
/*    This subroutine is adapted from ORD2 a subroutine written by */
/*    Bergland to re-order data after an FFT. */
/*    Berglands original subroutine may be found in IEEE */
/*    Transactions on Audio and Electroacoustic, Vol. Au-17, pp.138-144. */
/*  Keywords: */
/*    Fourier~Transform.Fast.Re-order */
/*  Method: */
/*    See FAST FOURIER ANALYSIS:  RADIX 8 METHOD */
/*    SEE BERGLAND IN IEEE TRANS. AUDIO & ELECTROACOUSTICS */
/*    VOL. AU-17, NO. 2, PP138-144 */
/*  Usage: */
/*    Private */
/*  Deficiencies: */
/*  Bugs: */
/*  Authors: */
/*    Bergland : See BERGLAND IN IEEE TRANS. AUDIO & ELECTROACOUSTICS */
/*    VOL. AU-17, NO. 2, PP138-144 */
/*    A P Hammersley (hammersley@esrf.fr) */
/*  History: */
/*    16-Jun-1992: V0.1 Original, based on MA_ORD2 (HAMMERSLEY), */
/*    based on ORD2 (BERGLAND) */
/*    03-Feb-1999: V0.2 Simplify code, by removing line numbers and */
/*    replacing 'Continue' statements with 'End Do' statements where */
/*    possible (HAMMERSLEY) */
/*    04-Feb-1999: V0.3 Add number of data points as argument */
/*    (HAMMERSLEY) */
/*    08-Apr-2002: V0.4 Replace old style DO statements with statement numbers by */
/*    the 'DO - END DO' construct (problems with Absoft F95 compiler) (WILCKE) */
/*  Type Definitions: */
/* ...Translated by Pacific-Sierra Research vf90 Personal 3.4N5 11:36:22 7/11/02 */
/* ...Switches: */
/*  Global Constants: */
/*      Include 'st_symbols.inc' */
/*  Import: */
/* Number of data points in FFT */
/*  Import/Export: */
/*  Status: */
/*  Local Constants: */
/* FFT to be re-ordered */
/* Version number for */
/*      subroutine */
/*  Local Variables: */
/*  Local Arrays: */
/* Temporary variable for swapping elements */
/*    Equivalences: */
    /* Parameter adjustments */
    --b;

    /* Function Body */
    l[0] = *n;
    i__1 = *m;
    for (k = 2; k <= i__1; ++k) {
	l[k - 1] = l[k - 2] / 2;
    }
    for (k = *m; k <= 19; ++k) {
	l[k] = 2;
    }
    ij = 2;
    i__1 = *l1;
    for (j1 = 2; j1 <= i__1; j1 += 2) {
	i__2 = *l2;
	i__3 = *l1;
	for (j2 = j1; i__3 < 0 ? j2 >= i__2 : j2 <= i__2; j2 += i__3) {
	    i__4 = *l3;
	    i__5 = *l2;
	    for (j3 = j2; i__5 < 0 ? j3 >= i__4 : j3 <= i__4; j3 += i__5) {
		i__6 = *l4;
		i__7 = *l3;
		for (j4 = j3; i__7 < 0 ? j4 >= i__6 : j4 <= i__6; j4 += i__7) 
			{
		    i__8 = *l5;
		    i__9 = *l4;
		    for (j5 = j4; i__9 < 0 ? j5 >= i__8 : j5 <= i__8; j5 += 
			    i__9) {
			i__10 = *l6;
			i__11 = *l5;
			for (j6 = j5; i__11 < 0 ? j6 >= i__10 : j6 <= i__10; 
				j6 += i__11) {
			    i__12 = *l7;
			    i__13 = *l6;
			    for (j7 = j6; i__13 < 0 ? j7 >= i__12 : j7 <= 
				    i__12; j7 += i__13) {
				i__14 = *l8;
				i__15 = *l7;
				for (j8 = j7; i__15 < 0 ? j8 >= i__14 : j8 <= 
					i__14; j8 += i__15) {
				    i__16 = *l9;
				    i__17 = *l8;
				    for (j9 = j8; i__17 < 0 ? j9 >= i__16 : 
					    j9 <= i__16; j9 += i__17) {
					i__18 = *l10;
					i__19 = *l9;
					for (j10 = j9; i__19 < 0 ? j10 >= 
						i__18 : j10 <= i__18; j10 += 
						i__19) {
					    i__20 = *l11;
					    i__21 = *l10;
					    for (j11 = j10; i__21 < 0 ? j11 >=
						     i__20 : j11 <= i__20; 
						    j11 += i__21) {
			  i__22 = *l12;
			  i__23 = *l11;
			  for (j12 = j11; i__23 < 0 ? j12 >= i__22 : j12 <= 
				  i__22; j12 += i__23) {
			      i__24 = *l13;
			      i__25 = *l12;
			      for (j13 = j12; i__25 < 0 ? j13 >= i__24 : j13 
				      <= i__24; j13 += i__25) {
				  i__26 = *l14;
				  i__27 = *l13;
				  for (j14 = j13; i__27 < 0 ? j14 >= i__26 : 
					  j14 <= i__26; j14 += i__27) {
				      i__28 = *l15;
				      i__29 = *l14;
				      for (j15 = j14; i__29 < 0 ? j15 >= 
					      i__28 : j15 <= i__28; j15 += 
					      i__29) {
					  i__30 = *l16;
					  i__31 = *l15;
					  for (j16 = j15; i__31 < 0 ? j16 >= 
						  i__30 : j16 <= i__30; j16 +=
						   i__31) {
			i__32 = *l17;
			i__33 = *l16;
			for (j17 = j16; i__33 < 0 ? j17 >= i__32 : j17 <= 
				i__32; j17 += i__33) {
			    i__34 = *l18;
			    i__35 = *l17;
			    for (j18 = j17; i__35 < 0 ? j18 >= i__34 : j18 <= 
				    i__34; j18 += i__35) {
				i__36 = *l19;
				i__37 = *l18;
				for (ji = j18; i__37 < 0 ? ji >= i__36 : ji <=
					 i__36; ji += i__37) {
				    if (ij < ji) {
					t = b[ij - 1];
					b[ij - 1] = b[ji - 1];
					b[ji - 1] = t;
					t = b[ij];
					b[ij] = b[ji];
					b[ji] = t;
				    }
				    ij += 2;
				}
			    }
			}
					  }
				      }
				  }
			      }
			  }
					    }
					}
				    }
				}
			    }
			}
		    }
		}
	    }
	}
    }
/*                                                           End of HST_ORD2 */
} /* hst_ord2__ */

#undef l19
#undef l18
#undef l17
#undef l16
#undef l15
#undef l14
#undef l13
#undef l12
#undef l11
#undef l10
#undef l9
#undef l8
#undef l7
#undef l6
#undef l5
#undef l4
#undef l3
#undef l2
#undef l1
#undef l


/* ********1*********2*********3*********4*********5*********6*********7** */
/* ********1*********2*********3*********4*********5*********6*********7** */
/*  ******************** */
/*  *                  * */
/*  *  hst_ord1.f  * */
/*  *                  * */
/*  ******************** */
/* + HST_ORD1 - (MAthematical procedures) ORDering (1) of radix-8 FFT */
/* Subroutine */ int hst_ord1__(n, b)
integer *n;
real *b;
{
    /* System generated locals */
    integer i__1;

    /* Local variables */
    static integer j, k;
    static real t;
    static integer kl;

/*  Description: */
/*    This subroutine is adapted from ORD1 a subroutine written by */
/*    Bergland to re-order data after an FFT. */
/*    Berglands original subroutine may be found in IEEE */
/*    Transactions on Audio and Electroacoustic, Vol. Au-17, pp.138-144. */
/*  Keywords: */
/*    Fourier~Transform.Fast.Re-order */
/*  Method: */
/*    See FAST FOURIER ANALYSIS:  RADIX 8 METHOD */
/*    SEE BERGLAND IN IEEE TRANS. AUDIO & ELECTROACOUSTICS */
/*    VOL. AU-17, NO. 2, PP138-144 */
/*  Usage: */
/*    Private */
/*  Deficiencies: */
/*  Bugs: */
/*  Authors: */
/*    Bergland : See BERGLAND IN IEEE TRANS. AUDIO & ELECTROACOUSTICS */
/*    VOL. AU-17, NO. 2, PP138-144 */
/*    A P Hammersley (hammersley@esrf.fr) */
/*  History: */
/*    16-Jun-1992: V0.1 Original, based on MA_ORD1 (HAMMERSLEY), */
/*    based on R8TR (BERGLAND) */
/*    03-Feb-1999: V0.2 Simplify code, by removing line numbers and */
/*    replacing 'Continue' statements with 'End Do' statements where */
/*    possible (HAMMERSLEY) */
/*  Type Definitions: */
/* ...Translated by Pacific-Sierra Research vf90 Personal 3.4N5 11:36:22 7/11/02 */
/* ...Switches: */
/*  Global Constants: */
/*      Include 'st_symbols.inc' */
/*  Import: */
/*  Import/Export: */
/*  Status: */
/*  Local Constants: */
/* Version number for */
/*      subroutine */
/*  Local Variables: */
/*  Local Arrays: */
/*    Equivalences: */
/* --------1---------2---------3---------4---------5---------6---------7-- */
/* Temporary variable for swapping elements */
    /* Parameter adjustments */
    --b;

    /* Function Body */
    k = 4;
    kl = 2;
    i__1 = *n;
    for (j = 4; j <= i__1; j += 2) {
	if (k > j) {
	    t = b[j];
	    b[j] = b[k];
	    b[k] = t;
	}
	k += -2;
	if (k <= kl) {
	    k = j + j;
	    kl = j;
	}
    }
/*  End of HST_ORD1 */
} /* hst_ord1__ */

