# COPYRIGHT
# Alessandro MIRONE
# ESRF
# 5 July 2002


import string
import Numeric
import my_EdfFile
import math
from copy import copy
import sys
import string


EdfFile=my_EdfFile

DEG2RAD=math.pi/180.0

def treat_par_file(s):
    """
      pythonify the old format (fortran)
      input file given as a string s
    """
    print "PYTHONIFYING INPUT FILE"
    s=string.replace(s,"!","#")
    lines=string.split(s,"\n")
    new_lines=""
    for line in lines:
        if( string.find(line,"FILE ")>=0 or string.find(line,"FILE=")>=0):
            line=add_quotes(line)
        elif( string.find(line,"PREFIX")>=0):
             line=add_quotes(line)
        elif( string.find(line,"POSTFIX")>=0):
             line=add_quotes(line)
        new_lines=new_lines+"\n"+line
    # try to execute the input file
    print "CHECKING INPUTFILE FOR EXECUTION"
    try:
       NO =0
       YES=1       
       new_lines= string.replace(new_lines, "\"N.A.\"", "\"N_A_\"")
       new_lines= string.replace(new_lines, "N.A.", "\"N_A_\"")
       exec(new_lines)
    except:
       print new_lines
       raise " something went wrong interpreting input file " 
    print "INPUT FILE IS GOOD FOR ME"
    return new_lines


def add_quotes(s):
    pos=string.find(s,"=")
    if(pos==-1): return s
    pos=pos+1
    new_s=s[:pos+1]
    toggle=0
    while(pos<len(s) and s[pos]==" "):
        pos=pos+1
    if(pos==len(s)):
        return s
    new_s=new_s+"\""
    while(pos<len(s) and s[pos]!=" "):
        new_s=new_s+s[pos]
        pos=pos+1
    new_s=new_s+"\""
    return new_s
    
    
def extract_edf_N(prefix , n ,  lvaries, nlength, postfix, vertical , pos_edf, size_edf ):
    name=prefix
    if(lvaries):
        name=name+("%d"%n)+postfix
    else:
        number = "%d"%n
        number = ("0" *  (nlength-len(number)))+ number
        name=name+number+postfix
    return extract_edf(name , vertical    , pos_edf, size_edf    )
                  
def extract_edf(name , vertical  , pos_edf, size_edf      ):      
   ima=EdfFile.EdfFile(name)
   P=copy(pos_edf)
   S=copy(size_edf)
   P.reverse()
   S.reverse()
   image=ima.GetData(0,Pos=P, Size=S, DataType="FloatValue")
           
   if(vertical==0):
        image=Numeric.transpose(image)
   return image



if(len(sys.argv)!=4 and len(sys.argv)!=6):
  raise " WRONG NUMBER OF ARGUMENTS, give par_file_name + n_of_threads  FLOAT/INT"

if(sys.argv[3]=="FLOAT"):
  import PyHST_c_F
  PyHST_c=PyHST_c_F
elif(sys.argv[3]=="INT"):
  import PyHST_c_I
  PyHST_c=PyHST_c_I
else:
  raise " either FLOAT or INT"


filename=sys.argv[1]
nthreads=int(sys.argv[2])
print " nthreads=", nthreads

try:    
 f=open(filename,"r")
except:
 print " problems reading file ", filename
 raise " EXITING "

s=f.read()
f.close()

s=treat_par_file(s)

NO=0
YES=1
class Parameters:
    RECONSTRUCT_FROM_SINOGRAMS=0
    NO_SINOGRAM_FILTERING=0
    exec(s)


PARALLEL_MACHINE = 0

if(len(sys.argv)==6):

  PARALLEL_MACHINE = 1

  nmachines = int(sys.argv[5])
  nmach     = int(sys.argv[4])
  tot_slices = Parameters.END_VOXEL_3 - Parameters.START_VOXEL_3 + 1
  partial_slices = int ( 0.999999 +  (  0.0 + tot_slices )/ nmachines   ) 
  START_VOXEL_3 =  partial_slices  * nmach
  END_VOXEL_3   =  min ( Parameters.END_VOXEL_3 , partial_slices  * ( nmach+1) -1 )
  Parameters.START_VOXEL_3   = START_VOXEL_3 +1
  Parameters.END_VOXEL_3     = END_VOXEL_3 +1
  Parameters.OUTPUT_FILE = Parameters.OUTPUT_FILE  + "_" + str (nmach) 


  print START_VOXEL_3  , "  ",  END_VOXEL_3
 
if( Parameters.RECONSTRUCT_FROM_SINOGRAMS):
 if( PARALLEL_MACHINE):
     raise " PARALLEL_MACHINE not yet implemented for reconstruction from sinograms "

 for nsino in range( Parameters.NUM_FIRST_SINOGRAM, Parameters.NUM_LAST_SINOGRAM+1 ):
    name=""
    if(Parameters.NUMBER_LENGTH_VARIES):
        name=name+("%d"%nsino)+Parameters.SINOGRAM_POSTFIX
        name_out=Parameters.OUTPUT_FILE+("%d"%nsino)
    else:
        number = "%d"%nsino
        number = ("0" *  (Parameters.NUMBER_LENGTH_VARIES-len(number)))+ number
        name=name+number+Parameters.SINOGRAM_POSTFIX
        name_out=Parameters.OUTPUT_FILE + number
    name=Parameters.SINOGRAM_PREFIX+name
    # name_out=name[string.rfind(name,"/")+1:] +".vol"
    print " reading file ", name
    SINO = EdfFile.EdfFile(name).GetData(0)
    # SINO = Numeric.transpose(SINO)*Numeric.array([1],"f")
    print SINO.shape
   
    print " name_out est ", name_out


    pyhst=PyHST_c.PyHST( name_out ,
                  Parameters.OVERSAMPLING_FACTOR,
                  Parameters.START_VOXEL_1-1 +1,
                  Parameters.START_VOXEL_2-1 +1,
                  Parameters.END_VOXEL_1-Parameters.START_VOXEL_1+1,
                  Parameters.END_VOXEL_2-Parameters.START_VOXEL_2+1,
                  Parameters.ROTATION_AXIS_POSITION,
                  Parameters.ANGLE_OFFSET*DEG2RAD,
                  Parameters.ANGLE_BETWEEN_PROJECTIONS*DEG2RAD,
				  Parameters.NO_SINOGRAM_FILTERING,
                  SINO.shape[1],
                  SINO.shape[0],
                  SINO  )
    pyhst.calcSlices(1 ,nthreads)
    pyhst = None
else:

  ########################################################################################################  #    
  # determine how many slice to read at once
  # --------------------------------------------
  Parameters.nsinos = (Parameters.NUM_LAST_IMAGE - Parameters.NUM_FIRST_IMAGE+1)

  output_limit  = 2000*1.0e6/(   ( Parameters.END_VOXEL_2 - Parameters.START_VOXEL_2+1 ) * (Parameters.END_VOXEL_1 - Parameters.START_VOXEL_1+1) *4  )
  if(Parameters.ROTATION_VERTICAL):
      input_limit  = Parameters.SINOGRAM_MEGABYTES*1.0e6/(
                             Parameters.NUM_IMAGE_1 *Parameters.nsinos  *4  )
  else:

      input_limit = Parameters.SINOGRAM_MEGABYTES*1.0e6/(
                             Parameters.NUM_IMAGE_2 *Parameters.nsinos) 

  Parameters.nslices_atonce = min( input_limit, output_limit ) 
  Parameters.nslices_atonce = int(Parameters.nslices_atonce)

  # =======================================================================================================

  ###############################################################################
  # How many slices we want in total
  # ----------------------------------------------------------------------------

  Parameters.tot_slices = Parameters.END_VOXEL_3 - Parameters.START_VOXEL_3 + 1

  # ///////////////////////////////////////////////////////////////////////////////////////////////////////////////


  #########################################################################################
  # read and store the BACKGROUND in variable background fully dimensioned
  # -------------------------------------------------------------------------------------
  if(Parameters.SUBTRACT_BACKGROUND):
     print " reading edf file for background ", Parameters.BACKGROUND_FILE
     dark=EdfFile.EdfFile(Parameters.BACKGROUND_FILE)
     background=dark.GetData(0,DataType="FloatValue")
  else:
    background=Numeric.zeros([ Parameters.NUM_IMAGE_2, Parameters.NUM_IMAGE_1 ],"f")

  if(Parameters.ROTATION_VERTICAL==0):
      background=Numeric.transpose(background)

  # ////////////////////////////////////////////////////////////////////////////////////////////



  ###############################################################################################
  # create the big array to contain sinograms
  # --------------------------------------------------------------------------------------------
  #
  if(Parameters.ROTATION_VERTICAL==0):
    dim_1 = Parameters.NUM_IMAGE_2
    dim_2 = Parameters.nsinos
    dim_3 = Parameters.nslices_atonce
  
  if(Parameters.ROTATION_VERTICAL==1):
    dim_1 = Parameters.NUM_IMAGE_1
    dim_2 = Parameters.nsinos
    dim_3 = Parameters.nslices_atonce
  #
  # >>>>>>>>>>>>>>>> the BIG thing <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
  BIG_SINOS = Numeric.zeros( [dim_3,dim_2,dim_1],"f" )  
  #
  #
  #!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
  # another reference to access the BIG thing with a different scheme
  # ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
  BIG_SINOS_natural_ordering = Numeric.swapaxes(BIG_SINOS ,0,1)
  # ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
  # **********************************************************************

  # ///////////////////////////////////////////////////////////////////////////////////

  ########################################################################################
  # How many angular steps we must integrate
  # -----------------------------------------------------------------------------------------
  num_projections=  Parameters.NUM_LAST_IMAGE+1-Parameters.NUM_FIRST_IMAGE
  # ///////////////////////////////////////////////////////////////////////////////////////


  #################################################################################################
  # constant to normalise the result
  # -----------------------------------------------------------------------------------------------
  if (Parameters.ROTATION_VERTICAL):
          normalise = Numeric.array([(math.pi / 2.0) * (1.0 / num_projections) *   (1.0e6*0.01 / Parameters.IMAGE_PIXEL_SIZE_1)],"f")
  else:
          normalise = Numeric.array([(math.pi / 2.0) * (1.0 / num_projections) *   (1.0e6*0.01 / Parameters.IMAGE_PIXEL_SIZE_2)],"f")
  # //////////////////////////////////////////////////////////////////////////////////////////////////////////


  ###############################################################################
  # create the C speedy-object 
  # -----------------------------------------------------------------------------

  pyhst=PyHST_c.PyHST(Parameters. OUTPUT_FILE ,
                  Parameters.OVERSAMPLING_FACTOR,
                  Parameters.START_VOXEL_1-1 +1,
                  Parameters.START_VOXEL_2-1 +1,
                  Parameters.END_VOXEL_1-Parameters.START_VOXEL_1+1,
                  Parameters.END_VOXEL_2-Parameters.START_VOXEL_2+1,
                  Parameters.ROTATION_AXIS_POSITION,
                  Parameters.ANGLE_OFFSET*DEG2RAD,
                  Parameters.ANGLE_BETWEEN_PROJECTIONS*DEG2RAD,
				  Parameters.NO_SINOGRAM_FILTERING,
                  dim_1,
                  num_projections,
                  BIG_SINOS  )

  #######################################################################################
  # SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS
  #
  # start the loop over memory bunches
  #
  # --------------------------------------------------------------------------------------

  ###########################################################################################
  #
  # HOW many passes, reading a maximum of nslices_atonce slices each time, we have to perform
  # 
  tot_passes = int(Parameters.tot_slices/ Parameters.nslices_atonce ) +1
  # --------------------------------------------------------------------------------------

  for i_pass in range( tot_passes  ): 

    print " pass ", i_pass, " of ", tot_passes

    first_slice = i_pass * Parameters.nslices_atonce + Parameters.START_VOXEL_3 -1
    last_slice  = min(first_slice + Parameters.nslices_atonce-1, Parameters.END_VOXEL_3-1) 

    print " processing slice ", first_slice+1," up to (included) " , last_slice+1

    ######################################################################
    # pos_edf and size_edf are passed to the Gobbo's EdfFile routine
    # to extract the interesting part of the edf images
    # -------------------------------------------------------------------

    if(Parameters.ROTATION_VERTICAL==1):
      pos_edf=   [first_slice,0]
      size_edf = [last_slice-first_slice+1, Parameters.NUM_IMAGE_1 ]

    if(Parameters.ROTATION_VERTICAL==0):
      pos_edf=   [0,first_slice]
      size_edf = [  Parameters.NUM_IMAGE_2, last_slice-first_slice+1      ]

    # ///////////////////////////////////////////////////////////////////////

    ################################################################################
    # the background that is going to be used for the interesting pat
    # ------------------------------------------------------------------------------
    #
    new_background = background[first_slice:last_slice+1]
  
    # /////////////////////////////////////////////////////////////////////////////  


    #################################################################################
    # ipro is an index running over the  projection edf-images
    # It can be used directly to access the files by postpending it to the file prefix
    # -------------------------------------------------------------------------------
    for i_pro in range(Parameters.NUM_FIRST_IMAGE, Parameters.NUM_LAST_IMAGE+1,1):

      if(( i_pro- Parameters.NUM_FIRST_IMAGE)%100 ==0 ):
        print " READING projection # ", i_pro- Parameters.NUM_FIRST_IMAGE, " of ",  Parameters.NUM_LAST_IMAGE+1-Parameters.NUM_FIRST_IMAGE

      if(Parameters.CORRECT_FLATFIELD):
        if( Parameters.FLATFIELD_CHANGING):
          i_FF=( (i_pro - Parameters.NUM_FIRST_IMAGE  )   %Parameters.FF_FILE_INTERVAL)
          if( i_FF==0 ):

            ########################################################
            # convert ipro to the index for the FF
            # ------------------------------------------------------------
            nFF=i_pro - Parameters.NUM_FIRST_IMAGE + Parameters.FF_NUM_FIRST_IMAGE
            nFF = min(nFF,  Parameters.FF_NUM_LAST_IMAGE)
            # ////////////////////////////////////////////////////////////////
            ############################################################
            #   read the fisrt  FF of the interpolation range
            # -----------------------------------------------------------
            FF_a = extract_edf_N(Parameters.FF_PREFIX, nFF,
                               Parameters.FF_NUMBER_LENGTH_VARIES,
                               Parameters.FF_LENGTH_OF_NUMERICAL_PART,
                               Parameters.FF_POSTFIX,
                               Parameters.ROTATION_VERTICAL, 
                               pos_edf, size_edf)
            # ////////////////////////////////////////////////////////////
            FF_b = FF_a
          if( i_FF==1 ):
            ########################################################
            # convert ipro to the index for the FF
            # ------------------------------------------------------------
            nFF = i_pro-1 - Parameters.NUM_FIRST_IMAGE + Parameters.FF_NUM_FIRST_IMAGE+ Parameters.FF_FILE_INTERVAL  
            nFF = min(nFF,  Parameters.FF_NUM_LAST_IMAGE)
            # ////////////////////////////////////////////////////////////////
            ############################################################
            # read the second  FF of the interpolation range
            # -----------------------------------------------------------
            FF_b = extract_edf_N(Parameters.FF_PREFIX,
                           nFF ,
                               Parameters.FF_NUMBER_LENGTH_VARIES,
                               Parameters.FF_LENGTH_OF_NUMERICAL_PART,
                               Parameters.FF_POSTFIX,
                               Parameters.ROTATION_VERTICAL, 
                               pos_edf, size_edf)
             # ////////////////////////////////////////////////////////////
                           
          ##########################################################################
          # linear interpolation
          # ------------------------------------------------------------------------
          FF = ( FF_a*Numeric.array([Parameters.FF_FILE_INTERVAL-i_FF]).astype("f") +
                 FF_b *Numeric.array([i_FF]).astype("f")  )/Numeric.array([Parameters.FF_FILE_INTERVAL]    ).astype("f")
          # /////////////////////////////////////////////////////////////////////////////////////////////////////////////
        else:
            if(ipro==Parameters.NUM_FIRST_IMAGE):
               ###################################################
               # read at the beginning of the scan the only
               # FF available
               # -------------------------------------------------
               FF = extract_edf(Parameters.FLATFIELD_FILE,
                                 Parameters.ROTATION_VERTICAL, 
                                 pos_edf, size_edf)
               # /////////////////////////////////////////////////

        if( Parameters.SUBTRACT_BACKGROUND):
          newFF = FF - new_background
        else:
          newFF = FF

        # clipping newFF 
        newFF=Numeric.maximum(newFF,Numeric.array([0.1],"f") )
      
      newitem =  extract_edf_N(Parameters.FILE_PREFIX,
                           i_pro,
                           Parameters.NUMBER_LENGTH_VARIES,
                           Parameters.LENGTH_OF_NUMERICAL_PART,
                           Parameters.FILE_POSTFIX,
                           Parameters.ROTATION_VERTICAL , 
                           pos_edf, size_edf )

      if( Parameters.SUBTRACT_BACKGROUND):
          newitem = newitem - new_background

        
      # clipping  newitem 
      newitem=Numeric.maximum(newitem,Numeric.array([1.0e-9],"f") )

      if( Parameters.CORRECT_FLATFIELD):
        newitem =  newitem/newFF 

      if( Parameters.TAKE_LOGARITHM):
        newitem = -Numeric.log( newitem) 

      newitem=newitem*normalise

      # throwing new data into the BIG thing

      throw_start=first_slice -Parameters.START_VOXEL_3 +1
      throw_end  =last_slice  -Parameters.START_VOXEL_3 +1

      # print "(i_pro-Parameters.NUM_FIRST_IMAGE , throw_start:throw_end+1) ", (i_pro-Parameters.NUM_FIRST_IMAGE , throw_start, throw_end+1)
      # print BIG_SINOS_natural_ordering.shape
      # print newitem.shape

      BIG_SINOS_natural_ordering[i_pro-Parameters.NUM_FIRST_IMAGE , 0 :throw_end+1 -throw_start ] = newitem
      
    # calculate slices from first_slice up to last_slice

    # ///////////////////////////////////////////////////////////////////////////////////////  
    pyhst.calcSlices(last_slice+1-first_slice,nthreads)

  # close the object












