"""
    tkplplot.py
    Plplot base widget for Tkinter
 
"""

__version__=  '1.0'
__date__ =    '01 June 2002'
__author__ =  'Alexandre Gobbo (gobbo@esrf.fr)'


from Tkinter import *
from Numeric import *
import sys, time,os
import pyqt_pl
pl=pyqt_pl

###TODO: Find reason double-buffered modo doesn't work on Windows


class tkplplot(Frame):

   def __init__(self,parent=None,name=None,back_color=(0,0,0),double_buffered=1,meta_buffer=1,alloc_colors=1):
      #Frame.__init__(self,parent)
      Frame.__init__(self,parent,background="#%02x%02x%02x" % back_color)
      self.is_created=0
      self.count=1
      self.ipls=pl.plpartialInitXw()
      self.formerheight= 0
      self.formerwidth = 0
      self.bind("<Configure>",self.resizeEvent)
      self.bind("<Expose>",self.paintEvent)
      self.back_color=back_color
      self.parent=parent
      self.double_buffered=double_buffered
      self.pack(fill=BOTH, expand=YES)        

      self.parent.update_idletasks()
      self.InitDrawing()
      if sys.platform== "win32":
         pl.plsdev("win3")
         handler=self.winfo_id()
         if double_buffered: pl.plsetopt("-db","")
         if meta_buffer==0: pl.plsetopt("-drvopt","hwnd=%d,buffered=0"%(handler,))
         else:pl.plsetopt("-drvopt","hwnd=%d"%(handler,))         
      else:
         pl.plsdev("xwin")
         pl.plsxwin(self.winfo_id())
         if double_buffered:pl.plsetopt("-db","")
         if meta_buffer==0:
             if alloc_colors:pl.plsetopt("-drvopt","nobuffered=1")
             else: pl.plsetopt("-drvopt","nobuffered=1,noinitcolors=1")
         elif alloc_colors==0: pl.plsetopt("-drvopt","noinitcolors=1")
         
      pl.plinit()
      pl.plscolbg(self.back_color[0],self.back_color[1],self.back_color[2])
      pl.plbop()
      self.is_created=1

   def resizeEvent(self,e):
      if self.is_created:
         self.update()
         self.InitDrawing()
         pl.plresize(self.winfo_width(), self.winfo_height())
         self.EndDrawing()

   def paintEvent(self,e):
      if self.is_created:
         self.update()
         self.InitDrawing()
         pl.plexpose()
           
   def InitDrawing(self):
      pl.plsstrm(self.ipls)

   def EndDrawing(self):
      if self.double_buffered:
         pl.plexpose()
      

if __name__ == '__main__':
   parent=Tk()
   if sys.platform== "win32":
      wid=tkplplot(parent,double_buffered=0)
   else:
      wid=tkplplot(parent,double_buffered=1)





   wid.update()

   wid.InitDrawing()

   pl.pladv(0)
   pl.plfont(2)

   f0 = 1000.0
   freql = 1.0 + arrayrange(101)/20.0
   freq = pow(10.0, freql)
   ampl = 20.0 * log10(1.0 / sqrt(1.0 + pow((freq / f0), 2.)))
   phase = -(180.0 / pi) * arctan(freq / f0)

   pl.plvpor(0.15, 0.85, 0.1, 0.9)
   pl.plwind(1.0, 6.0, -80.0, 0.0)
   pl.plbox("bclnst", 0.0, 0, "bnstv", 0.0, 0)
   pl.plcol0(2)
   pl.plline(freql, ampl)
   pl.plcol0(1)
   pl.plptex(5.0, -30.0, 1.0, -20.0, 0.5, "-20 dB/decade")

   pl.plwind(1.0, 6.0, -100.0, 0.0)
   pl.plbox("", 0.0, 0, "cmstv", 30.0, 3)
   pl.plcol0(3)
   pl.plline(freql, phase)

   pl.plcol0(1)
   pl.plmtex("b", 3.2, 0.5, 0.5, "Frequency")
   pl.plmtex("t", 2.0, 0.5, 0.5, "Single Pole Low-Pass Filter")
   pl.plcol0(2)
   pl.plmtex("l", 5.0, 0.5, 0.5, "Amplitude (dB)")
   pl.plcol0(3)
   pl.plmtex("r", 5.0, 0.5, 0.5, "Phase shift (degrees)")

   # Restore defaults
   pl.plfont(1)
   pl.plcol0(1)


   wid.EndDrawing()


   parent.mainloop()
