"""	
	ExtendedGraphDialogs.py
"""

__author__ =  'Nicolas Pascal (pascal@esrf.fr)'
__version__=  '1.0'


import Tkinter
from Binding import Dialog
import tkColorChooser
import Selector
import string

def MapFillModeToTk(fill='25%'):
	if fill=='None' :  return "fill_0"
	elif fill=='12%' :  return "fill_12"
	elif fill=='25%' :  return "fill_25"
	elif fill=='50%' :  return "fill_50"
	elif fill=='75%' :  return "fill_75"
	elif fill=='100%' :  return "fill_100"
	else : raise  "TkGraphPopup: fill style error : ",fill," unknown"

def MapFillModeFromTk(fill='fill_25'):
	if fill=='fill_0' :  return "None"
	elif fill=='fill_12' :  return "12%"
	elif fill=='fill_25' :  return "25%"
	elif fill=='fill_50' :  return "50%"
	elif fill=='fill_75' :  return "75%"
	elif fill=='fill_100' :  return "100%"
	else : raise  "TkGraphPopup: fill style error : ",fill," unknown"
	
def MapColorToTk(color=(00,255,00)):
	return "#%02x%02x%02x"%color
	
def MapLineStyle(lineStyle='None'):
	if lineStyle=='None' or lineStyle is None: return 'hidden'
	else: return lineStyle
	
def MapSymbolStyle(symbolStyle='None'):
	if symbolStyle=='None' or symbolStyle is None: return 'none'
	else: return symbolStyle

class GraphStyleDialog(Dialog):
	"""
	Dialog allowing to choose the properties of a graph :
		-	plot symbols
		-	line style
		-	line width
		-	color
	It's possible to display only a few selection's widgets. Only the widgets used for changing the options explicitely given in graphCnf will be displayed. 
	"""
	def __init__(self,parent,eh,graphName='graph',graphCnf={'symbol':'circle','style':'dashed','width':2,'color':(00,00,255)}):
		Dialog.__init__(self,parent,title="Graph style",modal=0)
		
		self.parent=parent
		
		self.eh=eh
		
		self.graphElementStyleChangedEvent=self.eh.create("graphElementStyleChangedEvent")
		
		self.symbols=['circle','square','diamond','plus','cross','triangle','none']
		self.lines=['solid','dashed','dotted','hidden']
		
		self.graphName=graphName
		
		self.style=graphCnf

		if graphCnf.has_key('symbol'):
			symbolsLab=Tkinter.Label(self,text='Symbols')
			symbolsLab.grid(row=0,col=0,sticky='nsew')
			symbolsSelect=Selector.Selector(self,self.symbols,command=self._SetSymbol)
			symbolsSelect.value.set(MapSymbolStyle(self.style['symbol']))
			symbolsSelect.grid(row=0,col=1,sticky='nsew')
		
		if graphCnf.has_key('style'):
			lineLab=Tkinter.Label(self,text='Line')
			lineLab.grid(row=1,col=0,sticky='nsew')
			lineSelect=Selector.Selector(self,self.lines,command=self._SetLineStyle)
			lineSelect.value.set(MapLineStyle(self.style['style']))
			lineSelect.grid(row=1,col=1,sticky='nsew')
		
		if graphCnf.has_key('width'):
			lineWidthLab=Tkinter.Label(self,text='Width')
			lineWidthLab.grid(row=2,col=0,sticky='nsew')
			lineWidthSelect=Selector.Selector(self,range(20),command=self._SetLineWidth)
			lineWidthSelect.value.set(self.style['width'])
			lineWidthSelect.grid(row=2,col=1,sticky='nsew')
		
		if graphCnf.has_key('color'):
			colorLab=Tkinter.Label(self,text='Color')
			colorLab.grid(row=3,col=0,sticky='nsew')
			self.colorSelect=Tkinter.Frame(self,bg=MapColorToTk(self.style['color']))
			self.colorSelect.bind('<Button-1>',self._SetColor)
			self.colorSelect.grid(row=3,col=1,sticky='nsew')
		
		ok=Tkinter.Button(self,text='OK',command=self.valid)
		ok.grid(row=4,col=0,padx=10,pady=10)
		
		cancel=Tkinter.Button(self,text='Cancel',command=self.cancel)
		cancel.grid(row=4,col=1,padx=10,pady=10)
		
		self.protocol("WM_DELETE_WINDOW", self.cancel)
				
	def GetGraphStyle(self):
		return self.style
	
	def _SetSymbol(self,symbol):
		self.style['symbol']=symbol
		self.eh.event(self.graphElementStyleChangedEvent,self.graphName,self.GetGraphStyle())
		
	def _SetLineStyle(self,lineStyle):
		self.style['style']=lineStyle
		self.eh.event(self.graphElementStyleChangedEvent,self.graphName,self.GetGraphStyle())
	
	def _SetLineWidth(self,lineWidth):
		self.style['width']=lineWidth
		self.eh.event(self.graphElementStyleChangedEvent,self.graphName,self.GetGraphStyle())
	
	def _SetColor(self,e):
		colorSeq,colorString=tkColorChooser.askcolor()
		if colorSeq is not None:
			for color  in colorSeq:
				color=int(color)
			self.style['color']=colorSeq
			self.colorSelect['bg']=colorString
			self.eh.event(self.graphElementStyleChangedEvent,self.graphName,self.GetGraphStyle())
	
	def cancel(self, event=None):
		self.parent.focus_set()
		self.Destroyed=1
		# delete self's reference in parent's diplayed popups
		try: del self.parent.popups['Graph'][self.graphName]
		except: pass
		self.destroy()

	def valid(self):
		self.parent.focus_set()
		# delete self's reference in parent's diplayed popups
		try: del self.parent.popups['Graph'][self.graphName]
		except: pass
		self.destroy()

class RoiStyleDialog(Dialog):
	"""
	Dialog allowing to choose the properties of a roi :
		in general :
			-	its name
		for its filling :
			-	style ( stripe density )
			-	color
		for its border
			-	line style
			-	width
			-	color
	It's possible to display only a few selection's widgets. Only the widgets used for changing the options explicitely given in roiFillCnf/roiBorderCnf will be displayed. 
	If roiFillCnf/roiBorderCnf are equal to an empty dictionnary won't be displayed, and if roiName is None, it's name won't be displayed too. 
	"""
	def __init__(self,parent,eh,roiName='roi',roiFillCnf={'fill':'fill_25','color':(198, 179, 234)},roiBorderCnf={'style':'solid','width':2,'color':(0, 179, 254)}):
		Dialog.__init__(self,parent,title="Roi style",modal=0)
		
		self.parent=parent
		
		self.eh=eh
		
		self.roiStyleChangedEvent=self.eh.create("roiStyleChangedEvent")
		
		self.fillStyle=['None','12%','25%','50%','75%','100%']
		self.lineStyle=['solid','dashed','dotted','hidden']
		
		self.roiName=roiName
		self.roiFillStyle=roiFillCnf
		self.roiBorderStyle=roiBorderCnf
		
		#--- roi name ---#
		if self.roiName is not None:
			nameLab=Tkinter.Label(self,text='Name')
			nameLab.grid(row=0,col=0,sticky='nsew')
			self.nameEntry=Tkinter.Entry(self,width=6)
			self.nameEntry.insert(Tkinter.END,roiName)
			self.nameEntry.bind('<Return>',self._SetRoiName)
			self.nameEntry.grid(row=0,col=1,sticky='nsew')
		
		#--- roi filling style ---#
		if self.roiFillStyle!={}:
			fillLab=Tkinter.Label(self,text='Fill style',bg='#befefe')
			fillLab.grid(row=1,col=0,columnspan=2,sticky='nsew',pady=10)
			if self.roiFillStyle.has_key('fill'):
				stripesLab=Tkinter.Label(self,text='Stripes')
				stripesLab.grid(row=2,col=0,sticky='nsew')
				stripesSelect=Selector.Selector(self,self.fillStyle,command=self._SetStripesFill)
				stripesSelect.value.set(MapFillModeFromTk(self.roiFillStyle['fill']))
				stripesSelect.grid(row=2,col=1,sticky='nsew')
			if self.roiFillStyle.has_key('color'):
				colorLab=Tkinter.Label(self,text='Color')
				colorLab.grid(row=3,col=0,sticky='nsew')
				self.stripesColorSelect=Tkinter.Frame(self,bg=MapColorToTk(self.roiFillStyle['color']))
				self.stripesColorSelect.bind('<Button-1>',self._SetStripesColor)
				self.stripesColorSelect.grid(row=3,col=1,sticky='nsew')
		
		#--- roi border style ---#
		if self.roiBorderStyle!={}:
			borderLab=Tkinter.Label(self,text='Border style',bg='#befefe')
			borderLab.grid(row=4,col=0,columnspan=2,sticky='nsew',pady=10)
			if self.roiBorderStyle.has_key('style'):
				borderLineLab=Tkinter.Label(self,text='Line')
				borderLineLab.grid(row=5,col=0,sticky='nsew')
				borderLineSelect=Selector.Selector(self,self.lineStyle,command=self._SetBorderLineStyle)
				borderLineSelect.value.set(MapLineStyle(self.roiBorderStyle['style']))
				borderLineSelect.grid(row=5,col=1,sticky='nsew')
			if self.roiBorderStyle.has_key('width'):
				borderLineWidthLab=Tkinter.Label(self,text='Width')
				borderLineWidthLab.grid(row=6,col=0,sticky='nsew')
				borderLineWidthSelect=Selector.Selector(self,range(20),command=self._SetBorderLineWidth)
				borderLineWidthSelect.value.set(self.roiBorderStyle['width'])
				borderLineWidthSelect.grid(row=6,col=1,sticky='nsew')
			if self.roiBorderStyle.has_key('color'):
				borderLineColorLab=Tkinter.Label(self,text='Color')
				borderLineColorLab.grid(row=7,col=0,sticky='nsew')
				self.borderLineColorSelect=Tkinter.Frame(self,bg=MapColorToTk(self.roiBorderStyle['color']))
				self.borderLineColorSelect.bind('<Button-1>',self._SetBorderLineColor)
				self.borderLineColorSelect.grid(row=7,col=1,sticky='nsew')
		
		ok=Tkinter.Button(self,text='OK',command=self.valid)
		ok.grid(row=8,col=0,padx=10,pady=10)
		
		cancel=Tkinter.Button(self,text='Cancel',command=self.cancel)
		cancel.grid(row=8,col=1,padx=10,pady=10)
		
		self.protocol("WM_DELETE_WINDOW", self.cancel)
		
	def GetRoiStyle(self):
		return self.roiName,self.roiFillStyle,self.roiBorderStyle
	
	def _SetRoiName(self,e=None):
		oldRoiName=self.roiName
		self.roiName=self.nameEntry.get()
		self.eh.event(self.roiStyleChangedEvent,oldRoiName,self.GetRoiStyle())
	
	def _SetStripesFill(self,fill):
		self.roiFillStyle['fill']=MapFillModeToTk(fill)
		self.eh.event(self.roiStyleChangedEvent,self.roiName,self.GetRoiStyle())
		
	def _SetStripesColor(self,color):
		colorSeq,colorString=tkColorChooser.askcolor()
		if colorSeq is not None:
			for color  in colorSeq:
				color=int(color)
			self.roiFillStyle['color']=colorSeq
			self.stripesColorSelect['bg']=colorString
			self.eh.event(self.roiStyleChangedEvent,self.roiName,self.GetRoiStyle())
	
	def _SetBorderLineStyle(self,lineStyle):
		self.roiBorderStyle['style']=lineStyle
		self.eh.event(self.roiStyleChangedEvent,self.roiName,self.GetRoiStyle())
		
	def _SetBorderLineWidth(self,lineWidth):
		self.roiBorderStyle['width']=lineWidth
		self.eh.event(self.roiStyleChangedEvent,self.roiName,self.GetRoiStyle())
	
	def _SetBorderLineColor(self,e):
		colorSeq,colorString=tkColorChooser.askcolor()
		if colorSeq is not None:
			for color  in colorSeq:
				color=int(color)
			self.roiBorderStyle['color']=colorSeq
			self.borderLineColorSelect['bg']=colorString
			self.eh.event(self.roiStyleChangedEvent,self.roiName,self.GetRoiStyle())

	def cancel(self, event=None):
		self.parent.focus_set()
		self.Destroyed=1
		# delete self's reference in parent's diplayed popups
		try: del self.parent.popups['Roi'][self.roiName]
		except: pass
		self.destroy()
	
	def valid(self):
		if self.roiName is not None and self.roiName!=self.nameEntry.get():
			# if new roi name hasn't been validated
			self._SetRoiName()
		self.parent.focus_set()
		# delete self's reference in parent's diplayed popups
		try: del self.parent.popups['Roi'][self.roiName]
		except: pass
		self.destroy()
		
class PeakStyleDialog(Dialog):
	"""
	Dialog allowing to choose the properties of a peak :
		in general :
			-	its name
		for its filling :
			-	style ( stripe density )
			-	color
		for its border
			-	line style
			-	width
			-	color
	It's possible to display only a few selection's widgets. Only the widgets used for changing the options explicitely given in peakCnf will be displayed. 
	If peakCnf is equal to an empty dictionnary, it won't be displayed, and if peakName is None, it's name won't be displayed too. 
	"""
	def __init__(self,parent,eh,peakName='peak',peakCnf={'style':'solid','width':2,'color':(0,0,0)}):
		Dialog.__init__(self,parent,title="Peak style",modal=0)
		
		self.parent=parent
		
		self.eh=eh
		
		self.peakStyleChangedEvent=self.eh.create("peakStyleChangedEvent")
		
		self.lineStyle=['solid','dashed','dotted','None']
		
		self.peakName=peakName
		self.peakStyle=peakCnf
		
		if self.peakName is not None:
			nameLab=Tkinter.Label(self,text='Name')
			nameLab.grid(row=0,col=0,sticky='nsew')

			self.nameEntry=Tkinter.Entry(self,width=6)
			self.nameEntry.insert(Tkinter.END,peakName)
			self.nameEntry.bind('<Return>',self._SetPeakName)
			self.nameEntry.grid(row=0,col=1,sticky='nsew')
		
		if self.peakStyle!={}:
			if self.peakStyle.has_key('style'):
				lineLab=Tkinter.Label(self,text='Line')
				lineLab.grid(row=1,col=0,sticky='nsew')
				lineSelect=Selector.Selector(self,self.lineStyle,command=self._SetLineStyle)
				lineSelect.value.set(MapLineStyle(self.peakStyle['style']))
				lineSelect.grid(row=1,col=1,sticky='nsew')
			if self.peakStyle.has_key('width'):
				lineWidthLab=Tkinter.Label(self,text='Width')
				lineWidthLab.grid(row=2,col=0,sticky='nsew')
				lineWidthSelect=Selector.Selector(self,range(20),command=self._SetLineWidth)
				lineWidthSelect.value.set(self.peakStyle['width'])
				lineWidthSelect.grid(row=2,col=1,sticky='nsew')
			if self.peakStyle.has_key('color'):
				lineColorLab=Tkinter.Label(self,text='Color')
				lineColorLab.grid(row=3,col=0,sticky='nsew')
				self.lineColorSelect=Tkinter.Frame(self,bg=MapColorToTk(self.peakStyle['color']))
				self.lineColorSelect.bind('<Button-1>',self._SetLineColor)
				self.lineColorSelect.grid(row=3,col=1,sticky='nsew')
		
		ok=Tkinter.Button(self,text='OK',command=self.valid)
		ok.grid(row=4,col=0,padx=10,pady=10)
		
		cancel=Tkinter.Button(self,text='Cancel',command=self.cancel)
		cancel.grid(row=4,col=1,padx=10,pady=10)
		
		self.protocol("WM_DELETE_WINDOW", self.cancel)

	def GetPeakStyle(self):
		return self.peakName,self.peakStyle
	
	def _SetPeakName(self,e=None):
		oldPeakName=self.peakName
		self.peakName=self.nameEntry.get()
		self.eh.event(self.peakStyleChangedEvent,oldPeakName,self.GetPeakStyle())
	
	def _SetLineStyle(self,lineStyle):
		self.peakStyle['style']=lineStyle
		self.eh.event(self.peakStyleChangedEvent,self.peakName,self.GetPeakStyle())
		
	def _SetLineWidth(self,lineWidth):
		self.peakStyle['width']=lineWidth
		self.eh.event(self.peakStyleChangedEvent,self.peakName,self.GetPeakStyle())
	
	def _SetLineColor(self,e):
		colorSeq,colorString=tkColorChooser.askcolor()
		if colorSeq is not None:
			for color  in colorSeq:
				color=int(color)
			self.peakStyle['color']=colorSeq
			self.lineColorSelect['bg']=colorString
			self.eh.event(self.peakStyleChangedEvent,self.peakName,self.GetPeakStyle())

	def cancel(self, event=None):
		self.parent.focus_set()
		self.Destroyed=1
		# delete self's reference in parent's diplayed popups
		try: del self.parent.popups['Peak'][self.peakName]
		except: pass
		self.destroy()
	
	def valid(self):
		if self.peakName is not None and self.peakName!=self.nameEntry.get():
			# if new peak name hasn't been validated
			self._SetPeakName()
		self.parent.focus_set()
		# delete self's reference in parent's diplayed popups
		try: del self.parent.popups['Peak'][self.peakName]
		except: pass
		self.destroy()

def testGraphStyle(r):
	a=GraphStyleDialog(r,EventHandler.EventHandler())
	print a.GetGraphStyle()
	
def testRoiStyle(r):
	a=RoiStyleDialog(r,EventHandler.EventHandler())
	print a.GetRoiStyle()
	
def testPeakStyle(r):
	a=PeakStyleDialog(r,EventHandler.EventHandler())
	print a.GetPeakStyle()

if __name__ == '__main__':
	import EventHandler
	r=Tkinter.Tk()
	
	testGraphStyle(r)
	testRoiStyle(r)
	testPeakStyle(r)
	
	r.mainloop()
		
		
		
