"""	
	ExtendedGraphDialogs.py
"""

__author__ =  'Nicolas Pascal (pascal@esrf.fr)'
__version__=  '1.0'


import qt
from Binding import Dialog
import sys

def MapLineStyle(lineStyle='None'):
	if lineStyle=='None' or lineStyle is None: return 'hidden'
	else: return lineStyle
	
def MapSymbolStyle(symbolStyle='None'):
	if symbolStyle=='None' or symbolStyle is None: return 'none'
	else: return symbolStyle

def MapFillModeToQt(fill='25%'):
	if fill=='None' :  return "fill_0"
	elif fill=='12%' :  return "fill_12"
	elif fill=='25%' :  return "fill_25"
	elif fill=='50%' :  return "fill_50"
	elif fill=='75%' :  return "fill_75"
	elif fill=='100%' :  return "fill_100"
	else : raise  "TkGraphPopup: fill style error : ",fill," unknown"

def MapFillModeFromQt(fill='fill_25'):
	if fill=='fill_0' :  return "None"
	elif fill=='fill_12' :  return "12%"
	elif fill=='fill_25' :  return "25%"
	elif fill=='fill_50' :  return "50%"
	elif fill=='fill_75' :  return "75%"
	elif fill=='fill_100' :  return "100%"
	else : raise  "TkGraphPopup: fill style error : ",fill," unknown"

class ColorWidget(qt.QWidget):
	def __init__(self,parent,changeColorCB,bgColor=(255,0,0)):
		qt.QWidget.__init__(self,parent)
		if qt.qVersion()>="3.0.0":
			self.setPaletteBackgroundColor(qt.QColor(bgColor[0],bgColor[1],bgColor[2]))
		else:
			self.setBackgroundColor(qt.QColor(bgColor[0],bgColor[1],bgColor[2]))
		self.changeColorCB=changeColorCB
		
	def setColor(self,bgColor=(255,0,0)):
		if qt.qVersion()>="3.0.0":
			if isinstance(bgColor,qt.QColor):
				self.setPaletteBackgroundColor(bgColor)
			else:
				self.setPaletteBackgroundColor(qt.QColor(bgColor[0],bgColor[1],bgColor[2]))
		else:
			if isinstance(bgColor,qt.QColor):
				self.setBackgroundColor(bgColor)
			else:
				self.setBackgroundColor(qt.QColor(bgColor[0],bgColor[1],bgColor[2]))	
			
	def mousePressEvent(self,event):
		if qt.qVersion()>="3.0.0": newColor=qt.QColorDialog.getColor(self.paletteBackgroundColor(),self.topLevelWidget())
		else : newColor=qt.QColorDialog.getColor(self.backgroundColor(),self.topLevelWidget())
		self.setColor(newColor)
		#self.parentWidget()._SetColor(newColor.rgb())
		self.changeColorCB(newColor.rgb())

class GraphStyleDialog(Dialog):
	"""
	Dialog allowing to choose the properties of a graph :
		-	plot symbols
		-	line style
		-	color
	"""
	
	def __init__(self,parent,eh,graphName='graph',graphCnf={'symbol':'circle','style':'dashed','width':2,'color':(00,00,255)}):
		Dialog.__init__(self,parent,title="Graph style",modal=0)
		
		self.parent=parent
		
		self.gridLayout=qt.QGridLayout(self,6,2)
		
		self.eh=eh
		
		self.graphElementStyleChangedEvent=self.eh.create("graphElementStyleChangedEvent")
		
		self.symbols=['circle','square','diamond','plus','cross','triangle','none']
		self.lines=['solid','dashed','dotted','hidden']
		
		self.graphName=graphName
		
		self.style=graphCnf

		if graphCnf.has_key('symbol'):
			symbolsLab=qt.QLabel(self)
			symbolsLab.setText('Symbols')
			self.gridLayout.addWidget(symbolsLab,0,0)
			symbolsCombo=qt.QComboBox(self)
			symbolsCombo.insertStrList(self.symbols)
			symbolsCombo.setCurrentItem(MapSymbolStyle(self.symbols.index(self.style['symbol'])))
			self.connect(symbolsCombo,qt.SIGNAL('activated(const QString &)'),self._SetSymbol)
			self.gridLayout.addWidget(symbolsCombo,0,1)

		if graphCnf.has_key('style'):		
			lineLab=qt.QLabel(self)
			lineLab.setText('Line')
			self.gridLayout.addWidget(lineLab,1,0)
			lineCombo=qt.QComboBox(self)
			lineCombo.insertStrList(self.lines)
			lineCombo.setCurrentItem(MapLineStyle(self.lines.index(self.style['style'])))
			self.connect(lineCombo,qt.SIGNAL('activated(const QString &)'),self._SetLineStyle)
			self.gridLayout.addWidget(lineCombo,1,1)

		if graphCnf.has_key('width'):
			lineWidthLab=qt.QLabel(self)
			lineWidthLab.setText('Width')
			self.gridLayout.addWidget(lineWidthLab,2,0)
			lineWidthCombo=qt.QComboBox(self)
			lineWidthCombo.insertStrList(map(str,range(20)))
			lineWidthCombo.setCurrentItem(self.style['width'])
			self.connect(lineWidthCombo,qt.SIGNAL('activated(const QString &)'),self._SetLineWidth)
			self.gridLayout.addWidget(lineWidthCombo,2,1)
		if graphCnf.has_key('color'):
			colorLab=qt.QLabel(self)
			colorLab.setText('Color')
			self.gridLayout.addWidget(colorLab,3,0)
			self.colorSelect=ColorWidget(self,self._SetColor)
			self.colorSelect.setColor(self.style['color'])
			self.gridLayout.addWidget(self.colorSelect,3,1)
		
		self.gridLayout.addRowSpacing(4,10)
		
		okButton=qt.QPushButton(self)
		okButton.setAutoDefault(0)
		okButton.setText('OK')
		self.connect(okButton,qt.SIGNAL('clicked()'),self.valid)
		self.gridLayout.addWidget(okButton,5,0)
		
		cancelButton=qt.QPushButton(self)
		cancelButton.setAutoDefault(0)
		cancelButton.setText('Cancel')
		self.connect(cancelButton,qt.SIGNAL('clicked()'),self.cancel)
		self.gridLayout.addWidget(cancelButton,5,1)
		self.gridLayout.addRowSpacing(6,10)
		
	def GetGraphStyle(self):
		return self.style
	
	def _SetSymbol(self,symbol):
		self.style['symbol']=str(symbol)
		self.eh.event(self.graphElementStyleChangedEvent,self.graphName,self.GetGraphStyle())
		
	def _SetLineStyle(self,lineStyle):
		self.style['style']=str(lineStyle)
		self.eh.event(self.graphElementStyleChangedEvent,self.graphName,self.GetGraphStyle())
	
	def _SetLineWidth(self,lineWidth):
		self.style['width']=int(str(lineWidth))
		self.eh.event(self.graphElementStyleChangedEvent,self.graphName,self.GetGraphStyle())
	
	def _SetColor(self,color):
		self.style['color']=color
		self.eh.event(self.graphElementStyleChangedEvent,self.graphName,self.GetGraphStyle())
	
	def cancel(self, event=None):
		self.Destroyed=1
		# delete self's reference in parent's diplayed popups
		try: del self.parent.popups['Graph'][self.graphName]
		except: pass
		self.close()

	def valid(self):
		# delete self's reference in parent's diplayed popups
		try: del self.parent.popups['Graph'][self.graphName]
		except: pass
		self.close()

class RoiStyleDialog(Dialog):
	"""
	Dialog allowing to choose the properties of a roi :
		in general :
			-	its name
		for its filling :
			-	style ( stripe density )
			-	color
		for its border
			-	line style
			-	width
			-	color
	"""
	def __init__(self,parent,eh,roiName='roi',roiFillCnf={'fill':'fill_25','color':(198, 179, 234)},roiBorderCnf={'style':'solid','width':2,'color':(0, 179, 254)}):
		Dialog.__init__(self,parent,title="Roi style",modal=0)
		
		self.parent=parent
		
		self.eh=eh
		
		self.roiStyleChangedEvent=self.eh.create("roiStyleChangedEvent")
		
		self.fillStyle=['None','12%','25%','50%','75%','100%']
		self.lineStyle=['solid','dashed','dotted','hidden']
		
		self.roiName=roiName
		self.roiFillStyle=roiFillCnf
		self.roiBorderStyle=roiBorderCnf
		
		self.gridLayout=qt.QGridLayout(self,11,2)
		
		if self.roiName is not None:
			nameLab=qt.QLabel(self)
			nameLab.setText('Name')
			nameLab.setAlignment(68) # center both
			self.gridLayout.addWidget(nameLab,0,0)

			self.nameEntry=qt.QLineEdit(self)
			self.nameEntry.clear()
			self.nameEntry.setText(roiName)
			self.connect(self.nameEntry,qt.SIGNAL('returnPressed()'),self._SetRoiName)
			self.gridLayout.addWidget(self.nameEntry,0,1)
		
		if self.roiFillStyle!={}:
			fillLab=qt.QLabel(self)
			if qt.qVersion()>="3.0.0": fillLab.setPaletteBackgroundColor(qt.QColor(190,254,254))
			else: fillLab.setBackgroundColor(qt.QColor(190,254,254))
			fillLab.setText('Fill style')
			fillLab.setAlignment(68) # center both
			self.gridLayout.addMultiCellWidget(fillLab,1,1,0,1)

			if self.roiFillStyle.has_key('fill'):
				stripesLab=qt.QLabel(self)
				stripesLab.setText('Stripes')
				self.gridLayout.addWidget(stripesLab,2,0)
				stripesCombo=qt.QComboBox(self)
				stripesCombo.insertStrList(self.fillStyle)
				stripesCombo.setCurrentItem(self.fillStyle.index(MapFillModeFromQt(self.roiFillStyle['fill'])))
				self.connect(stripesCombo,qt.SIGNAL('activated(const QString &)'),self._SetStripesFill)
				self.gridLayout.addWidget(stripesCombo,2,1)

			if self.roiFillStyle.has_key('color'):
				stripesColorLab=qt.QLabel(self)
				stripesColorLab.setText('Color')
				self.gridLayout.addWidget(stripesColorLab,3,0)
				self.stripesColorSelect=ColorWidget(self,self._SetStripesColor)
				self.stripesColorSelect.setColor(self.roiFillStyle['color'])
				self.gridLayout.addWidget(self.stripesColorSelect,3,1)

		if self.roiBorderStyle!={}:
			borderLab=qt.QLabel(self)
			if qt.qVersion()>="3.0.0": borderLab.setPaletteBackgroundColor(qt.QColor(190,254,254))
			else : borderLab.setBackgroundColor(qt.QColor(190,254,254))
			borderLab.setText('Border style')
			self.gridLayout.addMultiCellWidget(borderLab,4,4,0,1)
			if self.roiBorderStyle.has_key('style'):
				borderLineLab=qt.QLabel(self)
				borderLineLab.setText('Line')
				self.gridLayout.addWidget(borderLineLab,5,0)
				borderLineCombo=qt.QComboBox(self)
				borderLineCombo.insertStrList(self.lineStyle)
				borderLineCombo.setCurrentItem(self.lineStyle.index(MapLineStyle(self.roiBorderStyle['style'])))
				self.connect(borderLineCombo,qt.SIGNAL('activated(const QString &)'),self._SetBorderLineStyle)
				self.gridLayout.addWidget(borderLineCombo,5,1)

			if self.roiBorderStyle.has_key('width'):
				borderLineWidthLab=qt.QLabel(self)
				borderLineWidthLab.setText('Width')
				self.gridLayout.addWidget(borderLineWidthLab,6,0)
				borderLineWidthCombo=qt.QComboBox(self)
				borderLineWidthCombo.insertStrList(map(str,range(20)))
				borderLineWidthCombo.setCurrentItem(self.roiBorderStyle['width'])
				self.connect(borderLineWidthCombo,qt.SIGNAL('activated(const QString &)'),self._SetBorderLineWidth)
				self.gridLayout.addWidget(borderLineWidthCombo,6,1)

			if self.roiBorderStyle.has_key('color'):
				borderLineColorLab=qt.QLabel(self)
				borderLineColorLab.setText('Color')
				self.gridLayout.addWidget(borderLineColorLab,7,0)
				self.borderLineColorSelect=ColorWidget(self,self._SetBorderLineColor)
				self.borderLineColorSelect.setColor(self.roiBorderStyle['color'])
				self.gridLayout.addWidget(self.borderLineColorSelect,7,1)

		self.gridLayout.addRowSpacing(8,10)
		
		okButton=qt.QPushButton(self)
		okButton.setAutoDefault(0)
		okButton.setText('OK')
		self.connect(okButton,qt.SIGNAL('clicked()'),self.valid)
		self.gridLayout.addWidget(okButton,9,0)
		
		cancelButton=qt.QPushButton(self)
		cancelButton.setAutoDefault(0)
		cancelButton.setText('Cancel')
		self.connect(cancelButton,qt.SIGNAL('clicked()'),self.cancel)
		self.gridLayout.addWidget(cancelButton,9,1)
		
		self.gridLayout.addRowSpacing(10,10)
		
	def GetRoiStyle(self):
		return self.roiName,self.roiFillStyle,self.roiBorderStyle
	
	def _SetRoiName(self,e=None):
		oldRoiName=self.roiName
		self.roiName=str(self.nameEntry.text())
		self.eh.event(self.roiStyleChangedEvent,oldRoiName,self.GetRoiStyle())
	
	def _SetStripesFill(self,fill): 
		self.roiFillStyle['fill']=MapFillModeToQt(str(fill))
		self.eh.event(self.roiStyleChangedEvent,self.roiName,self.GetRoiStyle())
		
	def _SetStripesColor(self,color):
		self.roiFillStyle['color']=color
		self.eh.event(self.roiStyleChangedEvent,self.roiName,self.GetRoiStyle())

	def _SetBorderLineStyle(self,lineStyle):
		self.roiBorderStyle['style']=str(lineStyle)
		self.eh.event(self.roiStyleChangedEvent,self.roiName,self.GetRoiStyle())
		
	def _SetBorderLineWidth(self,lineWidth):
		self.roiBorderStyle['width']=int(str(lineWidth))
		self.eh.event(self.roiStyleChangedEvent,self.roiName,self.GetRoiStyle())
	
	def _SetBorderLineColor(self,color):
		self.roiBorderStyle['color']=color
		self.eh.event(self.roiStyleChangedEvent,self.roiName,self.GetRoiStyle())

	def cancel(self, event=None):
		self.Destroyed=1
		# delete self's reference in parent's diplayed popups
		try: del self.parent.popups['Roi'][self.roiName]
		except: pass
		self.close()
	
	def valid(self):
		if self.roiName!=str(self.nameEntry.text()):
			# if new roi name hasn't been validated
			self._SetRoiName()
		# delete self's reference in parent's diplayed popups
		try: del self.parent.popups['Roi'][self.roiName]
		except: pass
		self.close()
		
		
class PeakStyleDialog(Dialog):
	"""
	Dialog allowing to choose the properties of a peak :
		in general :
			-	its name
		for its filling :
			-	style ( stripe density )
			-	color
		for its border
			-	line style
			-	width
			-	color
	"""
	def __init__(self,parent,eh,peakName='peak',peakCnf={'style':'solid','width':2,'color':(0,0,0)}):
		Dialog.__init__(self,parent,title="Peak style",modal=0)
		
		self.parent=parent
		
		self.eh=eh
		
		self.peakStyleChangedEvent=self.eh.create("peakStyleChangedEvent")
		
		self.lineStyle=['solid','dashed','dotted','None']
		
		self.peakName=peakName
		self.peakStyle=peakCnf
		
		self.gridLayout=qt.QGridLayout(self,7,2)

		if self.peakName is not None:		
			nameLab=qt.QLabel(self)
			nameLab.setText('Name')
			nameLab.setAlignment(68) # center both
			self.gridLayout.addWidget(nameLab,0,0)

			self.nameEntry=qt.QLineEdit(self)
			self.nameEntry.clear()
			self.nameEntry.setText(peakName)
			self.connect(self.nameEntry,qt.SIGNAL('returnPressed()'),self._SetPeakName)
			self.gridLayout.addWidget(self.nameEntry,0,1)

		if self.peakStyle!={}:
			if self.peakStyle.has_key('style'):
				lineLab=qt.QLabel(self)
				lineLab.setText('Line')
				self.gridLayout.addWidget(lineLab,1,0)
				lineCombo=qt.QComboBox(self)
				lineCombo.insertStrList(self.lineStyle)
				lineCombo.setCurrentItem(self.lineStyle.index(MapLineStyle(self.peakStyle['style'])))
				self.connect(lineCombo,qt.SIGNAL('activated(const QString &)'),self._SetLineStyle)
				self.gridLayout.addWidget(lineCombo,1,1)

			if self.peakStyle.has_key('width'):
				lineWidthLab=qt.QLabel(self)
				lineWidthLab.setText('Width')
				self.gridLayout.addWidget(lineWidthLab,2,0)
				lineWidthCombo=qt.QComboBox(self)
				lineWidthCombo.insertStrList(map(str,range(20)))
				lineWidthCombo.setCurrentItem(self.peakStyle['width'])
				self.connect(lineWidthCombo,qt.SIGNAL('activated(const QString &)'),self._SetLineWidth)
				self.gridLayout.addWidget(lineWidthCombo,2,1)

			if self.peakStyle.has_key('color'):
				lineColorLab=qt.QLabel(self)
				lineColorLab.setText('Color')
				self.gridLayout.addWidget(lineColorLab,3,0)
				self.lineColorSelect=ColorWidget(self,self._SetLineColor)
				self.lineColorSelect.setColor(self.peakStyle['color'])
				self.gridLayout.addWidget(self.lineColorSelect,3,1)

		self.gridLayout.addRowSpacing(4,10)
		
		okButton=qt.QPushButton(self)
		okButton.setAutoDefault(0)
		okButton.setText('OK')
		self.connect(okButton,qt.SIGNAL('clicked()'),self.valid)
		self.gridLayout.addWidget(okButton,5,0)
		
		cancelButton=qt.QPushButton(self)
		cancelButton.setAutoDefault(0)
		cancelButton.setText('Cancel')
		self.connect(cancelButton,qt.SIGNAL('clicked()'),self.cancel)
		self.gridLayout.addWidget(cancelButton,5,1)
		
		self.gridLayout.addRowSpacing(6,10)
		
	def GetPeakStyle(self):
		return self.peakName,self.peakStyle
	
	def _SetPeakName(self,e=None):
		oldPeakName=self.peakName
		self.peakName=str(self.nameEntry.text())
		self.eh.event(self.peakStyleChangedEvent,oldPeakName,self.GetPeakStyle())

	def _SetLineStyle(self,lineStyle):
		self.peakStyle['style']=str(lineStyle)
		self.eh.event(self.peakStyleChangedEvent,self.peakName,self.GetPeakStyle())
		
	def _SetLineWidth(self,lineWidth):
		self.peakStyle['width']=int(str(lineWidth))
		self.eh.event(self.peakStyleChangedEvent,self.peakName,self.GetPeakStyle())
	
	def _SetLineColor(self,color):
		self.peakStyle['color']=color
		self.eh.event(self.peakStyleChangedEvent,self.peakName,self.GetPeakStyle())

	def cancel(self, event=None):
		self.Destroyed=1
		# delete self's reference in parent's diplayed popups
		try : del self.parent.popups['Peak'][self.peakName]
		except: pass
		self.close()
	
	def valid(self):
		if self.peakName!=str(self.nameEntry.text()):
			# if new peak name hasn't been validated
			self._SetPeakName()
		# delete self's reference in parent's diplayed popups
		try : del self.parent.popups['Peak'][self.peakName]
		except: pass
		self.close()

def testGraphStyleDialog():
	dial=GraphStyleDialog(None,EventHandler.EventHandler())
	dial.Show()
	return dial

def testRoiStyleDialog():
	dial=RoiStyleDialog(None,EventHandler.EventHandler())
	dial.Show()
	return dial
	
def testPeakStyleDialog():
	dial=PeakStyleDialog(None,EventHandler.EventHandler())
	dial.Show()
	return dial
	
if __name__ == '__main__':
	import EventHandler
	app = qt.QApplication(sys.argv)
	app.connect(app,qt.SIGNAL('lastWindowClosed()'),app,qt.SLOT('quit()'))
	
	dial=testGraphStyleDialog()
	dial=testRoiStyleDialog()
	dial=testPeakStyleDialog()
