"""
    DrawableTable.py
    Table displaying widget
"""

from PyDVT import __version__,__date__,__author__


class  Drawable_Table:
    """
    Table widget interface definition
            
    This class generates the following callbacks to parent (a View object):
        _RightButtonPress
        _ButtonPress
        _DoubleClick
        _ButtonRelease
        _Motion
        _ButtonPressMotion
        _KeyPress
    """
    
    
    def __init__( self, parent=None, vertical_header=1, horizontal_header=1):
        """
        Parameters:
            parent: parent widget (a View object)
            vertical_header: if non-zero adds a vertical header
            horizontal_header: if non-zero adds a horizontal header
        """
        pass

    def Show(self):
        """
        Displays widget
        """
        pass
                      
    def SetData(self,data=None,h_header=None,v_header=None):
        pass

    def SetRows(self,rows):
        """
        Parameters:
            rows: sets number of rows
        """
        pass

    def SetCols(self,cols):
        """
        Parameters:
            rows: sets number of columns
        """
        pass

    def SetText(self,row,col,text):
        """
        Sets the string "text" in the cell ("row" x "col")
        """
        pass

    def SetHHeaderText(self,col,text):
        """
        Sets the string "text" in the column "col" of horizontal header 
        """
        pass
        
    def SetVHeaderText(self,row,text):
        """
        Sets the string "text" in the row "row" of vertical header 
        """
        pass

    def MergeCells(self,row,col,rowspan,colspan):
        """
        Parameters:
            row: first row to merge
            col: first column to merge
            rowspan: number of rows to merge
            colspan: number of columns to merge
        """
        pass

    def AdjustColumn(self,col):
        """
        Adjust the size of column "col" so all it's text fields
        are visible.
        """
        pass

