import EventHandler
import Specfit
import sys

from qt import *
import FitConfigGUI
import MultiParameters
import FitActionsGUI
import FitStatusGUI
import EventHandler

class SpecfitGUI(QWidget):
    def __init__(self,parent = None,name = None,fl = 0,
                 config = 0, status = 0, buttons = 0, eh = None):
        QWidget.__init__(self,parent,name,fl)
        
        layout= QVBoxLayout(self)
        layout.setAutoAdd(1)
        if name == None:
            self.setName("SpecfitGUI")
        if eh == None:
            self.eh = EventHandler.EventHandler()
        else:
            self.eh = eh
        self.specfit=Specfit.Specfit(eh=self.eh)
        self.specfit.importfun("SpecfitFunctions.py")
        self.setdata=self.specfit.setdata
        self.specfit.fitconfig['weight']=0
        if not self.specfit.fitconfig.has_key('McaMode'):
            self.specfit.fitconfig['McaMode']=0
        if config:
            self.guiconfig = FitConfigGUI.FitConfigGUI(self)
            self.guiconfig.connect(self.guiconfig.MCACheckBox,
                                   SIGNAL("stateChanged(int)"),self.mcaevent) 
            self.guiconfig.connect(self.guiconfig.WeightCheckBox,
                                   SIGNAL("stateChanged(int)"),self.weightevent) 
            self.guiconfig.connect(self.guiconfig.AutoFWHMCheckBox,
                                   SIGNAL("stateChanged(int)"),self.autofwhmevent) 
            self.guiconfig.connect(self.guiconfig.AutoScalingCheckBox,
                                   SIGNAL("stateChanged(int)"),self.autoscaleevent) 
            self.guiconfig.connect(self.guiconfig.ConfigureButton,
                                   SIGNAL("clicked()"),self.configure) 
            self.guiconfig.connect(self.guiconfig.PrintPushButton,
                                   SIGNAL("clicked()"),self.printps) 
            for key in self.specfit.bkgdict.keys():            
                self.guiconfig.BkgComBox.insertItem(str(key))
            self.guiconfig.connect(self.guiconfig.BkgComBox,
                                SIGNAL("activated(const QString &)"),self.bkgevent)
            self.guiconfig.BkgComBox.setCurrentItem(1)
            for key in self.specfit.theorylist:            
                self.guiconfig.FunComBox.insertItem(str(key))
            self.guiconfig.connect(self.guiconfig.FunComBox,
                                SIGNAL("activated(const QString &)"),self.funevent)
            self.guiconfig.FunComBox.setCurrentItem(1)
            
        self.guiparameters = MultiParameters.ParametersTab(self)
        if config:
            self.funevent(self.specfit.theorylist[0])
            self.bkgevent(self.specfit.bkgdict.keys()[0])
            self.mcaevent(0)
            self.weightevent(0)
            self.autofwhmevent(0)
            self.autoscaleevent(0)
        if status:
            self.guistatus =  FitStatusGUI.FitStatusGUI(self)
            self.eh.register('FitStatusChanged',self.fitstatus)
            
        if buttons:
            self.guibuttons = FitActionsGUI.FitActionsGUI(self)
            self.guibuttons.connect(self.guibuttons.EstimateButton,
                                    SIGNAL("clicked()"),self.estimate)
            self.guibuttons.connect(self.guibuttons.StartfitButton,
                                    SIGNAL("clicked()"),self.startfit)
            self.guibuttons.connect(self.guibuttons.DismissButton,
                                    SIGNAL("clicked()"),self.dismiss)

        self.resize(300,500) 
    def configure(self):
        print "configure method to be overwritten"    
        return
        
    def estimate(self):
        if self.specfit.fitconfig['McaMode']:
            try:
                mcaresult=self.specfit.mcafit()
            except:
                print "Error on mcafit"
                return
            self.guiparameters.fillfrommca(mcaresult)
            self.guiparameters.removeview(view='Fit')
        else:
            #try:
            self.specfit.estimate()
            #except:
            #    print "Error on estimate"
            #    return
            self.guiparameters.fillfromfit(self.specfit.paramlist,current='Fit')
            self.guiparameters.removeview(view='MCA')
            
        return
    
    def startfit(self):
        if self.specfit.fitconfig['McaMode']:
            try:
                mcaresult=self.specfit.mcafit()
            except:
                print "Error on mcafit"
                return
            self.guiparameters.fillfrommca(mcaresult)
            self.guiparameters.removeview(view='Fit')
        else:
            #for param in self.specfit.paramlist:
            #    print param['name'],param['group'],param['estimation']
            self.specfit.paramlist=self.guiparameters.fillfitfromtable()
            #for param in self.specfit.paramlist:
            #    print param['name'],param['group'],param['estimation']
            try:
                self.specfit.startfit()
            except:
                print "Error on startfit"
                return
            self.guiparameters.fillfromfit(self.specfit.paramlist,current='Fit')
            self.guiparameters.removeview(view='MCA')
        return
    
    
    def printps(self):
        print "print method to be overwritten"
        return
    
    
    def mcaevent(self,item):
        if int(item):
            self.specfit.fitconfig['McaMode']=1
        else:
            self.specfit.fitconfig['McaMode']=0
        self.__initialparameters() 
        return

    def weightevent(self,item):
        if int(item):
            self.specfit.configure(WeightFlag=1,weight=1)
            self.specfit.fitconfig['weight']=1
        else:
            self.specfit.configure(WeightFlag=0,weight=0)
            self.specfit.fitconfig['weight']=0 
        return

    def autofwhmevent(self,item):
        if int(item):
            self.specfit.configure(AutoFwhm=1)
            self.specfit.fitconfig['autofwhm']=1
        else:
            self.specfit.configure(AutoFwhm=0)
            self.specfit.fitconfig['autofwhm']=0
        return

    def autoscaleevent(self,item):
        if int(item):
            self.specfit.configure(autoscale=1)
            self.specfit.fitconfig['autoscale']=1
        else:
            self.specfit.configure(autoscale=0)
            self.specfit.fitconfig['autoscale']=0 
        return
    
    def bkgevent(self,item):
        item=str(item)
        if item in self.specfit.bkgdict.keys():
            self.specfit.setbackground(item)
        else:
            print " Funtion not implemented"
            i=1+self.specfit.bkgdict.keys().index(self.specfit.fitconfig['fitbkg'])
            self.guiconfig.BkgComBox.setCurrentItem(i)
        self.__initialparameters()
        return

    def funevent(self,item):
        item=str(item)
        if item in self.specfit.theorylist:
            self.specfit.settheory(item)
        else:
            print " Funtion not yet implemented"
            i=1+self.specfit.theorylist.index(self.specfit.fitconfig['fittheory'])
            self.guiconfig.FunComBox.setCurrentItem(i)
        self.__initialparameters()
        return
    
    def __initialparameters(self):
        self.specfit.final_theory=[]
        self.specfit.paramlist=[]
        for pname in self.specfit.bkgdict[self.specfit.fitconfig['fitbkg']][1]:
            self.specfit.final_theory.append(pname)
            self.specfit.paramlist.append({'name':pname,
                                       'estimation':0,
                                       'group':0,
                                       'code':'FREE',
                                       'cons1':0,
                                       'cons2':0,
                                       'fitresult':0.0,
                                       'sigma':0.0,
                                       'xmin':None,
                                       'xmax':None})
        for pname in self.specfit.theorydict[self.specfit.fitconfig['fittheory']][1]:
            self.specfit.final_theory.append(pname+`1`)
            self.specfit.paramlist.append({'name':pname+`1`,
                                       'estimation':0,
                                       'group':1,
                                       'code':'FREE',
                                       'cons1':0,
                                       'cons2':0,
                                       'fitresult':0.0,
                                       'sigma':0.0,
                                       'xmin':None,
                                       'xmax':None})
        if self.specfit.fitconfig['McaMode']:
            self.guiparameters.fillfromfit(self.specfit.paramlist,current='Region 1')
            self.guiparameters.removeview(view='Fit')
        else:
            self.guiparameters.fillfromfit(self.specfit.paramlist,current='Fit')
            self.guiparameters.removeview(view='MCA')
            self.guiparameters.removeview(view='Region 1')            
        return        

    def fitstatus(self,data):
        if data.has_key('chisq'):
            if data['chisq'] is None:
                self.guistatus.ChisqLine.setText(" ")
            else:
                chisq=data['chisq']
                self.guistatus.ChisqLine.setText("%6.2f" % chisq)
            
        if data.has_key('status'):
            status=data['status']
            self.guistatus.StatusLine.setText(str(status))
        return


    
    def dismiss(self):
        self.close()
        return
        
if __name__ == "__main__":
    import Numeric
    import SpecfitFunctions
    a=SpecfitFunctions.SpecfitFunctions()
    x = Numeric.arange(1000).astype(Numeric.Float)
    p1 = Numeric.array([1500,100.,50.0])
    p2 = Numeric.array([1500,700.,50.0])
    y = a.gauss(p1,x)+1
    y = y + a.gauss(p2,x)
    y=y/1000.0
    a = QApplication(sys.argv)
    QObject.connect(a,SIGNAL("lastWindowClosed()"),a,SLOT("quit()"))
    w = SpecfitGUI(config=1, status=1, buttons=1)
    w.setdata(x=x,y=y)
    a.setMainWidget(w)
    w.show()
    a.exec_loop()


    
