from Numeric import *

def gauss(param0,t0):
        param=array(param0)
        t=array(t0)
        dummy=2.3548200450309493*(t-param[1])/param[2]
        return param[0] * myexp(-0.5 * dummy * dummy)

def myexp(x):
        # put a (bad) filter to avoid over/underflows
        # with no python looping
        return exp(x*less(abs(x),250))-1.0*greater_equal(abs(x),250)

def estimate(x,y,z,xscaling=1.0,yscaling=1.0):
    ngauss = input(' Number of Gaussians : ')
    ngauss=int(ngauss)
    if ngauss < 1:
        ngauss=1
    newpar=[]
    for i in range(ngauss):
        print "Defining Gaussian numer %d " % (i+1)
        newpar.append(input('Height   = '))
        newpar.append(input('Position = '))
        newpar.append(input('FWHM     = '))
        #newpar.append(in)
    return newpar,zeros((3,len(newpar)),Float)

def test():
    import Tkinter
    import Specfit
    x = arange(1000).astype(Float)
    p1 = array([1500,100.,50.0])
    p2 = array([1500,700.,50.0])
    y = gauss(p1,x)+1
    y = y + gauss(p2,x)
    root=Tkinter.Tk()
    fit=Specfit.Specfit(root,x,y,
                        user_theory='New Theory',
                        user_function=gauss,
                        user_parameters=['Height','Position','FWHM'])
                        #user_estimate=estimate)
    root.mainloop()

FUNCTION=gauss
PARAMETERS=['Height','Position','FWHM']
THEORY='New Gaussian'

if __name__ == "__main__":
    test()


