#!/usr/bin/env python
"""
Event Handler derived class which stores weak references to callbacks
(doesn't avoid the destruction of callback's owner object)
"""
__version__ = '0.1Beta'

from EventHandler import *
import WeakMethod



class EventHandler(EventHandler) :
    def register(self, fulleventstr, callback, myid = None, source = None):
      """ Register the event a.b.c with callback . You have to specify the
          full name of the event class as it might be created during this call.
          A later create call with the same event will just confirm this 
          creation. You can specify an id for yourself and an id for the
          source you would like to listen to. The source restrictions are not
          yet implemented because of performance considerations.
      """
      oe = self._create(fulleventstr)
      weekrefcallback=WeakMethod.WeakMethod(callback,self.ending_callback) ### CHECK THE NEED OF CALLBACK
      #weekrefcallback=WeakMethod.WeakMethod(callback)
      oe.callbacks.append((weekrefcallback, myid, source))
      self.preparefastevents()
      return oe.event

    def ending_callback(self,obj):
      try:
        for oe in self.fulldict.values():
          for cb, regid, source in oe.callbacks:
            if cb._dead():
              oe.callbacks.remove((cb, regid, source))
      except KeyError:                      # there is no such event
        pass
      self.preparefastevents()
         
    def unregister(self, fulleventstr, callback, myid = None):
      """ Unregister the callback from the eventclass a.b.c. The id has to
          be specified if it has been specified on registering the callback
      """
      try:
        oe = self.fulldict[fulleventstr]
        for cb, regid, source in oe.callbacks:
          wcallback=WeakMethod.WeakMethod(callback)
          if cb.im_self == wcallback.im_self and cb.im_func==wcallback.im_func and regid == myid:          
            oe.callbacks.remove((cb, myid, source))
      except KeyError:                      # there is no such event
        pass
      self.preparefastevents()

