import weakref


class WeakMethod:
    def __init__(self,method,endingcallback=None):
        try:
            #self._obj = weakref.ref(method.im_self,endingcallback)
            if endingcallback is not None:
                self._obj = weakref.ref(method.im_self,endingcallback)
            else:
                self._obj = weakref.ref(method.im_self)
            self._meth = method.im_func
        except AttributeError:
            # It's not a bound method.
            self._obj = None
            self._meth = method

    def __call__(self,*args,**kws):
        if self._obj is not None:
            #if self._obj() is None:
            #    return None
            #else:
                return self._meth(self._obj(),*args,**kws)
        else:
            return self._meth(*args,**kws)

    def __getattr__(self,attr):
        if attr == 'im_self':
            return self._obj
        if attr == 'im_func':
            return self._meth
        raise AttributeError, attr

    def _dead(self):
        return self._obj is not None and self._obj() is None    

