import sys
sys.path.insert(0,'./..')
from PyDisWindow import *
from PyDVT.View import View

__version__=  '1.0.0'
__author__ =  'Alexandre Gobbo (gobbo@esrf.fr)'

DEBUG=0


class DemoPyDisPlugin(Plugin):
    ########################################################
    ### Virtuals
    ########################################################
    def OnStartInit (self):
	if DEBUG: print 'In DemoPyDisPlugin.OnStartInit...'
	return 0

    def OnInitMenuBar (self,menu_bar):
    	if DEBUG: print 'In DemoPyDisPlugin.OnInitMenuBar...'
        self.menu_plugin = qt.QPopupMenu(menu_bar)
        self.menu_plugin.insertItem('Plugin Info',self.PluginInfo)
        menu_bar.insertItem('&DemoPlugin',self.menu_plugin)

    def OnFinishInit (self,app_window):
        if DEBUG: print 'In DemoPyDisPlugin.OnFinishInit...'
	self.app_window=app_window
        

    def OnInitWindowPopupMenu (self,window):
        if DEBUG: print 'In DemoPyDisPlugin.OnInitWindowPopupMenu...'
	window.View.AddMenuSeparator()
        window.View.AddMenuPopupItem("View Doc",Command.Command(self.ViewDoc,window))

    def OnFileOpen (self,filename,format_string):
        if DEBUG: print 'In DemoPyDisPlugin.OnFileOpen...'
	window=ViewWindow (self.app_window.mdi,TextView)        
        window.show()
        window.SetTitle(os.path.split(filename)[1])
        window.View.SetSource(qt.QString(filename))

    def OnFileSave (self,window,filename,format_string):
        if DEBUG: print 'In DemoPyDisPlugin.OnFileSave...'
	window.View.Save(filename)
        window.SetTitle(os.path.split(filename)[1])
        window.View.SetSource(qt.QString(filename))        

    def OnFilePrint(self,window):
        if DEBUG: print 'In DemoPyDisPlugin.OnFilePrint...'
	if window.View.__class__ is TextView:
            self.app_window.statusBar().message("I'm pretending to print...",4000)
            return 1
        return 0

    def GetOpenFormatList(self):
        if DEBUG: print 'In DemoPyDisPlugin.GetOpenFormatList...'
	return ["Text files (*.txt)"]

    def GetSaveFormatList(self,window):
        if DEBUG: print 'In DemoPyDisPlugin.GetSaveFormatList...'
	if window.View.__class__ is TextView: return ["Text files (*.txt)"]
        else: return []
        
    def GetInfoString(self):
        if DEBUG: print 'In DemoPyDisPlugin.GetInfoString...'
	return "v. "+__version__

    ########################################################
    ### Private methods
    ########################################################
    def PluginInfo(self):
        if DEBUG: print 'In DemoPyDisPlugin.PluginInfo...'
	new_window=ViewWindow (self.app_window.mdi,TextView)        
        new_window.show()
        new_window.SetTitle("Plugin Info")
        str="Demo PyDis Plugin \nFile: "+__file__
        new_window.View.SetSource(str)

    def ViewDoc(self,window):
        if DEBUG: print 'In DemoPyDisPlugin.ViewDoc...'
	new_window=ViewWindow (self.app_window.mdi,TextView,master_window=window)        
        new_window.show()
        new_window.SetTitle(None,prefix="Doc - ")
        new_window.View.SetSource(str(window.View.__doc__))


class TextView(View):
    def CreateDrawable(self):
        if DEBUG: print 'In TextView.CreateDrawable...'
	self.Drawable= qt.QTextBrowser(self)
        self.Drawable.show()
    def SetSource(self,source):
        if DEBUG: print 'In TextView.SetSource...'
	import types
        if type(source)is types.StringType: self.Drawable.setText(source)
        else: self.Drawable.setSource(source)
        self.Refresh()
    def Save(self,filename):
        if DEBUG: print 'In TextView.Save...'
	open(filename,"w+").write(str(self.Drawable.text()))


plugin=DemoPyDisPlugin()
