from scidxp.util import *
import _pyhl,os,string,Numeric
from Py4datDisplay import Py4datDisplay

class ReadHdf5FileGroupNode(DefaultGroupNode):

	def __init__(self, filename):
		DefaultGroupNode.__init__(self, 'filename')
		self.readHdf5File(filename)
		self.setAttribute("Status",DefaultArray("OK"))
		self.setAttribute("StatusMessage",DefaultArray("No errors."))
	
	def readHdf5File(self, filename):	
		print 'In readHdf5File...'						
		aList=_pyhl.read_nodelist(filename)

		# Select individual nodes
		aList.selectAll()
		# Fetch the data for selected nodes
		aList.fetch()

		nodeNames=aList.getNodeNames()
		print nodeNames
		childNumList=[]
		for nodeName in nodeNames.keys():
			aNode=aList.getNode(nodeName)
			nodesList=string.split(aNode.name()[1:],'/')
			if len(nodesList)!=1:
				childNumList.append(len(nodesList))
		if childNumList==[]: print 'File does not contain anything'
		else:
			maxChildNum=max(childNumList)
			#print 'maxChildNum=',maxChildNum
		
			scidxpGroupNodesList=[]
			position=2
			while position<=maxChildNum:
				for nodeName in nodeNames.keys():
					aNode=aList.getNode(nodeName)
					nodesList=string.split(aNode.name()[1:],'/')
					#print 'node=',aNode.name(),aNode.type(),aNode.dims(),aNode.format()
					if len(nodesList)==position:
						if aNode.type()==1:
							# aNode is a GROUP_ID
							node=DefaultGroupNode(nodesList[len(nodesList)-1])
							scidxpGroupNodesList.append(node)
							#print 'scidxpGroupNodesList=',scidxpGroupNodesList
							#print 'node=',node
							if position==2:  
								self.insertChild(node)
							else:
								for groupNode in scidxpGroupNodesList:
									if groupNode.getName()==nodesList[len(nodesList)-2]:
										parentNode=groupNode
								print 'parentNode=',parentNode
								parentNode.insertChild(node)
						elif aNode.type()==2:
							print 'aNode is a DATASET_ID'
							array=Hdf5Array(aNode)
							scidxpNode = DefaultDataSetNode(nodesList[len(nodesList)-1],array)
							#parentNode=DefaultGroupNode(nodesList[len(nodesList)-2])
							#print position
							if position==2:
								self.insertChild(scidxpNode)
							else:
								for groupNode in scidxpGroupNodesList:
									#print groupNode.getName()
									if groupNode.getName()==nodesList[len(nodesList)-2]:
										parentNode=groupNode
								#print 'parentNode=',parentNode.getName()
								parentNode.insertChild(scidxpNode)
						else :  print aNode.name()+' is not a GROUP_ID nor a DATASET_ID'
				position=position+1


    

class Hdf5Array(Array):
	def __init__(self,hdf5Node):
		self._hdf5Node=hdf5Node
		self._arrayChangeSupport=ArrayChangeSupport(self)
	
	def getRank(self):
		return len(self._hdf5Node.dims())
	
	def getExtends(self):
		return self._hdf5Node.dims()
	
	def getExtend(self,dim):
		return self._hdf5Node.dims()[dim]
	
	def getUnit(self):
		return self._hdf5Node.format()
	
	def getDataCount(self):
		self._dataCount=1
		for dim in self._hdf5Node.dims():
			self._dataCount=self._dataCount*dim
		return self._dataCount
	
	def getDataType(self):
		return Array.FLOAT64
	
	def getData(self):
		return self._hdf5Node.data()
	
	def getDataSlab(self,first,last):
		self.Array=self._hdf5Node.data()[first[0]:last[0]+1,first[1]:last[1]+1]
		return self.Array
	
	def addArrayChangeEventListener(self,ArrayChangeEventListener):
    		self._arrayChangeSupport.addArrayChangeEventListener(ArrayChangeEventListener)
	
	def removeArrayChangeEventListener(self,ArrayChangeEventListener):
    		self._arrayChangeSupport.removeArrayChangeEventListener(ArrayChangeEventListener)
	
	def fireArrayChangeEvent(self,ArrayChangeEvent):
    		self._arrayChangeSupport.fireArrayChangeEvent(ArrayChangeEvent)


if __name__=='__main__':

	#readHdf5FileGroupNode = ReadHdf5FileGroupNode('IPhi0.hdf5')
	readHdf5FileGroupNode = ReadHdf5FileGroupNode('toto.hdf5')

	print readHdf5FileGroupNode.getChildren()
	#datasetnode=readHdf5FileGroupNode.getChild(readHdf5FileGroupNode.getChildren().keys()[0]).getChild('Pulser')
	datasetnode=readHdf5FileGroupNode.getChild(readHdf5FileGroupNode.getChildren().keys()[0])

	print type((datasetnode.getData().getData())[0]), datasetnode.getData().getData()[0,0]
	Py4datDisplay(datasetnode)

