from PyDVT.ImageViewSelect import *

DEBUG=0

class ViewSelectPolygon(ViewSelect):
  """
  Select a polygon
  """ 
  def __init__(self,data=None,callback=None):
  	ViewSelect.__init__(self,data,callback)
	self.polygon=[]
	
  def Motion(self,pos):
    """
    Virtual: See ViewSelect
    """
    mouse_position=pos.DataCoord
    for view in self.ViewList.keys():   self.DrawTemp(view,mouse_position)

  def DoubleClick(self,pos):
    """
    Virtual: See ViewSelect
    """
    if DEBUG: print 'double click'
    #self.Erase("ALL")
    #self.Selection={}
    if self.Selection!={}:
    	self.Selection={}
	self.polygon=[]	
    if len(self.polygon)>2:
    	self.polygon.append(self.polygon[0])
	self.Selection={"Polygon":self.polygon}
    	#for view in self.ViewList.keys(): self.DrawView(view)
    	self.Update("ALL")
    	if self.callback is not None: self.callback(self)

  def Press(self,pos):
    """
    Virtual: See ViewSelect
    """
    if DEBUG: print 'In Press'
    #self.Erase("ALL")
    #self.Selection={}
    if self.Selection!={}:
    	self.Selection={}
	self.polygon=[]	
    self.polygon.append(pos.DataCoord)
    if DEBUG:
    	for point in self.polygon: print point.PageCoord,
    for view in self.ViewList.keys(): self.DrawView(view)


  def Release(self,pos):
    """
    Virtual: See ViewSelect
    """
    if hasattr(self,"Begin")==0: return
    #self.SetSelectionPos((self.Begin,pos.DataCoord))


  def DrawView(self,view):
    	i=0
	if len(self.polygon)>1:
	    	while i < len(self.polygon)-1:
		       	start=view.DataCoord2ImageCoord(self.polygon[i])
    			end= view.DataCoord2ImageCoord(self.polygon[i+1])   
			if DEBUG: print start,end
			name="SelectDraw"+str(i)
    			if name not in self.ViewList[view].keys():
        			self.ViewList[view][name]=view.Drawable.PutLine(start[0], start[1], end[0], end[1],self.Pen)
				#self.ViewList[view][name]=view.Drawable.PutLine(start[0]+100, start[1], end[0]+100, end[1],self.Pen)
    			else:
        			#self.ViewList[view][name]=view.Drawable.PutLine(start[0], start[1], end[0], end[1],self.Pen)
        			view.Drawable.SetObjectCoords(self.ViewList[view][name], start[0], start[1], end[0], end[1])
			i=i+1


  def EraseView(self,view):		  
    	for key in self.ViewList[view].keys():
    		if str(key)[:10]=="SelectDraw" or str(key)=="TempDraw":
        		view.Drawable.EraseObject(self.ViewList[view][key])
        		del self.ViewList[view][key]
		

  def DrawTemp(self,view,mouse_position):
    """
    Virtual: See ViewSelectDefault
    """
    if self.Selection!={}: return
    if len(self.polygon):
    	start=view.DataCoord2ImageCoord(self.polygon[-1])
    	end=  view.DataCoord2ImageCoord(mouse_position)    
    	if "TempDraw" not in self.ViewList[view].keys():
        	self.ViewList[view]["TempDraw"]=view.Drawable.PutLine(start[0], start[1], end[0], end[1],self.Pen)
	else:
		view.Drawable.SetObjectCoords(self.ViewList[view]["TempDraw"], start[0], start[1], end[0], end[1])


  def GetDataSelection(self):
    """
    Virtual: See ImageViewSelect
    """
    if "BoundingRect" not in self.Selection.keys(): return None
    begin=self.Selection["BoundingRect"][0]
    end=self.Selection["BoundingRect"][1]
    return DataSelection.LineSelection(self.Data,begin.PageCoord,end.PageCoord,end.PageIndex)    


  def GetType(self):
    """
    Virtual: See ViewSelect
    """
    return "Polygon"
