import qt,sys
from Numeric import *
sys.path.insert(0,'./data')
sys.path.insert(0,"./fit")
from PyDVT.FitFilter import FitFilter
from PyDVT.ExtendedGraphView import *
from scidxp.util import *
import ReadSpecFile
from SciDXPData import SciDXPData
from PyDVT.Binding import FitParametersDialog

DEBUG=1

class Py4datGraphDisplay(DefaultDataSetNode):
	def __init__(self,inputDataSetNode):
		DefaultDataSetNode.__init__(self,'Graph',DefaultArray([0]))
		root=qt.QApplication(sys.argv)
		view=Py4datGraphView(None)
		#view=ExtendedGraphView(None)
		#graphData=Graph(inputDataSetNode.getData().getData())
		dvt_data=SciDXPData()
		dvt_data.SetSource(inputDataSetNode)
		dvt_data.LoadSource()
		print dvt_data.GetSourceInfo()["KeyList"]
		graphData=GraphFilter(  "Graph",\
                     			OrthoLineSelection(dvt_data),\
                     			pen=Pen((255,0,0),0,"solid") \
                     			)
		view.SetSource(graphData)
		view.SetSize(400,400)
		view.Show()
		root.setMainWidget(view)
		root.exec_loop()

class Py4datGraphView(ExtendedGraphView):
	def __init__(self, parent=None, pars={}, **kw):
		ExtendedGraphView.__init__(self, parent, pars, **kw)
		if self.MenuPopup is not None:self.AddMenuSeparator()
		self.AddMenuPopupItem("Fit",self.Fit1d)
		
	def Fit1d(self):
		if DEBUG: print 'In Py4datGraphView.Fit'
		fit_filter=FitFilter(self.GetSource()[0])
		graphFit=GraphFilter("GraphFit",fit_filter,pen=Pen((255,0,255),2,"dotted"))
		self.SetSource((self.GetSource()[0],graphFit))
		FitDlg=FitParametersDialog(None,None)
		FitDlg.Show()
		fit_filter.ConnectParameterEditor(FitDlg)


def test():
	specFile='data/ll.spec'
	node = ReadSpecFile.ReadSpecFileGroupNode(specFile)
	scan = node.getChild("scan69")
	dataSetNode = scan.getChild("Detector")
	print specFile,'/', scan.getName(),'/', dataSetNode.getName()
	Py4datGraphDisplay(dataSetNode)

	
if __name__=='__main__':

	test()
