import  NumericA
from Numeric import *
from  PPM import *
from Dabax import *
from Minimiser import *
import string
List=list
betacomp=BetaManipulator_ScanReader(Np="automatic",Polarisation=[(1.0,1)],energies_col=[3600,3900,1],)

beta=BetaManipulator_ContributionsFromFile("fluo.dat",shift=0.0,factor=0.0002,rescaleXlambda=1,)

t0=Dabax_f0_Table("f0_WaasKirf.dat",)

t12=Dabax_f1f2_Table("f1f2_asf_Kissel.dat",)

Udens=AtomicProperties("U","Density[g/ccm]",)

U_index=IndexFromTable(t0,t12,"U",Udens,)

betajoined=BetaManipulator_BetaJoin(beta,material=U_index,trim_left=10,trim_right=20,)

lh=Variable(0.5e-5,0.1e-5,1.0e-4,)

gammaL=Variable(4.0,1.0,20.0,)

gammaR=Variable(6.0,1.0,20.0,)

bl1=BetaManipulator_ContributionsFromLorentz(E0=3726.0,height=lh,gammaL=gammaL,gammaR=gammaR,min=0,max=0,)

bc1=BetaManipulator_ContributionsFromContinuum(E0=3726.0,step=0.18e-4,pente=0.5e-5/100,min=-20000,max=20000,)

bc2=BetaManipulator_ContributionsFromContinuum(E0=3599,step=0.59e-4,pente=-0.9e-5/100,min=0,max=0,)

betasum=BetaManipulator_SumOfContributions(bl1,bc1,bc2,)

fit=BetaManipulator_Comparison([betajoined, betasum],[betacomp],[1.0],normlist=[1.0],)

op_var=List([lh,gammaL,gammaR,])

fit.error()

