/*char RcsId[] = "$Header: /scisoft/users/mirone/SOURCESCVS//specfile/src/sftest.c,v 1.1.1.1 2001/06/27 16:26:14 mirone Exp $"; */
/************************************************************************
 *
 *   File:          sftest.c
 *
 *   Project:       SpecFile library
 *
 *   Description:   Stand-alone program for library tests
 * 
 *   Author:        V.Rey
 *
 *   Date:          $Date: 2001/06/27 16:26:14 $
 *
 ************************************************************************/
/*
 *   Log: $Log: sftest.c,v $
 *   Log: Revision 1.1.1.1  2001/06/27 16:26:14  mirone
 *   Log: given from Bixente
 *   Log:
 *   Log:
 *   Log: Revision 3.0  2000/12/20 14:17:19  rey
 *   Log: Python version available
 *   Log:
 * Revision 2.0  2000/04/13  13:28:54  13:28:54  rey (Vicente Rey-Bakaikoa)
 * New version of the library. Complete rewrite
 * Adds support for MCA
 */
#include <SpecFile.h>
#include <malloc.h>

void test_sfindex  ( SpecFile *sf, long scanno );
void test_sfheader ( SpecFile *sf, long scanno );
void test_sflabel  ( SpecFile *sf, long scanno );
void test_sfdata   ( SpecFile *sf, long scanno );
void test_sfmca    ( SpecFile *sf, long scanno );
void test_sfwrite  ( SpecFile *sf, long scanno );

int
main(int argc,char *argv[]) {

   int        error;
   long       scanno;
   SpecFile  *sf;

   printf("\n\n          - Welcome to SfTest -\n");
   printf("  ( set of tests for SpecFile library ) \n\n");

   if (argc < 3 ) {
       printf("Usage: %s filename scan_no\n",argv[0]);
       scanno = 59; 
       sf = SfOpen("g:\\data\\mca.spec",&error);
   } else {
       sf = SfOpen(argv[1],&error);      
       scanno = atol(argv[2]);
   }

   printf(" <SfError> %s\n",SfError(error));

   if ( sf == (SpecFile *)NULL) {
       return(1);
   }

   printf(" <SfOpen>: \"%12s\"\n",sf->sfname);

   test_sfindex(sf,scanno);

   test_sfheader(sf,scanno);

   test_sflabel(sf,scanno);

   test_sfdata(sf,scanno);

   test_sfmca(sf,scanno);

   test_sfwrite(sf,scanno);

   printf(" <SfClose>\n");
   SfClose(sf);

   return(0);
}

void
test_sfindex(SpecFile *sf,long scanno) {
   int        error,i;
   long      *sclist;
   long      idx,numb,order;
   int       ret;

   printf("\n--- sfindex.c --- \n\n");

   printf(" <SfScanNo>: %3d\n",SfScanNo(sf));

   printf(" <SfList>: ");
   sclist = SfList(sf,&error);
   for (i=0;i<SfScanNo(sf);i++) {
       printf("%3d ",sclist[i]);
       if (i%12 == 11) printf("\n\t"); 
   }
   printf("\n");

/*
   numb = scanno;
   printf(" <SfIndexes>: ");
   ret = SfIndexes(sf,numb,&sclist);
   printf(" %d found ( numb = %d )\n",ret,numb);
   for (i=0;i<ret;i++) printf("%3d ",sclist[i]);
   printf("\n");

   numb = 0;
   printf(" <SfCondList>: ");
   ret = SfCondList(sf,numb,&sclist,&error);
   printf(" %d not aborted\n",ret);
   for (i=0;i<ret;i++) printf("%3d ",sclist[i]);
   printf("\n");
*/

   numb = scanno;
   order = 1;
   printf(" <SfIndex>:");
   idx = SfIndex(sf,numb,order);
   printf(" --> %d --> \n",idx);

   printf(" <SfNumberOrder>:");
   ret = SfNumberOrder(sf,idx,&numb,&order);
   printf(" idx: %d --> numb: %d.%d\n",idx,numb,order);

   printf(" <SfNumber>:");
   numb = SfNumber(sf,idx);
   printf("      idx: %d --> numb:  %d\n",idx,numb);

   printf(" <SfOrder>:");
   order = SfOrder(sf,idx);
   printf("       idx: %d --> order: %d\n",idx,order);
}

void
test_sfheader(SpecFile *sf,long scanno) {
   char *command,*user;
   long  idx;
   int   error;
   double *hkl;
   char   findstr[] = "C";
   char   **lines;
   long   nblines,i;

   printf("\n--- sfheader.c --- \n\n");

   idx = SfIndex(sf,scanno,1);
   printf(" <SfCommand>:");
   command = SfCommand(sf,idx,&error);
   if ( command ) {
      printf(" Scan:%d -%s\n",SfNumber(sf,idx),command);
      free(command);
   }

   printf(" <SfUser>:");
   user = SfUser(sf,idx,&error);
   if (user) {
      printf("           -%s\n",user);
      free(user);
   }
   printf(" <SfTitle>:");
   user = SfTitle(sf,idx,&error);
   if (user) {
      printf("          -%s\n",user);
      free(user);
   }

   printf(" <SfDate>:");
   user = SfDate(sf,idx,&error);
   if (user) {
      printf("           -%s\n",user);
      free(user);
   }
   printf(" <SfFileDate>:");
   user = SfFileDate(sf,idx,&error);
   if (user) {
      printf("       -%s\n",user);
      free(user);
   }
   printf(" <SfHKL>:\n");
   hkl = SfHKL(sf,idx,&error);
   if (hkl) {
      printf("       -H:%f K:%f L:%f\n",hkl[0],hkl[1],hkl[2]);
      free(hkl);
   }
 
   printf(" <SfGeometry>:");
   nblines = SfGeometry(sf,idx,&lines,&error);
   printf("           %d lines\n",nblines);
   for (i=0;i<nblines;i++) {
     printf("%s\n",lines[i]);
   }
   if (nblines) freeArrNZ((void ***)&lines,nblines); 

   printf(" <SfHeader>:");
   nblines = SfHeader(sf,idx,findstr,&lines,&error);
   printf("           %d lines\n",nblines);
   for (i=0;i<nblines;i++) {
     printf("%s\n",lines[i]);
   }
   if (nblines) freeArrNZ((void ***)&lines,nblines); 

   printf(" <SfFileHeader>:");
   nblines = SfFileHeader(sf,idx,findstr,&lines,&error);
   printf("           %d lines\n",nblines);
   for (i=0;i<nblines;i++) {
     printf("%s\n",lines[i]);
   }
   if (nblines) freeArrNZ((void ***)&lines,nblines); 

   printf(" <SfNoColumns>:");
   printf("           %d\n",SfNoColumns(sf,idx,&error));
   printf(" <SfEpoch>:");
   printf("           %d\n",SfEpoch(sf,idx,&error));
}

void
test_sflabel(SpecFile *sf,long scanno) {
   long idx;
   int  error;
   char **labs;
   int   nolab,nopos,i;
   char *first,*last;
   double *pos;
   double firstp;

   char motname[]  = "DX";
   char motname2[] = "bla";

   idx = SfIndex(sf,scanno,1);

   printf("\n--- sflabel.c --- \n\n");

   printf(" <SfLabel>:");
   first = SfLabel(sf,idx,1,&error); last  = SfLabel(sf,idx,-1,&error);
   printf(" --> First: -%s- Last: -%s-\n",first,last);
   free(first); free(last);

   nolab = SfAllLabels(sf,idx,&labs,&error);
   printf(" <SfAllLabels>:");
   printf("           %d labels\n",nolab);
   for (i=0;i<nolab;i++) {
     printf("%8s ",labs[i]);
     if (i%8 == 7) printf("\n");
   }
   printf("\n");
   if (nolab) freeArrNZ((void ***)&labs,nolab); 

   nolab = SfAllMotors  (sf,idx,&labs,&error);
   nopos = SfAllMotorPos(sf,idx,&pos, &error);

   printf(" <SfAllMotors(Pos)>:");
   printf("           %d motors\n",nolab);
   if (nopos != nolab) {
       printf("<Wrong number of motors>\n");
   }
   for (i=0;i<nolab;i++) {
     printf("% 8s:% 3.3f ",labs[i],pos[i]);
     if (i%4 == 3) printf("\n");
   }
   printf("\n");
   if (nolab) freeArrNZ((void ***)&labs,nolab); 
   if (nopos) free(pos);

   printf(" <SfMotor(SfMotorPos)>:");
   if ( (first  = SfMotor(sf,idx,1,&error)) == (char *)NULL) {
       printf("    * First: -motor not found (%s) ",SfError(error));
   } else {;    
       firstp = SfMotorPos(sf,idx,1,&error); 
       printf("    * First: -%s-> %3.3f * ",first,firstp);
       free(first);
   }
   if ( (first  = SfMotor(sf,idx,-1,&error)) == (char *)NULL) {
       printf("    * Last: -motor not found (%s) ",SfError(error));
   } else {;    
       firstp = SfMotorPos(sf,idx,-1,&error); 
       printf("    * Last: -%s-> %3.3f * ",first,firstp);
       free(first);
   }
   printf("\n");

   printf(" <SfMotorByName>:\n");
   firstp = SfMotorPosByName (sf,idx,motname,&error); 
   printf("  -motor %s -->  ",motname);
   if (firstp != HUGE_VAL) {
       printf(" %3.2f\n",firstp);
   } else {
       printf(" error -> %s \n",SfError(error));
   }
   firstp = SfMotorPosByName (sf,idx,motname2,&error); 
   printf("  -motor %s -->  ",motname2);
   if (firstp != HUGE_VAL) {
       printf(" %3.2f\n",firstp);
   } else {
       printf(" error -> %s \n",SfError(error));
   }

}

void
test_sfdata(SpecFile *sf,long scanno) {
   long     *dinfo;
   double  **data;
   double   *datacol;
   char    **datastr;
   int       error,ret;
   long      idx;
   int i,j,col;

   char colname[]="Veloc Media";

   printf("\n--- sfdata.c --- \n\n");

   idx = SfIndex(sf,scanno,1);

   printf(" <SfNoDataLines>: %d\n",SfNoDataLines(sf,idx,&error));
   
   printf(" <SfData>: \n");

   ret = SfData(sf,idx,&data,&dinfo,&error);

   if (ret == 0) {
      printf("   got %d rows / %d cols\n",dinfo[ROW],dinfo[COL]);
      for (i=0;i<dinfo[ROW];i++) {
          printf("Row %d -->",i+1);
          for (j=0;j<dinfo[COL];j++) {
              printf("%g ",data[i][j]); 
          }
          printf("\n");
      }
    freeArrNZ((void ***)&data,dinfo[ROW]);
    free(dinfo);
  } else {
     printf("No data\n");
  }

  printf(" <SfDataCol>: \n");
  col = -2;
  ret = SfDataCol(sf,idx,col,&datacol,&error);
  printf("Got %d values for column %d\n",ret,col);
  for (i=0;i<ret;i++) {
     printf("%g\n",datacol[i]);
  }
  free(datacol);

  printf(" <SfDataLine>: \n");
  ret = SfDataLine(sf,idx,col,&datacol,&error);
  printf("Got %d values for column %d\n",ret,col);
  for (i=0;i<ret;i++) {
     printf("%g\n",datacol[i]);
  }
  free(datacol);

  printf(" <SfDataColByName>: \n");
  ret = SfDataColByName(sf,idx,colname,&datacol,&error);
  printf("Got %d values for column %s\n",ret,colname);
  for (i=0;i<ret;i++) {
     printf("%g\n",datacol[i]);
  }
  free(datacol);

  printf(" <SfDataAsString>: \n");
  ret = SfDataAsString(sf,idx,&datastr,&error);
  printf("Got %d lines of string data\n",ret);
  for (i=0;i<ret;i++) {
     printf("%s\n",datastr[i]);
  }
  freeArrNZ((void ***)&datastr,ret);
}

void
test_sfmca(SpecFile *sf,long scanno) {

   double *mcadata;
   int      error,i;
   long     idx,ret,number;
   double *calib;

   idx = SfIndex(sf,scanno,1);

   printf("\n--- sfmca.c --- \n\n");

   printf(" <SfNoMca>: \n");
   ret = SfNoMca(sf,idx,&error);
   printf(" %d\n",ret);
 
   printf(" <SfMcaCalib>: \n");
   ret = SfMcaCalib(sf,idx,&calib,&error);
   if (ret == -1 ) {
       printf("No calibration\n");
   } else {
       printf("MCA Calibration is: %g %g %g\n",calib[0],calib[1],calib[2]);
       free(calib);
   }

   printf(" <SfGetMca>: \n");
   number = 2;
   ret = SfGetMca(sf,idx,number,&mcadata,&error);
   if ( ret == -1 ) {
      printf("Error mca %s\n",SfError(error));
   } else {
      printf("%d mca values\n",ret);
      printf("Head\n");
      for (i=0;i<30;i++) {
         printf("%g ",mcadata[i]);
      }
      printf("Tail\n");
      for (i=ret - 30;i<ret;i++) {
         printf("%g ",mcadata[i]);
      }
   } 
   free(mcadata);


}

void
test_sfwrite(SpecFile *sf,long scanno) {

   SpecFileOut *sfo;
   int          error;
   long         ret;

   printf("\n--- sfwrite.c --- \n\n");

   printf(" <SfoInit>: \n");
   sfo = SfoInit(sf,&error);

   printf(" <SfoSelectOne>: \n");
   ret = SfoSelectOne(sfo,1,&error);

   printf(" <SfoWrite>: \n");
   ret = SfoWrite(sfo,"bla.out",&error);

   printf(" <SfoClose>:\n");
   SfoClose(sfo);
}


