"""
    qplplot.py
    Plplot base widget for qt
  
"""

__version__=  '1.0.0'
__date__ =    '01 June 2002'
__author__ =  'Alexandre Gobbo (gobbo@esrf.fr)'


import qt
from qt import QWidget
from Numeric import array
import sys, time
import pyqt_pl
pl=pyqt_pl


class qplplot(QWidget):
   def __init__(self,parent=None,name=None,back_color=None,double_buffered=1,meta_buffer=1,alloc_colors=1):      
      self.App=qt.qApp
      qt.QWidget.__init__(self,parent,name)
      self.is_created=0
      self.count=1
      self.setUpdatesEnabled(0)
      self.ipls=pl.plpartialInitXw()
      self.formerheight= 0
      self.formerwidth = 0
      
      self.App.processEvents()       
      if back_color==None:
         back_color = qt.QColor()
         back_color.setRgb( 0x00, 0x00, 0x00 )
      self.setPalette( qt.QPalette( back_color ) )
      self.show()
      self.double_buffered=double_buffered

      self.InitDrawing()

      if sys.platform== "win32":
         pl.plsdev("win3")
         handler=pl.plgetwin3hwnd(self.winId())
         if double_buffered: pl.plsetopt("-db","")
         
         if meta_buffer==0: pl.plsetopt("-drvopt","hwnd=%d,buffered=0"%(handler,))
         else:pl.plsetopt("-drvopt","hwnd=%d"%(handler,))
         
      else:
         pl.plsdev("xwin")
         pl.plsxwin(self.winId())
         if double_buffered:pl.plsetopt("-db","")
         if meta_buffer==0:
             if alloc_colors:pl.plsetopt("-drvopt","nobuffered=1")
             else: pl.plsetopt("-drvopt","nobuffered=1,noinitcolors=1")
         elif alloc_colors==0: pl.plsetopt("-drvopt","noinitcolors=1")
      
      pl.plinit()
      pl.plscolbg(back_color.red(),back_color.green(),back_color.blue())
      self.back_color=back_color
      self.plsize=(0,0)

      pl.plbop()      
      self.is_created=1

   def resizeEvent(self,e):
      if self.is_created:
             if sys.platform!= "win32": self.App.processEvents()
             self.InitDrawing()
             if self.plsize != (self.width(), self.height()):
                 pl.plresize(self.width(), self.height())
                 self.plsize=(self.width(), self.height())
         #if sys.platform== "win32":
         #   if (self.width()<=self.formerwidth) and (self.height()<=self.formerheight):            
         #      pl.plexpose()
         #   self.formerheight= self.height()
         #   self.formerwidth = self.width()

   def paintEvent(self,e):
      if self.is_created:
         self.InitDrawing()
         pl.plexpose()
           
   def InitDrawing(self):
      pl.plsstrm(self.ipls)

   def EndDrawing(self):
      if self.double_buffered: pl.plexpose()
      
