"""
    FitDialog.py
    Fit filter parameters control dialog    
"""

from PyDVT import __version__,__date__,__author__


class FitParametersDialog:
    """
    This class implements a dialog to edit fit parameters of connected FitFilters, by:
    - Sending event "ParametersChange" through the event handler received in onInitialize,
      with the fit parameters dictionary (See FitFilter.SetParameters)
    - Registering the event "FitFinished" that passes the final fit parameters (see
      NewSpecfit)
    """
    def __init__(self, parent,initial_parameters):
        """
        Parameters:
            parent: parent widget
            initial_parameters: dictionary with initial fit parameters
                               (see FitFilter.SetParameters)
        """
        pass

    def onInitialize(self,eh=None,fit=None):
        """
        Called upon connection to new FitFilter or disconnection
        Parameters:
            eh: event handler
            fit: Specfit object (see NewSpecfit)
        """
        pass

    def SetParameters(self,parameters):
        """
        Sets fit parameters (see FitFilter.SetParameters)
        """

    def GetParameters(self,parameters):
        """
        Gets fit parameters (see FitFilter.SetParameters)
        """
