/***************************************************************************
                          forze.cc  -  description
                             -------------------
    begin                : Mon Jan 17 2000
    copyright            : (C) 2000 by Alessandro MIRONE
    email                : mirone@lure.u-psud.fr
 ***************************************************************************/



#include<stdio.h>
#include<iostream.h>
#include<string.h>
#include<math.h>
#include<complex.h> 
#include<nMatrix/nMatrix.h>
#include <nMatrix/nLapack.h>
#include"../atomosferico/fichier.h"
#include"../atomosferico/hfs.h"
#include"../atomosferico/integrate.h"
#include"../atomosferico/wigner.h"

#include<Sparsa/Sparsa.h>
#include"../libasfhfs/asfhfs.h"
	
#ifndef PI
#define PI M_PI
#endif

void calcoladipolo(asfhfs &atomoA, asfhfs &atomoB, int na, int la,
									 int  nb, int lb , double &dipolo)
{

  double func[atomoA.hfs.get_n_grille()];

  if(atomoA.hfs.get_n_grille()!=atomoB.hfs.get_n_grille())
    {
      cout << " problema atomoA.get_n_grille()!=atomoB.get_n_grille() in calcoladipolo\n";
      cout <<atomoA.hfs.get_n_grille()<< endl;
      cout <<atomoB.hfs.get_n_grille()<< endl;
      exit(0);
    }

    if( fabs((atomoA.hfs.getx()[0]-atomoB.hfs.getx()[0])/atomoB.hfs.getx()[0]) > 1.0e-5 )
    {
      cout << " problema 2  incalcoladipolo  \n";
      exit(0);
    }

  int ngrille=atomoA.hfs.get_n_grille();

  if( fabs((atomoA.hfs.getx()[ngrille-1]-atomoB.hfs.getx()[ngrille-1])/atomoB.hfs.getx()[ngrille-1]) > 1.0e-5 )
    {
      cout << " problema 3  in calcoladipolo  \n";
      exit(0);
    }


  int n1,n2;
  n1=  atomoA.num_orbitale(na,la);
  n2=  atomoB.num_orbitale(nb,lb);

 
  double *f1,*f2;
  double *x;
  x=atomoA.hfs.getx();
  f1= atomoA.hfs.getpsi()[n1] ;
  f2= atomoB.hfs.getpsi()[n2] ;
  for(int i=0; i< ngrille; i++)
    {
      func[i]=f1[i]*f2[i]*x[i];
    }
  dipolo=integrate(func,  atomoA.hfs.getx()     ,ngrille);
}


void calcolaintegrali( asfhfs &atomoA, asfhfs &atomoB, uMatrix<double> & ricoprimento)
{

  double func[atomoA.hfs.get_n_grille()];
  if(atomoA.hfs.get_n_grille()!=atomoB.hfs.get_n_grille())
    {
      cout << " problema atomoA.get_n_grille()!=atomoB.get_n_grille() in calcolaintegrali\n";
      cout <<atomoA.hfs.get_n_grille()<< endl;
      cout <<atomoB.hfs.get_n_grille()<< endl;
      exit(0);
    }
  
  if( fabs((atomoA.hfs.getx()[0]-atomoB.hfs.getx()[0])/atomoB.hfs.getx()[0]) > 1.0e-5 )
    {
      cout << " problema 2  in calcolaintegrali\n";
      exit(0);
    }

  int ngrille=atomoA.hfs.get_n_grille();
  if( fabs((atomoA.hfs.getx()[ngrille-1]-atomoB.hfs.getx()[ngrille-1])/atomoB.hfs.getx()[ngrille-1]) > 1.0e-5 )
    {
      cout << " problema 3  in calcolaintegrali\n";
      exit(0);
    }

  int n1,n2;
  n1=  atomoA.hfs.get_n_stati();
  n2=  atomoB.hfs.get_n_stati();
  ricoprimento.resize(n1,n2);
  double *f1,*f2;
  for(int i1=0; i1< n1; i1++)
    for(int i2=0; i2< n2; i2++)
      {
	f1= atomoA.hfs.getpsi()[i1] ;
	f2= atomoB.hfs.getpsi()[i2] ;
	for(int i=0; i< ngrille; i++)
	  {
	    func[i]=f1[i]*f2[i];
	  }
	ricoprimento(i1,i2)=integrate(func,  atomoA.hfs.getx()     ,ngrille);
      }
}



double scalarefraduedetconduestatirimossi(DETERMINANTE &da, DETERMINANTE &db,
					  int **corrispondenze, uMatrix<double> &ricoprimento,
					  uMatrix<int> &Anumorb, uMatrix<int> &Bnumorb)
{
  double res=1;
  int count = 0;
  int pauliA[da.getnel()];
  int pauliB[db.getnel()];


  // l'antisimmetria va considerata su tutti gli elettroni
  // Anche sui due rimossi
  for(int i=0; i<da.getnel();i++)
    {
      pauliA[i]=0;
      pauliB[i]=0;
    }
  
  // Bisogna appaiare  da.getnel()-1 elettroni
  while(count < da.getnel()-1)
    {
      // cout << " count = " << count << "corrispondenze[0][count]=" << corrispondenze[0][count] << endl;
      int segno=(corrispondenze[0][count]>0)? 1:-1;
      int i=count;
      int segnopauli=1;
      while(i<da.getnel()-1  && segno*corrispondenze[0][i]>0) 
	{
	  int iA,iB;
	  iA=  -1+segno*corrispondenze[0][i] ;
	  iB=  -1+segno*corrispondenze[1] [i];
	  for(int k=0; k<iA; k++)
	    {
	      if(!pauliA[k]) segnopauli=-segnopauli;
	    }
	  for(int k=0; k<iB; k++)
	    {
	      if(!pauliB[k]) segnopauli=-segnopauli;
	    }
	  pauliA[iA]=1;
	  pauliB[iB]=1;
	  i++;
	}

      uMatrix<double> det( i-count, i-count);
      det=0.0;
      int countold=count;

      while(count<i)
	{
	  for(int j=countold; j<i; j++)
	    {
	      det(count-countold,j-countold) = ricoprimento(Anumorb(da.getlevel(-1+segno*corrispondenze[0][count]).n,
								    da.getlevel(-1+segno*corrispondenze[0][count]).l),
							    Bnumorb(db.getlevel(-1+segno*corrispondenze[1][j]).n,
								    db.getlevel(-1+segno*corrispondenze[1][j]).l)
							    ) ;
	    }
	  count++;
	}
      // cout << " ciao " << det << endl;
      if(det.rows()>1)
	{
	  res *= uDet(det)*segnopauli;
	  if( res < 0.8) 
	    {
	      cout << " res est " << res << endl;
	      

	    }
	}
      else
	{
	  res *=det(0,0)*segnopauli;
	}
    }
  //  cout << " det " << res*da.getsegno()*db.getsegno() << endl;
  return res*da.getsegno()*db.getsegno() ;

};

int transizionedipolare(DETERMINANTE &da, DETERMINANTE &db, int &dep, int &fin, int **corrispondenze, int &Dmz,
			int &la, int &lb, int &ma)
{

  if(Sz(da)!=Sz(db)) {  return 0; }
  if(fabs(Mz(da)-Mz(db))>1) {  return 0; }

  int count=0;
  int segno=-1;
  int Agia[da.getnel()];
  int Bgia[da.getnel()];
  for(int i=0; i< da.getnel(); i++)
    {
      Agia[i]=0;
      Bgia[i]=0;
    }

  
  int spaiati=0;
  LIVELLO *old;
  int fatti=1;
  while(fatti)
    {
      fatti=0;
      old=NULL;

      for(int i=da.getnel()-1; i>=0; i--)
	{

	  if(Agia[i]) continue;
	  if(old && stessaparteangolare(*old, da.getlevel(i))==0) continue;

	  for(int j=db.getnel()-1 ; j>=0 ; j-- )
	    {
	      if(Bgia[j]) continue;
	      
	      //  if( stessaparteangolare(da.getlevel(i),db.getlevel(j)))
	      if( da.getlevel(i) == db.getlevel(j) )
		{
		  if(!old)
		    {
		      old = &da.getlevel(i);
		      segno=-segno;
		    }
		  Agia[i]=1;
		  Bgia[j]=1;
		  corrispondenze[0][count]=i*segno + segno;
		  corrispondenze[1][count]=j*segno + segno;
		  // cout << " corrispondenze[ "<< count << "]=" << i*segno + segno << endl;
		  // cout << "                " << j*segno + segno << endl; 
		  count ++;
		  fatti++;
		  break;
		}
	    }
	  if(!Agia[i]) 
	    {
	      // cout << i << " e spaiato\n";
	      spaiati++;
	      dep=i;
	      Agia[i]=1;
	    }
	  // cout << " SPAIATI = " << spaiati << endl;
	  if(spaiati>1) return 0;
	}
    }
  // cout << " spaiati ******* = " << spaiati << endl;
  if(spaiati!=1) return 0;

  for(int i=0; i<db.getnel(); i++)
    {
      if(!Bgia[i])
	{
	  fin=i;
	  break;
	}
    }
  if( fabs(da.getlevel(dep).l - db.getlevel(fin).l)!=1) return 0;
  if( fabs(da.getlevel(dep).mz - db.getlevel(fin).mz)>1)
    {
      cout << " problema subrck\n";
      return 0;
    }
  if( da.getlevel(dep).sz != db.getlevel(fin).sz)
    {
      cout << " problema jriciek\n";
      return 0;
    }

  if( (da.getlevel(dep).mz - db.getlevel(fin).mz)==-1 )
    {
      Dmz=+1;
    }
  else if( (da.getlevel(dep).mz - db.getlevel(fin).mz)==1 )
    {
      Dmz=-1;
    }
  else if( (da.getlevel(dep).mz - db.getlevel(fin).mz)==0 )
    {
      Dmz=0;
    }
  else
    {
      cout << " Kaputt zijfh iu\n";
      exit(0);
    }

  la=da.getlevel(dep).l;
  lb=db.getlevel(fin).l;
  ma=da.getlevel(dep).mz;
  
  return 1;
}



void dipolo(asfhfs &atomoA, asfhfs &atomoB,Sparsa3A &DipoliPlus,
	    Sparsa3A  &DipoliMinus,Sparsa3A &DipoliZ  )
{
  uMatrix<double> ricoprimento;
  double dipolo;
  calcolaintegrali(atomoA,atomoB, ricoprimento);

  DETERMINANTE *da,*db;

  int Acolumns=0;
  int Bcolumns=0;

  DipoliPlus.pulisci();
  DipoliMinus.pulisci();
  DipoliZ.pulisci();



  int oldla=-1, oldlb=-1, oldna=-1, oldnb=-1;

  for(int sA=0; sA<atomoA.nsottospazi;sA++)
    {
      for(int sB=0 ; sB<atomoB.nsottospazi; sB++)
	{
	  for(int i=atomoA.sottospazi[sA].inizio; i<atomoA.sottospazi[sA].fine; i++)
	    {
	      for(int j=atomoB.sottospazi[sB].inizio; j<atomoB.sottospazi[sB].fine; j++)
		{
		  double el=0;
		  da =atomoA.sottospazi[sA].base_canonica + i;
		  db =atomoB.sottospazi[sB].base_canonica + j;
		  
		  int dep, fin;
		  int *corrispondenze[2];
		  corrispondenze[0]=new int [atomoA.nel];
		  corrispondenze[1]=new int [atomoB.nel];
		  if(atomoA.nel!=atomoB.nel)
		    {
		      cout << " grosso problema in forze!!! atomoA.nel!=atomoB.nel \n";
		      exit(0);
		    }
		  int Dmz, la, lb, ma;
		  //  cout << "controllo  transizione possibile fra " << i << " e " << j << endl;
		  
		  if( transizionedipolare(*da,*db, dep,fin, corrispondenze,Dmz, la, lb, ma))
		    {
		      // cout << "transizione possibile fra " << i << " e " << j << endl;
		      // cout << "iniziale  " << dep  << " finale " << fin << endl;
		      
		      
		      if( oldla!=da->getlevel(dep).l ||  oldna!=da->getlevel(dep).n || 
			  oldlb!=db->getlevel(fin).l ||  oldnb!=db->getlevel(fin).n
			  )
			{
			  oldla==da->getlevel(dep).l;
			  oldna==da->getlevel(dep).n;
			  oldlb==db->getlevel(fin).l;
			  oldnb==db->getlevel(fin).n;
			  // cout << "  calcolao  il dipolo       " << endl;
			  calcoladipolo(atomoA,atomoB,da->getlevel(dep).n ,da->getlevel(dep).l ,
					db->getlevel(fin).n ,db->getlevel(fin).l , dipolo);
			  
			}
		      int segno   = 1; // ( (dep+fin) % 2 )? 1:-1; // Il segno e gia preso in conto da scalare
		      
		      // cout << " calcolo lo scalare \n";
		      double scal = 
			scalarefraduedetconduestatirimossi(*da,*db,corrispondenze, ricoprimento,
							   atomoA.num_orbitale,
							   atomoB.num_orbitale);
		      // cout << " tutto bene, scal= " << scal << " dipolo= " << dipolo << "\n";
		      el=segno*scal*dipolo;
		      int mb=ma+Dmz;
		      
		      double add= el*sqrt(3*(2*la+1)*(2*lb+1)/3.)*
			Atomo_sferico::trej(lb,1,la,-mb,Dmz,ma)*
			Atomo_sferico::trej(lb,1,la,0,0,0)
			* (  (mb % 2 ) ? -1:1       )
			;
		      
		      if(Dmz==1)
			{
			  DipoliPlus.aggiungiElemento(add,j,i);
			}
		      else if(Dmz==-1)
			{
			  DipoliMinus.aggiungiElemento(add,j,i);
			}
		      else if(Dmz==0)
			{
			  DipoliZ.aggiungiElemento(add,j,i);
			}
		      else
			{
			  cout << " kaputt kviuerihfs\n";
			  exit(0);
			}			  


		    }
		  delete corrispondenze[0];
		  delete corrispondenze[1];
		}
	    }

	  Bcolumns += atomoB.sottospazi[sB].dim();
	}
      Acolumns += atomoA.sottospazi[sA].dim();
    }
}

