/***************************************************************************
                          wigner.cc  -  description
                             -------------------
    begin                : Sat Jan 1 2000
    copyright            : (C) 2000 by Alessandro MIRONE
    email                : mirone@lure.u-psud.fr
 ***************************************************************************/



#include<stdio.h>
#include<stdlib.h>
#include<iostream.h>
#include<math.h>
#define MIN(a,b) (((a)<(b)) ? (a):(b))
#include"wigner.h"
void stampavaloriwigner(int l1,int l2,int l3,int m1,int  m2,int  m3)
{
  cout << " l1="<< l1 << endl;
  cout << " l2="<< l2 << endl;
  cout << " l3="<< l3 << endl;
  cout << " m1="<< m1 << endl;
  cout << " m2="<< m2 << endl;
  cout << " m3="<< m3 << endl;
}
double Wignercoef::operator()(int l1,int l2,int l3,int m1,int  m2,int  m3)
{
  
  if(l1>lmax || l2>lmax || l3>lmax )
    {
      printf("depassato lmax in wigner \n");
      stampavaloriwigner( l1, l2, l3, m1,  m2,  m3);
      exit(0);
    }
  if(l1<0 || l2<0 || l3<0 )
    {
      printf("valori di l non validi in wigner \n");
       stampavaloriwigner( l1, l2, l3, m1,  m2,  m3);
       exit(0);
    }
  if(l1<abs(m1) || l2<abs(m2) || l3<abs(m3) )
    {
      printf("valori di m non validi in wigner \n");
      stampavaloriwigner( l1, l2, l3, m1,  m2,  m3);
      exit(0);
    }
  if(l3>(l1+l2) || l3<abs(l2-l1))
    {
      return 0.0;
    }
  if( (m1+m2+m3) != 0) return 0.0;

  int segno,f;
  segno = (l1+l2+l3) % 2;
  if(segno) segno=-1;
  else segno=1;
  f=1;
  int sw;
  if(l3<l1)
    {
      sw=l1;
      l1=l3;
      l3=sw;

      sw=m1;
      m1=m3;
      m3=sw;
      f*=segno;
    }
   if(l2<l1)
    {
      sw=l1;
      l1=l2;
      l2=sw;

      sw=m1;
      m1=m2;
      m2=sw;
      f*=segno;
    } 
   if(m1<0)
     {
       m1=-m1;
       m2=-m2;
       m3=-m3;
       f*=segno;       
     }
   return wignercoef[l1][l2][l3][m1][m2];
}


Wignercoef::Wignercoef()
{
	cout << _REPERTORIO_ << endl;
  FILE *wig=fopen(_REPERTORIO_,"r");
  if(!wig)
    {
      cout << " problemi in apertura del file wignercoef\n";
      exit(0);
    }
  fscanf(wig,"%d", &lmax);
  wignercoef= new double**** [lmax+1];
  double a,b,c;
  for (int l1=0; l1<=lmax; l1++)
    {
      wignercoef[l1]=new double*** [lmax-l1+1];
      wignercoef[l1]-=l1;
      for(int l2=l1; l2<=lmax; l2++)
	{
	  wignercoef[l1][l2]=new double ** [MIN(l2+l1,lmax)-(l2-l1)+1];
	  wignercoef[l1][l2]-=l2-l1;
   	  for(int l3=l2-l1; l3<=MIN(l2+l1,lmax); l3++)
	    {
	      fscanf(wig,"%le %le %le",&a,&b,&c);
	      if(a!=l1 || b!=l2 || c!=l3)
		{
		  printf("errore nella lettura del file coefficienti\n");
		  exit(0);
		}
	      wignercoef[l1][l2][l3]= new double * [l1+1];
	      for(int m1=0;m1<=l1;m1++)
		{ // - MIN(l2, l3+m1)  -> MIN(l2,l3-m1)
		  wignercoef[l1][l2][l3][m1]= new double  [1+  MIN(l2, l3+m1) + MIN(l2,l3-m1)  ];
		  wignercoef[l1][l2][l3][m1]+=  MIN(l2, l3+m1);
		  for(int m2=- MIN(l2, l3+m1);m2<= MIN(l2,l3-m1); m2++)
		    {
		      fscanf(wig,"%le %le %le",&a,&b,&c);
		      if(a!=m1 || b!=m2 || c!= -m1-m2)
			{
			  printf("errore nella lettura del file coefficienti, gli m differiscono\n");
			  exit(0);
			}		      
		      fscanf(wig,"%le %le",&a,&b);
		      wignercoef[l1][l2][l3][m1][m2]= a/sqrt(b);
		    }
		}
	    }  
	}
    }
}


/*

main()
{
    Wignercoef wigner;
    int l1,l2,l3,m1,m2,m3;
    while(1)
      {
	cout << " nuovi valori \n";
	cin >> l1>>l2>>l3>>m1>>m2>>m3;
	cout << " ***** " << l1 << " " << l2 << " " << l3<<  " " << m1 << " " << m2 << " " << m3 <<endl;
	cout << " WIGNER " << wigner(   l1,l2,l3,m1,m2,m3 )<<endl;
      }
}




*/

