#include <stdio.h>
#include <string.h>
#include "Lists.h"

/*********************************************************************
 *   Function:		ObjectList *findInList( list, proc, value )
 *
 *   Description:	Looks for an list element.
 *
 *   Parameters:
 *		Input :	(1) ListHeader pointer   
 *			(2) Comp. procedure
 *			(3) value 
 *   Returns:
 *		Pointer to the found element ,
 *		NULL if not found .
 *
 *********************************************************************/
ObjectList *
findInList( list, proc, value )

ListHeader	*list;
int	       (*proc)();
void		*value;
{
     register ObjectList	*ptr;
     

     for ( ptr=list->first ; ptr ; ptr=ptr->next ) {
          if ( (*proc)(ptr->contents, value) ) {
	       return( ptr );
	  }
     }
     return (ObjectList *)NULL;
}

/*********************************************************************
 *   Function:		int addToList( list, object, size )
 *
 *   Description:	Adds an element to the list.
 *
 *   Parameters:
 *		Input :	(1) List pointer   
 *			(2) Pointer to the new element
 *			(3) Size of the new element
 *   Returns:		
 *		(  0 ) => OK
 *	        ( -1 ) => error
 *	
 *********************************************************************/
long
addToList( list, object, size )

ListHeader     *list;
void	       *object;
long		size;
{
     void    *newobj;

     if ( (newobj = (void *)malloc(size)) == (void *)NULL ) return( -1 );
     memcpy(newobj, object, size);
     
     return( linkToList( list, newobj ) );
       
}

/*********************************************************************
 *   Function:		int linkToList( list, object )
 *
 *   Description:	Adds an element to the list.
 *
 *   Parameters:
 *		Input:	(1) ListHeader pointer   
 *			(2) pointer to the new element
 *   Returns:		
 *		(  0 ) => OK
 *	        ( -1 ) => error
 *
 *********************************************************************/
long
linkToList( list, object )

ListHeader	*list;
void		*object;
{
     ObjectList	*newobj;


     if ((newobj = (ObjectList *) malloc(sizeof(ObjectList))) == 
	    (ObjectList *) NULL)  return( -1 );
      
     newobj->contents	= object;
     newobj->prev	= list->last;
     newobj->next	= NULL;

     if (list->first == (ObjectList *)NULL) {
         list->first  = newobj;
     } else {
         (list->last)->next = newobj;
     }

     list->last = newobj;
     return( 0 );
}

/*********************************************************************
 *   Function:		int unlinkFromList( list, element )
 *
 *   Description:	Removes an element from the list.
 *
 *   Parameters:
 *		Input :	(1) List pointer   
 *			(2) Pointer to the element
 *
 *********************************************************************/
void
unlinkFromList( list, element )

ListHeader	*list;
ObjectList	*element;
{
     if ( element != (ObjectList *)NULL ) {
	  if ( element->next != (ObjectList *)NULL ) {
	       element->next->prev = element->prev;
	  }
	  else {
	       list->last = element->prev ;
	  }
	  if ( element->prev != (ObjectList *)NULL ) {
	       element->prev->next = element->next;
	  } 
	  else {
	       list->first = element->next;
	  }
	  free( element->contents );
	  free( element );
     }
}








